/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.reflection;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import io.mateu.i18n.Translator;
import io.mateu.mdd.shared.annotations.Action;
import io.mateu.mdd.shared.annotations.Caption;
import io.mateu.mdd.shared.annotations.DataProvider;
import io.mateu.mdd.shared.annotations.FieldsFilter;
import io.mateu.mdd.shared.annotations.Forbidden;
import io.mateu.mdd.shared.annotations.GenericClass;
import io.mateu.mdd.shared.annotations.Ignored;
import io.mateu.mdd.shared.annotations.KPI;
import io.mateu.mdd.shared.annotations.LiteralSearchFilter;
import io.mateu.mdd.shared.annotations.ModifyValuesOnly;
import io.mateu.mdd.shared.annotations.NotInEditor;
import io.mateu.mdd.shared.annotations.NotWhenCreating;
import io.mateu.mdd.shared.annotations.NotWhenEditing;
import io.mateu.mdd.shared.annotations.Output;
import io.mateu.mdd.shared.annotations.Position;
import io.mateu.mdd.shared.annotations.ReadOnly;
import io.mateu.mdd.shared.annotations.ReadWrite;
import io.mateu.mdd.shared.annotations.SameLine;
import io.mateu.mdd.shared.annotations.SearchFilter;
import io.mateu.mdd.shared.annotations.Submenu;
import io.mateu.mdd.shared.annotations.UseCheckboxes;
import io.mateu.mdd.shared.annotations.UseIdToSelect;
import io.mateu.mdd.shared.annotations.ValueClass;
import io.mateu.mdd.shared.annotations.ValueQL;
import io.mateu.mdd.shared.interfaces.PushWriter;
import io.mateu.mdd.shared.interfaces.RpcView;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.mdd.shared.ui.IMDDUI;
import io.mateu.mdd.shared.ui.IMDDUIInjector;
import io.mateu.mdd.springboot.BeanProvider;
import io.mateu.reflection.BaseReflectionHelper;
import io.mateu.reflection.FakeClass;
import io.mateu.reflection.FieldInterfacedForCheckboxColumn;
import io.mateu.reflection.FieldInterfacedFromField;
import io.mateu.reflection.FieldInterfacedFromParameter;
import io.mateu.reflection.MapEntry;
import io.mateu.reflection.ProxyClass;
import io.mateu.util.Helper;
import io.mateu.util.data.Pair;
import io.mateu.util.interfaces.AuditRecord;
import io.mateu.util.interfaces.GeneralRepository;
import io.mateu.util.interfaces.Translated;
import io.mateu.util.notification.Notifier;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.constant.Constable;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.net.URI;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.AnnotationMemberValue;
import javassist.bytecode.annotation.ArrayMemberValue;
import javassist.bytecode.annotation.BooleanMemberValue;
import javassist.bytecode.annotation.ByteMemberValue;
import javassist.bytecode.annotation.ClassMemberValue;
import javassist.bytecode.annotation.DoubleMemberValue;
import javassist.bytecode.annotation.EnumMemberValue;
import javassist.bytecode.annotation.FloatMemberValue;
import javassist.bytecode.annotation.IntegerMemberValue;
import javassist.bytecode.annotation.LongMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.ShortMemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import javax.persistence.CascadeType;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderColumn;
import javax.persistence.Version;
import javax.servlet.ServletContext;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.ToolProvider;
import javax.validation.constraints.NotNull;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.BooleanConverter;
import org.apache.commons.beanutils.converters.DoubleConverter;
import org.apache.commons.beanutils.converters.IntegerConverter;
import org.apache.commons.beanutils.converters.LongConverter;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionHelper
extends BaseReflectionHelper {
    private static final Logger log = LoggerFactory.getLogger(ReflectionHelper.class);
    static Map<Class, List<FieldInterfaced>> allFieldsCache = new HashMap<Class, List<FieldInterfaced>>();
    static Map<Class, List<Method>> allMethodsCache = new HashMap<Class, List<Method>>();
    static Map<String, Method> methodCache = new HashMap<String, Method>();
    static List<Class> notFromString = new ArrayList<Class>();
    public static IMDDUIInjector injector;
    private static BeanProvider beanProvider;

    public static void setBeanProvider(BeanProvider aBeanProvider) {
        beanProvider = aBeanProvider;
    }

    public static IMDDUI getUI() {
        if (injector == null) {
            try {
                injector = (IMDDUIInjector)Helper.getImpl(IMDDUIInjector.class);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return injector != null ? injector.get() : null;
    }

    public static Object getValue(Field f, Object o) {
        Method getter = null;
        try {
            getter = o.getClass().getMethod(ReflectionHelper.getGetter(f), new Class[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object v = null;
        try {
            if (getter != null) {
                v = getter.invoke(o, new Object[0]);
            } else {
                if (!Modifier.isPublic(f.getModifiers())) {
                    f.setAccessible(true);
                }
                v = f.get(o);
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return v;
    }

    public static void setValue(FieldInterfaced f, Object o, Object v) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        block11: {
            if (f instanceof FieldInterfacedForCheckboxColumn) {
                f.setValue(o, v);
            } else if (f instanceof FieldInterfacedFromField) {
                Method setter = null;
                try {
                    setter = o.getClass().getMethod(ReflectionHelper.getSetter(f), f.getType());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (setter != null) {
                        setter.invoke(o, v);
                        break block11;
                    }
                    if (!Modifier.isPublic(f.getField().getModifiers())) {
                        f.getField().setAccessible(true);
                    }
                    f.getField().set(o, v);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            } else {
                ReflectionHelper.setValue(f.getId(), o, v);
            }
        }
    }

    public static void setValue(String fn, Object o, Object v) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        if (Map.class.isAssignableFrom(o.getClass())) {
            ((Map)o).put(fn, v);
        } else if (fn.contains(".")) {
            o = ReflectionHelper.getInstance(o, fn.substring(0, fn.indexOf(".")));
            ReflectionHelper.setValue(fn.substring(fn.indexOf(".") + 1), o, v);
        } else {
            if (v instanceof Collection) {
                if (v instanceof List) {
                    v = new ArrayList(v);
                } else if (v instanceof Set) {
                    v = new HashSet(v);
                }
            }
            FieldInterfaced f = ReflectionHelper.getFieldByName(o.getClass(), fn);
            ReflectionHelper.setValue(f, o, v);
        }
    }

    public static Object getValue(FieldInterfaced f, Object o, Object valueIfNull) {
        Object v = null;
        try {
            v = ReflectionHelper.getValue(f, o);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return v != null ? v : valueIfNull;
    }

    public static Object getValue(FieldInterfaced f, Object o) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (o == null) {
            return null;
        }
        if (Map.class.isAssignableFrom(o.getClass())) {
            return ((Map)o).get(f.getName());
        }
        if (f instanceof FieldInterfacedForCheckboxColumn) {
            return f.getValue(o);
        }
        return ReflectionHelper.getValue(f.getId(), o);
    }

    private static Object getValue(String id, Object o) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object v;
        block24: {
            v = null;
            if (id.contains(".")) {
                String firstId = id.substring(0, id.indexOf("."));
                String path = id.substring(id.indexOf(".") + 1);
                Method getter2 = null;
                try {
                    FieldInterfaced f = ReflectionHelper.getFieldByName(o.getClass(), firstId);
                    if (f == null) break block24;
                    try {
                        getter2 = o.getClass().getMethod(ReflectionHelper.getGetter(f.getType(), firstId), new Class[0]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (getter2 != null) {
                        v = getter2.invoke(o, new Object[0]);
                    } else {
                        try {
                            if (f instanceof FieldInterfacedFromField) {
                                Field field = f.getField();
                                if (!Modifier.isPublic(field.getModifiers())) {
                                    field.setAccessible(true);
                                }
                                v = field.get(o);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (v != null) {
                        v = ReflectionHelper.getValue(path, v);
                    }
                }
                catch (Exception exception) {}
            } else {
                FieldInterfaced f = ReflectionHelper.getFieldByName(o.getClass(), id);
                if (f != null) {
                    Method getter = null;
                    try {
                        getter = o.getClass().getMethod(ReflectionHelper.getGetter(f.getType(), id), new Class[0]);
                    }
                    catch (Exception getter2) {
                        // empty catch block
                    }
                    try {
                        if (getter != null) {
                            v = getter.invoke(o, new Object[0]);
                            break block24;
                        }
                        try {
                            if (f instanceof FieldInterfacedFromField) {
                                Field field = f.getField();
                                if (!Modifier.isPublic(field.getModifiers())) {
                                    field.setAccessible(true);
                                }
                                v = field.get(o);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return v;
    }

    private static Object getInstance(Object o, String fn) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Object x = null;
        if (o != null) {
            if (fn.contains(".")) {
                o = ReflectionHelper.getInstance(o, fn.substring(0, fn.indexOf(".")));
                x = ReflectionHelper.getInstance(o, fn.substring(fn.indexOf(".") + 1));
            } else {
                x = o.getClass().getMethod(ReflectionHelper.getGetter(fn), new Class[0]).invoke(o, new Object[0]);
            }
        }
        return x;
    }

    public static Method getMethod(Class<?> c, String methodName) {
        if (c == null) {
            log.debug("getMethod(null, " + methodName + ") devolver\u00e1 null!");
            return null;
        }
        Method l = methodCache.get(c.getName() + "-" + methodName);
        if (l == null) {
            l = ReflectionHelper.buildMethod(c, methodName);
            methodCache.put(c.getName() + "-" + methodName, l);
        }
        return l;
    }

    public static Method buildMethod(Class<?> c, String methodName) {
        Method m = null;
        if (c != null) {
            for (Method q : ReflectionHelper.getAllMethods(c)) {
                if (!methodName.equals(q.getName())) continue;
                m = q;
                break;
            }
        }
        return m;
    }

    private static Field getDeclaredField(Class<?> c, String fieldName) {
        Field m = null;
        while (m == null) {
            try {
                m = c.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            if (m != null || c.getSuperclass() == null || !c.getSuperclass().isAnnotationPresent(Entity.class)) break;
            c = c.getSuperclass();
        }
        return m;
    }

    private static Method getMethod(Class<?> c, String methodName, Class<?> parameterClass) {
        Method m = null;
        while (m == null) {
            try {
                m = c.getDeclaredMethod(methodName, parameterClass);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (m != null || c.getSuperclass() == null || !c.getSuperclass().isAnnotationPresent(Entity.class)) break;
            c = c.getSuperclass();
        }
        return m;
    }

    public static String getGetter(Field f) {
        return ReflectionHelper.getGetter(f.getType(), f.getName());
    }

    public static String getGetter(FieldInterfaced f) {
        return ReflectionHelper.getGetter(f.getType(), f.getName());
    }

    public static String getGetter(Class c, String fieldName) {
        return (Boolean.TYPE.equals(c) ? "is" : "get") + ReflectionHelper.getFirstUpper(fieldName);
    }

    public static String getGetter(String fn) {
        return "get" + ReflectionHelper.getFirstUpper(fn);
    }

    public static String getSetter(Field f) {
        return ReflectionHelper.getSetter(f.getType(), f.getName());
    }

    public static String getSetter(FieldInterfaced f) {
        return ReflectionHelper.getSetter(f.getType(), f.getName());
    }

    public static String getSetter(Class c, String fieldName) {
        return "set" + ReflectionHelper.getFirstUpper(fieldName);
    }

    public static String getMappedBy(FieldInterfaced f) {
        if (f.isAnnotationPresent(OneToOne.class)) {
            return ((OneToOne)f.getAnnotation(OneToOne.class)).mappedBy();
        }
        if (f.isAnnotationPresent(OneToMany.class)) {
            return ((OneToMany)f.getAnnotation(OneToMany.class)).mappedBy();
        }
        if (f.isAnnotationPresent(ManyToMany.class)) {
            return ((ManyToMany)f.getAnnotation(ManyToMany.class)).mappedBy();
        }
        return null;
    }

    public static boolean esJpa(FieldInterfaced f) {
        return f.getType().isAnnotationPresent(Entity.class) || f.isAnnotationPresent(OneToOne.class) || f.isAnnotationPresent(OneToMany.class) || f.isAnnotationPresent(ManyToOne.class) || f.isAnnotationPresent(ManyToMany.class);
    }

    private static void addToList(List<String> l, String s) {
        if (s != null) {
            for (String t : s.split(",")) {
                if ("".equals(t = t.trim())) continue;
                l.add(t);
            }
        }
    }

    private static void addToList(List<String> l, List<String> nl, String s) {
        if (s != null) {
            for (String t : s.split(",")) {
                if ("".equals(t = t.trim())) continue;
                if (t.startsWith("\u00ac")) {
                    nl.add(t.replaceAll("\u00ac", ""));
                    continue;
                }
                l.add(t);
            }
        }
    }

    public static List<Method> getAllMethods(Class c) {
        List<Method> l = ReflectionHelper._getAllMethods(c);
        ArrayList<Method> r = new ArrayList<Method>();
        for (Method m : l) {
            if (!ReflectionHelper.check(m)) continue;
            r.add(m);
        }
        return r;
    }

    public static List<Method> _getAllMethods(Class c) {
        List<Method> l = allMethodsCache.get(c);
        if (l == null) {
            l = ReflectionHelper.buildAllMethods(c);
            allMethodsCache.put(c, l);
        }
        return l;
    }

    public static List<Method> buildAllMethods(Class c) {
        ArrayList<Method> l = new ArrayList<Method>();
        if (c.getSuperclass() != null && (!c.isAnnotationPresent(Entity.class) || c.getSuperclass().isAnnotationPresent(Entity.class) || c.getSuperclass().isAnnotationPresent(MappedSuperclass.class))) {
            l.addAll(ReflectionHelper.getAllMethods(c.getSuperclass()));
        }
        for (Method f : c.getDeclaredMethods()) {
            l.removeIf(m -> ReflectionHelper.getSignature(m).equals(ReflectionHelper.getSignature(f)));
            l.add(f);
        }
        return l;
    }

    private static String getSignature(Method m) {
        return m.getGenericReturnType().getTypeName() + " " + m.getName() + "(" + ReflectionHelper.getSignature(m.getParameters()) + ")";
    }

    private static String getSignature(Parameter[] parameters) {
        Object s = "";
        if (parameters != null) {
            for (Parameter p : parameters) {
                if (!"".equals(s)) {
                    s = (String)s + ", ";
                }
                s = (String)s + p.getType().getName();
            }
        }
        return s;
    }

    private static Method getMethod(Class c, String methodName, Class<?> ... parameterTypes) throws NoSuchMethodException {
        Method m = c.getClass().getDeclaredMethod(methodName, parameterTypes);
        if (m == null && c.getSuperclass() != null && (!c.isAnnotationPresent(Entity.class) || c.getSuperclass().isAnnotationPresent(Entity.class) || c.getSuperclass().isAnnotationPresent(MappedSuperclass.class))) {
            m = ReflectionHelper.getMethod(c.getSuperclass(), methodName, parameterTypes);
        }
        return m;
    }

    public static List<FieldInterfaced> getAllFields(Class c) {
        List<FieldInterfaced> l = allFieldsCache.get(c);
        if (l == null) {
            l = ReflectionHelper.buildAllFields(c);
            allFieldsCache.put(c, l);
        }
        return new ArrayList<FieldInterfaced>(l);
    }

    private static List<FieldInterfaced> buildAllFields(Class c) {
        ArrayList<String> vistos = new ArrayList<String>();
        HashMap<String, Field> originales = new HashMap<String, Field>();
        for (Field f : c.getDeclaredFields()) {
            if (Logger.class.isAssignableFrom(f.getType()) || f.getName().contains("$") || "_proxied".equalsIgnoreCase(f.getName()) || "_possibleValues".equalsIgnoreCase(f.getName()) || "_binder".equalsIgnoreCase(f.getName()) || "_field".equalsIgnoreCase(f.getName())) continue;
            originales.put(f.getName(), f);
        }
        ArrayList<FieldInterfaced> l = new ArrayList<FieldInterfaced>();
        if (c.getSuperclass() != null && (!c.isAnnotationPresent(Entity.class) || c.getSuperclass().isAnnotationPresent(Entity.class) || c.getSuperclass().isAnnotationPresent(MappedSuperclass.class))) {
            for (FieldInterfaced f : ReflectionHelper.getAllFields(c.getSuperclass())) {
                if (!originales.containsKey(f.getId())) {
                    l.add(f);
                } else {
                    l.add(new FieldInterfacedFromField((Field)originales.get(f.getName())));
                }
                vistos.add(f.getName());
            }
        }
        for (Field f : c.getDeclaredFields()) {
            if (Modifier.isStatic(f.getModifiers()) || f.isAnnotationPresent(Version.class) || Logger.class.isAssignableFrom(f.getType()) || vistos.contains(f.getName()) || f.getName().contains("$") || "_proxied".equalsIgnoreCase(f.getName()) || "_possibleValues".equalsIgnoreCase(f.getName()) || "_binder".equalsIgnoreCase(f.getName()) || "_field".equalsIgnoreCase(f.getName())) continue;
            l.add(new FieldInterfacedFromField(f));
        }
        return l;
    }

    public static boolean hasGetter(FieldInterfaced f) {
        return ReflectionHelper.getMethod(f.getDeclaringClass(), ReflectionHelper.getGetter(f)) != null;
    }

    public static boolean hasSetter(FieldInterfaced f) {
        return ReflectionHelper.getMethod(f.getDeclaringClass(), ReflectionHelper.getSetter(f)) != null;
    }

    public static List<FieldInterfaced> getAllFields(Method m) {
        ArrayList<FieldInterfaced> l = new ArrayList<FieldInterfaced>();
        for (Parameter p : m.getParameters()) {
            if (ReflectionHelper.isInjectable(m, p)) continue;
            l.add(new FieldInterfacedFromParameter(m, p));
        }
        return l;
    }

    public static List<FieldInterfaced> getAllFields(Constructor m) {
        ArrayList<FieldInterfaced> l = new ArrayList<FieldInterfaced>();
        for (Parameter p : m.getParameters()) {
            if (ReflectionHelper.isInjectable(m, p)) continue;
            l.add(new FieldInterfacedFromParameter(m, p));
        }
        return l;
    }

    public static boolean isInjectable(Executable m, Parameter p) {
        boolean injectable = true;
        if (!EntityManager.class.equals(p.getType())) {
            if (Set.class.isAssignableFrom(p.getType())) {
                Class gc = null;
                if (m.isAnnotationPresent(Action.class) && !Strings.isNullOrEmpty((String)m.getAnnotation(Action.class).attachToField())) {
                    gc = ReflectionHelper.getGenericClass(ReflectionHelper.getFieldByName(m.getDeclaringClass(), m.getAnnotation(Action.class).attachToField()), List.class, "E");
                } else {
                    gc = m.getDeclaringClass();
                    if (RpcView.class.isAssignableFrom(gc)) {
                        gc = ReflectionHelper.getGenericClass(gc, RpcView.class, "C");
                    } else if (Modifier.isStatic(m.getModifiers())) {
                        gc = m.getDeclaringClass();
                    }
                }
                if (gc == null || !gc.equals(new FieldInterfacedFromParameter(m, p).getGenericClass())) {
                    injectable = false;
                }
            } else if (!PushWriter.class.equals(p.getType())) {
                injectable = false;
            }
        }
        return injectable;
    }

    private static Map<String, FieldInterfaced> getAllFieldsMap(Class c) {
        return ReflectionHelper.getAllFieldsMap(ReflectionHelper.getAllFields(c));
    }

    private static Map<String, FieldInterfaced> getAllFieldsMap(List<FieldInterfaced> l) {
        HashMap<String, FieldInterfaced> m = new HashMap<String, FieldInterfaced>();
        for (FieldInterfaced f : l) {
            m.put(f.getName(), f);
        }
        return m;
    }

    private static List<FieldInterfaced> getAllFields(Class entityClass, boolean fieldsInFilterOnly, List<String> fieldsFilter, List<String> negatedFormFields) {
        ArrayList<FieldInterfacedFromField> l;
        block5: {
            List<FieldInterfaced> fs;
            block4: {
                fs = ReflectionHelper.getAllFields(entityClass);
                Map<String, FieldInterfaced> m = ReflectionHelper.getAllFieldsMap(fs);
                l = new ArrayList<FieldInterfacedFromField>();
                if (!fieldsInFilterOnly) break block4;
                if (fieldsFilter == null) break block5;
                for (String fn : fieldsFilter) {
                    boolean soloSalida = false;
                    if (fn.startsWith("-")) {
                        soloSalida = true;
                        fn = fn.substring(1);
                    }
                    if (fn.contains(".")) {
                        FieldInterfacedFromField f2 = null;
                        final String finalFn = fn;
                        final boolean finalSoloSalida = soloSalida;
                        f2 = new FieldInterfacedFromField(ReflectionHelper.getField(entityClass, finalFn, m)){

                            @Override
                            public String getId() {
                                return finalFn;
                            }

                            @Override
                            public String getName() {
                                return Helper.capitalize((String)this.getId());
                            }

                            @Override
                            public boolean isAnnotationPresent(Class<? extends java.lang.annotation.Annotation> annotationClass) {
                                if (finalSoloSalida && Output.class.equals(annotationClass)) {
                                    return true;
                                }
                                return super.isAnnotationPresent(annotationClass);
                            }
                        };
                        l.add(f2);
                        continue;
                    }
                    if (!m.containsKey(fn)) continue;
                    final boolean finalSoloSalida1 = soloSalida;
                    l.add(soloSalida ? new FieldInterfacedFromField(m.get(fn)){

                        @Override
                        public boolean isAnnotationPresent(Class<? extends java.lang.annotation.Annotation> annotationClass) {
                            if (finalSoloSalida1 && Output.class.equals(annotationClass)) {
                                return true;
                            }
                            return super.isAnnotationPresent(annotationClass);
                        }
                    } : m.get(fn));
                }
                break block5;
            }
            for (FieldInterfaced f3 : fs) {
                if (negatedFormFields != null && negatedFormFields.contains(f3.getId())) continue;
                final boolean soloSalida = fieldsFilter != null && fieldsFilter.contains("-" + f3.getId());
                final boolean forzarEditable = fieldsFilter != null && fieldsFilter.contains("+" + f3.getId());
                l.add(soloSalida || forzarEditable ? new FieldInterfacedFromField(f3){

                    @Override
                    public boolean isAnnotationPresent(Class<? extends java.lang.annotation.Annotation> annotationClass) {
                        if (Output.class.equals(annotationClass)) {
                            return soloSalida || !forzarEditable || super.isAnnotationPresent(annotationClass);
                        }
                        return super.isAnnotationPresent(annotationClass);
                    }
                } : f3);
            }
        }
        return l.stream().filter(f -> f != null).collect(Collectors.toList());
    }

    private static FieldInterfaced getField(Class entityClass, String fn, Map<String, FieldInterfaced> m) {
        FieldInterfaced f = null;
        if (fn.contains(".")) {
            String flfn = fn.substring(0, fn.indexOf("."));
            FieldInterfaced flf = m.get(flfn);
            if (flf != null) {
                f = ReflectionHelper.getField(flf.getType(), fn.substring(flfn.length() + 1), ReflectionHelper.getAllFieldsMap(flf.getType()));
            }
        } else if (m.containsKey(fn)) {
            f = m.get(fn);
        }
        return f;
    }

    public static Object getId(Object model) {
        if (model instanceof Object[]) {
            return ((Object[])model)[0];
        }
        if (model instanceof io.mateu.util.common.Pair) {
            return ((io.mateu.util.common.Pair)model).getA();
        }
        if (model instanceof Pair) {
            return ((Pair)model).getKey();
        }
        if (model.getClass().isAnnotationPresent(Entity.class)) {
            Object id = null;
            try {
                FieldInterfaced idField = ReflectionHelper.getIdField(model.getClass());
                id = ReflectionHelper.getValue(idField, model);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            return id;
        }
        if (model.getClass().isEnum()) {
            return ((Enum)model).ordinal();
        }
        return model;
    }

    public static FieldInterfaced getIdField(Class type) {
        if (type.isAnnotationPresent(Entity.class)) {
            FieldInterfaced idField = null;
            for (FieldInterfaced f : ReflectionHelper.getAllFields(type)) {
                if (!f.isAnnotationPresent(Id.class)) continue;
                idField = f;
                break;
            }
            return idField;
        }
        return null;
    }

    public static Field getVersionField(Class c) {
        if (c.isAnnotationPresent(Entity.class)) {
            Field idField = null;
            if (c.getSuperclass() != null && (!c.isAnnotationPresent(Entity.class) || c.getSuperclass().isAnnotationPresent(Entity.class) || c.getSuperclass().isAnnotationPresent(MappedSuperclass.class))) {
                idField = ReflectionHelper.getVersionField(c.getSuperclass());
            }
            if (idField == null) {
                for (Field f : c.getDeclaredFields()) {
                    if (!f.isAnnotationPresent(Version.class)) continue;
                    idField = f;
                }
            }
            return idField;
        }
        return null;
    }

    public static FieldInterfaced getNameField(Class entityClass) {
        boolean toStringIsOverriden;
        FieldInterfaced fName = null;
        Method toStringMethod = ReflectionHelper.getMethod(entityClass, "toString");
        boolean bl = toStringIsOverriden = toStringMethod != null && toStringMethod.getDeclaringClass().equals(entityClass);
        if (!toStringIsOverriden) {
            boolean hayName = false;
            for (FieldInterfaced ff : ReflectionHelper.getAllFields(entityClass)) {
                if (!"name".equalsIgnoreCase(ff.getName()) && !"nombre".equalsIgnoreCase(ff.getName())) continue;
                fName = ff;
                hayName = true;
            }
            if (!hayName) {
                for (FieldInterfaced ff : ReflectionHelper.getAllFields(entityClass)) {
                    if (!"value".equalsIgnoreCase(ff.getName()) && !"title".equalsIgnoreCase(ff.getName()) && !"titulo".equalsIgnoreCase(ff.getName()) && !"description".equalsIgnoreCase(ff.getName()) && !"descripcion".equalsIgnoreCase(ff.getName())) continue;
                    fName = ff;
                    hayName = true;
                }
            }
            if (!hayName) {
                for (FieldInterfaced ff : ReflectionHelper.getAllFields(entityClass)) {
                    if (!"description".equalsIgnoreCase(ff.getName()) && !"descripcion".equalsIgnoreCase(ff.getName())) continue;
                    fName = ff;
                    hayName = true;
                }
            }
            if (!hayName) {
                for (FieldInterfaced ff : ReflectionHelper.getAllFields(entityClass)) {
                    if (!ff.isAnnotationPresent(Id.class)) continue;
                    fName = ff;
                }
            }
        }
        return fName;
    }

    public static FieldInterfaced getFieldByName(Class sourceClass, String fieldName) {
        FieldInterfaced field = null;
        String fn = fieldName.split("\\.")[0];
        for (FieldInterfaced f : ReflectionHelper.getAllFields(sourceClass)) {
            if (!fn.equals(f.getName())) continue;
            if (fn.equals(fieldName)) {
                field = f;
                break;
            }
            field = ReflectionHelper.getFieldByName(f.getType(), fieldName.substring(fn.length() + 1));
            break;
        }
        if (field == null) {
            System.out.println("No field " + fieldName + " at " + sourceClass);
        }
        return field;
    }

    public static FieldInterfaced getMapper(FieldInterfaced field) {
        FieldInterfaced mapper = null;
        String mfn = null;
        if (field.isAnnotationPresent(OneToOne.class)) {
            mfn = ((OneToOne)field.getAnnotation(OneToOne.class)).mappedBy();
        } else if (field.isAnnotationPresent(OneToMany.class)) {
            mfn = ((OneToMany)field.getAnnotation(OneToMany.class)).mappedBy();
        } else if (field.isAnnotationPresent(ManyToMany.class)) {
            mfn = ((ManyToMany)field.getAnnotation(ManyToMany.class)).mappedBy();
        } else if (field.isAnnotationPresent(ManyToOne.class)) {
            for (FieldInterfaced f : ReflectionHelper.getAllFields(field.getType())) {
                String z = null;
                if (f.isAnnotationPresent(OneToOne.class)) {
                    z = ((OneToOne)f.getAnnotation(OneToOne.class)).mappedBy();
                } else if (f.isAnnotationPresent(OneToMany.class)) {
                    z = ((OneToMany)f.getAnnotation(OneToMany.class)).mappedBy();
                } else if (f.isAnnotationPresent(ManyToMany.class)) {
                    z = ((ManyToMany)f.getAnnotation(ManyToMany.class)).mappedBy();
                }
                if (!field.getName().equals(z) || !field.getDeclaringClass().equals(f.getType()) && !field.getDeclaringClass().equals(ReflectionHelper.getGenericClass(f.getGenericType()))) continue;
                mfn = f.getName();
                break;
            }
        }
        Class targetClass = null;
        targetClass = Collection.class.isAssignableFrom(field.getType()) || Set.class.isAssignableFrom(field.getType()) ? field.getGenericClass() : (Map.class.isAssignableFrom(field.getType()) ? ReflectionHelper.getGenericClass(field, Map.class, "V") : field.getType());
        if (!Strings.isNullOrEmpty((String)mfn)) {
            mapper = ReflectionHelper.getFieldByName(targetClass, mfn);
        } else if (targetClass.isAnnotationPresent(Entity.class)) {
            for (FieldInterfaced f : ReflectionHelper.getAllFields(targetClass)) {
                mfn = null;
                if (f.isAnnotationPresent(OneToOne.class)) {
                    mfn = ((OneToOne)f.getAnnotation(OneToOne.class)).mappedBy();
                } else if (f.isAnnotationPresent(OneToMany.class)) {
                    mfn = ((OneToMany)f.getAnnotation(OneToMany.class)).mappedBy();
                } else if (f.isAnnotationPresent(ManyToMany.class)) {
                    mfn = ((ManyToMany)f.getAnnotation(ManyToMany.class)).mappedBy();
                }
                if (!field.getName().equals(mfn)) continue;
                Class reverseClass = null;
                reverseClass = Collection.class.isAssignableFrom(f.getType()) || Set.class.isAssignableFrom(f.getType()) ? f.getGenericClass() : (Map.class.isAssignableFrom(field.getType()) ? ReflectionHelper.getGenericClass(f, Map.class, "V") : f.getType());
                if (reverseClass == null || !field.getDeclaringClass().isAssignableFrom(reverseClass)) continue;
                mapper = f;
                break;
            }
        }
        return mapper;
    }

    public static Class getGenericClass(FieldInterfaced field, Class asClassOrInterface, String genericArgumentName) {
        Type t = field.getGenericType();
        if (field.isAnnotationPresent(GenericClass.class)) {
            return ((GenericClass)field.getAnnotation(GenericClass.class)).clazz();
        }
        return ReflectionHelper.getGenericClass(t instanceof ParameterizedType ? (ParameterizedType)t : null, field.getType(), asClassOrInterface, genericArgumentName);
    }

    public static Class getGenericClass(ParameterizedType parameterizedType, Class asClassOrInterface, String genericArgumentName) {
        return ReflectionHelper.getGenericClass(parameterizedType, (Class)parameterizedType.getRawType(), asClassOrInterface, genericArgumentName);
    }

    public static Class getGenericClass(Class sourceClass, Class asClassOrInterface, String genericArgumentName) {
        return ReflectionHelper.getGenericClass(null, sourceClass, asClassOrInterface, genericArgumentName);
    }

    public static Class getGenericClass(ParameterizedType parameterizedType, Class sourceClass, Class asClassOrInterface, String genericArgumentName) {
        Class c = null;
        if (asClassOrInterface.isInterface()) {
            Class baseInterface = null;
            if (sourceClass.isInterface()) {
                boolean laImplementa;
                baseInterface = sourceClass;
                ArrayList jerarquiaInterfaces = ReflectionHelper.buscarInterfaz(sourceClass, asClassOrInterface);
                if (asClassOrInterface.equals(sourceClass)) {
                    jerarquiaInterfaces = Lists.newArrayList((Object[])new Type[]{asClassOrInterface});
                }
                boolean bl = laImplementa = jerarquiaInterfaces != null;
                if (laImplementa) {
                    jerarquiaInterfaces.add(parameterizedType != null ? parameterizedType : sourceClass);
                    c = ReflectionHelper.buscarHaciaAbajo(asClassOrInterface, genericArgumentName, jerarquiaInterfaces);
                }
            } else {
                Type tipoEnCurso;
                boolean laImplementa = false;
                ArrayList<Type> jerarquia = new ArrayList<Type>();
                List<Type> jerarquiaInterfaces = null;
                Type type = tipoEnCurso = parameterizedType != null ? parameterizedType : sourceClass;
                while (tipoEnCurso != null && !laImplementa) {
                    jerarquiaInterfaces = ReflectionHelper.buscarInterfaz(tipoEnCurso, asClassOrInterface);
                    laImplementa = jerarquiaInterfaces != null;
                    if (laImplementa) continue;
                    Type genericSuperclass = ReflectionHelper.getSuper(tipoEnCurso);
                    if (genericSuperclass != null && genericSuperclass instanceof ParameterizedType) {
                        ParameterizedType pt = (ParameterizedType)genericSuperclass;
                        if (!(pt.getRawType() instanceof Class)) continue;
                        genericSuperclass = pt.getRawType();
                        if (Object.class.equals((Object)genericSuperclass)) {
                            tipoEnCurso = null;
                            continue;
                        }
                        jerarquia.add(tipoEnCurso);
                        tipoEnCurso = pt;
                        continue;
                    }
                    if (genericSuperclass != null && genericSuperclass instanceof Class) {
                        if (Object.class.equals((Object)genericSuperclass)) {
                            tipoEnCurso = null;
                            continue;
                        }
                        jerarquia.add(tipoEnCurso);
                        tipoEnCurso = (Class)genericSuperclass;
                        continue;
                    }
                    tipoEnCurso = null;
                }
                if (laImplementa) {
                    jerarquia.add(tipoEnCurso);
                    jerarquia.addAll(jerarquiaInterfaces);
                    c = ReflectionHelper.buscarHaciaAbajo(asClassOrInterface, genericArgumentName, jerarquia);
                }
            }
        } else {
            Type tipoEnCurso;
            if (sourceClass.isInterface()) {
                return null;
            }
            ArrayList<Type> jerarquia = new ArrayList<Type>();
            Type type = tipoEnCurso = parameterizedType != null ? parameterizedType : sourceClass;
            while (!(tipoEnCurso == null || asClassOrInterface.equals(tipoEnCurso) || tipoEnCurso instanceof ParameterizedType && asClassOrInterface.equals(tipoEnCurso.getRawType()))) {
                Type genericSuperclass = ReflectionHelper.getSuper(tipoEnCurso);
                if (genericSuperclass != null && genericSuperclass instanceof ParameterizedType) {
                    ParameterizedType pt = (ParameterizedType)genericSuperclass;
                    if (!(pt.getRawType() instanceof Class)) continue;
                    genericSuperclass = pt.getRawType();
                    if (Object.class.equals((Object)genericSuperclass)) {
                        tipoEnCurso = null;
                        continue;
                    }
                    jerarquia.add(tipoEnCurso);
                    tipoEnCurso = pt;
                    continue;
                }
                if (genericSuperclass != null && genericSuperclass instanceof Class) {
                    if (Object.class.equals((Object)genericSuperclass)) {
                        tipoEnCurso = null;
                        continue;
                    }
                    jerarquia.add(tipoEnCurso);
                    tipoEnCurso = (Class)genericSuperclass;
                    continue;
                }
                tipoEnCurso = null;
            }
            if (tipoEnCurso != null) {
                jerarquia.add(tipoEnCurso);
                c = ReflectionHelper.buscarHaciaAbajo(asClassOrInterface, genericArgumentName, jerarquia);
            }
        }
        return c;
    }

    private static Class buscarHaciaAbajo(Type asClassOrInterface, String genericArgumentName, List<Type> jerarquia) {
        Class c = null;
        int argPos = ReflectionHelper.getArgPos(asClassOrInterface, genericArgumentName);
        for (int escalon = jerarquia.size() - 1; escalon >= 0 && c == null; --escalon) {
            Type tipoEnCurso = jerarquia.get(escalon);
            if (tipoEnCurso instanceof Class) {
                if (((Class)tipoEnCurso).getTypeParameters().length > argPos) {
                    TypeVariable t = ((Class)tipoEnCurso).getTypeParameters()[argPos];
                    genericArgumentName = t.getName();
                    asClassOrInterface = (Class)tipoEnCurso;
                    argPos = ReflectionHelper.getArgPos(asClassOrInterface, genericArgumentName);
                    continue;
                }
                c = Object.class;
                continue;
            }
            if (!(tipoEnCurso instanceof ParameterizedType)) continue;
            ParameterizedType pt = (ParameterizedType)tipoEnCurso;
            Type t = pt.getActualTypeArguments()[argPos];
            if (t instanceof Class) {
                c = (Class)t;
                continue;
            }
            if (!(t instanceof TypeVariable)) continue;
            genericArgumentName = ((TypeVariable)t).getName();
            asClassOrInterface = tipoEnCurso;
            argPos = ReflectionHelper.getArgPos(asClassOrInterface, genericArgumentName);
        }
        return c;
    }

    private static List<Type> buscarInterfaz(Type tipo, Class interfaz) {
        ParameterizedType pt;
        List<Type> jerarquia = null;
        Class clase = null;
        if (tipo instanceof Class) {
            clase = (Class)tipo;
        } else if (tipo instanceof ParameterizedType && (pt = (ParameterizedType)tipo).getRawType() instanceof Class) {
            clase = (Class)pt.getRawType();
        }
        if (clase != null) {
            Type t;
            Type[] typeArray = clase.getGenericInterfaces();
            int n = typeArray.length;
            for (int i = 0; i < n && (jerarquia = ReflectionHelper.buscarSuperInterfaz(t = typeArray[i], interfaz)) == null; ++i) {
            }
        }
        return jerarquia;
    }

    private static List<Type> buscarSuperInterfaz(Type tipo, Class interfaz) {
        ParameterizedType pt;
        ArrayList<Type> jerarquia = null;
        Class clase = null;
        if (tipo instanceof Class) {
            clase = (Class)tipo;
        } else if (tipo instanceof ParameterizedType && (pt = (ParameterizedType)tipo).getRawType() instanceof Class) {
            clase = (Class)pt.getRawType();
        }
        if (clase != null) {
            Type tipoEnCurso = clase;
            ArrayList<Type> tempJerarquia = new ArrayList<Type>();
            tempJerarquia.add(tipo);
            while (!(tipoEnCurso == null || interfaz.equals(tipoEnCurso) || tipoEnCurso instanceof ParameterizedType && interfaz.equals(((ParameterizedType)tipoEnCurso).getRawType()))) {
                Type genericSuperclass = ReflectionHelper.getSuper(tipoEnCurso);
                if (genericSuperclass != null && genericSuperclass instanceof ParameterizedType) {
                    ParameterizedType pt2 = (ParameterizedType)genericSuperclass;
                    if (!(pt2.getRawType() instanceof Class)) continue;
                    genericSuperclass = pt2.getRawType();
                    if (Object.class.equals((Object)genericSuperclass)) {
                        tipoEnCurso = null;
                        continue;
                    }
                    tempJerarquia.add(tipoEnCurso);
                    tipoEnCurso = pt2;
                    continue;
                }
                if (genericSuperclass != null && genericSuperclass instanceof Class) {
                    if (Object.class.equals((Object)genericSuperclass)) {
                        tipoEnCurso = null;
                        continue;
                    }
                    tempJerarquia.add(tipoEnCurso);
                    tipoEnCurso = (Class)genericSuperclass;
                    continue;
                }
                tipoEnCurso = null;
            }
            if (tipoEnCurso != null) {
                jerarquia = tempJerarquia;
            }
        }
        return jerarquia;
    }

    private static Type getSuper(Type tipoEnCurso) {
        ParameterizedType pt;
        Class<?> genericSuperclass = null;
        if (tipoEnCurso instanceof Class) {
            if (((Class)tipoEnCurso).isInterface()) {
                Class<?>[] is = ((Class)tipoEnCurso).getInterfaces();
                if (is != null && is.length > 0) {
                    genericSuperclass = is[0];
                }
            } else {
                genericSuperclass = ((Class)tipoEnCurso).getGenericSuperclass();
            }
        } else if (tipoEnCurso instanceof ParameterizedType && (pt = (ParameterizedType)tipoEnCurso).getRawType() instanceof Class) {
            genericSuperclass = ((Class)pt.getRawType()).getGenericSuperclass();
        }
        return genericSuperclass;
    }

    private static int getArgPos(Type asClassOrInterface, String genericArgumentName) {
        int argPos = 0;
        Type[] types = null;
        if (asClassOrInterface instanceof Class) {
            types = ((Class)asClassOrInterface).getTypeParameters();
        } else if (asClassOrInterface instanceof ParameterizedType) {
            types = ((ParameterizedType)asClassOrInterface).getActualTypeArguments();
        }
        int argPosAux = 0;
        if (types != null) {
            for (int pos = 0; pos < types.length; ++pos) {
                if (!(types[pos] instanceof TypeVariable)) continue;
                TypeVariable t = (TypeVariable)types[pos];
                if (t.getName().equals(genericArgumentName)) {
                    argPos = argPosAux;
                    break;
                }
                ++argPosAux;
            }
        }
        return argPos;
    }

    public static <T> T fillQueryResult(List<FieldInterfaced> fields, Object[] o, T t) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        int pos = 0;
        for (FieldInterfaced f : fields) {
            if (pos >= o.length) break;
            if (o[pos] != null) {
                if (f instanceof FieldInterfacedFromField) {
                    f.getField().set(t, o[pos]);
                } else {
                    ReflectionHelper.set(t, f, o[pos]);
                }
            }
            ++pos;
        }
        return t;
    }

    private static void set(Object o, FieldInterfaced f, Object v) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method m = null;
        try {
            m = o.getClass().getMethod(ReflectionHelper.getSetter(f), v.getClass());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (m == null) {
            m = ReflectionHelper.getMethod(o.getClass(), ReflectionHelper.getSetter(f));
        }
        if (m != null) {
            try {
                m.invoke(o, v);
            }
            catch (Exception e) {
                System.out.println("Exception when setting value " + v + " for field " + f.getName());
                throw e;
            }
        }
    }

    public static List<FieldInterfaced> getKpiFields(Class modelType) {
        List<Object> allFields = ReflectionHelper.getAllFields(modelType);
        allFields = allFields.stream().filter(f -> f.isAnnotationPresent(KPI.class)).collect(Collectors.toList());
        return allFields;
    }

    public static List<FieldInterfaced> getAllEditableFields(Class modelType) {
        return ReflectionHelper.getAllEditableFilteredFields(modelType, null, null);
    }

    public static List<FieldInterfaced> getAllEditableFilteredFields(Class modelType, String fieldsFilter, List<FieldInterfaced> editableFields) {
        List<FieldInterfaced> l;
        List<FieldInterfaced> list = l = editableFields != null ? editableFields : ReflectionHelper.getAllEditableFields(modelType, null, true);
        if (!Strings.isNullOrEmpty((String)fieldsFilter)) {
            ArrayList<FieldInterfaced> borrar = new ArrayList<FieldInterfaced>();
            List<String> ts = Arrays.asList(fieldsFilter.replaceAll(" ", "").split(","));
            for (FieldInterfaced f : l) {
                if (ts.contains(f.getName())) continue;
                borrar.add(f);
            }
            l.removeAll(borrar);
        }
        return l;
    }

    public static List<FieldInterfaced> getAllEditableFields(Class modelType, Class superType) {
        return ReflectionHelper.getAllEditableFields(modelType, superType, true);
    }

    public static List<FieldInterfaced> getAllEditableFields(Class modelType, Class superType, boolean includeReverseMappers) {
        return ReflectionHelper.getAllEditableFields(modelType, superType, includeReverseMappers, null);
    }

    public static List<FieldInterfaced> getAllEditableFields(Class modelType, Class superType, boolean includeReverseMappers, FieldInterfaced field) {
        List<Object> allFields = ReflectionHelper.getAllFields(modelType);
        if (field != null && field.isAnnotationPresent(FieldsFilter.class)) {
            List<String> fns = Arrays.asList(((FieldsFilter)field.getAnnotation(FieldsFilter.class)).value().split(","));
            ArrayList<FieldInterfaced> borrar = new ArrayList<FieldInterfaced>();
            for (FieldInterfaced fieldInterfaced : allFields) {
                if (fns.contains(fieldInterfaced.getName())) continue;
                borrar.add(fieldInterfaced);
            }
            allFields.removeAll(borrar);
        }
        allFields = ReflectionHelper.filterAccesible(allFields);
        allFields = ReflectionHelper.filterAuthorized(allFields);
        boolean isEditingNewRecord = ReflectionHelper.getUI() != null && ReflectionHelper.getUI().isEditingNewRecord();
        allFields = allFields.stream().filter(f -> !(f.isAnnotationPresent(Version.class) || f.isAnnotationPresent(Ignored.class) || f.isAnnotationPresent(KPI.class) || f.isAnnotationPresent(NotInEditor.class) || f.isAnnotationPresent(Id.class) && f.isAnnotationPresent(GeneratedValue.class) || f.isAnnotationPresent(NotWhenCreating.class) && isEditingNewRecord || f.isAnnotationPresent(NotWhenEditing.class) && !isEditingNewRecord)).collect(Collectors.toList());
        if (superType != null && !includeReverseMappers) {
            List manytoones = allFields.stream().filter(f -> f.isAnnotationPresent(ManyToOne.class)).collect(Collectors.toList());
            block1: for (FieldInterfaced fieldInterfaced : manytoones) {
                if (!superType.equals(fieldInterfaced.getType())) continue;
                for (FieldInterfaced parentField : ReflectionHelper.getAllFields(fieldInterfaced.getType())) {
                    String mb;
                    OneToMany aa = (OneToMany)parentField.getAnnotation(OneToMany.class);
                    if (aa == null || Strings.isNullOrEmpty((String)(mb = ((OneToMany)parentField.getAnnotation(OneToMany.class)).mappedBy()))) continue;
                    FieldInterfaced mbf = null;
                    for (FieldInterfaced fieldInterfaced2 : allFields) {
                        if (!fieldInterfaced2.getName().equals(mb)) continue;
                        mbf = fieldInterfaced2;
                        break;
                    }
                    if (mbf == null) continue;
                    allFields.remove(mbf);
                    continue block1;
                }
            }
        }
        for (FieldInterfaced fieldInterfaced : new ArrayList<Object>(allFields)) {
            if (!fieldInterfaced.isAnnotationPresent(Position.class)) continue;
            allFields.remove(fieldInterfaced);
            allFields.add(((Position)fieldInterfaced.getAnnotation(Position.class)).value(), fieldInterfaced);
        }
        return allFields;
    }

    private static List<FieldInterfaced> filterAccesible(List<FieldInterfaced> allFields) {
        ArrayList<FieldInterfaced> r = new ArrayList<FieldInterfaced>();
        for (FieldInterfaced f : allFields) {
            if (!ReflectionHelper.hasGetter(f)) continue;
            r.add(f);
        }
        return r;
    }

    private static List<FieldInterfaced> filterAuthorized(List<FieldInterfaced> allFields) {
        ArrayList<FieldInterfaced> r = new ArrayList<FieldInterfaced>();
        for (FieldInterfaced f : allFields) {
            if (!ReflectionHelper.check(f)) continue;
            r.add(f);
        }
        return r;
    }

    private static boolean check(FieldInterfaced f) {
        ReadOnly a;
        boolean r = false;
        boolean annotated = false;
        if (f.isAnnotationPresent(ReadOnly.class)) {
            annotated = true;
            a = (ReadOnly)f.getAnnotation(ReadOnly.class);
            r |= ReflectionHelper.check((java.lang.annotation.Annotation)a);
        }
        if (f.isAnnotationPresent(ReadWrite.class)) {
            annotated = true;
            a = (ReadWrite)f.getAnnotation(ReadWrite.class);
            r |= ReflectionHelper.check((java.lang.annotation.Annotation)a);
        }
        if (f.isAnnotationPresent(Forbidden.class)) {
            annotated = true;
            a = (Forbidden)f.getAnnotation(Forbidden.class);
            r &= !ReflectionHelper.check((java.lang.annotation.Annotation)a);
        }
        return !annotated || r;
    }

    private static boolean check(java.lang.annotation.Annotation a) {
        return false;
    }

    private static boolean check(Method m) {
        ReadOnly a;
        boolean r = false;
        boolean annotated = false;
        if (m.isAnnotationPresent(ReadOnly.class)) {
            annotated = true;
            a = m.getAnnotation(ReadOnly.class);
            r |= ReflectionHelper.check((java.lang.annotation.Annotation)a);
        }
        if (m.isAnnotationPresent(ReadWrite.class)) {
            annotated = true;
            a = m.getAnnotation(ReadWrite.class);
            r |= ReflectionHelper.check((java.lang.annotation.Annotation)a);
        }
        if (m.isAnnotationPresent(Forbidden.class)) {
            annotated = true;
            a = m.getAnnotation(Forbidden.class);
            r &= !ReflectionHelper.check((java.lang.annotation.Annotation)a);
        }
        return !annotated || r;
    }

    private static FieldInterfaced getInterfaced(final Parameter p) {
        return new FieldInterfaced(){

            public boolean isAnnotationPresent(Class<? extends java.lang.annotation.Annotation> annotationClass) {
                return p.isAnnotationPresent(annotationClass);
            }

            public Class<?> getType() {
                return p.getType();
            }

            public AnnotatedType getAnnotatedType() {
                return p.getAnnotatedType();
            }

            public Class<?> getGenericClass() {
                if (p.getParameterizedType() instanceof ParameterizedType) {
                    ParameterizedType genericType = (ParameterizedType)p.getParameterizedType();
                    Class genericClass = (Class)genericType.getActualTypeArguments()[0];
                    return genericClass;
                }
                return null;
            }

            public Class<?> getDeclaringClass() {
                return null;
            }

            public Type getGenericType() {
                return p.getParameterizedType();
            }

            public String getName() {
                return p.getName();
            }

            public String getId() {
                return p.getName();
            }

            public <T extends java.lang.annotation.Annotation> T getAnnotation(Class<T> annotationClass) {
                return p.getAnnotation(annotationClass);
            }

            public Class<?> getOptionsClass() {
                return p.isAnnotationPresent(ValueClass.class) ? p.getAnnotation(ValueClass.class).value() : null;
            }

            public String getOptionsQL() {
                return p.isAnnotationPresent(ValueQL.class) ? p.getAnnotation(ValueQL.class).value() : null;
            }

            public Object getValue(Object o) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
                return null;
            }

            public Field getField() {
                return null;
            }

            public <T extends java.lang.annotation.Annotation> T[] getDeclaredAnnotationsByType(Class<T> annotationClass) {
                return this.getDeclaredAnnotationsByType(annotationClass);
            }

            public void setValue(Object o, Object v) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
            }

            public int getModifiers() {
                return p.getModifiers();
            }

            public com.vaadin.data.provider.DataProvider getDataProvider() {
                return null;
            }

            public java.lang.annotation.Annotation[] getDeclaredAnnotations() {
                return p.getDeclaredAnnotations();
            }
        };
    }

    public static String getCaption(FieldInterfaced f) {
        if (f.isAnnotationPresent(Caption.class)) {
            return Translator.translate(((Caption)f.getAnnotation(Caption.class)).value());
        }
        String caption = "";
        if (f.isAnnotationPresent(Submenu.class)) {
            caption = ((Submenu)f.getAnnotation(Submenu.class)).value();
        }
        if (f.isAnnotationPresent(Action.class)) {
            ((Action)f.getAnnotation(Action.class)).value();
        }
        if (Strings.isNullOrEmpty((String)caption)) {
            caption = Helper.capitalize((String)f.getName());
        }
        return Translator.translate(caption);
    }

    public static String getCaption(Method f) {
        if (f.isAnnotationPresent(Caption.class)) {
            return Translator.translate(f.getAnnotation(Caption.class).value());
        }
        String caption = "";
        if (f.isAnnotationPresent(Submenu.class)) {
            caption = f.getAnnotation(Submenu.class).value();
        }
        if (f.isAnnotationPresent(Action.class)) {
            f.getAnnotation(Action.class).value();
        }
        if (Strings.isNullOrEmpty((String)caption)) {
            caption = Helper.capitalize((String)f.getName());
        }
        return Translator.translate(caption);
    }

    public static Collection addToCollection(FieldInterfaced field, Object bean) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Method m = ReflectionHelper.getMethod(bean.getClass(), "create" + ReflectionHelper.getFirstUpper(field.getName()) + "Instance");
        Object i = null;
        i = m != null ? m.invoke(bean, new Object[0]) : ReflectionHelper.createChild(bean, field);
        return ReflectionHelper.addToCollection(field, bean, i);
    }

    public static Collection addToCollection(FieldInterfaced field, Object bean, Object i) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Object v = ReflectionHelper.getValue(field, bean);
        v = v != null ? ReflectionHelper.extend((Collection)v, i) : (ImmutableList.class.isAssignableFrom(field.getType()) ? ImmutableList.of((Object)i) : (ImmutableSet.class.isAssignableFrom(field.getType()) ? ImmutableSet.of((Object)i) : (Set.class.isAssignableFrom(field.getType()) ? Set.of(i) : List.of(i))));
        ReflectionHelper.setValue(field, bean, v);
        return (Collection)v;
    }

    private static Object createChild(Object parent, FieldInterfaced collectionField) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        Class c = collectionField.getGenericClass();
        return ReflectionHelper.newInstance(c, parent);
    }

    public static void addToMap(FieldInterfaced field, Object bean, Object k, Object v) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Map<Object, Object> m = (Map<Object, Object>)ReflectionHelper.getValue(field, bean);
        if (m == null) {
            if (ImmutableMap.class.isAssignableFrom(field.getType())) {
                v = ImmutableMap.of((Object)k, (Object)v);
            } else {
                m = Map.of(k, v);
            }
            ReflectionHelper.setValue(field, bean, m);
        } else {
            ReflectionHelper.setValue(field, bean, ReflectionHelper.extend(m, k, v));
        }
    }

    public static void removeFromMap(FieldInterfaced field, Object bean, Set l) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object v = ReflectionHelper.getValue(field, bean);
        if (v != null) {
            l.forEach(e -> ((Map)v).remove(((MapEntry)e).getKey()));
        }
    }

    public static Class<?> getGenericClass(Class type) {
        Class gc;
        block2: {
            Type[] typeArray;
            int n;
            int n2;
            gc = null;
            if (type.getGenericInterfaces() == null || (n2 = 0) >= (n = (typeArray = type.getGenericInterfaces()).length)) break block2;
            Type gi = typeArray[n2];
            if (gi instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)gi;
                gc = (Class)pt.getActualTypeArguments()[0];
            } else {
                gc = (Class)gi;
            }
        }
        return gc;
    }

    public static Class<?> getGenericClass(Type type) {
        Class gc = null;
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            gc = (Class)pt.getActualTypeArguments()[0];
        } else {
            gc = (Class)type;
        }
        return gc;
    }

    public static Set<Class> getSubclasses(Class c) {
        Object pkg = c.getPackage().getName();
        String[] ts = ((String)pkg).split("\\.");
        if (ts.length > 3) {
            pkg = ts[0] + "." + ts[1] + "." + ts[2];
        }
        Reflections reflections = new Reflections((String)pkg, new Scanner[0]);
        Set subs = reflections.getSubTypesOf(c);
        TreeSet<Class> subsFiltered = new TreeSet<Class>((a, b) -> a.getSimpleName().compareTo(b.getSimpleName()));
        subsFiltered.addAll(subs.stream().filter(s -> !Modifier.isAbstract(s.getModifiers())).collect(Collectors.toSet()));
        return subsFiltered;
    }

    public static Class<?> getGenericClass(Method m) {
        Type gi = m.getGenericReturnType();
        Class gc = null;
        if (gi instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)gi;
            gc = (Class)pt.getActualTypeArguments()[0];
        } else {
            gc = (Class)gi;
        }
        return gc;
    }

    public static Method getMethod(Function methodReference) {
        return null;
    }

    public static boolean isOwnedCollection(FieldInterfaced field) {
        boolean owned = false;
        if (!Set.class.isAssignableFrom(field.getType()) && Collection.class.isAssignableFrom(field.getType())) {
            owned = ReflectionHelper.isOwner(field);
            if (field.isAnnotationPresent(ElementCollection.class)) {
                owned = true;
            } else if (!ReflectionHelper.getGenericClass(field.getGenericType()).isAnnotationPresent(Entity.class)) {
                owned = true;
            }
            if (owned) {
                Method mdp;
                DataProvider dpa;
                DataProvider dataProvider = dpa = field.isAnnotationPresent(DataProvider.class) ? (DataProvider)field.getAnnotation(DataProvider.class) : null;
                owned = dpa == null ? (mdp = ReflectionHelper.getMethod(field.getDeclaringClass(), ReflectionHelper.getGetter(field.getName()) + "DataProvider")) == null : false;
            }
        }
        return owned;
    }

    public static boolean isOwner(FieldInterfaced field) {
        OneToOne oo = (OneToOne)field.getAnnotation(OneToOne.class);
        OneToMany aa = (OneToMany)field.getAnnotation(OneToMany.class);
        ManyToMany mm = (ManyToMany)field.getAnnotation(ManyToMany.class);
        boolean owner = false;
        if (oo != null) {
            owner = ReflectionHelper.checkCascade(oo.cascade());
        } else if (aa != null) {
            owner = ReflectionHelper.checkCascade(aa.cascade());
        } else if (mm != null) {
            owner = ReflectionHelper.checkCascade(mm.cascade());
        }
        return owner;
    }

    private static boolean checkCascade(CascadeType[] cascade) {
        boolean owned = false;
        for (CascadeType ct : cascade) {
            if (!CascadeType.ALL.equals((Object)ct) && !CascadeType.PERSIST.equals((Object)ct)) continue;
            owned = true;
            break;
        }
        return owned;
    }

    public static boolean puedeBorrar(FieldInterfaced field) {
        if (field.isAnnotationPresent(ModifyValuesOnly.class)) {
            return false;
        }
        boolean puede = true;
        CascadeType[] cascades = null;
        if (field.isAnnotationPresent(OneToMany.class)) {
            cascades = ((OneToMany)field.getAnnotation(OneToMany.class)).cascade();
        } else if (field.isAnnotationPresent(ManyToMany.class)) {
            cascades = ((ManyToMany)field.getAnnotation(ManyToMany.class)).cascade();
        }
        if (cascades != null) {
            puede = false;
            for (CascadeType ct : cascades) {
                if (!CascadeType.ALL.equals((Object)ct) && !CascadeType.REMOVE.equals((Object)ct)) continue;
                puede = true;
                break;
            }
        }
        return puede;
    }

    public static boolean puedeOrdenar(FieldInterfaced field) {
        boolean puede = List.class.isAssignableFrom(field.getType());
        Class gc = field.getGenericClass();
        if (gc != null && gc.isAnnotationPresent(Entity.class)) {
            puede = field.isAnnotationPresent(OrderColumn.class);
        }
        return puede;
    }

    public static boolean puedeAnadir(FieldInterfaced field) {
        if (field.isAnnotationPresent(ModifyValuesOnly.class)) {
            return false;
        }
        boolean puede = true;
        CascadeType[] cascades = null;
        if (field.isAnnotationPresent(OneToMany.class)) {
            cascades = ((OneToMany)field.getAnnotation(OneToMany.class)).cascade();
        } else if (field.isAnnotationPresent(ManyToMany.class)) {
            cascades = ((ManyToMany)field.getAnnotation(ManyToMany.class)).cascade();
        }
        if (cascades != null) {
            puede = false;
            for (CascadeType ct : cascades) {
                if (!CascadeType.ALL.equals((Object)ct) && !CascadeType.PERSIST.equals((Object)ct)) continue;
                puede = true;
                break;
            }
        }
        return puede;
    }

    public static boolean puedeClonar(FieldInterfaced field) {
        boolean puede = ReflectionHelper.puedeAnadir(field);
        if (puede) {
            Constructor con;
            Class targetType = field.getType();
            if (Collection.class.isAssignableFrom(field.getType())) {
                targetType = field.getGenericClass();
            }
            puede = (con = ReflectionHelper.getConstructor(targetType)) != null && con.getParameterCount() == 0;
        }
        return puede;
    }

    public static Class createClassUsingJavac(String fullClassName, List<FieldInterfaced> fields) throws CannotCompileException, IOException, NoSuchFieldException, IllegalAccessException, ClassNotFoundException {
        String java = "public class " + fullClassName + " {\n";
        for (FieldInterfaced f : fields) {
            java = java + "\n";
            java = java + "\n";
            java = java + "  private " + f.getType().getName() + " " + f.getName() + ";";
            java = java + "\n";
            java = java + "\n";
            java = java + "  private " + f.getType().getName() + " " + ReflectionHelper.getGetter(f) + "() {\n";
            java = java + "    return this." + f.getName() + ";\n";
            java = java + "  }";
        }
        java = java + "\n";
        java = java + "\n";
        java = java + "}";
        log.debug(java);
        final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        final String finalJava = java;
        final SimpleJavaFileObject simpleJavaFileObject = new SimpleJavaFileObject(URI.create(fullClassName + ".java"), JavaFileObject.Kind.SOURCE){

            @Override
            public CharSequence getCharContent(boolean ignoreEncodingErrors) {
                return finalJava;
            }

            @Override
            public OutputStream openOutputStream() throws IOException {
                return byteArrayOutputStream;
            }
        };
        ForwardingJavaFileManager javaFileManager = new ForwardingJavaFileManager(ToolProvider.getSystemJavaCompiler().getStandardFileManager(null, null, null)){

            @Override
            public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
                return simpleJavaFileObject;
            }
        };
        ToolProvider.getSystemJavaCompiler().getTask(null, javaFileManager, null, null, null, Collections.singletonList(simpleJavaFileObject)).call();
        return Class.forName(fullClassName);
    }

    public static Class createClassUsingJavassist(String fullClassName, List<FieldInterfaced> fields) throws CannotCompileException, IOException, NoSuchFieldException, IllegalAccessException, ClassNotFoundException, NotFoundException {
        ClassPool pool = ClassPool.getDefault();
        CtClass cc = pool.get(FakeClass.class.getName());
        cc.setName(fullClassName);
        for (FieldInterfaced f : fields) {
            CtField ctf = new CtField(pool.get(f.getType().getName()), f.getName(), cc);
            cc.addField(ctf);
            ctf.setModifiers(2);
            CtMethod ctm = new CtMethod(ctf.getType(), ReflectionHelper.getGetter(f), new CtClass[0], cc);
            cc.addMethod(ctm);
            ctm.setModifiers(1);
            ctm.setBody(" return this." + f.getName() + "; ");
        }
        cc.writeFile();
        cc.detach();
        cc.toClass(BaseReflectionHelper.class.getClassLoader(), BaseReflectionHelper.class.getProtectionDomain());
        return Class.forName(fullClassName);
    }

    public static Class createClassUsingJavassist2(ClassPool pool, Class mddBinderClass, String fullClassName, List<FieldInterfaced> fields, boolean forFilters) throws Exception {
        return ReflectionHelper.createClassUsingJavassist2(pool, mddBinderClass, fullClassName, fields, forFilters, false, null, null);
    }

    public static Class createClassUsingJavassist2(ClassPool pool, Class mddBinderClass, String fullClassName, List<FieldInterfaced> fields, boolean forFilters, boolean forInlineEditing, FieldInterfaced collectionField, Object owner) throws Exception {
        log.debug("creating class " + fullClassName);
        ArrayList avoidedAnnotationNames = forFilters ? Lists.newArrayList((Object[])new String[]{"Id", "GeneratedValue", "NotNull", "NotEmpty", "SameLine", "Unmodifiable"}) : new ArrayList();
        CtClass cc = pool.makeClass(fullClassName);
        cc.setModifiers(1);
        if (forInlineEditing) {
            cc.addInterface(pool.get(ProxyClass.class.getName()));
            CtField ctf = new CtField(pool.get(collectionField.getGenericClass().getName()), "_proxied", cc);
            cc.addField(ctf);
            ctf.setModifiers(2);
            ctf = new CtField(pool.get(Map.class.getName()), "_possibleValues", cc);
            cc.addField(ctf);
            ctf.setModifiers(2);
            ctf = new CtField(pool.get(mddBinderClass.getName()), "_binder", cc);
            cc.addField(ctf);
            ctf.setModifiers(2);
            CtConstructor cons = new CtConstructor(new CtClass[]{pool.get(collectionField.getGenericClass().getName())}, cc);
            cc.addConstructor(cons);
            cons.setBody("this._proxied = $1;");
            cons = new CtConstructor(new CtClass[]{pool.get(collectionField.getGenericClass().getName()), pool.get(Map.class.getName())}, cc);
            cc.addConstructor(cons);
            cons.setBody("{super();this._proxied = $1;this._possibleValues = $2;}");
            cons = new CtConstructor(new CtClass[]{pool.get(collectionField.getGenericClass().getName()), pool.get(Map.class.getName()), pool.get(mddBinderClass.getName())}, cc);
            cc.addConstructor(cons);
            cons.setBody("{super();this._proxied = $1;this._possibleValues = $2;this._binder = $3;}");
            cc.addMethod(CtNewMethod.make((String)"public Object toObject() { return this._proxied; }", (CtClass)cc));
        }
        ClassFile cfile = cc.getClassFile();
        ConstPool cpool = cfile.getConstPool();
        for (FieldInterfaced f : fields) {
            Class t = f.getType();
            if (forFilters) {
                if (t.isAnnotationPresent(UseIdToSelect.class)) {
                    t = ReflectionHelper.getIdField(t).getType();
                }
                if (Boolean.TYPE.equals(t)) {
                    t = Boolean.class;
                }
                if (Integer.TYPE.equals(t)) {
                    t = Integer.class;
                }
                if (Long.TYPE.equals(t)) {
                    t = Long.class;
                }
                if (Double.TYPE.equals(t)) {
                    t = Double.class;
                }
                boolean esLiteral = false;
                if (Translated.class.isAssignableFrom(t)) {
                    t = String.class;
                    esLiteral = true;
                }
                if (Double.class.equals(t) || Double.TYPE.equals(t) || Long.class.equals(t) || Long.TYPE.equals(t) || Integer.class.equals(t) || Integer.TYPE.equals(t)) {
                    ReflectionHelper.addField((List<String>)avoidedAnnotationNames, pool, cfile, cpool, cc, forFilters, t, f.getName(), f.getDeclaredAnnotations(), false);
                    java.lang.annotation.Annotation[] sfa = new java.lang.annotation.Annotation[]{new SearchFilter(){

                        public Class<? extends java.lang.annotation.Annotation> annotationType() {
                            return SearchFilter.class;
                        }

                        public String field() {
                            return null;
                        }
                    }};
                    ReflectionHelper.addField((List<String>)avoidedAnnotationNames, pool, cfile, cpool, cc, forFilters, t, f.getName() + "From", sfa, true);
                    ReflectionHelper.addField((List<String>)avoidedAnnotationNames, pool, cfile, cpool, cc, forFilters, t, f.getName() + "To", sfa, true);
                    continue;
                }
                if (LocalDate.class.equals(t) || LocalDateTime.class.equals(t) || Date.class.equals(t)) {
                    ReflectionHelper.addField((List<String>)avoidedAnnotationNames, pool, cfile, cpool, cc, forFilters, t, f.getName() + "From", f.getDeclaredAnnotations(), false);
                    ReflectionHelper.addField((List<String>)avoidedAnnotationNames, pool, cfile, cpool, cc, forFilters, t, f.getName() + "To", f.getDeclaredAnnotations(), true);
                    continue;
                }
                ReflectionHelper.addField((List<String>)avoidedAnnotationNames, pool, cfile, cpool, cc, forFilters, t, f.getName(), esLiteral ? ReflectionHelper.addAnnotation(f.getDeclaredAnnotations(), (java.lang.annotation.Annotation)new LiteralSearchFilter(){

                    public Class<? extends java.lang.annotation.Annotation> annotationType() {
                        return LiteralSearchFilter.class;
                    }
                }) : f.getDeclaredAnnotations(), false);
                continue;
            }
            if (forInlineEditing) {
                if (f.isAnnotationPresent(UseCheckboxes.class) && ((UseCheckboxes)f.getAnnotation(UseCheckboxes.class)).editableInline()) {
                    Collection possibleValues = null;
                    String vmn = ReflectionHelper.getGetter(collectionField.getName() + ReflectionHelper.getFirstUpper(f.getName())) + "Values";
                    Method mdp = ReflectionHelper.getMethod(collectionField.getDeclaringClass(), vmn);
                    if (mdp != null) {
                        possibleValues = (Collection)mdp.invoke(owner, new Object[0]);
                    } else {
                        Notifier.alert((String)("Missing " + vmn + " method at " + collectionField.getDeclaringClass().getName()));
                    }
                    int pos = 0;
                    if (possibleValues == null) continue;
                    for (Object v : possibleValues) {
                        if (v == null) continue;
                        ReflectionHelper.addField(avoidedAnnotationNames, pool, cfile, cpool, cc, forFilters, Boolean.TYPE, f.getName() + pos, f.getDeclaredAnnotations(), false, true, "" + v, pos, f);
                        ++pos;
                    }
                    continue;
                }
                ReflectionHelper.addField(avoidedAnnotationNames, pool, cfile, cpool, cc, forFilters, t, f.getName(), f.getDeclaredAnnotations(), false, forInlineEditing, null, -1, null);
                continue;
            }
            ReflectionHelper.addField((List<String>)avoidedAnnotationNames, pool, cfile, cpool, cc, forFilters, f.getAnnotatedType(), f.getName(), f.getDeclaredAnnotations(), false);
        }
        return cc.toClass();
    }

    private static java.lang.annotation.Annotation[] addAnnotation(java.lang.annotation.Annotation[] list, java.lang.annotation.Annotation annotation) {
        java.lang.annotation.Annotation[] l = new java.lang.annotation.Annotation[list == null ? 1 : list.length + 1];
        int pos = 0;
        if (list != null) {
            for (java.lang.annotation.Annotation a : list) {
                l[pos++] = a;
            }
        }
        l[pos] = annotation;
        return l;
    }

    private static java.lang.annotation.Annotation[] expand(java.lang.annotation.Annotation[] original, final Class<? extends java.lang.annotation.Annotation> annotationClass) {
        java.lang.annotation.Annotation[] r = original != null ? Arrays.copyOf(original, original.length + 1) : new java.lang.annotation.Annotation[1];
        r[r.length - 1] = new java.lang.annotation.Annotation(){

            @Override
            public Class<? extends java.lang.annotation.Annotation> annotationType() {
                return annotationClass;
            }
        };
        return r;
    }

    private static void addField(List<String> avoidedAnnotationNames, ClassPool pool, ClassFile cfile, ConstPool cpool, CtClass cc, boolean forFilters, Class t, String fieldName, java.lang.annotation.Annotation[] declaredAnnotations, boolean forceSameLine) throws Exception {
        CtField ctf = new CtField(pool.get(t.getName()), fieldName, cc);
        cc.addField(ctf);
        ctf.setModifiers(2);
        ReflectionHelper.addField(avoidedAnnotationNames, pool, cfile, cpool, cc, ctf, forFilters, t, fieldName, declaredAnnotations, forceSameLine, false, null, -1, null);
    }

    private static void addField(List<String> avoidedAnnotationNames, ClassPool pool, ClassFile cfile, ConstPool cpool, CtClass cc, boolean forFilters, AnnotatedType t, String fieldName, java.lang.annotation.Annotation[] declaredAnnotations, boolean forceSameLine) throws Exception {
        Type type = t.getType() instanceof ParameterizedType ? ((ParameterizedType)t.getType()).getRawType() : t.getType();
        CtField ctf = new CtField(pool.get(type.getTypeName()), fieldName, cc);
        cc.addField(ctf);
        ctf.setModifiers(2);
        final Class<?> gc = ReflectionHelper.getGenericClass(t.getType());
        if (gc != null) {
            declaredAnnotations = Arrays.copyOf(declaredAnnotations, declaredAnnotations.length + 1);
            declaredAnnotations[declaredAnnotations.length - 1] = new GenericClass(){

                public Class clazz() {
                    return gc;
                }

                public Class<? extends java.lang.annotation.Annotation> annotationType() {
                    return GenericClass.class;
                }
            };
        }
        ReflectionHelper.addField(avoidedAnnotationNames, pool, cfile, cpool, cc, ctf, forFilters, (Class)type, fieldName, declaredAnnotations, forceSameLine, false, null, -1, null);
    }

    private static void addField(List<String> avoidedAnnotationNames, ClassPool pool, ClassFile cfile, ConstPool cpool, CtClass cc, boolean forFilters, Class t, String fieldName, java.lang.annotation.Annotation[] declaredAnnotations, boolean forceSameLine, boolean forInlineEditing, String caption, int valueKey, FieldInterfaced collectionField) throws Exception {
        CtField ctf = new CtField(pool.get(t.getName()), fieldName, cc);
        cc.addField(ctf);
        ctf.setModifiers(2);
        ReflectionHelper.addField(avoidedAnnotationNames, pool, cfile, cpool, cc, ctf, forFilters, t, fieldName, declaredAnnotations, forceSameLine, false, null, -1, null);
    }

    private static void addField(List<String> avoidedAnnotationNames, ClassPool pool, ClassFile cfile, ConstPool cpool, CtClass cc, CtField ctf, boolean forFilters, Class t, String fieldName, java.lang.annotation.Annotation[] declaredAnnotations, boolean forceSameLine, boolean forInlineEditing, final String caption, int valueKey, FieldInterfaced collectionField) throws Exception {
        boolean yaEsta;
        if (forceSameLine) {
            yaEsta = false;
            for (java.lang.annotation.Annotation a : declaredAnnotations) {
                if (!SameLine.class.equals(a.annotationType())) continue;
                yaEsta = true;
                break;
            }
            if (!yaEsta) {
                declaredAnnotations = Arrays.copyOf(declaredAnnotations, declaredAnnotations.length + 1);
                declaredAnnotations[declaredAnnotations.length - 1] = new SameLine(){

                    public Class<? extends java.lang.annotation.Annotation> annotationType() {
                        return SameLine.class;
                    }
                };
            }
        }
        if (caption != null) {
            yaEsta = false;
            for (java.lang.annotation.Annotation a : declaredAnnotations) {
                if (!Caption.class.equals(a.annotationType())) continue;
                yaEsta = true;
                break;
            }
            if (!yaEsta) {
                declaredAnnotations = Arrays.copyOf(declaredAnnotations, declaredAnnotations.length + 1);
                declaredAnnotations[declaredAnnotations.length - 1] = new Caption(){

                    public String value() {
                        return caption;
                    }

                    public Class<? extends java.lang.annotation.Annotation> annotationType() {
                        return Caption.class;
                    }
                };
            }
        }
        if (declaredAnnotations.length > 0) {
            boolean hay;
            boolean bl = hay = !forFilters;
            if (!hay) {
                for (java.lang.annotation.Annotation a : declaredAnnotations) {
                    String n = a.annotationType().getSimpleName();
                    if (avoidedAnnotationNames.contains(n) && (!forceSameLine || !"SameLine".equals(n)) && (caption == null || !"Caption".equals(n))) continue;
                    hay = true;
                    break;
                }
            }
            if (hay) {
                AnnotationsAttribute attr = new AnnotationsAttribute(cpool, "RuntimeVisibleAnnotations");
                for (java.lang.annotation.Annotation a : declaredAnnotations) {
                    String n = a.annotationType().getSimpleName();
                    if (forFilters && avoidedAnnotationNames.contains(n) && (!forceSameLine || !"SameLine".equals(n)) && (caption == null || !"Caption".equals(n))) continue;
                    ReflectionHelper.addAnnotation(cc, cfile, cpool, ctf, a, attr);
                }
                ctf.getFieldInfo().addAttribute((AttributeInfo)attr);
            }
        }
        if (forInlineEditing) {
            CtMethod g = CtNewMethod.getter((String)ReflectionHelper.getGetter(t, fieldName), (CtField)ctf);
            cc.addMethod(g);
            if (valueKey >= 0) {
                String b = "return this._proxied." + ReflectionHelper.getGetter(collectionField) + "().contains(((" + Map.class.getName() + ")this._possibleValues.get(\"" + collectionField.getName() + "\")).get(new Integer(" + valueKey + ")));";
                g.setBody("{" + b + "}");
            } else {
                g.setBody("return this._proxied." + g.getName() + "();");
            }
            CtMethod s = CtNewMethod.setter((String)ReflectionHelper.getSetter(t, fieldName), (CtField)ctf);
            cc.addMethod(s);
            if (valueKey >= 0) {
                String b = "if ($1) {Object tercero = ((" + Map.class.getName() + ")this._possibleValues.get(\"" + collectionField.getName() + "\")).get(new Integer(" + valueKey + "));this._proxied." + ReflectionHelper.getGetter(collectionField) + "().add(tercero); this._binder.getMergeables().add(tercero);" + FieldInterfaced.class.getName() + " field = " + ReflectionHelper.class.getName() + ".getFieldByName(this._proxied.getClass(), \"" + collectionField.getName() + "\");this._binder.getMergeables().add(tercero);" + ReflectionHelper.class.getName() + ".reverseMap(this._binder, field, this._proxied, tercero);} else {Object tercero = ((" + Map.class.getName() + ")this._possibleValues.get(\"" + collectionField.getName() + "\")).get(new Integer(" + valueKey + "));this._proxied." + ReflectionHelper.getGetter(collectionField) + "().remove(tercero);" + FieldInterfaced.class.getName() + " field = " + ReflectionHelper.class.getName() + ".getFieldByName(this._proxied.getClass(), \"" + collectionField.getName() + "\");this._binder.getMergeables().add(tercero);" + ReflectionHelper.class.getName() + ".unReverseMap(this._binder, field, this._proxied, tercero);}";
                log.debug(b);
                s.setBody("{" + b + "}");
            } else {
                s.setBody("this._proxied." + s.getName() + "($1);");
            }
        } else {
            cc.addMethod(CtNewMethod.getter((String)ReflectionHelper.getGetter(t, fieldName), (CtField)ctf));
            cc.addMethod(CtNewMethod.setter((String)ReflectionHelper.getSetter(t, fieldName), (CtField)ctf));
        }
    }

    private static void addAnnotation(CtClass cc, ClassFile cfile, ConstPool cpool, CtField ctf, java.lang.annotation.Annotation a, AnnotationsAttribute attr) throws InvocationTargetException, IllegalAccessException {
        Annotation annot = new Annotation(a.annotationType().getName(), cpool);
        for (Method m : a.annotationType().getDeclaredMethods()) {
            MemberValue mv;
            log.debug(m.getName());
            Object v = m.invoke((Object)a, new Object[0]);
            if (v == null || (mv = ReflectionHelper.getAnnotationMemberValue(cpool, m.getReturnType(), v)) == null) continue;
            annot.addMemberValue(m.getName(), mv);
        }
        attr.addAnnotation(annot);
    }

    private static MemberValue getAnnotationMemberValue(ConstPool cpool, Class t, Object v) {
        IntegerMemberValue mv = null;
        if (v != null) {
            if (Integer.TYPE.equals(t)) {
                mv = new IntegerMemberValue(cpool, ((Integer)v).intValue());
            } else if (Long.TYPE.equals(t)) {
                mv = new LongMemberValue(((Long)v).longValue(), cpool);
            } else if (Double.TYPE.equals(t)) {
                mv = new DoubleMemberValue(((Double)v).doubleValue(), cpool);
            } else if (Boolean.TYPE.equals(t)) {
                mv = new BooleanMemberValue(((Boolean)v).booleanValue(), cpool);
            } else if (t.isEnum()) {
                EnumMemberValue emv = new EnumMemberValue(cpool);
                mv = emv;
                emv.setType(t.getName());
                emv.setValue(v.toString());
            } else if (String.class.equals((Object)t)) {
                mv = new StringMemberValue((String)v, cpool);
            } else if (Class.class.equals((Object)t)) {
                mv = new ClassMemberValue(((Class)v).getName(), cpool);
            } else if (v instanceof Annotation) {
                mv = new AnnotationMemberValue((Annotation)v, cpool);
            } else if (Byte.TYPE.equals(t)) {
                mv = new ByteMemberValue(((Byte)v).byteValue(), cpool);
            } else if (Float.TYPE.equals(t)) {
                mv = new FloatMemberValue(((Float)v).floatValue(), cpool);
            } else if (Short.TYPE.equals(t)) {
                mv = new ShortMemberValue(((Short)v).shortValue(), cpool);
            } else if (t.isArray()) {
                ArrayMemberValue amv = new ArrayMemberValue(cpool);
                mv = amv;
                ArrayList<MemberValue> mvs = new ArrayList<MemberValue>();
                for (Object c : (Object[])v) {
                    MemberValue mvx = ReflectionHelper.getAnnotationMemberValue(cpool, c.getClass(), c);
                    if (mvx == null) continue;
                    mvs.add(mvx);
                }
                amv.setValue(mvs.toArray(new MemberValue[0]));
            } else {
                log.debug("ups");
            }
        }
        return mv;
    }

    public static Class createClass(ClassPool classPool, Class mddBinderClass, ClassLoader classLoader, String fullClassName, List<FieldInterfaced> fields, boolean forFilters) throws Exception {
        try {
            Class<?> c = Class.forName(fullClassName, false, classLoader);
            log.debug("class " + fullClassName + " already exists");
            return c;
        }
        catch (ClassNotFoundException e) {
            Class c = ReflectionHelper.createClassUsingJavassist2(classPool, mddBinderClass, fullClassName, fields, forFilters);
            return c;
        }
    }

    public static Class createClass(ClassPool classPool, Class mddBinderClass, ClassLoader classLoader, String fullClassName, List<FieldInterfaced> fields, boolean forFilters, boolean forInlineEditing, FieldInterfaced collectionField, Object owner) throws Exception {
        if (forInlineEditing) {
            Class c = ReflectionHelper.createClassUsingJavassist2(classPool, mddBinderClass, fullClassName, fields, forFilters, forInlineEditing, collectionField, owner);
            return c;
        }
        try {
            Class<?> c = Class.forName(fullClassName, false, classLoader);
            log.debug("class " + fullClassName + " already exists");
            return c;
        }
        catch (ClassNotFoundException e) {
            Class c = ReflectionHelper.createClassUsingJavassist2(classPool, mddBinderClass, fullClassName, fields, forFilters, forInlineEditing, collectionField, owner);
            return c;
        }
    }

    public static void main(String[] args) throws Exception {
    }

    public static ClassPool createClassPool(ServletContext servletContext) {
        ClassPool pool = ClassPool.getDefault();
        return pool;
    }

    public static String getFirstUpper(String fieldName) {
        return fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
    }

    public static Object clone(Object original) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        if (original == null) {
            return null;
        }
        Method m = ReflectionHelper.getMethod(original.getClass(), "cloneAsConverted");
        if (m != null) {
            return m.invoke(original, new Object[0]);
        }
        Object copy = null;
        Constructor con = ReflectionHelper.getConstructor(original.getClass());
        if (con != null && con.getParameterCount() == 0) {
            copy = con.newInstance(new Object[0]);
        } else {
            con = Arrays.stream(original.getClass().getDeclaredConstructors()).filter(x -> x.getParameterCount() == 0).findFirst().orElse(null);
            if (!Modifier.isPublic(con.getModifiers())) {
                con.setAccessible(true);
            }
            copy = con.newInstance(new Object[0]);
        }
        for (FieldInterfaced f : ReflectionHelper.getAllFields(original.getClass())) {
            if (f.isAnnotationPresent(Id.class)) continue;
            ReflectionHelper.setValue(f, copy, ReflectionHelper.getValue(f, original));
        }
        return copy;
    }

    public static void delete(EntityManager em, Object o) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (o != null) {
            for (FieldInterfaced f : ReflectionHelper.getAllFields(o.getClass())) {
                CascadeType[] c;
                Object t = ReflectionHelper.getValue(f, o);
                if (t == null) continue;
                boolean owner = false;
                if (f.isAnnotationPresent(ManyToOne.class) && (c = ((ManyToOne)f.getAnnotation(ManyToOne.class)).cascade()) != null) {
                    for (CascadeType cx : c) {
                        if (!CascadeType.ALL.equals((Object)cx) && !CascadeType.REMOVE.equals((Object)cx)) continue;
                        owner = true;
                        break;
                    }
                }
                if (f.isAnnotationPresent(OneToMany.class) && (c = ((OneToMany)f.getAnnotation(OneToMany.class)).cascade()) != null) {
                    for (CascadeType cx : c) {
                        if (!CascadeType.ALL.equals((Object)cx) && !CascadeType.REMOVE.equals((Object)cx)) continue;
                        owner = true;
                        break;
                    }
                }
                if (f.isAnnotationPresent(ManyToMany.class) && (c = ((ManyToMany)f.getAnnotation(ManyToMany.class)).cascade()) != null) {
                    for (CascadeType cx : c) {
                        if (!CascadeType.ALL.equals((Object)cx) && !CascadeType.REMOVE.equals((Object)cx)) continue;
                        owner = true;
                        break;
                    }
                }
                if (owner || !f.isAnnotationPresent(OneToMany.class) && !f.isAnnotationPresent(ManyToMany.class)) continue;
                FieldInterfaced mbf = ReflectionHelper.getMapper(f);
                if (Collection.class.isAssignableFrom(t.getClass())) {
                    Collection col = (Collection)t;
                    t = col.size() > 0 ? col.iterator().next() : null;
                }
                if (mbf == null || t == null) continue;
                throw new Error(o + " is referenced from " + t);
            }
            em.remove(o);
        }
    }

    public static Class getProxy(ClassPool classPool, Class mddBinderClass, ClassLoader classLoader, String fieldsFilter, Class sourceClass, FieldInterfaced collectionField, Object owner, List<FieldInterfaced> editableFields) {
        try {
            return ReflectionHelper.createClass(classPool, mddBinderClass, classLoader, sourceClass.getName() + "000EditableInline" + UUID.randomUUID().toString(), ReflectionHelper.getAllEditableFilteredFields(sourceClass, fieldsFilter, editableFields), false, true, collectionField, owner);
        }
        catch (Exception e) {
            Notifier.alert((Throwable)e);
            return null;
        }
    }

    public static Object toId(Class c, String s) {
        Object id = s;
        FieldInterfaced f = ReflectionHelper.getIdField(c);
        if (Long.class.equals((Object)f.getType()) || Long.TYPE.equals(f.getType())) {
            id = Long.parseLong(s);
        }
        if (Integer.class.equals((Object)f.getType()) || Integer.TYPE.equals(f.getType())) {
            id = Integer.parseInt(s);
        }
        return id;
    }

    public static void copy(Object o1, Object o2) {
        block8: {
            if (o1 == null || o2 == null) break block8;
            if (o1.getClass().equals(o2.getClass())) {
                for (FieldInterfaced f : ReflectionHelper.getAllEditableFields(o2.getClass())) {
                    try {
                        ReflectionHelper.setValue(f, o2, ReflectionHelper.getValue(f, o1));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else {
                for (FieldInterfaced f2 : ReflectionHelper.getAllEditableFields(o2.getClass())) {
                    try {
                        FieldInterfaced f1 = ReflectionHelper.getFieldByName(o1.getClass(), f2.getName());
                        if (f1 == null || !f1.getType().equals(f2.getType())) continue;
                        ReflectionHelper.setValue(f2, o2, ReflectionHelper.getValue(f1, o1));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public static Object newInstance(Constructor c, Object params) throws Throwable {
        ArrayList<Object> vs = new ArrayList<Object>();
        for (Parameter p : c.getParameters()) {
            if (params != null && ReflectionHelper.getFieldByName(params.getClass(), p.getName()) != null) {
                vs.add(ReflectionHelper.getValue(ReflectionHelper.getFieldByName(params.getClass(), p.getName()), params));
                continue;
            }
            Constable v = null;
            if (Integer.TYPE.equals(p.getType())) {
                v = 0;
            }
            if (Long.TYPE.equals(p.getType())) {
                v = 0L;
            }
            if (Float.TYPE.equals(p.getType())) {
                v = Float.valueOf(0.0f);
            }
            if (Double.TYPE.equals(p.getType())) {
                v = 0.0;
            }
            if (Boolean.TYPE.equals(p.getType())) {
                v = Boolean.valueOf(false);
            }
            vs.add(v);
        }
        Object[] args = vs.toArray();
        return c.newInstance(args);
    }

    public static Object newInstance(Class c) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Object o = null;
        if (!notFromString.contains(c)) {
            o = beanProvider.getBean(c);
        }
        if (o == null) {
            if (c.getDeclaringClass() != null) {
                Object p = ReflectionHelper.newInstance(c.getDeclaringClass());
                Constructor<?> cons = c.getDeclaredConstructors()[0];
                cons.setAccessible(true);
                o = cons.newInstance(p);
            } else {
                Constructor con = ReflectionHelper.getConstructor(c);
                o = con.newInstance(new Object[0]);
            }
            notFromString.add(c);
        }
        return o;
    }

    public static Object newInstance(Class c, Object parent) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        Object i = null;
        if (parent != null) {
            Constructor con = ReflectionHelper.getConstructor(c, parent.getClass());
            if (con != null) {
                i = con.newInstance(parent);
            } else {
                con = Arrays.stream(c.getDeclaredConstructors()).filter(x -> x.getParameterCount() == 0).findFirst().orElse(null);
                if (!Modifier.isPublic(con.getModifiers())) {
                    con.setAccessible(true);
                }
                i = con.newInstance(new Object[0]);
                for (FieldInterfaced f : ReflectionHelper.getAllFields(c)) {
                    if (!f.getType().equals(parent.getClass()) || !f.isAnnotationPresent(NotNull.class)) continue;
                    ReflectionHelper.setValue(f, i, parent);
                    break;
                }
            }
        } else {
            Constructor con = ReflectionHelper.getConstructor(c);
            i = con.newInstance(new Object[0]);
        }
        ReflectionHelper.auditar(i);
        return i;
    }

    public static Constructor getConstructor(Class type) {
        Constructor<?> con = null;
        int minParams = Integer.MAX_VALUE;
        for (Constructor<?> x : type.getConstructors()) {
            if (!Modifier.isPublic(x.getModifiers()) || x.getParameterCount() >= minParams) continue;
            con = x;
            minParams = con.getParameterCount();
        }
        return con;
    }

    public static Constructor getConstructor(Class c, Class parameterClass) {
        Constructor con = null;
        while (con == null && !Object.class.equals((Object)parameterClass)) {
            try {
                con = c.getConstructor(parameterClass);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (con != null) continue;
            parameterClass = parameterClass.getSuperclass();
        }
        return con;
    }

    public static void auditar(Object bean) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        for (FieldInterfaced f : ReflectionHelper.getAllFields(bean.getClass())) {
            if (!AuditRecord.class.isAssignableFrom(f.getType())) continue;
            AuditRecord a = (AuditRecord)ReflectionHelper.getValue(f, bean);
            if (a == null) {
                try {
                    a = ((GeneralRepository)Helper.getImpl(GeneralRepository.class)).getNewAudit();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                ReflectionHelper.setValue(f, bean, (Object)a);
                continue;
            }
            try {
                a.touch();
            }
            catch (Throwable throwable) {
                Notifier.alert((Throwable)throwable);
            }
        }
    }

    public static String toHtml(Object o) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ReflectionHelper.toHtml(pw, o, new ArrayList());
        return sw.toString();
    }

    public static void toHtml(PrintWriter pw, Object o, List visited) {
        if (o != null) {
            if (!visited.contains(o)) {
                visited.add(o);
            }
            pw.println("<table>");
            for (FieldInterfaced f : ReflectionHelper.getAllFields(o.getClass())) {
                try {
                    Object i = ReflectionHelper.getValue(f, o);
                    pw.println("<tr><td style='text-align:right; font-style:italic;'>" + Helper.capitalize((String)f.getName()) + ":</td><td>");
                    if (i != null) {
                        if (BaseReflectionHelper.isBasico(i)) {
                            pw.print("" + i);
                        } else {
                            ReflectionHelper.toHtml(pw, i, visited);
                        }
                    }
                    pw.println("</td></tr>");
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
            pw.println("</table>");
        }
    }

    public static Element toXml(Object o) {
        return ReflectionHelper.toXml(o, new ArrayList());
    }

    public static Element toXml(Object o, List visited) {
        if (o == null) {
            return null;
        }
        if (!visited.contains(o)) {
            visited.add(o);
        }
        Element e = new Element(o.getClass().getSimpleName());
        e.setAttribute("className", o.getClass().getName());
        for (FieldInterfaced f : ReflectionHelper.getAllFields(o.getClass())) {
            try {
                Object i = ReflectionHelper.getValue(f, o);
                if (i == null) continue;
                if (BaseReflectionHelper.isBasico(i)) {
                    e.setAttribute(f.getName(), "" + i);
                    continue;
                }
                e.addContent((Content)ReflectionHelper.toXml(i, visited));
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        return e;
    }

    public static Object fromXml(String s) {
        if (Strings.isNullOrEmpty((String)s)) {
            return null;
        }
        try {
            Document doc = new SAXBuilder().build((Reader)new StringReader(s));
            Element root = doc.getRootElement();
            HashMap o = null;
            o = root.getAttribute("className") != null && !Strings.isNullOrEmpty((String)root.getAttributeValue("className")) ? Class.forName(root.getAttributeValue("className")).newInstance() : new HashMap();
            return o;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> Collection<T> extend(Collection<T> list, T o) {
        if (list == null) {
            return null;
        }
        if (list instanceof ImmutableList) {
            return ReflectionHelper.extend((ImmutableList)list, o);
        }
        if (list instanceof ImmutableSet) {
            return ReflectionHelper.extend((ImmutableSet)list, o);
        }
        if (Set.class.isAssignableFrom(list.getClass())) {
            return ReflectionHelper.extend((Set)list, o);
        }
        return ReflectionHelper.extend((List)list, o);
    }

    public static <T> List<T> extend(List<T> list, T o) {
        ArrayList<T> l = new ArrayList<T>(list);
        l.add(o);
        return l;
    }

    public static <T> ImmutableList<T> extend(ImmutableList<T> list, T o) {
        ArrayList<T> l = new ArrayList<T>(list);
        l.add(o);
        return ImmutableList.copyOf(l);
    }

    public static <T> Set<T> extend(Set<T> list, T o) {
        HashSet<T> l = new HashSet<T>(list);
        l.add(o);
        return l;
    }

    public static <T> ImmutableSet<T> extend(ImmutableSet<T> list, T o) {
        HashSet<T> l = new HashSet<T>(list);
        l.add(o);
        return ImmutableSet.copyOf(l);
    }

    public static <K, V> Map<K, V> extend(Map<K, V> list, K k, V v) {
        HashMap<K, V> l = new HashMap<K, V>(list);
        l.put(k, v);
        return l;
    }

    public static <K, V> ImmutableMap<K, V> extend(ImmutableMap<K, V> list, K k, V v) {
        HashMap<K, V> l = new HashMap<K, V>(list);
        l.put(k, v);
        return ImmutableMap.copyOf(l);
    }

    public static <T> Collection<T> remove(Collection<T> list, T o) {
        if (list == null) {
            return null;
        }
        if (list instanceof ImmutableList) {
            return ReflectionHelper.remove((ImmutableList)list, o);
        }
        if (list instanceof ImmutableSet) {
            return ReflectionHelper.remove((ImmutableSet)list, o);
        }
        if (Set.class.isAssignableFrom(list.getClass())) {
            return ReflectionHelper.remove((Set)list, o);
        }
        return ReflectionHelper.remove((List)list, o);
    }

    public static <T> List<T> remove(List<T> list, T o) {
        if (list == null) {
            return null;
        }
        ArrayList<T> l = new ArrayList<T>(list);
        l.remove(o);
        return l;
    }

    public static <T> Set<T> remove(Set<T> list, T o) {
        if (list == null) {
            return null;
        }
        HashSet<T> l = new HashSet<T>(list);
        l.remove(o);
        return l;
    }

    public static <T> ImmutableList<T> remove(ImmutableList<T> list, T o) {
        if (list == null) {
            return null;
        }
        ArrayList<T> l = new ArrayList<T>(list);
        l.remove(o);
        return ImmutableList.copyOf(l);
    }

    public static <T> ImmutableSet<T> remove(ImmutableSet<T> list, T o) {
        if (list == null) {
            return null;
        }
        HashSet<T> l = new HashSet<T>(list);
        l.remove(o);
        return ImmutableSet.copyOf(l);
    }

    public static <K, V> ImmutableMap<K, V> remove(ImmutableMap<K, V> list, K o) {
        if (list == null) {
            return null;
        }
        HashMap<K, V> l = new HashMap<K, V>(list);
        l.remove(o);
        return ImmutableMap.copyOf(l);
    }

    public static <T> Collection<T> removeAll(Collection<T> list, Collection o) {
        if (list == null) {
            return null;
        }
        if (list instanceof ImmutableList) {
            return ReflectionHelper.removeAll((ImmutableList)list, o);
        }
        if (list instanceof ImmutableSet) {
            return ReflectionHelper.removeAll((ImmutableSet)list, o);
        }
        if (Set.class.isAssignableFrom(list.getClass())) {
            return ReflectionHelper.removeAll((Set)list, o);
        }
        return ReflectionHelper.removeAll((List)list, o);
    }

    public static <T> List<T> removeAll(List<T> list, Collection o) {
        if (list == null) {
            return null;
        }
        ArrayList<T> l = new ArrayList<T>(list);
        l.removeAll(o);
        return l;
    }

    public static <T> Set<T> removeAll(Set<T> list, Collection o) {
        if (list == null) {
            return null;
        }
        HashSet<T> l = new HashSet<T>(list);
        l.removeAll(o);
        return l;
    }

    public static <T> ImmutableList<T> removeAll(ImmutableList<T> list, Collection o) {
        if (list == null) {
            return null;
        }
        ArrayList<T> l = new ArrayList<T>(list);
        l.removeAll(o);
        return ImmutableList.copyOf(l);
    }

    public static <T> ImmutableSet<T> removeAll(ImmutableSet<T> list, Collection o) {
        if (list == null) {
            return null;
        }
        HashSet<T> l = new HashSet<T>(list);
        l.removeAll(o);
        return ImmutableSet.copyOf(l);
    }

    static {
        BeanUtilsBean beanUtilsBean = BeanUtilsBean.getInstance();
        beanUtilsBean.getConvertUtils().register((Converter)new IntegerConverter(null), Integer.class);
        beanUtilsBean.getConvertUtils().register((Converter)new LongConverter(null), Long.class);
        beanUtilsBean.getConvertUtils().register((Converter)new DoubleConverter(null), Double.class);
        beanUtilsBean.getConvertUtils().register((Converter)new BooleanConverter(null), Boolean.class);
    }
}

