/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.util.Map;

public class Serializer {
    private static ObjectMapper mapper = new ObjectMapper();
    private static ObjectMapper yamlMapper = new ObjectMapper((JsonFactory)new YAMLFactory());

    public static Map<String, Object> fromJson(String json) throws IOException {
        if (json == null || "".equals(json)) {
            json = "{}";
        }
        return (Map)mapper.readValue(json, Map.class);
    }

    public static <T> T fromJson(String json, Class<T> c) throws IOException {
        if (json == null || "".equals(json)) {
            json = "{}";
        }
        return (T)mapper.readValue(json, c);
    }

    public static String toJson(Object o) throws IOException {
        return mapper.writeValueAsString(o);
    }

    public static Map<String, Object> fromYaml(String yaml) throws IOException {
        if (yaml == null) {
            yaml = "";
        }
        return (Map)yamlMapper.readValue(yaml, Map.class);
    }

    public static <T> T fromYaml(String yaml, Class<T> c) throws IOException {
        if (yaml == null) {
            yaml = "";
        }
        return (T)yamlMapper.readValue(yaml, c);
    }

    public static String toYaml(Object o) throws IOException {
        return yamlMapper.writeValueAsString(o);
    }

    static {
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        mapper.registerModule((Module)new JavaTimeModule());
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        yamlMapper.enable(SerializationFeature.INDENT_OUTPUT);
        yamlMapper.registerModule((Module)new JavaTimeModule());
        yamlMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
    }
}

