/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.util.app;

import io.mateu.mdd.shared.AppContextListener;
import io.mateu.mdd.shared.BoundedContextListener;
import io.mateu.mdd.shared.Command;
import io.mateu.util.SharedHelper;
import io.mateu.util.app.ShutdownHookThread;
import io.mateu.util.eventBus.EventBus;
import io.mateu.util.quartz.QuartzEngine;
import java.util.Arrays;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.quartz.Scheduler;

public class MateuApplication {
    private Scheduler scheduler;
    protected static HashMap<String, Command> scheduledCommands = new HashMap();

    public MateuApplication start() {
        this._start();
        return this;
    }

    @PostConstruct
    private void _start() {
        this.init();
        this.started();
    }

    private void init() {
        SharedHelper.loadProperties();
        try {
            SharedHelper.getImpls(AppContextListener.class).stream().forEach(c -> c.init());
            SharedHelper.getImpls(BoundedContextListener.class).stream().forEach(c -> c.init());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            SharedHelper.getImpls(AppContextListener.class).stream().forEach(c -> c.registerEventConsumers());
            SharedHelper.getImpls(BoundedContextListener.class).stream().forEach(c -> c.registerEventConsumers());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            SharedHelper.getImpls(AppContextListener.class).stream().forEach(c -> {
                if (c.isPopulationNeeded()) {
                    try {
                        c.populate();
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(new ShutdownHookThread(this)));
    }

    private void started() {
        try {
            SharedHelper.getImpls(AppContextListener.class).stream().forEach(c -> QuartzEngine.runAndSchedule(c.getCommands()));
            SharedHelper.getImpls(BoundedContextListener.class).stream().forEach(c -> QuartzEngine.runAndSchedule(c.getCommands()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void run(Command ... commands) {
        this.init();
        QuartzEngine.runAndSchedule(Arrays.asList(commands));
        this.destroy();
    }

    @PreDestroy
    public void destroy() {
        try {
            SharedHelper.getImpls(AppContextListener.class).stream().forEach(c -> c.destroyed());
            SharedHelper.getImpls(BoundedContextListener.class).stream().forEach(c -> c.contextDestroyed());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        QuartzEngine.destroy();
        EventBus.shutdown();
    }
}

