/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.util.eventBus;

import io.mateu.util.eventBus.Event;
import io.mateu.util.reflection.MiniReflectionHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class EventBus {
    private final Thread worker;
    private Map<Class, List<Consumer>> consumers = new HashMap<Class, List<Consumer>>();
    private List<Event> events = new ArrayList<Event>();
    static EventBus instance;

    static synchronized EventBus get() {
        if (instance == null) {
            instance = new EventBus();
        }
        return instance;
    }

    public EventBus() {
        this.worker = new Thread(() -> {
            try {
                while (true) {
                    if (this.events.size() > 0) {
                        Event event = this.events.remove(0);
                        List<Consumer> l = this.consumers.get(event.getClass());
                        if (l == null || l.size() == 0) {
                            System.out.println("**** NO CONSUMER FOR EVENTS OF TYPE " + event.getClass().getSimpleName() + " ****");
                            continue;
                        }
                        l.stream().forEach(c -> c.accept(event));
                        continue;
                    }
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException e) {
                System.out.println("EventBus worker thread interrupted");
                return;
            }
        });
        this.worker.start();
    }

    public static void publish(Event event) {
        new Thread(() -> {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            EventBus.get().events.add(event);
        }).start();
    }

    public static void register(Consumer consumer) {
        if (consumer != null) {
            Class<?> eventClass = MiniReflectionHelper.getGenericClass(consumer.getClass());
            List<Consumer> l = EventBus.get().consumers.get(eventClass);
            if (l == null) {
                l = new ArrayList<Consumer>();
                EventBus.get().consumers.put(eventClass, l);
            }
            l.add(consumer);
        }
    }

    public static void unregister(Consumer consumer) {
        Class<?> eventClass;
        List<Consumer> l;
        if (consumer != null && (l = EventBus.get().consumers.get(eventClass = MiniReflectionHelper.getGenericClass(consumer.getClass()))) != null) {
            l.remove(consumer);
        }
    }

    public static void shutdown() {
        EventBus.get()._shutdown();
    }

    private void _shutdown() {
        if (this.worker != null && !this.worker.isInterrupted()) {
            this.worker.interrupt();
        }
    }
}

