/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.util;

import com.Ostermiller.util.CSVParser;
import com.Ostermiller.util.CSVPrinter;
import com.github.slugify.Slugify;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.UrlEncodedContent;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.util.ObjectParser;
import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import io.mateu.mdd.shared.AppConfigLocator;
import io.mateu.mdd.shared.IAppConfig;
import io.mateu.util.Serializer;
import io.mateu.util.SharedHelper;
import io.mateu.util.i18n.DeepLClient;
import io.mateu.util.runtime.MemInfo;
import io.mateu.util.xml.XMLSerializable;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.UUID;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMultipart;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.sql.DataSource;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.commons.mail.DefaultAuthenticator;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.apps.FopFactoryBuilder;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class Helper {
    private static final Logger log = LoggerFactory.getLogger(Helper.class);
    private static Configuration fopConfig;
    private static ScriptEngineManager scriptEngineManager;
    static final HttpTransport HTTP_TRANSPORT;
    static final JsonFactory JSON_FACTORY;
    private static DataSource dataSource;
    private static freemarker.template.Configuration cfg;
    private static final int BUFFER = 2048;

    public Helper() {
        try {
            cfg.setDirectoryForTemplateLoading(new File(""));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        cfg.setDefaultEncoding("UTF-8");
        cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        cfg.setLogTemplateExceptions(false);
    }

    public static LocalDate toDate(int n) {
        return LocalDate.of((n - n % 10000) / 10000, (n % 10000 - n % 100) / 100, n % 100);
    }

    public static int toInt(LocalDate n) {
        return n.getDayOfMonth() + n.getMonthValue() * 100 + n.getYear() * 10000;
    }

    public static long dias(LocalDate start, LocalDate end) {
        return ChronoUnit.DAYS.between(start, end);
    }

    public static long noches(LocalDate start, LocalDate end) {
        return ChronoUnit.DAYS.between(start, end) - 1L;
    }

    public static boolean intersects(LocalDate start, LocalDate end, LocalDate checkIn, LocalDate checkOut) {
        return !(start != null && !start.isBefore(checkOut) || end != null && end.compareTo(checkIn) < 0);
    }

    public static boolean cabe(LocalDate validFrom, LocalDate validTo, LocalDate checkIn, LocalDate checkOut) {
        return validFrom.compareTo(checkIn) <= 0 && validTo.compareTo(checkOut) >= 0;
    }

    public static Map<String, Object> fromJson(String json) throws IOException {
        return Serializer.fromJson(json);
    }

    public static <T> T fromJson(String json, Class<T> c) throws IOException {
        return Serializer.fromJson(json, c);
    }

    public static String toJson(Object o) throws IOException {
        return Serializer.toJson(o);
    }

    public static Map<String, Object> fromYaml(String yaml) throws IOException {
        return Serializer.fromYaml(yaml);
    }

    public static <T> T fromYaml(String yaml, Class<T> c) throws IOException {
        return Serializer.fromYaml(yaml, c);
    }

    public static String toYaml(Object o) throws IOException {
        return Serializer.toYaml(o);
    }

    public static String md5(String s) {
        return Hashing.sha256().newHasher().putString((CharSequence)s, Charsets.UTF_8).hash().toString();
    }

    public static void setDataSource(DataSource dataSource) {
        Helper.dataSource = dataSource;
    }

    public static String freemark(String freemarker, Map<String, Object> root) throws IOException, TemplateException {
        long t0 = new Date().getTime();
        freemarker.template.Configuration conf = new freemarker.template.Configuration();
        conf.setDefaultEncoding("utf-8");
        Template temp = new Template("name", (Reader)new StringReader(freemarker), conf);
        StringWriter out = new StringWriter();
        temp.process(root, (Writer)out);
        log.debug("freemarker template compiled and applied in " + (new Date().getTime() - t0) + " ms.");
        return out.toString();
    }

    public static URL whichJar(Class c) {
        return c.getProtectionDomain().getCodeSource().getLocation();
    }

    public static double roundEuros(double value) {
        return (double)Math.round(value * 100.0) / 100.0;
    }

    public static String formatEuros(double value) {
        return new DecimalFormat("##,###,###,###,###,###.00").format(value);
    }

    public static String capitalize(String s) {
        return Helper.capitalize(s, true);
    }

    public static String capitalize(String s, boolean startWithUppercase) {
        if (s == null || "".equals(s)) {
            return s;
        }
        s = s.replaceAll("\\.", " ");
        String c = s.replaceAll(String.format("%s|%s|%s", "(?<=[A-Z])(?=[A-Z][a-z])", "(?<=[^A-Z])(?=[A-Z])", "(?<=[A-Za-z])(?=[^A-Za-z])"), " ").toLowerCase();
        c = c.replaceAll("[ ]+", " ");
        if (startWithUppercase && c.length() > 1) {
            c = c.substring(0, 1).toUpperCase() + c.substring(1);
        }
        return c;
    }

    public static String camelcasize(String s) {
        if (s == null || "".equals(s)) {
            return s;
        }
        s = s.replaceAll("\\.", " ");
        String c = s.replaceAll(String.format("%s|%s|%s", "(?<=[A-Z])(?=[A-Z][a-z])", "(?<=[^A-Z])(?=[A-Z])", "(?<=[A-Za-z])(?=[^A-Za-z])"), " ").toLowerCase();
        if ((c = c.replaceAll("[ ]+", " ")).length() > 1) {
            String aux = c;
            c = "";
            int pos = 0;
            for (String z : aux.split(" ")) {
                c = pos++ > 0 && !Strings.isNullOrEmpty((String)z) ? c + z.substring(0, 1).toUpperCase() + z.substring(1) : c + z;
            }
        }
        return c;
    }

    public static String urlize(String s) {
        return new Slugify().slugify(s);
    }

    public static String pluralize(String s) {
        if (s == null || "".equals(s)) {
            return s;
        }
        if ((s = s.endsWith("s") ? s + "es" : s + "s").endsWith("ys")) {
            s = s.replaceAll("ys$", "ies");
        }
        return s;
    }

    public static String httpGet(String url) throws IOException {
        log.debug("HTTP GET " + url);
        HttpRequestFactory requestFactory = HTTP_TRANSPORT.createRequestFactory(new HttpRequestInitializer(){

            public void initialize(HttpRequest request) {
                request.setParser((ObjectParser)new JsonObjectParser(JSON_FACTORY));
            }
        });
        HttpRequest request = requestFactory.buildGetRequest(new GenericUrl(url));
        return request.execute().parseAsString();
    }

    public static String httpPost(String url, Map<String, String> parameters) throws IOException {
        log.debug("HTTP POST " + url);
        HttpRequestFactory requestFactory = HTTP_TRANSPORT.createRequestFactory(new HttpRequestInitializer(){

            public void initialize(HttpRequest request) {
                request.setParser((ObjectParser)new JsonObjectParser(JSON_FACTORY));
            }
        });
        HttpRequest request = requestFactory.buildPostRequest(new GenericUrl(url), (HttpContent)new UrlEncodedContent((Object)""));
        return request.execute().parseAsString();
    }

    public static Object[][][] parseExcel(File f) throws IOException, InvalidFormatException {
        ArrayList l0 = new ArrayList();
        Workbook wb = WorkbookFactory.create((File)f);
        return Helper.readExcel(wb);
    }

    public static Object[][][] readExcel(Workbook wb) throws IOException, InvalidFormatException {
        ArrayList<Object[][]> l0 = new ArrayList<Object[][]>();
        for (int poshoja = 0; poshoja < wb.getNumberOfSheets(); ++poshoja) {
            ArrayList<Object[]> l1 = new ArrayList<Object[]>();
            Sheet sheet = wb.getSheetAt(poshoja);
            if (sheet != null) {
                for (int posfila = 0; posfila <= sheet.getLastRowNum(); ++posfila) {
                    ArrayList<String> l2 = new ArrayList<String>();
                    Row row = sheet.getRow(posfila);
                    if (row != null) {
                        int nrCol = row.getLastCellNum();
                        for (int poscol = 0; poscol < nrCol; ++poscol) {
                            Cell cell = row.getCell(poscol);
                            Object v = null;
                            if (cell != null) {
                                log.debug("" + cell.getCellTypeEnum());
                                log.debug(cell.toString());
                                switch (cell.getCellTypeEnum()) {
                                    case BLANK: {
                                        break;
                                    }
                                    case BOOLEAN: {
                                        v = cell.getBooleanCellValue();
                                        break;
                                    }
                                    case ERROR: {
                                        break;
                                    }
                                    case FORMULA: {
                                        break;
                                    }
                                    case NUMERIC: {
                                        if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                                            Date date = cell.getDateCellValue();
                                            if (date == null) break;
                                            v = date;
                                            break;
                                        }
                                        v = cell.getNumericCellValue();
                                        break;
                                    }
                                    case STRING: {
                                        v = cell.getStringCellValue();
                                        break;
                                    }
                                }
                            }
                            l2.add((String)v);
                        }
                    }
                    l1.add(l2.toArray(new Object[0]));
                }
            }
            l0.add((Object[][])l1.toArray((T[])new Object[0][0]));
        }
        return (Object[][][])l0.toArray((T[])new Object[0][0][0]);
    }

    public static File writeExcel(Object[][][] data) throws IOException, InvalidFormatException {
        String archivo = UUID.randomUUID().toString();
        File temp = System.getProperty("tmpdir") == null ? File.createTempFile(archivo, ".xlsx") : new File(new File(System.getProperty("tmpdir")), archivo + ".xlsx");
        log.debug("java.io.tmpdir=" + System.getProperty("java.io.tmpdir"));
        log.debug("Temp file : " + temp.getAbsolutePath());
        XSSFWorkbook wb = new XSSFWorkbook();
        CreationHelper createHelper = wb.getCreationHelper();
        for (int poshoja = 0; poshoja < data.length; ++poshoja) {
            Object[][] l1 = data[poshoja];
            Sheet sheet = wb.createSheet();
            for (int posfila = 0; posfila < l1.length; ++posfila) {
                Object[] l2 = l1[posfila];
                Row row = sheet.createRow(posfila);
                for (int poscol = 0; poscol < l2.length; ++poscol) {
                    Cell cell = row.createCell(poscol);
                    Object v = l2[poscol];
                    Helper.fillCell((Workbook)wb, createHelper, cell, v);
                }
            }
        }
        wb.close();
        FileOutputStream fileOut = new FileOutputStream(temp);
        wb.write((OutputStream)fileOut);
        fileOut.close();
        return temp;
    }

    public static void fillCell(Workbook wb, CreationHelper createHelper, Cell cell, Object v) {
        if (v == null) {
            cell.setCellType(CellType.BLANK);
        } else if (v instanceof Double || v instanceof Integer || v instanceof Long) {
            cell.setCellType(CellType.NUMERIC);
            cell.setCellValue(Double.parseDouble("" + v));
        } else if (v instanceof Date || v instanceof LocalDate || v instanceof LocalDateTime || v instanceof LocalTime) {
            cell.setCellType(CellType.NUMERIC);
            if (v instanceof LocalTime) {
                CellStyle cellStyle = wb.createCellStyle();
                cellStyle.setDataFormat(createHelper.createDataFormat().getFormat("HH:mm"));
                cell.setCellStyle(cellStyle);
                cell.setCellValue(HSSFDateUtil.convertTime((String)((LocalTime)v).format(DateTimeFormatter.ofPattern("HH:mm"))));
            } else if (v instanceof Date) {
                CellStyle cellStyle = wb.createCellStyle();
                cellStyle.setDataFormat(createHelper.createDataFormat().getFormat("d/m/yy"));
                cell.setCellStyle(cellStyle);
                cell.setCellValue(HSSFDateUtil.getExcelDate((Date)((Date)v)));
            } else if (v instanceof LocalDate) {
                CellStyle cellStyle = wb.createCellStyle();
                cellStyle.setDataFormat(createHelper.createDataFormat().getFormat("d/m/yy"));
                cell.setCellStyle(cellStyle);
                cell.setCellValue(HSSFDateUtil.getExcelDate((Date)Date.from(((LocalDate)v).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant())));
            } else if (v instanceof LocalDateTime) {
                CellStyle cellStyle = wb.createCellStyle();
                cellStyle.setDataFormat(createHelper.createDataFormat().getFormat("d/m/yy HH:mm"));
                cell.setCellStyle(cellStyle);
                cell.setCellValue(HSSFDateUtil.getExcelDate((Date)Date.from(((LocalDateTime)v).atZone(ZoneId.systemDefault()).toInstant())));
            }
        } else if (v instanceof Boolean) {
            cell.setCellType(CellType.BOOLEAN);
            cell.setCellValue(((Boolean)v).booleanValue());
        } else {
            cell.setCellType(CellType.STRING);
            cell.setCellValue("" + v);
        }
    }

    public static void resend(String host, int port, String user, String password, Message m, String subject, String to) throws MessagingException, EmailException, IOException {
        Helper.resend(host, port, user, password, m, subject, to, null, null);
    }

    public static void resend(String host, int port, String user, String password, Message m, String subject, String to, String cc) throws MessagingException, EmailException, IOException {
        Helper.resend(host, port, user, password, m, subject, to, cc, null);
    }

    public static void resend(String host, int port, String user, String password, Message m, String subject, String to, String cc, String postscript) throws MessagingException, EmailException, IOException {
        HtmlEmail email = new HtmlEmail();
        email.setHostName(host);
        email.setSmtpPort(port);
        email.setAuthenticator((Authenticator)new DefaultAuthenticator(user, password));
        log.debug("EmailHelper-->resend :  , to : " + to + " , user : " + user + "  , cc  : " + cc);
        if (subject == null) {
            subject = "";
        }
        if (!"".equals(subject)) {
            subject = subject + " / ";
        }
        subject = subject + m.getSubject();
        try {
            InternetAddress sender = (InternetAddress)m.getFrom()[0];
            subject = subject + " - SENDER: " + sender.getAddress();
        }
        catch (Exception e) {
            subject = subject + " - NO SENDER";
        }
        email.setSubject(subject);
        email.setFrom(user);
        log.debug("Resending email to : " + to);
        if (!Strings.isNullOrEmpty((String)cc)) {
            email.getCcAddresses().add(new InternetAddress(cc));
        }
        email.addTo(to);
        if (!Strings.isNullOrEmpty((String)postscript)) {
            email.addPart(postscript, "text/html");
        }
        email.addPart((MimeMultipart)m.getContent());
        email.buildMimeMessage();
        email.sendMimeMessage();
    }

    public static void addTos(Message m, String qui) throws EmailException, AddressException, MessagingException {
        StringTokenizer st = new StringTokenizer(qui, ";, ");
        while (st.hasMoreTokens()) {
            String adreca = st.nextToken();
            if (adreca.trim().equals("")) continue;
            m.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(adreca.trim()));
        }
    }

    public static int max(int ... values) {
        int max = Integer.MIN_VALUE;
        for (int value : values) {
            if (value <= max) continue;
            max = value;
        }
        return max;
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return LocalDateTime.of(c.get(1), c.get(2) + 1, c.get(5), c.get(11), c.get(12), c.get(13));
    }

    public static LocalDate toLocalDate(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return LocalDate.of(c.get(1), c.get(2) + 1, c.get(5));
    }

    public static Map<String, Object> hashmap(Object ... args) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        int pos = 0;
        Object o0 = null;
        for (Object o : args) {
            if (pos > 0 && pos % 2 == 1) {
                m.put("" + o0, o);
            } else {
                o0 = o;
            }
            ++pos;
        }
        return m;
    }

    public static double roundOffEuros(double v) {
        return (double)Math.round(100.0 * v) / 100.0;
    }

    public static int toInt(String s) {
        int v = 0;
        try {
            v = Integer.parseInt(s);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return v;
    }

    public static int[] toIntArray(String s) {
        if (s == null) {
            return null;
        }
        if ("".equals(s.trim())) {
            return new int[0];
        }
        String[] ts = s.replace("[", "").replace("]", "").split(",");
        int[] r = new int[ts.length];
        for (int pos = 0; pos < ts.length; ++pos) {
            r[pos] = Integer.parseInt(ts[pos]);
        }
        return r;
    }

    public static String leerFichero(Class c, String p) {
        String s = "";
        InputStream input = c.getResourceAsStream(p);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        long count = 0L;
        int n = 0;
        try {
            while (-1 != (n = input.read(buffer))) {
                output.write(buffer, 0, n);
                count += (long)n;
            }
            s = new String(output.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return s;
    }

    public static String leerInputStream(InputStream is, String encoding) {
        StringBuffer s = new StringBuffer();
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(is, encoding));
            String l = null;
            boolean primeraLinea = true;
            while ((l = br.readLine()) != null) {
                if (primeraLinea) {
                    primeraLinea = false;
                } else {
                    s.append("\n");
                }
                s.append(l);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return s.toString();
    }

    public static String leerFichero(InputStream input, String codificacion) {
        String s = "";
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        long count = 0L;
        int n = 0;
        try {
            while (-1 != (n = input.read(buffer))) {
                output.write(buffer, 0, n);
                count += (long)n;
            }
            s = new String(output.toByteArray(), codificacion);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return s;
    }

    public static String leerFichero(InputStream is) throws IOException {
        int count;
        byte[] data = new byte[2048];
        ByteArrayOutputStream dest = new ByteArrayOutputStream();
        while ((count = is.read(data, 0, 2048)) != -1) {
            dest.write(data, 0, count);
        }
        dest.flush();
        dest.close();
        return new String(dest.toByteArray());
    }

    public static String leerFichero(String fn, String encoding) {
        String s = "";
        byte[] buffer = new byte[(int)new File(fn).length()];
        try {
            BufferedInputStream f = new BufferedInputStream(new FileInputStream(fn));
            f.read(buffer);
            f.close();
            s = new String(buffer, encoding);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return s;
    }

    public static String leerFichero(String fn) {
        String s = "";
        byte[] buffer = new byte[(int)new File(fn).length()];
        try (BufferedInputStream f = new BufferedInputStream(new FileInputStream(fn));){
            f.read(buffer);
            f.close();
            s = new String(buffer);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return s;
    }

    public static void escribirFichero(String fn, byte[] bytes) throws IOException {
        File f = new File(fn);
        Files.write((byte[])bytes, (File)f);
    }

    public static void escribirFichero(String fn, String txt) throws IOException {
        Helper.escribirFichero(fn, txt.getBytes());
    }

    public static byte[] leerByteArray(InputStream is) {
        byte[] data = new byte[2048];
        ByteArrayOutputStream dest = new ByteArrayOutputStream();
        try {
            int count;
            while ((count = is.read(data, 0, 2048)) != -1) {
                dest.write(data, 0, count);
            }
            dest.flush();
            dest.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return dest.toByteArray();
    }

    public static String[][] parsearCSV(String txt, char delimitador) {
        return CSVParser.parse((String)txt, (char)delimitador);
    }

    public static String[][] parsearCSV(String txt) {
        return Helper.parsearCSV(txt, ',');
    }

    public static String[][] leerCSV(String path, char delimitador) {
        return CSVParser.parse((String)Helper.leerFichero(path), (char)delimitador);
    }

    public static String[][] leerCSV(String path) {
        return Helper.leerCSV(path, ',');
    }

    public static void escribirCSV(List<String[]> data, OutputStream os) throws IOException {
        CSVPrinter p = new CSVPrinter(os);
        for (String[] l : data) {
            p.writeln(l);
        }
        p.close();
    }

    public static void escribirCSV(List<String[]> data, OutputStream os, char delimiter) throws IOException {
        CSVPrinter p = new CSVPrinter(os);
        p.changeDelimiter(delimiter);
        for (String[] l : data) {
            p.writeln(l);
        }
        p.close();
    }

    public static void escribirCSV(List<String[]> data, String fileName) throws IOException {
        CSVPrinter p = new CSVPrinter((OutputStream)new FileOutputStream(fileName));
        for (String[] l : data) {
            p.writeln(l);
        }
        p.close();
    }

    public static void escribirCSV(List<String[]> data, String path, char delimiter) throws IOException {
        CSVPrinter p = new CSVPrinter((OutputStream)new FileOutputStream(path));
        p.changeDelimiter(delimiter);
        for (String[] l : data) {
            p.writeln(l);
        }
        p.close();
    }

    public static String[][] leerCSV(Class c, String path, char delimitador) {
        return CSVParser.parse((String)Helper.leerFichero(c, path), (char)delimitador);
    }

    public static String[][] leerCSV(Class c, String path) {
        return Helper.leerCSV(c, path, ',');
    }

    public static double toDouble(String s) {
        double v = 0.0;
        try {
            v = Double.parseDouble(s);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return v;
    }

    public static Map<String, String> parseQueryString(String query) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (!Strings.isNullOrEmpty((String)query)) {
            for (String t : query.split("&")) {
                if (Strings.isNullOrEmpty((String)t)) continue;
                String[] q = t.split("=");
                params.put(q[0], q.length > 1 ? q[1] : null);
            }
        }
        return params;
    }

    public static String runCommand(String command) throws IOException, InterruptedException {
        String homeDirectory = System.getProperty("user.home");
        String[] cmd = new String[]{"/bin/sh", "-c", command};
        String[] wcmd = new String[]{"cmd", "/c", command};
        Process process = Runtime.getRuntime().exec(System.getProperty("os.name").toLowerCase().contains("win") ? wcmd : cmd);
        String r = Helper.leerInputStream(process.getInputStream(), "utf-8");
        String e = Helper.leerInputStream(process.getErrorStream(), "utf-8");
        int exitCode = process.waitFor();
        return r + e;
    }

    public static String toHtml(String s) {
        if (!Strings.isNullOrEmpty((String)s)) {
            return s.replaceAll("\\\n", "<br/>");
        }
        return s;
    }

    public static String getMemInfo() {
        return new MemInfo().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] fop(Source xslfo, Source xml) throws IOException, SAXException {
        long t0 = System.currentTimeMillis();
        FopFactoryBuilder builder = new FopFactoryBuilder(new File(".").toURI());
        if (fopConfig != null) {
            builder.setConfiguration(fopConfig);
        } else {
            builder.setStrictFOValidation(false);
            builder.setBreakIndentInheritanceOnReferenceAreaBoundary(true);
            builder.setSourceResolution(96.0f);
        }
        FopFactory fopFactory = builder.build();
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            Fop fop = fopFactory.newFop("application/pdf", (OutputStream)out);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer(xslfo);
            SAXResult res = new SAXResult(fop.getDefaultHandler());
            transformer.transform(xml, res);
        }
        System.out.println("fop took " + (System.currentTimeMillis() - t0) + " ms");
        return out.toByteArray();
    }

    public static Object get(Map<String, Object> data, String key) {
        return Helper.get(data, key, null);
    }

    public static Object get(Map<String, Object> data, String key, Object defaultValue) {
        if (data == null) {
            return defaultValue;
        }
        Object v = defaultValue;
        Map d = data;
        String[] ks = key.split("/");
        int pos = 0;
        for (String k : ks) {
            if (!d.containsKey(k)) break;
            if (pos == ks.length - 1) {
                v = d.get(k);
                continue;
            }
            Object aux = d.get(k);
            if (!(aux instanceof Map)) break;
            d = (Map)aux;
            ++pos;
        }
        return v;
    }

    public static <T> T getImpl(Class<T> c) throws Exception {
        return (T)SharedHelper.getImpl(c);
    }

    public static <T> List<T> getImpls(Class<T> c) throws Exception {
        return SharedHelper.getImpls(c);
    }

    public static Map<String, Object> getGeneralData() throws Throwable {
        HashMap<String, Object> data = new HashMap<String, Object>();
        IAppConfig c = Helper.getImpl(AppConfigLocator.class).get();
        data.put("businessname", c.getBusinessName());
        String l = c.getLogoUrl();
        if (!Strings.isNullOrEmpty((String)l)) {
            data.put("logourl", l);
        }
        return data;
    }

    public static void main(String[] args) {
        try {
            log.debug(Helper.toJson(Helper.fromYaml(Files.toString((File)new File("/home/miguel/work/initialdata.yml"), (Charset)Charset.defaultCharset()))));
            Map<String, Object> o = Helper.fromYaml(Files.toString((File)new File("/home/miguel/work/initialdata.yml"), (Charset)Charset.defaultCharset()));
            log.debug("" + Helper.get(o, "smtp/host"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String toString(Element element) {
        if (element == null) {
            return "";
        }
        return new XMLOutputter(Format.getPrettyFormat()).outputString(element);
    }

    public static boolean areXmlSerializableEqual(XMLSerializable a, XMLSerializable b) {
        return a == b || b != null && Helper.toString(a.toXml()).equals(Helper.toString(b.toXml()));
    }

    public static boolean equals(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null && b != null) {
            return false;
        }
        if (a != null && b == null) {
            return false;
        }
        return a.equals(b);
    }

    public static String eval(String operations) {
        return Helper.eval("nashorn", operations, null);
    }

    public static String eval(String engineName, String operations, Map<String, Object> params) {
        long t0 = System.currentTimeMillis();
        ScriptEngine engine = scriptEngineManager.getEngineByName(engineName);
        ScriptContext context = engine.getContext();
        if (params != null) {
            params.forEach((k, v) -> engine.put((String)k, v));
        }
        StringWriter writer = new StringWriter();
        context.setWriter(writer);
        long t1 = System.currentTimeMillis();
        try {
            writer.append("" + engine.eval(operations));
        }
        catch (ScriptException e) {
            writer.append(e.getMessage());
        }
        String output = writer.toString();
        return output;
    }

    public static void generateQRCodeImage(String text, int width, int height, String filePath) throws WriterException, IOException {
        QRCodeWriter qrCodeWriter = new QRCodeWriter();
        BitMatrix bitMatrix = qrCodeWriter.encode(text, BarcodeFormat.QR_CODE, width, height);
        Path path = FileSystems.getDefault().getPath(filePath, new String[0]);
        MatrixToImageWriter.writeToPath((BitMatrix)bitMatrix, (String)"PNG", (Path)path);
    }

    public static String encodeState(String s) {
        return s.replaceAll("/", "YP9LKQ");
    }

    public static String decodeState(String s) {
        return s.replaceAll("YP9LKQ", "/");
    }

    public static String toString(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        pw.close();
        return sw.toString();
    }

    public byte[] getQRCodeImage(String text, int width, int height) throws WriterException, IOException {
        QRCodeWriter qrCodeWriter = new QRCodeWriter();
        BitMatrix bitMatrix = qrCodeWriter.encode(text, BarcodeFormat.QR_CODE, width, height);
        ByteArrayOutputStream pngOutputStream = new ByteArrayOutputStream();
        MatrixToImageWriter.writeToStream((BitMatrix)bitMatrix, (String)"PNG", (OutputStream)pngOutputStream);
        byte[] pngData = pngOutputStream.toByteArray();
        return pngData;
    }

    public static String translate(String source_lang, String target_lang, String text) throws Throwable {
        return new DeepLClient().translate(source_lang, target_lang, text);
    }

    static {
        SharedHelper.loadProperties();
        DefaultConfigurationBuilder cfgBuilder = new DefaultConfigurationBuilder();
        try {
            if (!Strings.isNullOrEmpty((String)System.getProperty("fopconfig"))) {
                log.debug("Loading fop config from " + System.getProperty("fopconfig"));
                fopConfig = cfgBuilder.buildFromFile(new File(System.getProperty("fopconfig")));
            } else {
                log.debug("Loading fop config from classpath: /xsl/fop.xml");
                fopConfig = cfgBuilder.build(Helper.class.getResourceAsStream("/xsl/fop.xml"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        scriptEngineManager = new ScriptEngineManager(ClassLoader.getSystemClassLoader());
        HTTP_TRANSPORT = new NetHttpTransport();
        JSON_FACTORY = new JacksonFactory();
        cfg = new freemarker.template.Configuration(freemarker.template.Configuration.VERSION_2_3_25);
    }
}

