/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.util.data;

import com.google.common.base.Strings;
import io.mateu.util.data.Data;
import io.mateu.util.data.SupplementOrPositiveType;
import java.io.IOException;

public class SupplementOrPositive
extends Data {
    public SupplementOrPositive(SupplementOrPositiveType type, double value) {
        this.setType(type);
        this.setValue(value);
    }

    public SupplementOrPositive(SupplementOrPositive value) {
        this.clear();
        if (value != null) {
            this.setValue(value.getValue());
            this.setType(value.getType());
        }
    }

    public SupplementOrPositive(String json) throws IOException {
        super(json);
    }

    public SupplementOrPositive() {
    }

    public SupplementOrPositiveType getType() {
        return (SupplementOrPositiveType)((Object)this.get("type"));
    }

    public void setType(SupplementOrPositiveType value) {
        this.set("type", value);
    }

    public double getValue() {
        return (Double)this.get("value");
    }

    public void setValue(double value) {
        this.set("value", value);
    }

    public String toStringValue() {
        double v = this.getValue();
        String s = null;
        switch (this.getType()) {
            case SUPPLEMENT: {
                s = (v >= 0.0 ? "+" : "-") + v;
                break;
            }
            case SUPPLEMENT_PERCENT: {
                s = (v >= 0.0 ? "+" : "-") + v + "%";
                break;
            }
            case VALUE: {
                s = "" + v;
                break;
            }
            default: {
                s = "";
            }
        }
        return s;
    }

    public static SupplementOrPositive fromStringValue(String s) {
        if (!Strings.isNullOrEmpty((String)s)) {
            SupplementOrPositiveType t = s.endsWith("%") ? SupplementOrPositiveType.SUPPLEMENT_PERCENT : (s.startsWith("+") || s.startsWith("-") ? SupplementOrPositiveType.SUPPLEMENT : SupplementOrPositiveType.VALUE);
            if ((s = s.replaceAll("%", "").replaceAll("\\+", "")).endsWith(".")) {
                s = s.replaceAll("\\.", "");
            }
            double v = Double.parseDouble(s);
            return new SupplementOrPositive(t, v);
        }
        return null;
    }
}

