/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.util;

import com.google.auto.service.AutoService;
import io.mateu.mdd.shared.JPAAdapter;
import io.mateu.util.Helper;
import io.mateu.util.IJPAHelper;
import io.mateu.util.persistence.JPATransaction;
import io.mateu.util.runnable.RunnableThrowsThrowable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.FlushModeType;
import javax.persistence.Persistence;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.jinq.jpa.JinqJPAStreamProvider;

@AutoService(value={IJPAHelper.class})
public class JPAHelperImpl
implements IJPAHelper {
    private static Map<String, JinqJPAStreamProvider> streams = new HashMap<String, JinqJPAStreamProvider>();
    private static Map<String, EntityManagerFactory> emf = new HashMap<String, EntityManagerFactory>();

    @Override
    public void transact(JPATransaction t) throws Throwable {
        this.transact(System.getProperty("defaultpuname", "default"), t, null);
    }

    @Override
    public void transact(JPATransaction t, RunnableThrowsThrowable callback) throws Throwable {
        this.transact(System.getProperty("defaultpuname", "default"), t, callback);
    }

    @Override
    public void transact(String persistenceUnit, JPATransaction t) throws Throwable {
        this.transact(persistenceUnit, t, null);
    }

    @Override
    public void transact(String persistenceUnit, JPATransaction t, RunnableThrowsThrowable callback) throws Throwable {
        try {
            EntityManager em = this.getEMF(persistenceUnit).createEntityManager();
            try {
                em.getTransaction().begin();
                t.run(em);
                em.getTransaction().commit();
            }
            catch (Throwable e) {
                e.printStackTrace();
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
                Throwable throwable = e = e.getCause() != null && e.getCause() instanceof ConstraintViolationException ? e.getCause() : e;
                if (e instanceof ConstraintViolationException) {
                    StringBuffer sb = new StringBuffer();
                    ((ConstraintViolationException)e).getConstraintViolations().forEach(v -> sb.append(("".equals(sb.toString()) ? "" : "\n") + (v.getPropertyPath() != null ? v.getPropertyPath().toString() + " " : "") + v.getMessage() + (v.getRootBeanClass() != null ? " en " + v.getRootBeanClass().getSimpleName() + "" : "")));
                    e = new Exception(sb.toString());
                }
                this.rethrow(e);
            }
            em.close();
        }
        catch (Throwable e) {
            this.rethrow(e.getCause() != null && e.getCause() instanceof ConstraintViolationException ? e.getCause() : e);
        }
    }

    public void rethrow(Throwable e) throws Throwable {
        if (e instanceof ConstraintViolationException) {
            StringBuffer sb = new StringBuffer();
            for (ConstraintViolation v : ((ConstraintViolationException)e).getConstraintViolations()) {
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append("" + v.getPropertyPath() + " " + v.getMessage() + " at " + Helper.capitalize(v.getRootBeanClass().getSimpleName()));
            }
            throw new Exception(sb.toString());
        }
        throw e;
    }

    public void printStackTrace(Throwable e) {
        e.printStackTrace();
        if (e instanceof ConstraintViolationException) {
            StringBuffer sb = new StringBuffer();
            for (ConstraintViolation v : ((ConstraintViolationException)e).getConstraintViolations()) {
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append("" + v.getPropertyPath() + " " + v.getMessage() + " at " + Helper.capitalize(v.getRootBeanClass().getSimpleName()));
            }
            System.out.println(sb.toString());
        }
    }

    @Override
    public void closeEMFs() {
        emf.values().forEach(x -> {
            if (x.isOpen()) {
                x.close();
            }
        });
        emf.clear();
    }

    @Override
    public void setEMF(EntityManagerFactory f) {
        emf.put(System.getProperty("defaultpuname", "default"), f);
    }

    @Override
    public EntityManagerFactory getEMF() {
        return this.getEMF(System.getProperty("defaultpuname", "default"));
    }

    @Override
    public EntityManagerFactory getEMF(String persistenceUnit) {
        EntityManagerFactory v = emf.get(persistenceUnit);
        if (v == null) {
            v = Persistence.createEntityManagerFactory((String)persistenceUnit, (Map)System.getProperties());
            emf.put(persistenceUnit, v);
        }
        return v;
    }

    @Override
    public void notransact(JPATransaction t) throws Throwable {
        this.notransact(System.getProperty("defaultpuname", "default"), t, true);
    }

    @Override
    public void notransact(JPATransaction t, boolean printException) throws Throwable {
        this.notransact(System.getProperty("defaultpuname", "default"), t, printException);
    }

    @Override
    public void notransact(String persistenceUnit, JPATransaction t) throws Throwable {
        this.notransact(persistenceUnit, t, true);
    }

    @Override
    public void notransact(String persistenceUnit, JPATransaction t, boolean printException) throws Throwable {
        EntityManager em = this.getEMF(persistenceUnit).createEntityManager();
        try {
            t.run(em);
        }
        catch (Exception e) {
            if (printException) {
                e.printStackTrace();
            }
            em.close();
            throw e;
        }
        em.close();
    }

    @Override
    public <T> T find(Class<T> type, Object id) throws Throwable {
        Object[] o = new Object[]{null};
        this.notransact(em -> {
            o[0] = em.find(type, id);
        });
        return (T)o[0];
    }

    @Override
    public <T> List<T> findAll(EntityManager em, Class<T> type) throws Throwable {
        return em.createQuery("select x from " + type.getName() + " x").setFlushMode(FlushModeType.COMMIT).getResultList();
    }

    @Override
    public <T> List<T> findAll(Class<T> type) throws Throwable {
        ArrayList l = new ArrayList();
        this.notransact(em -> l.addAll(this.findAll(em, type)));
        return l;
    }

    @Override
    public <T> List<T> getAll(Class<T> type) {
        try {
            return this.findAll(type);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return new ArrayList();
        }
    }

    @Override
    public <T> T get(Class<T> type, Object id) {
        try {
            return this.find(type, id);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    @Override
    public JinqJPAStreamProvider getStreams() {
        return this.getStreams(System.getProperty("defaultpuname", "default"));
    }

    @Override
    public JinqJPAStreamProvider getStreams(String persistenceUnit) {
        JinqJPAStreamProvider s = streams.get(persistenceUnit);
        if (s == null) {
            s = new JinqJPAStreamProvider(this.getEMF(persistenceUnit));
            streams.put(persistenceUnit, s);
        }
        return s;
    }

    @Override
    public <T> Optional<T> selectValue(String jpql) throws Throwable {
        return this.selectValue(jpql, null);
    }

    @Override
    public <T> Optional<T> selectValue(String jpql, Map<String, Object> params) throws Throwable {
        List l = this.selectObjects(jpql, params);
        return Optional.of(l.size() > 0 ? (Object)l.get(0) : null);
    }

    @Override
    public List selectObjects(String jpql) throws Throwable {
        return this.selectObjects(jpql, new HashMap<String, Object>());
    }

    @Override
    public List selectObjects(String jpql, Map<String, Object> params) throws Throwable {
        ArrayList l = new ArrayList();
        this.notransact(em -> {
            Query q = em.createQuery(jpql);
            Helper.getImpl(JPAAdapter.class).hint(q);
            if (params != null) {
                for (String k : params.keySet()) {
                    q.setParameter(k, params.get(k));
                }
            }
            l.addAll(q.getResultList());
        });
        return l;
    }

    @Override
    public List selectObjects(String jpql, Class targetClass) throws Throwable {
        return this.selectObjects(jpql, new HashMap<String, Object>(), targetClass);
    }

    @Override
    public List selectObjects(String jpql, Map<String, Object> params, Class targetClass) throws Throwable {
        ArrayList l = new ArrayList();
        this.notransact(em -> {
            TypedQuery q = em.createQuery(jpql, targetClass);
            Helper.getImpl(JPAAdapter.class).hint((Query)q);
            if (params != null) {
                for (String k : params.keySet()) {
                    q.setParameter(k, params.get(k));
                }
            }
            l.addAll(q.getResultList());
        });
        return l;
    }

    @Override
    public List<Object[]> nativeSelect(String sql) throws Throwable {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        this.notransact(em -> {
            Query q = em.createNativeQuery(sql);
            list.addAll(q.getResultList());
        });
        return list;
    }

    @Override
    public Object nativeSelectValue(String sql) throws Throwable {
        ArrayList list = new ArrayList();
        this.notransact(em -> {
            Query q = em.createNativeQuery(sql);
            list.addAll(q.getResultList());
        });
        return list.size() > 0 ? (list.get(0) instanceof Object[] ? ((Object[])list.get(0))[0] : (Object)list.get(0)) : null;
    }

    @Override
    public List<Object[]> sqlSelectPage(String jpql, int offset, int limit) throws Throwable {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        this.notransact(em -> {
            Query q = em.createQuery(jpql);
            q.setFirstResult(offset);
            q.setMaxResults(limit);
            Helper.getImpl(JPAAdapter.class).hint(q);
            list.addAll(q.getResultList());
        });
        return list;
    }

    @Override
    public int sqlCount(String sql) throws Throwable {
        int[] count = new int[]{0};
        this.notransact(em -> {
            String countjpql = "select count(*) from (" + sql + ") xxx";
            Query q = em.createQuery(countjpql);
            Helper.getImpl(JPAAdapter.class).hint(q);
            count[0] = ((Long)q.getSingleResult()).intValue();
        });
        return count[0];
    }

    @Override
    public String runNativeSqlUpdate(String sql) throws Throwable {
        StringBuffer sb = new StringBuffer();
        this.transact(em -> {
            System.out.println("running " + sql);
            int r = em.createNativeQuery(sql).executeUpdate();
            sb.append(r);
        });
        return sb.toString();
    }

    @Override
    public <T> void deleteWithId(EntityManager em, Class<T> type, Object id) {
        Object o = em.find(type, id);
        if (o != null) {
            em.remove(o);
        }
    }

    @Override
    public <T> T find(EntityManager em, Class<T> type, Object ... params) {
        TypedQuery<T> q = this.createQuery(em, type, params);
        return (T)q.getSingleResult();
    }

    @Override
    public <T> T find(Class<T> type, Object ... params) {
        Object[] o = new Object[]{null};
        try {
            this.notransact(em -> {
                TypedQuery q = this.createQuery(em, type, params);
                o[0] = q.getSingleResult();
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return (T)o[0];
    }

    @Override
    public <T> TypedQuery<T> createQuery(EntityManager em, Class<T> type, Object[] params) {
        CriteriaBuilder b = em.getCriteriaBuilder();
        CriteriaQuery cq = b.createQuery(type);
        Root root = cq.from(type);
        int pos = 0;
        Object o0 = null;
        ArrayList<Predicate> predicados = new ArrayList<Predicate>();
        for (Object o : params) {
            if (pos > 0 && pos % 2 == 1) {
                predicados.add(b.equal((Expression)root.get("" + o0), o));
            } else {
                o0 = o;
            }
            ++pos;
        }
        Predicate todosLosPredicados = b.and(predicados.toArray(new Predicate[0]));
        TypedQuery q = em.createQuery(cq.select((Selection)root).where((Expression)todosLosPredicados));
        return q;
    }

    @Override
    public <T> List<T> list(EntityManager em, Class<T> type, Object ... params) {
        TypedQuery<T> q = this.createQuery(em, type, params);
        return q.getResultList();
    }

    @Override
    public <T> void delete(EntityManager em, Class<T> type, Object ... params) {
        T o = this.find(em, type, params);
        if (o != null) {
            em.remove(o);
        }
    }

    @Override
    public <T> int count(EntityManager em, Class<T> type) {
        try {
            return this.findAll(type).size();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0;
        }
    }

    @Override
    public <T> int count(EntityManager em, Class<T> type, Object ... params) {
        return this.list(em, type, params).size();
    }

    @Override
    public <T> TypedQuery<T> createQueryForCount(EntityManager em, Class<T> type, Object[] params) {
        CriteriaBuilder b = em.getCriteriaBuilder();
        CriteriaQuery cq = b.createQuery(type);
        Root root = cq.from(type);
        int pos = 0;
        Object o0 = null;
        ArrayList<Predicate> predicados = new ArrayList<Predicate>();
        for (Object o : params) {
            if (pos > 0 && pos % 2 == 1) {
                predicados.add(b.equal((Expression)root.get("" + o0), o));
            } else {
                o0 = o;
            }
            ++pos;
        }
        Predicate todosLosPredicados = b.and(predicados.toArray(new Predicate[0]));
        TypedQuery q = em.createQuery(cq.select((Selection)root).where((Expression)todosLosPredicados));
        return q;
    }

    @Override
    public void update(Object a, String fieldName, Object value) {
    }
}

