/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.util.common;

import io.mateu.mdd.shared.annotations.Ignored;
import io.mateu.util.xml.XMLSerializable;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import org.jdom2.Element;

public class DatesRange
implements Serializable,
XMLSerializable {
    @Ignored
    private static final long serialVersionUID = 1L;
    private LocalDate start;
    private LocalDate end;

    public DatesRange() {
    }

    public DatesRange(LocalDate start, LocalDate end) {
        this.start = start;
        this.end = end;
    }

    public DatesRange(Element e) {
        this.fromXml(e);
    }

    @Override
    public Element toXml() {
        Element e = new Element("range");
        if (this.getStart() != null) {
            e.setAttribute("start", this.getStart().toString());
        }
        if (this.getEnd() != null) {
            e.setAttribute("end", this.getEnd().toString());
        }
        return e;
    }

    @Override
    public void fromXml(Element e) {
        if (e != null) {
            if (e.getAttribute("start") != null) {
                this.setStart(LocalDate.parse(e.getAttributeValue("start")));
            }
            if (e.getAttribute("end") != null) {
                this.setEnd(LocalDate.parse(e.getAttributeValue("end")));
            }
        }
    }

    public String toString() {
        DateTimeFormatter f = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        DateTimeFormatter fm = DateTimeFormatter.ofPattern("MM-dd");
        DateTimeFormatter fd = DateTimeFormatter.ofPattern("dd");
        String s = "[";
        if (this.start != null) {
            s = s + "from " + this.start.format(f);
        }
        if (this.end != null) {
            if (!"".equals(s)) {
                s = s + " ";
            }
            DateTimeFormatter fx = f;
            if (this.start != null && this.start.getYear() == this.end.getYear() && this.start.getMonthValue() == this.end.getMonthValue()) {
                fx = fd;
            } else if (this.start != null && this.start.getYear() == this.end.getYear()) {
                fx = fm;
            }
            s = s + "to " + this.end.format(fx);
        }
        s = s + "]";
        return s;
    }

    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public LocalDate getStart() {
        return this.start;
    }

    public LocalDate getEnd() {
        return this.end;
    }

    public void setStart(LocalDate start) {
        this.start = start;
    }

    public void setEnd(LocalDate end) {
        this.end = end;
    }
}

