/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.util.mail;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import io.mateu.mdd.shared.AppConfigLocator;
import io.mateu.mdd.shared.IAppConfig;
import io.mateu.util.Helper;
import io.mateu.util.mail.EmailMock;
import java.net.URL;
import java.util.List;
import javax.mail.Authenticator;
import javax.mail.internet.InternetAddress;
import org.apache.commons.mail.DefaultAuthenticator;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailHelper {
    private static final Logger log = LoggerFactory.getLogger(EmailHelper.class);
    private static boolean testing;
    private static EmailMock mock;

    public static boolean isTesting() {
        return testing;
    }

    public static void setTesting(boolean testing) {
        EmailHelper.testing = testing;
    }

    public static void setMock(EmailMock mock) {
        EmailHelper.mock = mock;
        EmailHelper.setTesting(mock != null);
    }

    public static EmailMock getMock() {
        return mock;
    }

    public static void sendEmail(String toEmail, String subject, String text, boolean noCC) throws Throwable {
        EmailHelper.sendEmail(toEmail, subject, text, noCC, (URL)null);
    }

    public static void sendEmail(String toEmail, String subject, String text, boolean noCC, URL attachment) throws Throwable {
        EmailHelper.sendEmail(toEmail, subject, text, noCC, attachment != null ? Lists.newArrayList((Object[])new URL[]{attachment}) : null);
    }

    public static void sendEmail(String toEmail, String subject, String text, boolean noCC, List<URL> attachments) throws Throwable {
        if (subject == null) {
            subject = "";
        }
        if (text == null) {
            text = "";
        }
        System.out.println("Sending email to " + toEmail);
        System.out.println("Subject: " + subject);
        String finalSubject = subject;
        String finalText = text;
        IAppConfig c = Helper.getImpl(AppConfigLocator.class).get();
        if (EmailHelper.checkAppConfigForSMTP(c)) {
            System.out.println("Host: " + c.getAdminEmailSmtpHost());
            System.out.println("Port: " + c.getAdminEmailSmtpPort());
            System.out.println("User: " + c.getAdminEmailUser());
            System.out.println("Password: " + c.getAdminEmailPassword());
            System.out.println("From: " + c.getAdminEmailFrom());
            HtmlEmail email = new HtmlEmail();
            email.setHostName(c.getAdminEmailSmtpHost());
            email.setSmtpPort(c.getAdminEmailSmtpPort());
            email.setAuthenticator((Authenticator)new DefaultAuthenticator(c.getAdminEmailUser(), c.getAdminEmailPassword()));
            email.setSSLOnConnect(c.isAdminEmailSSLOnConnect());
            email.setStartTLSEnabled(c.isAdminEmailStartTLS());
            email.setFrom(c.getAdminEmailFrom());
            if (!noCC && !Strings.isNullOrEmpty((String)c.getAdminEmailCC())) {
                email.getCcAddresses().add(new InternetAddress(c.getAdminEmailCC()));
            }
            email.setSubject(finalSubject);
            email.setHtmlMsg(finalText);
            email.setCharset("utf-8");
            email.addTo(!Strings.isNullOrEmpty((String)System.getProperty("allemailsto")) ? System.getProperty("allemailsto") : toEmail);
            if (attachments != null) {
                for (URL u : attachments) {
                    email.attach(u, u.toString().substring(u.toString().lastIndexOf("/") + 1), "");
                }
            }
            EmailHelper.send((Email)email);
        } else {
            System.out.println("************************************");
            System.out.println("Missing SMTP confirguration. Please go to admin > Appconfig and fill");
            System.out.println("************************************");
        }
    }

    public static void send(Email email) throws EmailException {
        if (EmailHelper.isTesting()) {
            System.out.println("************************************");
            System.out.println("Mail not sent as we are TESTING");
            System.out.println("************************************");
            if (mock != null) {
                mock.send(email);
            }
        } else {
            if ("false".equalsIgnoreCase(System.getProperty("sendemailsinforeground")) || "no".equalsIgnoreCase(System.getProperty("sendemailsinforeground"))) {
                email.send();
            } else {
                new Thread(() -> {
                    try {
                        email.send();
                    }
                    catch (EmailException e) {
                        e.printStackTrace();
                    }
                }).start();
            }
            System.out.println("******* Email sent");
        }
    }

    private static boolean checkAppConfigForSMTP(IAppConfig c) {
        boolean ok = true;
        ok &= c.getAdminEmailSmtpPort() > 0;
        ok &= !Strings.isNullOrEmpty((String)c.getAdminEmailSmtpHost());
        return ok &= !Strings.isNullOrEmpty((String)c.getAdminEmailUser());
    }

    public static void main(String[] args) throws EmailException {
        EmailHelper.send("miguelperezcolom@gmail.com", "quonext-tur@outlook.com", "Quonext123", "smtp.office365.com", 587, false);
    }

    private static void send(String a, String de, String pwd, String host, int port, boolean ssl) throws EmailException {
        System.out.println("Sending email to " + a);
        System.out.println("Subject: " + de);
        System.out.println("Pwd: " + pwd);
        if (EmailHelper.isTesting()) {
            System.out.println("************************************");
            System.out.println("Mail not sent as we are TESTING");
            System.out.println("************************************");
        } else {
            HtmlEmail email = new HtmlEmail();
            email.setHostName(host);
            email.setSmtpPort(port);
            email.setAuthenticator((Authenticator)new DefaultAuthenticator(de, pwd));
            email.setSSLOnConnect(false);
            email.setStartTLSEnabled(true);
            email.setFrom(de);
            email.setSubject("TestMail 3");
            email.setHtmlMsg("This is a test mail ... :-)");
            email.setCharset("utf-8");
            email.addTo(!Strings.isNullOrEmpty((String)System.getProperty("allemailsto")) ? System.getProperty("allemailsto") : a);
            EmailHelper.send((Email)email);
            System.out.println("sent");
        }
    }
}

