/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.util.quartz;

import io.mateu.mdd.shared.Command;
import io.mateu.mdd.shared.ScheduledCommand;
import io.mateu.util.quartz.MateuJob;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;

public class QuartzEngine {
    private Scheduler scheduler;
    protected HashMap<String, Command> scheduledCommands = new HashMap();
    public static QuartzEngine instance;

    public static QuartzEngine get() {
        if (instance == null) {
            instance = new QuartzEngine();
            instance.init();
        }
        return instance;
    }

    public static void runAndSchedule(List<Command> commands) {
        QuartzEngine.get()._runAndSchedule(commands);
    }

    public static void run(String uuid) {
        QuartzEngine.get()._run(uuid);
    }

    private void _run(String uuid) {
        try {
            this.scheduledCommands.get(uuid).run();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private void _runAndSchedule(List<Command> commands) {
        if (commands != null) {
            commands.stream().forEach(c -> {
                if (c instanceof ScheduledCommand) {
                    String uuid = UUID.randomUUID().toString();
                    this.scheduledCommands.put(uuid, (Command)c);
                    JobDetail job = JobBuilder.newJob(MateuJob.class).withIdentity("job-" + uuid, "io.mateu").usingJobData("_commandId", uuid).build();
                    Trigger trigger = TriggerBuilder.newTrigger().withIdentity("trigger-" + uuid, "io.mateu").startNow().withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)((ScheduledCommand)c).getSchedule())).build();
                    try {
                        this.scheduler.scheduleJob(job, trigger);
                    }
                    catch (SchedulerException e) {
                        e.printStackTrace();
                    }
                } else {
                    try {
                        c.run();
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
            });
        }
    }

    private void init() {
        try {
            this.scheduler = StdSchedulerFactory.getDefaultScheduler();
            this.scheduler.start();
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
    }

    public static void destroy() {
        QuartzEngine.get()._destroy();
    }

    private void _destroy() {
        try {
            this.scheduler.shutdown();
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
    }
}

