/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.vaadin;

import com.google.common.base.Strings;
import com.vaadin.navigator.Navigator;
import com.vaadin.navigator.ViewProvider;
import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinServletRequest;
import com.vaadin.server.WrappedHttpSession;
import com.vaadin.ui.Component;
import com.vaadin.ui.ComponentContainer;
import com.vaadin.ui.JavaScript;
import com.vaadin.ui.JavaScriptFunction;
import com.vaadin.ui.UI;
import com.vaadin.ui.Window;
import elemental.json.JsonArray;
import io.mateu.mdd.core.MDD;
import io.mateu.mdd.core.app.AbstractApplication;
import io.mateu.mdd.core.app.AbstractArea;
import io.mateu.mdd.core.app.MateuApp;
import io.mateu.mdd.core.interfaces.PersistentPojo;
import io.mateu.mdd.core.ui.MDDUIAccessor;
import io.mateu.mdd.shared.interfaces.App;
import io.mateu.mdd.shared.interfaces.MenuEntry;
import io.mateu.mdd.shared.interfaces.UserPrincipal;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.mdd.shared.reflection.IFieldBuilder;
import io.mateu.mdd.shared.ui.IMDDUI;
import io.mateu.mdd.vaadin.MateuWindow;
import io.mateu.mdd.vaadin.components.app.main.MainComponent;
import io.mateu.mdd.vaadin.components.app.views.firstLevel.AreaComponent;
import io.mateu.mdd.vaadin.components.app.views.firstLevel.MenuComponent;
import io.mateu.mdd.vaadin.components.fieldBuilders.AbstractFieldBuilder;
import io.mateu.mdd.vaadin.components.views.EditorListener;
import io.mateu.mdd.vaadin.components.views.EditorViewComponent;
import io.mateu.mdd.vaadin.components.views.ListViewComponent;
import io.mateu.mdd.vaadin.components.views.OwnedCollectionComponent;
import io.mateu.mdd.vaadin.navigation.MateuViewProvider;
import io.mateu.mdd.vaadin.navigation.View;
import io.mateu.mdd.vaadin.navigation.ViewStack;
import io.mateu.mdd.vaadin.util.VaadinHelper;
import io.mateu.mdd.vaadin.views.BrokenLinkView;
import io.mateu.reflection.ReflectionHelper;
import io.mateu.security.MateuSecurityManager;
import io.mateu.util.Helper;
import io.mateu.util.notification.Notifier;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javassist.ClassPool;
import javax.persistence.Entity;
import javax.servlet.ServletContext;
import org.apache.commons.lang3.StringUtils;

public class MateuUI
extends UI
implements IMDDUI {
    private Navigator navigator;
    private AbstractApplication app;
    private MateuViewProvider viewProvider;
    private ViewStack stack;
    private Set pendingSelection;
    private Object pendingResult;
    private String pendingFocusedSectionId;
    private MainComponent main;
    private AbstractArea area;
    private MateuSecurityManager securityManager;
    List<Locale> locales = Arrays.asList(new Locale("en"), new Locale("es"), new Locale("fr"), new Locale("ru"), new Locale("ar"), new Locale("zh"), new Locale("de"), new Locale("it"));

    public static MateuUI get() {
        return (MateuUI)UI.getCurrent();
    }

    public MainComponent getMain() {
        return this.main;
    }

    public void setCurrentEditor(EditorViewComponent editor) {
        this.viewProvider.setCurrentEditor(editor);
    }

    public EditorViewComponent getCurrentEditor() {
        return this.viewProvider != null ? this.viewProvider.getCurrentEditor() : null;
    }

    public Set getSelectedRows() {
        Set selectedRows;
        Set set = selectedRows = this.viewProvider != null && this.viewProvider.getCurrentEditor() != null && this.viewProvider.getCurrentEditor().getListViewComponent() != null ? this.viewProvider.getCurrentEditor().getListViewComponent().getSelection() : null;
        if (selectedRows == null && this.viewProvider != null && this.viewProvider.getLastView() != null && this.viewProvider.getLastView() != null && this.viewProvider.getLastView().getViewComponent() instanceof ListViewComponent) {
            selectedRows = ((ListViewComponent)this.viewProvider.getLastView().getViewComponent()).getSelection();
        }
        if (selectedRows == null) {
            selectedRows = new HashSet();
        }
        return selectedRows;
    }

    public String getPendingFocusedSectionId() {
        return this.pendingFocusedSectionId;
    }

    public void setPendingFocusedSectionId(String pendingFocusedSectionId) {
        this.pendingFocusedSectionId = pendingFocusedSectionId;
    }

    protected void init(VaadinRequest vaadinRequest) {
        JavaScript.getCurrent().addFunction("pingserver", new JavaScriptFunction(){

            public void call(JsonArray jsonArray) {
                if (MateuUI.this.getStyleName().contains("xxxxxx")) {
                    MateuUI.this.removeStyleName("xxxxxx");
                } else {
                    MateuUI.this.addStyleName("xxxxxx");
                }
            }
        });
        try {
            this.securityManager = (MateuSecurityManager)Helper.getImpl(MateuSecurityManager.class);
        }
        catch (Exception e) {
            System.out.println("security manager implementation not found");
        }
        try {
            this.initApp(vaadinRequest);
            String language = this.resolveLocale(vaadinRequest.getHeader("Accept-Language")).getLanguage();
            System.out.println("accepted language = " + language);
            this.getSession().setAttribute("__language", (Object)language);
            this.main = new MainComponent(this);
            this.setContent((Component)this.main);
            this.stack = new ViewStack();
            this.navigator = new Navigator((UI)this, (ComponentContainer)this.main.panel);
            this.navigator.setErrorView((com.vaadin.navigator.View)new BrokenLinkView(this.stack));
            this.viewProvider = new MateuViewProvider(this.stack);
            this.navigator.addProvider((ViewProvider)this.viewProvider);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Locale resolveLocale(String acceptLanguageHeader) {
        if (StringUtils.isBlank((CharSequence)acceptLanguageHeader)) {
            return Locale.getDefault();
        }
        List<Locale.LanguageRange> ranges = Locale.LanguageRange.parse(acceptLanguageHeader);
        Locale locale = Locale.lookup(ranges, this.locales);
        return locale;
    }

    private void initApp(VaadinRequest vaadinRequest) throws Exception {
        if (this.app == null) {
            Class<Object> uiClassFromContext;
            String cp;
            String k = Strings.isNullOrEmpty((String)this.getUiRootPath()) ? "/" : this.getUiRootPath();
            if (k.startsWith(cp = ((VaadinServletRequest)vaadinRequest).getServletContext().getContextPath())) {
                k = k.substring(cp.length());
            }
            if (!k.startsWith("/")) {
                k = "/" + k;
            }
            this.app = new MateuApp((uiClassFromContext = (Class<Object>)((VaadinServletRequest)vaadinRequest).getServletContext().getAttribute(k + "_app")) != null ? uiClassFromContext : Object.class, vaadinRequest);
            if (MDD.getClassPool() == null) {
                MDD.setClassPool((ClassPool)ReflectionHelper.createClassPool((ServletContext)((VaadinServletRequest)vaadinRequest).getHttpServletRequest().getServletContext()));
            }
            this.app.buildAreaAndMenuIds();
        }
    }

    public void irA(String donde) {
        this.navigator.navigateTo(donde);
    }

    public boolean isEditingNewRecord() {
        return this.getCurrentEditor() != null && this.getCurrentEditor().isNewRecord();
    }

    public IFieldBuilder getFieldBuilder(FieldInterfaced field) {
        IFieldBuilder r = null;
        for (IFieldBuilder iFieldBuilder : AbstractFieldBuilder.builders) {
            if (!iFieldBuilder.isSupported(field)) continue;
            r = iFieldBuilder;
            break;
        }
        return r;
    }

    public String getBaseUrl() {
        return null;
    }

    public void clearStack() {
    }

    public String getPath(MenuEntry e) {
        return this.app.getState(e);
    }

    public App getApp() {
        return this.app;
    }

    public String getCurrentUserLogin() {
        UserPrincipal p = this.securityManager != null ? this.securityManager.getPrincipal(((WrappedHttpSession)this.getSession().getSession()).getHttpSession()) : null;
        return p != null ? p.getLogin() : null;
    }

    public UserPrincipal getCurrentUser() {
        return null;
    }

    public Collection<FieldInterfaced> getColumnFields(Class targetType) {
        return ListViewComponent.getColumnFields(targetType);
    }

    public void updateTitle(String title) {
    }

    public boolean isMobile() {
        return false;
    }

    public String getCurrentState() {
        return this.navigator.getCurrentNavigationState();
    }

    public void go(String relativePath) {
        com.vaadin.navigator.View v;
        String path = this.stack.getState(this.stack.getLast());
        if (!"".equals(path) && !path.endsWith("/")) {
            path = path + "/";
        }
        if ((path = path + relativePath) != null && (v = this.viewProvider.getView(path)) != null) {
            this.navigator.navigateTo(path);
        }
    }

    public void goTo(String path) {
        com.vaadin.navigator.View v;
        if (path != null && (v = this.viewProvider.getView(path)) != null) {
            this.navigator.navigateTo(path);
        }
    }

    public void goBack() {
        if (this.stack.getLast() != null && !(this.stack.getLast().getComponent() instanceof OwnedCollectionComponent) && this.stack.getLast().getComponent() instanceof EditorViewComponent && (PersistentPojo.class.isAssignableFrom(((EditorViewComponent)this.stack.getLast().getComponent()).getModelType()) || ((EditorViewComponent)this.stack.getLast().getComponent()).getModelType().isAnnotationPresent(Entity.class)) && ((EditorViewComponent)this.stack.getLast().getComponent()).isModificado() && ((EditorViewComponent)this.stack.getLast().getComponent()).isCreateSaveButton()) {
            VaadinHelper.saveOrDiscard("There are unsaved changes. What do you want to do?", (EditorViewComponent)this.stack.getLast().getComponent(), () -> this.yesGoBack());
        } else {
            this.yesGoBack();
        }
    }

    public void yesGoBack() {
        View l = this.stack.getLast();
        if (this.stack.size() > 1) {
            View v = this.stack.get(this.stack.size() - 2);
            String u = this.stack.getState(v);
            if (v.getViewComponent() instanceof ListViewComponent) {
                u = ((ListViewComponent)v.getViewComponent()).getUrl();
            }
            if (l.getWindowContainer() != null && !l.getWindowContainer().equals((Object)v.getWindowContainer())) {
                l.getWindowContainer().setData((Object)"noback");
                l.getWindowContainer().close();
                this.stack.pop();
                this.viewProvider.setLastView(this.stack.getLast());
            } else {
                MDDUIAccessor.goTo((String)u);
            }
        } else {
            String u = this.stack.getState(l);
            if (!Strings.isNullOrEmpty((String)u) && u.contains("/")) {
                u = u.substring(0, u.lastIndexOf("/"));
                if (!MDDUIAccessor.isMobile() && this.esMenu(u)) {
                    while (this.esMenu(u.substring(0, u.lastIndexOf("/")))) {
                        u = u.substring(0, u.lastIndexOf("/"));
                    }
                }
                if (MDDUIAccessor.isMobile() && this.esInutil(u)) {
                    while (this.esInutil(u)) {
                        u = u.substring(0, u.lastIndexOf("/"));
                    }
                }
                MDDUIAccessor.goTo((String)u);
            }
        }
        if (l.getComponent() instanceof EditorViewComponent) {
            Object result = ((EditorViewComponent)l.getComponent()).getModel();
            if (result != null && result instanceof EditorListener) {
                ((EditorListener)result).onGoBack(result);
            }
            ((EditorViewComponent)l.getComponent()).onGoBack();
        }
    }

    public void goSibling(Object id) {
        if (this.stack.getLast().getComponent() instanceof EditorViewComponent && (PersistentPojo.class.isAssignableFrom(((EditorViewComponent)this.stack.getLast().getComponent()).getModelType()) || ((EditorViewComponent)this.stack.getLast().getComponent()).getModelType().isAnnotationPresent(Entity.class)) && ((EditorViewComponent)this.stack.getLast().getComponent()).isModificado()) {
            VaadinHelper.saveOrDiscard("There are unsaved changes. What do you want to do?", (EditorViewComponent)this.stack.getLast().getComponent(), () -> {
                try {
                    this.yesGoSibling(id);
                }
                catch (Throwable throwable) {
                    Notifier.alert((Throwable)throwable);
                }
            });
        } else {
            this.yesGoSibling(id);
        }
    }

    public void open(Method m, Set selection) {
        this.setPendingSelection(selection);
        this.go(m.getName());
    }

    public void open(Method m, Object result) {
        this.pendingResult = result;
        this.go(m.getName());
    }

    public Set getPendingSelection() {
        return this.pendingSelection;
    }

    public void setPendingSelection(Set selecion) {
        this.pendingSelection = selecion;
    }

    public Object getPendingResult() {
        return this.pendingResult;
    }

    public void setPendingResult(Object result) {
        this.pendingResult = result;
    }

    public void updateSession() {
        this.main.getHeader().updateSession();
    }

    private void yesGoSibling(Object id) {
        EditorViewComponent ed = null;
        if (this.stack.getLast().getComponent() instanceof EditorViewComponent) {
            ed = (EditorViewComponent)this.stack.getLast().getComponent();
            ed.onGoBack();
        }
        String u = this.stack.getState(this.stack.getLast());
        u = u.substring(0, u.lastIndexOf("/"));
        if (!MDDUIAccessor.isMobile() && this.esMenu(u)) {
            while (this.esMenu(u.substring(0, u.lastIndexOf("/")))) {
                u = u.substring(0, u.lastIndexOf("/"));
            }
        }
        if (MDDUIAccessor.isMobile() && this.esInutil(u)) {
            while (this.esInutil(u)) {
                u = u.substring(0, u.lastIndexOf("/"));
            }
        }
        u = u + "/" + id;
        if (ed != null && ed.getView().getWindowContainer() != null) {
            try {
                ed.load(id);
                this.viewProvider.getStack().getViewByState().remove(this.viewProvider.getStack().getStateByView().get(ed.getView()));
                this.viewProvider.getStack().getStateByView().put(ed.getView(), u);
                this.viewProvider.getStack().getViewByState().put(u, ed.getView());
            }
            catch (Throwable throwable) {
                Notifier.alert((Throwable)throwable);
            }
        } else {
            MDDUIAccessor.goTo((String)u);
        }
    }

    private boolean esInutil(String u) {
        Component c;
        View v;
        if (!Strings.isNullOrEmpty((String)u) && (v = this.stack.get(u)) != null && (c = v.getComponent()) instanceof AreaComponent) {
            return MDDUIAccessor.getApp().getAreas().length <= 1;
        }
        return false;
    }

    private boolean esMenu(String u) {
        Component c;
        View v;
        return !Strings.isNullOrEmpty((String)u) && (v = this.stack.get(u)) != null && (c = v.getComponent()) instanceof MenuComponent;
    }

    public void openInWindow(View view) {
        MateuWindow w = new MateuWindow(this, this.stack, view.getViewComponent().getCaption());
        w.addStyleName("maincomponent");
        int percent = 100 - (UI.getCurrent().getWindows().size() + 1) * 5;
        w.setWidth("" + percent + "%");
        w.setHeight("" + percent + "%");
        w.setContent((Component)view.getViewComponent());
        view.setWindowContainer(w);
        w.center();
        w.setModal(true);
        UI.getCurrent().addWindow((Window)w);
    }

    public void openInWindow(Component component) {
        MateuWindow w = new MateuWindow(this, this.stack, component.getCaption());
        w.addStyleName("maincomponent");
        int percent = 100 - (UI.getCurrent().getWindows().size() + 1) * 5;
        w.setWidth("" + percent + "%");
        w.setHeight("" + percent + "%");
        w.setContent(component);
        w.center();
        w.setModal(true);
        UI.getCurrent().addWindow((Window)w);
    }

    public static void closeWindow() {
        MateuUI.closeWindow(true);
    }

    public static void closeWindow(boolean notifyClosingEvent) {
        if (UI.getCurrent() != null && UI.getCurrent().getWindows().size() > 0) {
            ArrayList l = new ArrayList(UI.getCurrent().getWindows());
            Window w = (Window)l.get(l.size() - 1);
            w.setData((Object)notifyClosingEvent);
            w.close();
        }
    }

    public ViewStack getStack() {
        return this.viewProvider.getStack();
    }

    public void setArea(AbstractArea area) {
        this.area = area;
        this.main.getHeader().setArea(area);
        this.main.getHeaderForMobile().setArea(area);
    }
}

