/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.vaadin.components;

import com.vaadin.icons.VaadinIcons;
import com.vaadin.ui.Component;
import com.vaadin.ui.Window;
import io.mateu.mdd.core.app.AbstractAction;
import io.mateu.mdd.core.interfaces.HasActions;
import io.mateu.mdd.core.interfaces.HasIcon;
import io.mateu.mdd.core.ui.MDDUIAccessor;
import io.mateu.mdd.shared.annotations.ExpandOnOpen;
import io.mateu.mdd.shared.annotations.FullWidth;
import io.mateu.mdd.vaadin.components.views.AbstractViewComponent;
import java.util.List;

public class ComponentWrapper
extends AbstractViewComponent {
    private final Component wrapped;
    private final VaadinIcons _icon;
    private final boolean expand;

    @Override
    public VaadinIcons getIcon() {
        return this.wrapped instanceof HasIcon ? ((HasIcon)this.wrapped).getIcon() : this._icon;
    }

    public Component getWrapped() {
        return this.wrapped;
    }

    public ComponentWrapper(String title, Component component) {
        this(null, title, component, true);
    }

    public ComponentWrapper(VaadinIcons icon, String title, Component component, boolean expand) {
        this.setTitle(title);
        this._icon = icon != null ? icon : VaadinIcons.FILE;
        this.wrapped = component;
        this.expand = expand;
        this.addStyleName("componentwrapper");
        this.updatePageTitle();
    }

    public AbstractViewComponent build() throws Exception {
        super.build();
        if (!(this.wrapped instanceof Window)) {
            if (MDDUIAccessor.isMobile() || !this.expand && !(this.wrapped instanceof FullWidth)) {
                this.addComponent(this.wrapped);
            } else {
                this.addComponentsAndExpand(new Component[]{this.wrapped});
            }
        }
        return this;
    }

    @Override
    public List<AbstractAction> getActions() {
        List<AbstractAction> as = super.getActions();
        if (this.wrapped instanceof HasActions) {
            as.addAll(((HasActions)this.wrapped).getActions());
        }
        return as;
    }

    public String toString() {
        return this.getTitle() != null ? this.getTitle() : (this.wrapped != null ? this.wrapped.toString() : "Nothing wrapped");
    }

    @Override
    public boolean expandOnOpen() {
        return this.wrapped != null && this.wrapped.getClass().isAnnotationPresent(ExpandOnOpen.class);
    }
}

