/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.vaadin.components.app.main;

import com.vaadin.data.HasValue;
import com.vaadin.data.provider.ListDataProvider;
import com.vaadin.event.FieldEvents;
import com.vaadin.event.FocusShortcut;
import com.vaadin.event.ShortcutListener;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.ItemCaptionGenerator;
import io.mateu.mdd.core.app.AbstractApplication;
import io.mateu.mdd.core.app.AbstractMenu;
import io.mateu.mdd.shared.interfaces.IArea;
import io.mateu.mdd.shared.interfaces.IModule;
import io.mateu.mdd.shared.interfaces.MenuEntry;
import io.mateu.mdd.vaadin.MateuUI;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class MenuSearcher
extends ComboBox<MenuEntry> {
    public MenuSearcher(AbstractApplication app) {
        this.addStyleName("menusearcher");
        this.setPlaceholder("Search in menu");
        this.updateDataProvider(app);
        this.setItemCaptionGenerator((ItemCaptionGenerator & Serializable)i -> i.getCaption());
        this.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            if (e.getValue() != null) {
                MateuUI.get().getMain().irA(app.getState((MenuEntry)e.getValue()));
            }
        });
        this.setPopupWidth("500px");
        this.addShortcutListener((ShortcutListener)new FocusShortcut((Component.Focusable)this, 113));
        this.addFocusListener((FieldEvents.FocusListener & Serializable)e -> this.setValue(null));
    }

    public void updateDataProvider(AbstractApplication app) {
        List<MenuEntry> entries = this.buildOptionsList(app);
        this.setDataProvider(new ListDataProvider(entries));
    }

    private List<MenuEntry> buildOptionsList(AbstractApplication app) {
        this.setVisible(false);
        ArrayList<MenuEntry> entries = new ArrayList<MenuEntry>();
        for (IArea a : app.getAreas()) {
            for (IModule m : a.getModules()) {
                for (MenuEntry e : m.getMenu()) {
                    if (e instanceof AbstractMenu) {
                        this.addOptions(entries, (AbstractMenu)e);
                        continue;
                    }
                    entries.add(e);
                }
            }
        }
        return entries;
    }

    private void addOptions(List<MenuEntry> entries, AbstractMenu m) {
        this.setVisible(true);
        for (MenuEntry e : m.getEntries()) {
            if (e instanceof AbstractMenu) {
                this.addOptions(entries, (AbstractMenu)e);
                continue;
            }
            entries.add(e);
        }
    }
}

