/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.vaadin.components.charts;

import com.byteowls.vaadin.chartjs.ChartJs;
import com.byteowls.vaadin.chartjs.config.ChartConfig;
import com.byteowls.vaadin.chartjs.config.LineChartConfig;
import com.byteowls.vaadin.chartjs.data.Dataset;
import com.byteowls.vaadin.chartjs.data.LineDataset;
import com.byteowls.vaadin.chartjs.options.InteractionMode;
import com.byteowls.vaadin.chartjs.options.Position;
import com.byteowls.vaadin.chartjs.options.scale.Axis;
import com.byteowls.vaadin.chartjs.options.scale.LinearScale;
import com.byteowls.vaadin.chartjs.options.types.LineChartOptions;
import com.google.common.base.Strings;
import com.vaadin.data.provider.ListDataProvider;
import com.vaadin.data.provider.Query;
import com.vaadin.ui.Component;
import com.vaadin.ui.Composite;
import io.mateu.mdd.vaadin.components.charts.ChartData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class LineChart
extends Composite {
    private static String[] colores = new String[]{"red", "blue", "green", "orange", "darkgrey"};
    private final String title;
    private ListDataProvider<ChartData> dataProvider;

    public LineChart(ListDataProvider<ChartData> dataProvider) {
        this(null, dataProvider);
    }

    public LineChart(String title, ListDataProvider<ChartData> dataProvider) {
        this.title = title;
        this.dataProvider = dataProvider;
        ChartJs chart = new ChartJs((ChartConfig)this.createConfig(title, dataProvider));
        this.setCompositionRoot((Component)chart);
        this.setWidth("100%");
    }

    private LineChartConfig createConfig(String title, ListDataProvider<ChartData> dataProvider) {
        HashMap data = new HashMap();
        ArrayList keys = new ArrayList();
        ArrayList labels = new ArrayList();
        HashMap dataSets = new HashMap();
        dataProvider.fetch(new Query()).forEach(r -> {
            HashMap<Object, Double> l = (HashMap<Object, Double>)data.get(r.getLine());
            if (l == null) {
                l = new HashMap<Object, Double>();
                data.put(r.getLine(), l);
            }
            l.put(r.getLabel(), r.getValue());
            if (!keys.contains(r.getLine())) {
                keys.add(r.getLine());
            }
            if (!labels.contains(r.getLabel())) {
                labels.add(r.getLabel());
            }
        });
        LineChartConfig barConfig = new LineChartConfig();
        barConfig.data().labelsAsList(labels.stream().map(l -> "" + l).collect(Collectors.toList()));
        keys.forEach(k -> dataSets.computeIfAbsent(k, l -> {
            LineDataset ds = new LineDataset();
            ds.label("" + l);
            ds.backgroundColor(colores[keys.indexOf(k) % colores.length]);
            ds.fill(false);
            barConfig.data().addDataset((Dataset)ds);
            return ds;
        }));
        LineChartOptions options = barConfig.options();
        ((LineChartOptions)options.responsive(true)).hover().mode(InteractionMode.INDEX).intersect(true).animationDuration(400).and();
        if (!Strings.isNullOrEmpty((String)title)) {
            options.title().display(true).text(title).and();
        }
        ((LineChartOptions)options.scales().add(Axis.Y, new LinearScale().display(true).position(Position.LEFT)).and()).done();
        for (Object k2 : keys) {
            LineDataset lds = (LineDataset)dataSets.get(k2);
            ArrayList<Double> dl = new ArrayList<Double>();
            for (Object l2 : labels) {
                dl.add(((Map)data.get(k2)).getOrDefault(l2, 0.0));
            }
            lds.dataAsList(dl);
        }
        return barConfig;
    }
}

