/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.vaadin.components.fieldBuilders;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.vaadin.data.Binder;
import com.vaadin.data.BindingValidationStatusHandler;
import com.vaadin.data.HasValue;
import com.vaadin.data.ValidationResult;
import com.vaadin.data.Validator;
import com.vaadin.data.ValueContext;
import com.vaadin.data.ValueProvider;
import com.vaadin.server.ErrorHandler;
import com.vaadin.server.ErrorMessage;
import com.vaadin.server.Resource;
import com.vaadin.server.Setter;
import com.vaadin.server.UserError;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.AbstractTextField;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Grid;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Layout;
import com.vaadin.ui.VerticalLayout;
import io.mateu.mdd.core.app.AbstractAction;
import io.mateu.mdd.core.interfaces.AbstractStylist;
import io.mateu.mdd.core.ui.MDDUIAccessor;
import io.mateu.mdd.shared.annotations.Help;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.mdd.shared.reflection.IFieldBuilder;
import io.mateu.mdd.vaadin.MateuUI;
import io.mateu.mdd.vaadin.actions.AcctionRunner;
import io.mateu.mdd.vaadin.components.fieldBuilders.ButtonFieldBuilder;
import io.mateu.mdd.vaadin.components.fieldBuilders.ComponentFieldBuilder;
import io.mateu.mdd.vaadin.components.fieldBuilders.FareValueFieldBuilder;
import io.mateu.mdd.vaadin.components.fieldBuilders.FileFieldBuilder;
import io.mateu.mdd.vaadin.components.fieldBuilders.FromDataProviderFieldBuilder;
import io.mateu.mdd.vaadin.components.fieldBuilders.JPAAuditFieldBuilder;
import io.mateu.mdd.vaadin.components.fieldBuilders.JPABooleanFieldBuilder;
import io.mateu.mdd.vaadin.components.fieldBuilders.JPACodeFieldBuilder;
import io.mateu.mdd.vaadin.components.fieldBuilders.JPADateFieldBuilder;
import io.mateu.mdd.vaadin.components.fieldBuilders.JPADoubleFieldBuilder;
import io.mateu.mdd.vaadin.components.fieldBuilders.JPAEnumerationFieldBuilder;
import io.mateu.mdd.vaadin.components.fieldBuilders.JPAFastMoneyFieldBuilder;
import io.mateu.mdd.vaadin.components.fieldBuilders.JPAHtmlFieldBuilder;
import io.mateu.mdd.vaadin.components.fieldBuilders.JPAIFrameFieldBuilder;
import io.mateu.mdd.vaadin.components.fieldBuilders.JPAIconFieldBuilder;
import io.mateu.mdd.vaadin.components.fieldBuilders.JPAIntegerFieldBuilder;
import io.mateu.mdd.vaadin.components.fieldBuilders.JPALiteralFieldBuilder;
import io.mateu.mdd.vaadin.components.fieldBuilders.JPALocalDateFieldBuilder;
import io.mateu.mdd.vaadin.components.fieldBuilders.JPALocalDateTimeFieldBuilder;
import io.mateu.mdd.vaadin.components.fieldBuilders.JPALongFieldBuilder;
import io.mateu.mdd.vaadin.components.fieldBuilders.JPAManyToOneFieldBuilder;
import io.mateu.mdd.vaadin.components.fieldBuilders.JPAMoneyFieldBuilder;
import io.mateu.mdd.vaadin.components.fieldBuilders.JPAOneToManyFieldBuilder;
import io.mateu.mdd.vaadin.components.fieldBuilders.JPAOneToOneFieldBuilder;
import io.mateu.mdd.vaadin.components.fieldBuilders.JPAPOJOFieldBuilder;
import io.mateu.mdd.vaadin.components.fieldBuilders.JPAPrimitiveArraysFieldBuilder;
import io.mateu.mdd.vaadin.components.fieldBuilders.JPAPrimitiveCollectionsFieldBuilder;
import io.mateu.mdd.vaadin.components.fieldBuilders.JPAResourceFieldBuilder;
import io.mateu.mdd.vaadin.components.fieldBuilders.JPASignatureFieldBuilder;
import io.mateu.mdd.vaadin.components.fieldBuilders.JPAStringFieldBuilder;
import io.mateu.mdd.vaadin.components.fieldBuilders.JPATextAreaFieldBuilder;
import io.mateu.mdd.vaadin.components.fieldBuilders.JPATimeFieldBuilder;
import io.mateu.mdd.vaadin.components.fieldBuilders.JPAURLFieldBuilder;
import io.mateu.mdd.vaadin.components.fieldBuilders.JPAUnmodifiableFieldBuilder;
import io.mateu.mdd.vaadin.components.fieldBuilders.JPAWeekDaysFieldBuilder;
import io.mateu.mdd.vaadin.components.fieldBuilders.JPAWizardFieldBuilder;
import io.mateu.mdd.vaadin.components.fieldBuilders.KPIInlineFieldBuilder;
import io.mateu.mdd.vaadin.data.MDDBinder;
import io.mateu.mdd.vaadin.util.VaadinHelper;
import io.mateu.reflection.ReflectionHelper;
import io.mateu.util.Helper;
import io.mateu.util.data.Pair;
import io.mateu.util.notification.Notifier;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public abstract class AbstractFieldBuilder
implements IFieldBuilder {
    public static List<AbstractFieldBuilder> builders = Lists.newArrayList((Object[])new AbstractFieldBuilder[]{new KPIInlineFieldBuilder(), new ButtonFieldBuilder(), new FareValueFieldBuilder(), new JPAUnmodifiableFieldBuilder(), new FromDataProviderFieldBuilder(), new JPAAuditFieldBuilder(), new JPAWizardFieldBuilder(), new JPAWeekDaysFieldBuilder(), new JPAIFrameFieldBuilder(), new JPAURLFieldBuilder(), new FileFieldBuilder(), new JPAResourceFieldBuilder(), new JPAIconFieldBuilder(), new JPALiteralFieldBuilder(), new JPASignatureFieldBuilder(), new JPACodeFieldBuilder(), new JPAHtmlFieldBuilder(), new JPAPrimitiveArraysFieldBuilder(), new JPAPrimitiveCollectionsFieldBuilder(), new JPAFastMoneyFieldBuilder(), new JPAMoneyFieldBuilder(), new JPATextAreaFieldBuilder(), new JPAStringFieldBuilder(), new JPATimeFieldBuilder(), new JPAIntegerFieldBuilder(), new JPALongFieldBuilder(), new JPADoubleFieldBuilder(), new JPABooleanFieldBuilder(), new JPAEnumerationFieldBuilder(), new JPAOneToOneFieldBuilder(), new JPAManyToOneFieldBuilder(), new JPAOneToManyFieldBuilder(), new JPADateFieldBuilder(), new JPALocalDateFieldBuilder(), new JPALocalDateTimeFieldBuilder(), new ComponentFieldBuilder(), new JPAPOJOFieldBuilder()});

    public abstract boolean isSupported(FieldInterfaced var1);

    public abstract Component build(FieldInterfaced var1, Object var2, Layout var3, MDDBinder var4, Map<HasValue, List<Validator>> var5, AbstractStylist var6, Map<FieldInterfaced, Component> var7, boolean var8, Map<String, List<AbstractAction>> var9);

    public static void applyStyles(AbstractStylist stylist, Object model, Map<FieldInterfaced, Component> containers, Pair<Map<FieldInterfaced, List<String>>, Map<FieldInterfaced, List<String>>> styleChanges) {
        Map remove = (Map)styleChanges.getKey();
        Map add = (Map)styleChanges.getValue();
        remove.keySet().forEach(f -> {
            if (containers.containsKey(f)) {
                ((Component)containers.get(f)).removeStyleNames(((List)remove.get(f)).toArray(new String[0]));
            }
        });
        add.keySet().forEach(f -> {
            if (containers.containsKey(f)) {
                ((Component)containers.get(f)).addStyleNames(((List)add.get(f)).toArray(new String[0]));
            }
        });
        if (model != null) {
            for (FieldInterfaced f2 : containers.keySet()) {
                Component c = containers.get(f2);
                if (c == null) continue;
                List styles = stylist.style(f2, model);
                c.setEnabled(stylist.isEnabled(f2, model));
                boolean v = stylist.isVisible(f2, model);
                c.setVisible(v);
                if (!(c.getParent() instanceof HorizontalLayout)) continue;
                boolean[] algunoVisible = new boolean[]{false};
                ((Layout)c.getParent()).getComponentIterator().forEachRemaining(x -> {
                    algunoVisible[0] = algunoVisible[0] | x.isVisible();
                });
                c.getParent().setVisible(algunoVisible[0]);
            }
        }
    }

    public void addErrorHandler(FieldInterfaced f, AbstractComponent tf) {
        if (!MDDUIAccessor.isMobile() && f.isAnnotationPresent(Help.class) && !Strings.isNullOrEmpty((String)((Help)f.getAnnotation(Help.class)).value())) {
            String h = ((Help)f.getAnnotation(Help.class)).value();
            tf.setDescription(h);
            if (tf instanceof AbstractTextField) {
                ((AbstractTextField)tf).setPlaceholder(h);
            }
        }
        tf.setErrorHandler((ErrorHandler & Serializable)e -> {
            Throwable th;
            for (th = e.getThrowable(); th != null && th.getCause() != null; th = th.getCause()) {
            }
            e.setThrowable(th);
            tf.setComponentError((ErrorMessage)new UserError(th.getMessage()));
        });
    }

    public static Binder.Binding completeBinding(Binder.BindingBuilder aux, MDDBinder binder, FieldInterfaced field) {
        return AbstractFieldBuilder.completeBinding(aux, binder, field, null);
    }

    public static Binder.Binding completeBinding(Binder.BindingBuilder aux, final MDDBinder binder, final FieldInterfaced field, AbstractComponent captionOwner) {
        aux.withValidator(new Validator(){
            boolean initialized = false;
            Object lastValue = null;
            ValidationResult lastResult;

            public ValidationResult apply(Object v, ValueContext valueContext) {
                if (valueContext.getHasValue().isPresent()) {
                    if (!(this.initialized && (this.lastValue == v || v != null && v.equals(this.lastValue)) || this.initialized && this.lastValue == v && (v == null || v.equals(this.lastValue)))) {
                        this.initialized = true;
                        try {
                            Object old = ReflectionHelper.getValue((FieldInterfaced)field, (Object)binder.getBean());
                            if (!Helper.equals((Object)v, (Object)old)) {
                                ReflectionHelper.setValue((FieldInterfaced)field, (Object)binder.getBean(), (Object)v);
                            }
                            this.lastValue = v;
                            this.lastResult = ValidationResult.ok();
                            return this.lastResult;
                        }
                        catch (Exception e) {
                            Throwable th;
                            for (th = e; th != null && th.getCause() != null; th = th.getCause()) {
                            }
                            th.printStackTrace();
                            this.lastResult = ValidationResult.error((String)(th.getMessage() != null ? th.getMessage() : th.getClass().getSimpleName()));
                            return this.lastResult;
                        }
                    }
                    return this.lastResult != null ? this.lastResult : (this.lastResult = ValidationResult.ok());
                }
                return ValidationResult.error((String)"missing HasValue");
            }

            public Object apply(Object o, Object o2) {
                return ValidationResult.ok();
            }
        });
        if (captionOwner != null) {
            aux.withValidationStatusHandler((BindingValidationStatusHandler & Serializable)s -> {
                if (s.isError()) {
                    captionOwner.setComponentError((ErrorMessage)new UserError(s.getMessage().orElse("Error")));
                } else {
                    captionOwner.setComponentError(null);
                }
            });
        }
        Binder.Binding binding = aux.bind((ValueProvider & Serializable)o -> ReflectionHelper.getValue((FieldInterfaced)field, (Object)o, (Object)AbstractFieldBuilder.getDefaultValueForField(field)), (Setter & Serializable)(o, v) -> binder.update(o));
        return binding;
    }

    private static Object getDefaultValueForField(FieldInterfaced field) {
        if (String.class.equals((Object)field.getType())) {
            return "";
        }
        if (Boolean.TYPE.equals(field.getType())) {
            return false;
        }
        return null;
    }

    public static void completeBinding(HasValue hv, MDDBinder binder, FieldInterfaced field) {
        Binder.BindingBuilder aux = binder.forField(hv);
        AbstractFieldBuilder.completeBinding(aux, binder, field);
    }

    public void addComponent(Layout container, Component c, List<AbstractAction> attachedActions) {
        if (attachedActions == null || attachedActions.size() == 0) {
            container.addComponent(c);
        } else {
            VerticalLayout vl = null;
            if (c instanceof VerticalLayout && ((VerticalLayout)c).getComponentCount() == 2 && ((VerticalLayout)c).getComponent(1) instanceof HorizontalLayout) {
                vl = (VerticalLayout)c;
                this.crearBotonera(vl.getComponent(0), attachedActions, (Layout)vl.getComponent(1));
            } else {
                vl = new VerticalLayout(new Component[]{c, this.crearBotonera(c, attachedActions)});
            }
            vl.addStyleName("nopadding");
            vl.addStyleName("contenedorbotoneracampo");
            vl.addStyleName("conbotonera");
            container.addComponent((Component)vl);
        }
    }

    private Component crearBotonera(Component c, List<AbstractAction> attachedActions) {
        HorizontalLayout hl = new HorizontalLayout();
        hl.addStyleName("nopadding");
        hl.addStyleName("botoneracampo");
        return this.crearBotonera(c, attachedActions, (Layout)hl);
    }

    private Component crearBotonera(final Component c, List<AbstractAction> attachedActions, Layout hl) {
        for (final AbstractAction a : attachedActions) {
            Button b;
            Button i = null;
            i = b = new Button(a.getCaption(), (Resource)a.getIcon());
            b.addStyleName("quiet");
            b.addStyleName("tiny");
            b.addClickListener((Button.ClickListener & Serializable)e -> {
                try {
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            if (c instanceof Grid) {
                                MateuUI.get().setPendingSelection(((Grid)c).getSelectedItems());
                            }
                            try {
                                new AcctionRunner().run(a);
                            }
                            catch (Throwable ex) {
                                Notifier.alert((Throwable)ex);
                            }
                        }
                    };
                    if (!Strings.isNullOrEmpty((String)a.getConfirmationMessage())) {
                        VaadinHelper.confirm(a.getConfirmationMessage(), () -> r.run());
                    } else {
                        r.run();
                    }
                }
                catch (Throwable throwable) {
                    Notifier.alert((Throwable)throwable);
                }
            });
            if (!Strings.isNullOrEmpty((String)a.getStyle())) {
                i.addStyleName(a.getStyle());
            }
            if (Strings.isNullOrEmpty((String)a.getGroup())) {
                hl.addComponent((Component)i);
            }
            if (i != null && !Strings.isNullOrEmpty((String)a.getStyle())) {
                i.addStyleName(a.getStyle());
            }
            i.setVisible(true);
        }
        return hl;
    }
}

