/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.vaadin.components.fieldBuilders;

import com.vaadin.data.Binder;
import com.vaadin.data.HasValue;
import com.vaadin.data.Validator;
import com.vaadin.data.provider.ListDataProvider;
import com.vaadin.data.validator.BeanValidator;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.Layout;
import io.mateu.mdd.core.app.AbstractAction;
import io.mateu.mdd.core.interfaces.AbstractStylist;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.mdd.vaadin.components.fieldBuilders.AbstractFieldBuilder;
import io.mateu.mdd.vaadin.data.MDDBinder;
import io.mateu.reflection.ReflectionHelper;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;

public class JPAEnumerationFieldBuilder
extends AbstractFieldBuilder {
    @Override
    public boolean isSupported(FieldInterfaced field) {
        return field.getType().isEnum();
    }

    @Override
    public Component build(FieldInterfaced field, Object object, Layout container, MDDBinder binder, Map<HasValue, List<Validator>> validators, AbstractStylist stylist, Map<FieldInterfaced, Component> allFieldContainers, boolean forSearchFilter, Map<String, List<AbstractAction>> attachedActions) {
        ComboBox tf = new ComboBox();
        container.addComponent((Component)tf);
        if (allFieldContainers != null && allFieldContainers.size() == 0) {
            tf.focus();
        }
        tf.setDataProvider(new ListDataProvider(Arrays.asList(field.getType().getEnumConstants())));
        if (allFieldContainers != null) {
            allFieldContainers.put(field, (Component)tf);
        }
        tf.setCaption(ReflectionHelper.getCaption((FieldInterfaced)field));
        tf.setRequiredIndicatorVisible(field.isAnnotationPresent(NotNull.class));
        this.bind(binder, tf, field, forSearchFilter);
        this.addErrorHandler(field, (AbstractComponent)tf);
        return tf;
    }

    protected void bind(MDDBinder binder, ComboBox tf, FieldInterfaced field, boolean forSearchFilter) {
        Binder.BindingBuilder aux = binder.forField((HasValue)tf);
        if (!forSearchFilter && field.getDeclaringClass() != null) {
            aux.withValidator((Validator)new BeanValidator(field.getDeclaringClass(), field.getName()));
        }
        JPAEnumerationFieldBuilder.completeBinding(aux, binder, field);
    }
}

