/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.vaadin.components.fieldBuilders;

import com.vaadin.data.Binder;
import com.vaadin.data.HasValue;
import com.vaadin.data.Validator;
import com.vaadin.data.validator.BeanValidator;
import com.vaadin.event.LayoutEvents;
import com.vaadin.icons.VaadinIcons;
import com.vaadin.server.Resource;
import com.vaadin.shared.Registration;
import com.vaadin.shared.ui.ContentMode;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.Button;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Layout;
import io.mateu.mdd.core.app.AbstractAction;
import io.mateu.mdd.core.interfaces.AbstractStylist;
import io.mateu.mdd.core.ui.MDDUIAccessor;
import io.mateu.mdd.shared.FormLayoutBuilderParameters;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.mdd.vaadin.MateuUI;
import io.mateu.mdd.vaadin.components.ClassOption;
import io.mateu.mdd.vaadin.components.fieldBuilders.AbstractFieldBuilder;
import io.mateu.mdd.vaadin.components.views.FormLayoutBuilder;
import io.mateu.mdd.vaadin.data.MDDBinder;
import io.mateu.mdd.vaadin.util.VaadinHelper;
import io.mateu.reflection.ReflectionHelper;
import io.mateu.util.notification.Notifier;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.constraints.NotNull;

public class JPAPOJOFieldBuilder
extends AbstractFieldBuilder {
    MDDBinder subbinder;
    private FieldInterfaced field;
    private Layout formLayout;
    private MDDBinder binder;
    private Set<Class> subClasses;
    private ComboBox<ClassOption> cb;

    @Override
    public boolean isSupported(FieldInterfaced field) {
        return true;
    }

    @Override
    public Component build(FieldInterfaced field, Object object, Layout container, MDDBinder binder, Map<HasValue, List<Validator>> validators, AbstractStylist stylist, Map<FieldInterfaced, Component> allFieldContainers, boolean forSearchFilter, Map<String, List<AbstractAction>> attachedActions) {
        HorizontalLayout hl;
        this.field = field;
        this.binder = binder;
        HorizontalLayout r = null;
        HorizontalLayout tf = null;
        HasValue hv = null;
        tf = hl = new HorizontalLayout();
        container.addComponent((Component)hl);
        this.addErrorHandler(field, (AbstractComponent)hl);
        r = hl;
        final Label l = new Label();
        hl.addComponent((Component)l);
        l.setContentMode(ContentMode.HTML);
        final Button reset = new Button((Resource)VaadinIcons.CLOSE, (Button.ClickListener & Serializable)e -> {
            Object bean = binder.getBean();
            try {
                ReflectionHelper.setValue((FieldInterfaced)field, (Object)bean, null);
                binder.setBean(bean, false);
            }
            catch (Exception ex) {
                Notifier.alert((Throwable)ex);
            }
        });
        hl.addComponent((Component)reset);
        reset.addStyleName("tiny");
        reset.setVisible(false);
        final ArrayList listeners = new ArrayList();
        hv = new HasValue(){
            private Object value;

            public void setValue(Object o) {
                Object oldValue = this.value;
                this.value = o;
                String v = o != null ? "" + JPAPOJOFieldBuilder.this.toHtml(o) : "No value";
                l.setValue(v);
                1 finalHv = this;
                listeners.forEach(l -> l.valueChange(new HasValue.ValueChangeEvent((Component)hl, finalHv, oldValue, false)));
                reset.setVisible(o != null);
            }

            public Object getValue() {
                return this.value;
            }

            public Registration addValueChangeListener(final HasValue.ValueChangeListener valueChangeListener) {
                listeners.add(valueChangeListener);
                return new Registration(){

                    public void remove() {
                        listeners.remove(valueChangeListener);
                    }
                };
            }

            public void setRequiredIndicatorVisible(boolean b) {
            }

            public boolean isRequiredIndicatorVisible() {
                return false;
            }

            public void setReadOnly(boolean b) {
            }

            public boolean isReadOnly() {
                return false;
            }
        };
        if (!forSearchFilter) {
            hv.setRequiredIndicatorVisible(field.isAnnotationPresent(NotNull.class));
            hl.addStyleName("clickable");
            hl.addLayoutClickListener((LayoutEvents.LayoutClickListener & Serializable)e -> {
                Object bean = binder.getBean();
                try {
                    Object value = ReflectionHelper.getValue((FieldInterfaced)field, (Object)bean);
                    if (value == null) {
                        Class modelType = field.getType();
                        Set subClasses = ReflectionHelper.getSubclasses((Class)modelType);
                        if (subClasses.size() > 1) {
                            LinkedHashSet subClassesOptions = new LinkedHashSet();
                            subClasses.forEach(c -> subClassesOptions.add(new ClassOption((Class)c)));
                            VaadinHelper.choose("Please choose type", subClassesOptions, c -> {
                                if (c == null) {
                                    MDDUIAccessor.goBack();
                                } else {
                                    try {
                                        this.create(binder, ((ClassOption)c).get_class(), bean);
                                    }
                                    catch (Throwable th) {
                                        Notifier.alert((Throwable)th);
                                    }
                                }
                            }, () -> MDDUIAccessor.goBack());
                        } else if (subClasses.size() == 1) {
                            this.create(binder, (Class)subClasses.iterator().next(), bean);
                        } else {
                            this.create(binder, modelType, bean);
                        }
                    } else {
                        MDDUIAccessor.go((String)field.getName());
                    }
                }
                catch (Throwable ex) {
                    Notifier.alert((Throwable)ex);
                }
            });
        }
        if (allFieldContainers != null) {
            allFieldContainers.put(field, (Component)tf);
        }
        tf.setCaption(ReflectionHelper.getCaption((FieldInterfaced)field));
        this.bind(binder, hv, field, forSearchFilter);
        return r;
    }

    private String toHtml(Object o) {
        String h = "";
        if (o != null) {
            Method m = ReflectionHelper.getMethod(o.getClass(), (String)"toHtml");
            if (m != null) {
                try {
                    h = (String)m.invoke(o, new Object[0]);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            } else {
                m = ReflectionHelper.getMethod(o.getClass(), (String)"toString");
                if (m != null && !Object.class.equals(m.getDeclaringClass())) {
                    try {
                        h = (String)m.invoke(o, new Object[0]);
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                } else {
                    h = ReflectionHelper.toHtml((Object)o);
                }
            }
        }
        return h;
    }

    private void create(MDDBinder binder, Class type, Object parent) throws Throwable {
        Constructor con;
        Constructor constructor = con = parent != null ? ReflectionHelper.getConstructor((Class)type, parent.getClass()) : ReflectionHelper.getConstructor((Class)type);
        if (con != null && con.getParameterCount() > 0) {
            VaadinHelper.fill("I need some data", con, i -> {
                try {
                    ReflectionHelper.setValue((FieldInterfaced)this.field, (Object)parent, (Object)i);
                    binder.setBean(parent, false);
                }
                catch (Throwable e) {
                    Notifier.alert((Throwable)e);
                }
                MateuUI.closeWindow(false);
                MDDUIAccessor.go((String)this.field.getName());
            }, () -> MDDUIAccessor.goBack());
        } else {
            Object i2 = ReflectionHelper.newInstance((Class)type, (Object)parent);
            ReflectionHelper.setValue((FieldInterfaced)this.field, (Object)parent, (Object)i2);
            binder.setBean(parent, false);
            MDDUIAccessor.go((String)this.field.getName());
        }
    }

    protected void bind(MDDBinder binder, HasValue tf, FieldInterfaced field, boolean forSearchFilter) {
        Binder.BindingBuilder aux = binder.forField(tf);
        if (!forSearchFilter && field.getDeclaringClass() != null) {
            aux.withValidator((Validator)new BeanValidator(field.getDeclaringClass(), field.getName()));
        }
        aux.bind(field.getName());
    }

    private void subBuild(Map<String, List<AbstractAction>> attachedActions) {
        block9: {
            Object i = null;
            try {
                i = ReflectionHelper.getValue((FieldInterfaced)this.field, (Object)this.binder.getBean());
                if (i != null) {
                    this.subBuild(i.getClass(), i, attachedActions);
                    break block9;
                }
                if (this.subClasses.size() > 1) {
                    try {
                        if (i != null) {
                            this.subBuild(i.getClass(), attachedActions);
                        }
                        break block9;
                    }
                    catch (Exception e) {
                        Notifier.alert((Throwable)e);
                    }
                    break block9;
                }
                if (this.subClasses.size() == 1) {
                    this.subBuild(this.subClasses.iterator().next(), attachedActions);
                } else {
                    this.subBuild(this.field.getType(), attachedActions);
                }
            }
            catch (Exception e) {
                Notifier.alert((Throwable)e);
            }
        }
    }

    private void subBuild(Class subType, Map<String, List<AbstractAction>> attachedActions) {
        this.subBuild(subType, null, attachedActions);
    }

    private void subBuild(Class subType, Object o, Map<String, List<AbstractAction>> attachedActions) {
        this.formLayout.removeAllComponents();
        if (o == null) {
            try {
                o = subType.newInstance();
                Object bean = this.binder.getBean();
                ReflectionHelper.setValue((FieldInterfaced)this.field, (Object)bean, (Object)o);
                this.binder.setBean(bean, false);
            }
            catch (Exception e) {
                Notifier.alert((Throwable)e);
            }
        }
        this.subbinder = new MDDBinder(subType);
        this.subbinder.setBean(o);
        HashMap subvalidators = new HashMap();
        FormLayoutBuilder.get().build(this.formLayout, this.subbinder, subType, o, new ArrayList<Component>(), FormLayoutBuilderParameters.builder().validators(subvalidators).allFields(ReflectionHelper.getAllEditableFields((Class)subType, (Class)this.field.getType())).build(), attachedActions);
        this.bind(this.binder, this.field, this.subbinder);
    }

    private void bind(MDDBinder binder, FieldInterfaced field, final MDDBinder subbinder) {
        HasValue hv = new HasValue(){

            public void setValue(Object o) {
                try {
                    JPAPOJOFieldBuilder.this.cb.setValue((Object)(o != null ? new ClassOption(o.getClass()) : null));
                    subbinder.setBean(o);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            public Object getValue() {
                return subbinder.getBean();
            }

            public Registration addValueChangeListener(HasValue.ValueChangeListener valueChangeListener) {
                return null;
            }

            public void setRequiredIndicatorVisible(boolean b) {
            }

            public boolean isRequiredIndicatorVisible() {
                return false;
            }

            public void setReadOnly(boolean b) {
            }

            public boolean isReadOnly() {
                return false;
            }
        };
        JPAPOJOFieldBuilder.completeBinding(hv, binder, field);
    }

    public Object convert(String s) {
        return s;
    }

    public void addValidators(List<Validator> validators) {
    }
}

