/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.vaadin.components.fieldBuilders;

import com.google.common.base.Strings;
import com.vaadin.data.Binder;
import com.vaadin.data.Converter;
import com.vaadin.data.HasValue;
import com.vaadin.data.Result;
import com.vaadin.data.Validator;
import com.vaadin.data.ValueContext;
import com.vaadin.data.validator.BeanValidator;
import com.vaadin.ui.TextField;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.mdd.vaadin.components.fieldBuilders.JPAStringFieldBuilder;
import io.mateu.mdd.vaadin.data.MDDBinder;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;

public class JPATimeFieldBuilder
extends JPAStringFieldBuilder {
    @Override
    public boolean isSupported(FieldInterfaced field) {
        return LocalTime.class.equals((Object)field.getType());
    }

    @Override
    protected void bind(MDDBinder binder, TextField tf, FieldInterfaced field, boolean forSearchFilter) {
        Binder.BindingBuilder aux = binder.forField((HasValue)tf).withConverter((Converter)new Converter<String, LocalTime>(){

            public Result<LocalTime> convertToModel(String s, ValueContext valueContext) {
                LocalTime localTime = null;
                if (!Strings.isNullOrEmpty((String)s)) {
                    try {
                        try {
                            localTime = LocalTime.parse(s, DateTimeFormatter.ofPattern("HHmm"));
                        }
                        catch (Exception e) {
                            localTime = LocalTime.parse(s, DateTimeFormatter.ofPattern("HH:mm"));
                        }
                    }
                    catch (Exception e) {
                        return Result.error((String)"Invalid format. Must be HHmm or HH:mm");
                    }
                }
                return Result.ok(localTime);
            }

            public String convertToPresentation(LocalTime localTime, ValueContext valueContext) {
                return localTime != null ? localTime.format(DateTimeFormatter.ofPattern("HH:mm")) : "";
            }
        });
        if (!forSearchFilter && field.getDeclaringClass() != null) {
            aux.withValidator((Validator)new BeanValidator(field.getDeclaringClass(), field.getName()));
        }
        JPATimeFieldBuilder.completeBinding(aux, binder, field);
    }
}

