/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.vaadin.components.fieldBuilders.components;

import com.google.common.collect.Lists;
import com.vaadin.data.HasValue;
import com.vaadin.shared.Registration;
import com.vaadin.ui.CheckBoxGroup;
import com.vaadin.ui.Component;
import com.vaadin.ui.Composite;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.mdd.vaadin.data.MDDBinder;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class WeekDaysComponent
extends Composite
implements HasValue<boolean[]>,
Component.Focusable {
    private final MDDBinder binder;
    private final CheckBoxGroup<String> g;
    private boolean[] array;
    private Map<UUID, HasValue.ValueChangeListener> listeners = new HashMap<UUID, HasValue.ValueChangeListener>();
    public static final List<String> days = Lists.newArrayList((Object[])new String[]{"Mo", "Tu", "We", "Th", "Fr", "Sa", "Su"});

    public WeekDaysComponent(FieldInterfaced field, MDDBinder binder) {
        this.binder = binder;
        this.g = new CheckBoxGroup("", days);
        this.g.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            if (e.isUserOriginated()) {
                if (this.array == null) {
                    this.array = new boolean[]{false, false, false, false, false, false, false};
                }
                for (int i = 0; i < this.array.length; ++i) {
                    this.array[i] = ((Set)e.getValue()).contains(days.get(i));
                }
                HasValue.ValueChangeEvent ce = new HasValue.ValueChangeEvent((Component)this, (Object)this, e.isUserOriginated());
                this.listeners.values().forEach(l -> l.valueChange(ce));
            }
        });
        this.setCompositionRoot((Component)this.g);
    }

    public void setValue(boolean[] o) {
        this.array = o;
        if (this.array == null) {
            this.array = new boolean[]{false, false, false, false, false, false, false};
        }
        if (this.array != null) {
            HashSet<String> values = new HashSet<String>();
            for (int i = 0; i < this.array.length; ++i) {
                if (!this.array[i]) continue;
                values.add(days.get(i));
            }
            this.g.setValue(values);
        }
    }

    public boolean[] getValue() {
        return this.array;
    }

    public void setRequiredIndicatorVisible(boolean b) {
        this.g.setRequiredIndicatorVisible(b);
    }

    public boolean isRequiredIndicatorVisible() {
        return this.g.isRequiredIndicatorVisible();
    }

    public void setReadOnly(boolean b) {
        this.g.setReadOnly(b);
    }

    public boolean isReadOnly() {
        return this.g.isReadOnly();
    }

    public Registration addValueChangeListener(HasValue.ValueChangeListener<boolean[]> valueChangeListener) {
        final UUID _id = UUID.randomUUID();
        this.listeners.put(_id, valueChangeListener);
        return new Registration(){
            UUID id;
            {
                this.id = _id;
            }

            public void remove() {
                WeekDaysComponent.this.listeners.remove(this.id);
            }
        };
    }

    public void focus() {
        this.g.focus();
    }

    public int getTabIndex() {
        return this.g.getTabIndex();
    }

    public void setTabIndex(int i) {
        this.g.setTabIndex(i);
    }
}

