/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.vaadin.components.views;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.vaadin.data.provider.QuerySortOrder;
import com.vaadin.icons.VaadinIcons;
import com.vaadin.ui.Grid;
import io.mateu.mdd.core.app.AbstractAction;
import io.mateu.mdd.core.app.MDDRunnableAction;
import io.mateu.mdd.core.ui.MDDUIAccessor;
import io.mateu.mdd.shared.annotations.Action;
import io.mateu.mdd.shared.annotations.FieldsFilter;
import io.mateu.mdd.shared.annotations.NotWhenCreating;
import io.mateu.mdd.shared.annotations.NotWhenEditing;
import io.mateu.mdd.shared.annotations.UseLinkToListView;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.mdd.vaadin.MateuUI;
import io.mateu.mdd.vaadin.components.ClassOption;
import io.mateu.mdd.vaadin.components.views.IEditorViewComponent;
import io.mateu.mdd.vaadin.components.views.JPAListViewComponent;
import io.mateu.mdd.vaadin.components.views.ViewComponentHelper;
import io.mateu.mdd.vaadin.util.VaadinHelper;
import io.mateu.reflection.ReflectionHelper;
import io.mateu.util.notification.Notifier;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.ManyToOne;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPACollectionFieldListViewComponent
extends JPAListViewComponent {
    private static final Logger log = LoggerFactory.getLogger(JPACollectionFieldListViewComponent.class);
    private final FieldInterfaced field;
    private final IEditorViewComponent evfc;
    private Collection list;
    private Object model;

    @Override
    public VaadinIcons getIcon() {
        return VaadinIcons.LIST_SELECT;
    }

    @Override
    public String getFieldsFilter() {
        return JPACollectionFieldListViewComponent.getColumns(this.field);
    }

    public JPACollectionFieldListViewComponent(Class entityClass, FieldInterfaced field, IEditorViewComponent evfc) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        super(entityClass, JPACollectionFieldListViewComponent.getColumns(field));
        this.field = field;
        this.evfc = evfc;
        this.model = evfc.getModel();
        this.list = (Collection)ReflectionHelper.getValue((FieldInterfaced)field, (Object)this.model);
    }

    private static String getColumns(FieldInterfaced field) {
        String fields = "";
        if (field.getAnnotation(UseLinkToListView.class) != null) {
            fields = ((UseLinkToListView)field.getAnnotation(UseLinkToListView.class)).fields();
        }
        if (Strings.isNullOrEmpty((String)fields) && field.isAnnotationPresent(FieldsFilter.class)) {
            fields = ((FieldsFilter)field.getAnnotation(FieldsFilter.class)).value();
        }
        return fields;
    }

    @Override
    public String getTitle() {
        return "" + (this.model != null ? this.model.toString() : "--") + ": " + super.getTitle();
    }

    public FieldInterfaced getField() {
        return this.field;
    }

    public IEditorViewComponent getEvfc() {
        return this.evfc;
    }

    @Override
    public boolean isAddEnabled() {
        return false;
    }

    @Override
    public boolean isDeleteEnabled() {
        return false;
    }

    public boolean canAdd() {
        return ReflectionHelper.isOwnedCollection((FieldInterfaced)this.field) && (!this.field.isAnnotationPresent(UseLinkToListView.class) || ((UseLinkToListView)this.field.getAnnotation(UseLinkToListView.class)).addEnabled());
    }

    public boolean canDelete() {
        return ReflectionHelper.isOwnedCollection((FieldInterfaced)this.field) && (!this.field.isAnnotationPresent(UseLinkToListView.class) || ((UseLinkToListView)this.field.getAnnotation(UseLinkToListView.class)).deleteEnabled());
    }

    @Override
    public List<AbstractAction> getActions() {
        String filter;
        List<AbstractAction> l = super.getActions();
        if (this.canAdd()) {
            l.add((AbstractAction)new MDDRunnableAction("Add"){

                public void run() {
                    Set subClasses = ReflectionHelper.getSubclasses((Class)JPACollectionFieldListViewComponent.this.getModelType());
                    if (subClasses.size() > 1) {
                        LinkedHashSet subClassesOptions = new LinkedHashSet();
                        subClasses.forEach(c -> subClassesOptions.add(new ClassOption((Class)c)));
                        VaadinHelper.choose("Please choose type", subClassesOptions, c -> {
                            try {
                                MateuUI.get().setPendingResult(ReflectionHelper.newInstance((Class)((ClassOption)c).get_class(), (Object)JPACollectionFieldListViewComponent.this.model));
                                MDDUIAccessor.go((String)"add");
                            }
                            catch (Exception e) {
                                Notifier.alert((Throwable)e);
                            }
                        }, () -> MDDUIAccessor.goBack());
                    } else if (subClasses.size() == 1) {
                        try {
                            MateuUI.get().setPendingResult(ReflectionHelper.newInstance((Class)((Class)subClasses.iterator().next()), (Object)JPACollectionFieldListViewComponent.this.model));
                            MDDUIAccessor.go((String)"add");
                        }
                        catch (Exception e) {
                            Notifier.alert((Throwable)e);
                        }
                    } else {
                        MDDUIAccessor.go((String)"add");
                    }
                }
            });
        }
        if (this.canDelete()) {
            l.add((AbstractAction)new MDDRunnableAction("Remove selected items"){

                public void run() {
                    if (JPACollectionFieldListViewComponent.this.resultsComponent.getSelection().size() == 0) {
                        Notifier.alert((String)"No item selected");
                    } else {
                        VaadinHelper.confirm("Are you sure?", new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    Set borrar = JPACollectionFieldListViewComponent.this.resultsComponent.getSelection();
                                    Collection col = (Collection)ReflectionHelper.getValue((FieldInterfaced)JPACollectionFieldListViewComponent.this.field, (Object)JPACollectionFieldListViewComponent.this.model);
                                    col.removeAll(borrar);
                                    ReflectionHelper.setValue((FieldInterfaced)JPACollectionFieldListViewComponent.this.field, (Object)JPACollectionFieldListViewComponent.this.model, (Object)col);
                                    JPACollectionFieldListViewComponent.this.evfc.getBinder().setBean(JPACollectionFieldListViewComponent.this.evfc.getModel(), false);
                                    JPACollectionFieldListViewComponent.this.evfc.save(false);
                                    MDDUIAccessor.goBack();
                                }
                                catch (Throwable e) {
                                    Notifier.alert((Throwable)e);
                                }
                            }
                        });
                    }
                }
            });
        }
        Object bean = this.evfc != null ? this.evfc.getModel() : null;
        boolean isEditingNewRecord = MateuUI.get().isEditingNewRecord();
        ArrayList<Method> ms = new ArrayList<Method>();
        for (Method m2 : ReflectionHelper.getAllMethods((Class)(bean != null ? bean.getClass() : this.field.getDeclaringClass()))) {
            if (Modifier.isStatic(m2.getModifiers()) || m2.isAnnotationPresent(NotWhenCreating.class) && isEditingNewRecord || m2.isAnnotationPresent(NotWhenEditing.class) && !isEditingNewRecord || !m2.isAnnotationPresent(Action.class) || !this.field.getName().equals(m2.getAnnotation(Action.class).attachToField())) continue;
            ms.add(m2);
        }
        ms.sort((a, b) -> a.getAnnotation(Action.class).order() - b.getAnnotation(Action.class).order());
        ms.forEach(m -> {
            AbstractAction a = ViewComponentHelper.createAction(m, this);
            l.add(a);
        });
        String string = filter = this.field.isAnnotationPresent(UseLinkToListView.class) ? ((UseLinkToListView)this.field.getAnnotation(UseLinkToListView.class)).actions() : "";
        if (!Strings.isNullOrEmpty((String)filter)) {
            ArrayList filteredActionIds = Lists.newArrayList((Object[])filter.split(","));
            l.removeIf(a -> !filteredActionIds.contains(a.getId()));
        }
        return l;
    }

    @Override
    public Collection findAll(Object filters, List<QuerySortOrder> sortOrders, int offset, int limit) {
        return this.list;
    }

    @Override
    public int count(Object filters) throws Throwable {
        return this.list.size();
    }

    @Override
    public void edit(Object id) {
        MDDUIAccessor.go((String)("" + id));
    }

    public Object addNew() throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        Object o = this.getModelType().newInstance();
        return o;
    }

    public Object getItem(String sid) {
        Object id = this.deserializeId(sid);
        Object f = null;
        for (Object o : this.list) {
            if (!id.equals(this.toId(o))) continue;
            f = o;
            break;
        }
        return f;
    }

    public void saved(Object o) throws Throwable {
        Object bean = this.evfc.getModel();
        ReflectionHelper.setValue((FieldInterfaced)this.field, (Object)bean, (Object)ReflectionHelper.getValue((FieldInterfaced)this.field, (Object)bean));
        this.evfc.getBinder().setBean(bean, false);
        this.list = (Collection)ReflectionHelper.getValue((FieldInterfaced)this.field, (Object)this.model);
        this.search((Object)this);
    }

    @Override
    public void decorateGrid(Grid grid) {
        String fields = "";
        if (this.field.getAnnotation(UseLinkToListView.class) != null) {
            fields = ((UseLinkToListView)this.field.getAnnotation(UseLinkToListView.class)).fields();
        }
        if (Strings.isNullOrEmpty((String)fields) && this.field.isAnnotationPresent(FieldsFilter.class)) {
            fields = ((FieldsFilter)this.field.getAnnotation(FieldsFilter.class)).value();
        }
        if (!Strings.isNullOrEmpty((String)fields)) {
            ArrayList fns = Lists.newArrayList((Object[])fields.replaceAll(" ", "").split(","));
            for (Grid.Column col : grid.getColumns()) {
                if (col.getId() == null || fns.contains(col.getId()) || this.getFieldsByColId().get(col.getId()) != null && fns.contains(this.getFieldsByColId().get(col.getId()).getName())) continue;
                col.setHidden(true);
            }
        } else {
            super.decorateGrid(grid);
        }
    }

    public void preSave(Object model) throws Throwable {
        log.debug("******PRESAVE******");
        Object parent = this.evfc.getModel();
        log.debug("******MODEL=" + model);
        log.debug("******PARENT=" + parent);
        Collection col = (Collection)ReflectionHelper.getValue((FieldInterfaced)this.field, (Object)parent);
        log.debug("******RESULT=" + col.size());
        ReflectionHelper.addToCollection((FieldInterfaced)this.field, (Object)parent, (Object)model);
        this.evfc.getBinder().setBean(parent, false);
        col = (Collection)ReflectionHelper.getValue((FieldInterfaced)this.field, (Object)parent);
        log.debug("******RESULT=" + col.size());
        Class<?> targetType = model.getClass();
        List parentFields = ReflectionHelper.getAllFields(parent.getClass());
        for (FieldInterfaced f : ReflectionHelper.getAllEditableFields(targetType)) {
            for (FieldInterfaced pf : parentFields) {
                if (!pf.isAnnotationPresent(ManyToOne.class) || !f.isAnnotationPresent(ManyToOne.class) || !pf.getType().equals(f.getType()) || !pf.getName().equals(f.getName())) continue;
                ReflectionHelper.setValue((FieldInterfaced)f, (Object)model, (Object)ReflectionHelper.getValue((FieldInterfaced)pf, (Object)parent));
            }
        }
    }

    @Override
    public Method getMethod(String methodName) {
        Method a = super.getMethod(methodName);
        if (a == null) {
            Object bean = this.evfc != null ? this.evfc.getModel() : null;
            for (Method m : ReflectionHelper.getAllMethods((Class)(bean != null ? bean.getClass() : this.field.getDeclaringClass()))) {
                if (Modifier.isStatic(m.getModifiers()) || !m.getName().equals(methodName) || !m.isAnnotationPresent(Action.class) || !this.field.getName().equals(m.getAnnotation(Action.class).attachToField())) continue;
                a = m;
                break;
            }
        }
        return a;
    }
}

