/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.vaadin.components.views;

import com.vaadin.data.ValueProvider;
import com.vaadin.data.provider.CallbackDataProvider;
import com.vaadin.data.provider.DataProvider;
import com.vaadin.data.provider.GridSortOrder;
import com.vaadin.data.provider.Query;
import com.vaadin.event.SortEvent;
import com.vaadin.event.selection.SelectionEvent;
import com.vaadin.event.selection.SelectionListener;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Component;
import com.vaadin.ui.Grid;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.components.grid.ItemClickListener;
import io.mateu.mdd.core.interfaces.ReadOnly;
import io.mateu.mdd.core.ui.MDDUIAccessor;
import io.mateu.mdd.shared.interfaces.RpcView;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.mdd.vaadin.components.views.EditorViewComponent;
import io.mateu.mdd.vaadin.components.views.JPACollectionFieldListViewComponent;
import io.mateu.mdd.vaadin.components.views.ListViewComponent;
import io.mateu.mdd.vaadin.components.views.RpcListViewComponent;
import io.mateu.reflection.ReflectionHelper;
import io.mateu.util.notification.Notifier;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultsComponent
extends VerticalLayout {
    private static final Logger log = LoggerFactory.getLogger(ResultsComponent.class);
    private final ListViewComponent listViewComponent;
    private final Component matchesComponent;
    private Grid grid;
    private Object filters;
    private CallbackDataProvider<Object, Object> dataProvider;
    private int lastClickedRowIndex = -1;
    private Query<Object, Object> lastQuery;
    private Label labelSelection;
    private Collection found;
    private Map<String, Object> lastSignature;

    public int getLastClickedRowIndex() {
        return this.lastClickedRowIndex;
    }

    public void setLastClickedRowIndex(int lastClickedRowIndex) {
        this.lastClickedRowIndex = lastClickedRowIndex;
    }

    private void setLastQuery(Query<Object, Object> query) {
        this.lastQuery = query;
    }

    public Query<Object, Object> getLastQuery() {
        return this.lastQuery;
    }

    public Object getNext() {
        Optional<Object> o;
        if (this.listViewComponent instanceof JPACollectionFieldListViewComponent) {
            o = this.listViewComponent.findAll(null, null, 0, 0).stream().skip(this.getLastClickedRowIndex() + 1).findFirst();
        } else {
            Query q = new Query(this.getLastClickedRowIndex() + 1, 1, this.getLastQuery() != null ? this.getLastQuery().getSortOrders() : null, this.getLastQuery() != null ? this.getLastQuery().getInMemorySorting() : null, this.getLastQuery() != null ? this.getLastQuery().getFilter() : null);
            o = this.grid.getDataProvider().fetch(q).findFirst();
        }
        if (o.isPresent()) {
            this.setLastClickedRowIndex(this.getLastClickedRowIndex() + 1);
            return o.get();
        }
        Notifier.info((String)"This is the last item of the list");
        return null;
    }

    public Object getPrevious() {
        Optional<Object> o = Optional.empty();
        if (this.getLastClickedRowIndex() > 0) {
            if (this.listViewComponent instanceof JPACollectionFieldListViewComponent) {
                o = this.listViewComponent.findAll(null, null, 0, 0).stream().skip(this.getLastClickedRowIndex() - 1).findFirst();
            } else {
                Query q = new Query(this.getLastClickedRowIndex() - 1, 1, this.getLastQuery().getSortOrders(), this.getLastQuery().getInMemorySorting(), (Object)this.getLastQuery().getFilter());
                o = this.grid.getDataProvider().fetch(q).findFirst();
            }
        }
        if (o.isPresent()) {
            this.setLastClickedRowIndex(this.getLastClickedRowIndex() - 1);
            return o.get();
        }
        Notifier.info((String)"This is already the first item of the list");
        return null;
    }

    public CallbackDataProvider<Object, Object> getDataProvider() {
        return this.dataProvider;
    }

    public ResultsComponent(ListViewComponent listViewComponent, Component matchesComponent) {
        this.listViewComponent = listViewComponent;
        this.matchesComponent = matchesComponent;
        this.build();
    }

    private void build() {
        this.addStyleName("resultscomponent");
        if (!MDDUIAccessor.isMobile()) {
            this.setSizeFull();
        }
        this.grid = new Grid();
        this.grid.addStyleName("gridresultado");
        this.listViewComponent.buildColumns(this.grid);
        this.grid.addColumn((ValueProvider & Serializable)d -> null).setWidthUndefined().setCaption("");
        this.grid.addSortListener((SortEvent.SortListener)new SortEvent.SortListener<GridSortOrder<Object>>(){

            public void sort(SortEvent<GridSortOrder<Object>> sortEvent) {
                log.debug("sort listener received " + sortEvent);
            }
        });
        this.listViewComponent.decorateGridMain(this.grid);
        this.grid.setSizeFull();
        if (this.listViewComponent.getFrozenColumnCount() > 0) {
            this.grid.setFrozenColumnCount(this.listViewComponent.getFrozenColumnCount());
        }
        this.dataProvider = DataProvider.fromFilteringCallbacks((CallbackDataProvider.FetchCallback & Serializable)query -> {
            try {
                this.setLastQuery((Query<Object, Object>)query);
                this.found = this.listViewComponent.findAll(this.listViewComponent.getModelForSearchFilters(), query.getSortOrders(), query.getOffset(), query.getLimit());
                return this.found.stream();
            }
            catch (Throwable e) {
                Notifier.alert((Throwable)e);
                return null;
            }
        }, (CallbackDataProvider.CountCallback & Serializable)query -> {
            try {
                return this.listViewComponent.count(this.listViewComponent.getModelForSearchFilters());
            }
            catch (Throwable e) {
                Notifier.alert((Throwable)e);
                return 0;
            }
        });
        this.grid.setDataProvider(this.dataProvider);
        this.grid.setColumnReorderingAllowed(true);
        this.grid.setSelectionMode(Grid.SelectionMode.MULTI);
        this.grid.addSelectionListener(new SelectionListener(){

            public void selectionChange(SelectionEvent selectionEvent) {
                ResultsComponent.this.select(ResultsComponent.this.listViewComponent.toId(selectionEvent.getFirstSelectedItem()));
            }
        });
        if (this.esEditable(this.listViewComponent)) {
            this.grid.addItemClickListener((ItemClickListener)new ItemClickListener<Object>(){

                public void itemClick(Grid.ItemClick<Object> itemClick) {
                    if (itemClick.getColumn() != null) {
                        ResultsComponent.this.setLastClickedRowIndex(itemClick.getRowIndex());
                        Object i = itemClick.getItem();
                        if (i != null) {
                            ResultsComponent.this.edit(ResultsComponent.this.listViewComponent.toId(i));
                        }
                    }
                }
            });
        } else {
            this.grid.addStyleName("readonly");
        }
        this.labelSelection = new Label("No items selected");
        HorizontalLayout hl = new HorizontalLayout();
        hl.addStyleName("nopadding");
        hl.addStyleName("listsummaryline");
        if (this.matchesComponent != null) {
            hl.addComponent(this.matchesComponent);
        }
        hl.addComponent((Component)this.labelSelection);
        hl.setDefaultComponentAlignment(Alignment.TOP_LEFT);
        this.addComponent((Component)hl);
        this.addComponentsAndExpand(new Component[]{this.grid});
    }

    private boolean esEditable(ListViewComponent listViewComponent) {
        if (!(listViewComponent instanceof RpcListViewComponent)) {
            return true;
        }
        RpcListViewComponent rpc = (RpcListViewComponent)listViewComponent;
        RpcView v = rpc.getRpcListView();
        boolean ro = v instanceof ReadOnly && ((ReadOnly)v).isReadOnly();
        return !ro && v.isEditHandled();
    }

    private void edit(Object id) {
        try {
            this.listViewComponent.edit(id);
        }
        catch (Throwable throwable) {
            Notifier.alert((Throwable)throwable);
        }
    }

    private void select(Object id) {
        try {
            this.listViewComponent.select(id);
            this.refreshSelectionLabel();
        }
        catch (Throwable throwable) {
            Notifier.alert((Throwable)throwable);
        }
    }

    private void refreshSelectionLabel() {
        String s = "No items selected";
        Set sel = this.getSelection();
        if (sel.size() > 0) {
            s = sel.size() + " items selected";
            LinkedHashMap<Integer, Number> sums = new LinkedHashMap<Integer, Number>();
            LinkedHashMap<Integer, String> labels = new LinkedHashMap<Integer, String>();
            for (Object i : sel) {
                if (i == null) continue;
                if (i instanceof Object[]) {
                    Object[] a = (Object[])i;
                    for (int j = 0; j < a.length; ++j) {
                        if (a[j] != null && a[j] instanceof Double) {
                            sums.put(j, sums.getOrDefault(j, 0.0) + (Double)a[j]);
                            if (labels.containsKey(j)) continue;
                            labels.put(j, j > 1 && this.grid.getColumns().size() > j - 1 ? ((Grid.Column)this.grid.getColumns().get(j - 1)).getCaption() : "" + j);
                            continue;
                        }
                        if (a[j] == null || !(a[j] instanceof Integer)) continue;
                        sums.put(j, sums.getOrDefault(j, 0) + (Integer)a[j]);
                        if (labels.containsKey(j)) continue;
                        labels.put(j, j > 1 && this.grid.getColumns().size() > j - 1 ? ((Grid.Column)this.grid.getColumns().get(j - 1)).getCaption() : "" + j);
                    }
                    continue;
                }
                List<FieldInterfaced> fields = this.listViewComponent.getColumnFields();
                try {
                    for (int j = 0; j < fields.size(); ++j) {
                        FieldInterfaced f = fields.get(j);
                        if (Double.class.equals((Object)f.getType()) || Double.TYPE.equals(f.getType())) {
                            sums.put(j, sums.getOrDefault(j, 0.0) + (Double)ReflectionHelper.getValue((FieldInterfaced)f, i));
                            if (labels.containsKey(j)) continue;
                            labels.put(j, ReflectionHelper.getCaption((FieldInterfaced)f));
                            continue;
                        }
                        if (!Integer.class.equals((Object)f.getType()) && !Integer.TYPE.equals(f.getType())) continue;
                        sums.put(j, sums.getOrDefault(j, 0) + (Integer)ReflectionHelper.getValue((FieldInterfaced)f, i));
                        if (labels.containsKey(j)) continue;
                        labels.put(j, ReflectionHelper.getCaption((FieldInterfaced)f));
                    }
                }
                catch (Exception e) {
                    Notifier.alert((Throwable)e);
                }
            }
            DecimalFormat df = new DecimalFormat("##,###,###,###,###,###.00");
            Iterator iterator = sums.keySet().iterator();
            while (iterator.hasNext()) {
                int j = (Integer)iterator.next();
                Object v = sums.get(j);
                if (v instanceof Double) {
                    v = df.format(v);
                }
                s = s + ", \u03a3 " + (String)labels.get(j) + " = " + v;
            }
        }
        this.labelSelection.setValue(s);
    }

    public void search(Object filters) throws Throwable {
        boolean updateUrl = this.listViewComponent.getView().getWindowContainer() == null && EditorViewComponent.isModificado(this.lastSignature, EditorViewComponent.buildSignature(filters));
        this.lastSignature = EditorViewComponent.buildSignature(filters);
        this.filters = filters;
        this.grid.deselectAll();
        this.grid.getDataProvider().refreshAll();
        if (updateUrl) {
            this.listViewComponent.searched();
        }
    }

    public Set getSelection() {
        return this.grid.getSelectedItems();
    }

    public void refresh() throws Throwable {
        this.search(this.listViewComponent.getModelForSearchFilters());
    }

    public Grid getGrid() {
        return this.grid;
    }

    public Object getRow(String step) {
        if (this.found != null) {
            return this.found.stream().filter(o -> step.equals(o.toString())).findAny().orElse(null);
        }
        return null;
    }
}

