/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.vaadin.controllers.thirdLevel;

import com.vaadin.data.Binder;
import com.vaadin.ui.Component;
import io.mateu.mdd.core.interfaces.EntityProvider;
import io.mateu.mdd.core.ui.MDDUIAccessor;
import io.mateu.mdd.shared.annotations.UseLinkToListView;
import io.mateu.mdd.shared.interfaces.RpcView;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.mdd.vaadin.components.MDDViewComponentCreator;
import io.mateu.mdd.vaadin.components.app.views.secondLevel.FieldEditorComponent;
import io.mateu.mdd.vaadin.components.app.views.secondLevel.FiltersViewFlowComponent;
import io.mateu.mdd.vaadin.components.views.EditorListener;
import io.mateu.mdd.vaadin.components.views.EditorViewComponent;
import io.mateu.mdd.vaadin.components.views.JPACollectionFieldListViewComponent;
import io.mateu.mdd.vaadin.components.views.JPACollectionFieldViewComponent;
import io.mateu.mdd.vaadin.components.views.JPAListViewComponent;
import io.mateu.mdd.vaadin.components.views.ListViewComponent;
import io.mateu.mdd.vaadin.components.views.ListViewComponentListener;
import io.mateu.mdd.vaadin.components.views.OwnedCollectionComponent;
import io.mateu.mdd.vaadin.components.views.RpcListViewComponent;
import io.mateu.mdd.vaadin.controllers.Controller;
import io.mateu.mdd.vaadin.controllers.secondLevel.EditorController;
import io.mateu.mdd.vaadin.controllers.secondLevel.ListViewComponentController;
import io.mateu.mdd.vaadin.controllers.thirdLevel.MethodController;
import io.mateu.mdd.vaadin.data.MDDBinder;
import io.mateu.mdd.vaadin.navigation.ViewStack;
import io.mateu.reflection.ReflectionHelper;
import io.mateu.util.notification.Notifier;
import io.mateu.util.persistence.JPAHelper;
import java.lang.reflect.Method;
import java.util.Optional;
import javax.persistence.CascadeType;
import javax.persistence.Convert;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;

public class FieldController
extends Controller {
    private final FieldInterfaced field;
    private final EditorViewComponent editorViewComponent;
    private ListViewComponent listViewComponent;

    public FieldController(ViewStack stack, String path, FieldInterfaced field, final EditorViewComponent editorViewComponent) {
        this.field = field;
        this.editorViewComponent = editorViewComponent;
        try {
            boolean ownedCollection = ReflectionHelper.isOwnedCollection((FieldInterfaced)field);
            if (field.isAnnotationPresent(UseLinkToListView.class)) {
                UseLinkToListView aa = (UseLinkToListView)field.getAnnotation(UseLinkToListView.class);
                ListViewComponent lvc = null;
                ListViewComponent vc = null;
                if (!Void.class.equals((Object)aa.listViewClass())) {
                    lvc = new RpcListViewComponent(aa.listViewClass());
                    vc = lvc;
                } else if (field.isAnnotationPresent(ManyToOne.class)) {
                    lvc = new JPAListViewComponent(field.getType());
                    vc = lvc;
                } else {
                    lvc = new JPACollectionFieldListViewComponent(field.getGenericClass(), field, editorViewComponent);
                    vc = lvc;
                }
                if (field.isAnnotationPresent(ManyToOne.class)) {
                    final FieldInterfaced finalField = field;
                    lvc.addListener(new ListViewComponentListener(){

                        @Override
                        public void onEdit(Object id) {
                        }

                        @Override
                        public void onSelect(Object id) {
                            Optional o = (Optional)id;
                            if (o.isPresent()) {
                                try {
                                    JPAHelper.notransact(em -> {
                                        Object m = editorViewComponent.getModel();
                                        Object oid = o.get();
                                        Object e = null;
                                        e = oid instanceof Object[] ? em.find(finalField.getType(), ((Object[])oid)[0]) : (oid instanceof EntityProvider ? ((EntityProvider)oid).toEntity(em) : em.find(finalField.getType(), oid));
                                        ReflectionHelper.setValue((FieldInterfaced)finalField, (Object)m, (Object)e);
                                        editorViewComponent.updateModel(m);
                                        MDDUIAccessor.goBack();
                                    });
                                }
                                catch (Throwable throwable) {
                                    Notifier.alert((Throwable)throwable);
                                }
                            }
                        }
                    });
                }
                this.register(stack, path, (Component)vc);
            } else if (ownedCollection) {
                this.register(stack, path, (Component)new OwnedCollectionComponent(editorViewComponent.getBinder(), field, field.isAnnotationPresent(UseLinkToListView.class) ? -1 : 0));
            } else if (field.isAnnotationPresent(OneToMany.class) || field.isAnnotationPresent(ManyToMany.class)) {
                Object lvc = null;
                JPACollectionFieldViewComponent vc = null;
                if (field.isAnnotationPresent(UseLinkToListView.class)) {
                    editorViewComponent.save(false);
                }
                vc = new JPACollectionFieldViewComponent(field.getGenericClass(), field, editorViewComponent, false);
                this.register(stack, path, (Component)vc);
            } else {
                MDDBinder binder = editorViewComponent.getBinder();
                if (editorViewComponent.getCreatorWindow() != null) {
                    binder = editorViewComponent.getCreatorWindow().getBinder();
                }
                this.register(stack, path, this.procesarFieldEditor(binder, field, path));
            }
        }
        catch (Throwable e) {
            Notifier.alert((Throwable)e);
        }
    }

    private Component procesarFieldEditor(final MDDBinder parentBinder, final FieldInterfaced field, String step) throws Throwable {
        EditorViewComponent evc;
        if (step.endsWith("_search")) {
            this.listViewComponent = MDDViewComponentCreator.createSearcherComponent(parentBinder, field);
            return this.listViewComponent;
        }
        if (ReflectionHelper.isBasico((Class)field.getType())) {
            return new FieldEditorComponent(parentBinder, field);
        }
        Object o = ReflectionHelper.getValue((FieldInterfaced)field, (Object)parentBinder.getBean());
        boolean add = o == null;
        EditorViewComponent editorViewComponent = evc = add ? new EditorViewComponent(field.getType()) : new EditorViewComponent(o);
        if (add) {
            evc.load(null);
        }
        if (field.isAnnotationPresent(ManyToOne.class) && ((ManyToOne)field.getAnnotation(ManyToOne.class)).cascade() != null) {
            for (CascadeType c : ((ManyToOne)field.getAnnotation(ManyToOne.class)).cascade()) {
                if (!CascadeType.ALL.equals((Object)c) && !CascadeType.MERGE.equals((Object)c)) continue;
                evc.setCreateSaveButton(false);
                break;
            }
        }
        evc.addEditorListener(new EditorListener(){

            @Override
            public void preSave(Object model) throws Throwable {
            }

            @Override
            public void onSave(Object model) {
                try {
                    Object m = parentBinder.getBean();
                    ReflectionHelper.setValue((FieldInterfaced)field, (Object)m, (Object)model);
                    parentBinder.getBinding(field.getName()).ifPresent(b -> {
                        ((Binder.Binding)b).getField().setValue(null);
                        ((Binder.Binding)b).getField().setValue(model);
                    });
                    parentBinder.setBean(m, false);
                }
                catch (Exception e) {
                    Notifier.alert((Throwable)e);
                }
            }

            @Override
            public void onGoBack(Object model) {
                if (field.isAnnotationPresent(Embedded.class) || field.getDeclaringClass().isAnnotationPresent(Entity.class) && field.isAnnotationPresent(Convert.class)) {
                    Object m = parentBinder.getBean();
                    try {
                        ReflectionHelper.setValue((FieldInterfaced)field, (Object)m, (Object)model);
                        parentBinder.setBean(m, false);
                    }
                    catch (Exception e) {
                        Notifier.alert((Throwable)e);
                    }
                }
            }
        });
        return evc;
    }

    @Override
    public void apply(ViewStack stack, String path, String step, String cleanStep, String remaining) throws Throwable {
        if (!"".equals(cleanStep) && this.listViewComponent != null) {
            if ("filters".equals(step)) {
                this.register(stack, path + "/" + step, (Component)new FiltersViewFlowComponent(this.listViewComponent));
            } else if ("new".equals(step)) {
                EditorViewComponent editor = new EditorViewComponent(this.listViewComponent, this.listViewComponent.getModelType());
                editor.load(null);
                new EditorController(stack, path + "/" + step, editor).next(stack, path, step, remaining);
            } else {
                Method method = this.listViewComponent.getMethod(step);
                if (method != null) {
                    new MethodController(stack, path + "/" + step, method).next(stack, path, step, remaining);
                } else if (this.listViewComponent instanceof JPAListViewComponent) {
                    Class type = this.listViewComponent.getModelType();
                    new EditorController(stack, path + "/" + step, this.listViewComponent, JPAHelper.find((Class)type, (Object)ReflectionHelper.toId((Class)type, (String)step))).next(stack, path, step, remaining);
                } else {
                    Object o = ((RpcListViewComponent)this.listViewComponent).onEdit(step);
                    if (o instanceof RpcView) {
                        new ListViewComponentController(stack, path + "/" + step, new RpcListViewComponent((RpcView)o)).next(stack, path, step, remaining);
                    } else if (!(o instanceof Component)) {
                        new EditorController(stack, path + "/" + step, o).next(stack, path, step, remaining);
                    }
                }
            }
        }
    }
}

