/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.vaadin.components;

import com.vaadin.ui.Component;
import io.mateu.mdd.core.app.MDDOpenCRUDAction;
import io.mateu.mdd.core.app.MDDOpenEditorAction;
import io.mateu.mdd.core.interfaces.RpcCrudView;
import io.mateu.mdd.core.interfaces.WizardPage;
import io.mateu.mdd.core.views.ExtraFilters;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.mdd.vaadin.MateuUI;
import io.mateu.mdd.vaadin.components.views.EditorViewComponent;
import io.mateu.mdd.vaadin.components.views.JPAListViewComponent;
import io.mateu.mdd.vaadin.components.views.ListViewComponent;
import io.mateu.mdd.vaadin.components.views.RpcListViewComponent;
import io.mateu.mdd.vaadin.components.views.WizardComponent;
import io.mateu.mdd.vaadin.data.MDDBinder;
import io.mateu.reflection.ReflectionHelper;
import io.mateu.util.notification.Notifier;
import java.util.Map;
import java.util.function.Consumer;
import javax.persistence.Entity;

public class MDDViewComponentCreator {
    public static Component createComponent(MDDOpenEditorAction action) {
        return MDDViewComponentCreator.createComponent(action.getViewClass(), action.getBeanId());
    }

    public static Component createComponent(Class viewClass, Object id) {
        EditorViewComponent v = null;
        Class modelType = null;
        try {
            modelType = viewClass;
            v = MDDViewComponentCreator.createEditorViewComponent(modelType);
            v.load(id);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return v;
    }

    public static Component createComponent(Object bean) {
        Object v = null;
        if (bean != null) {
            if (bean instanceof Component) {
                v = (Component)bean;
            } else {
                Class<?> modelType = null;
                try {
                    modelType = bean.getClass();
                    v = MDDViewComponentCreator.createEditorViewComponent(modelType);
                    if (MateuUI.get() != null) {
                        MateuUI.get().setCurrentEditor((EditorViewComponent)v);
                    }
                    if (modelType.isAnnotationPresent(Entity.class)) {
                        ((EditorViewComponent)v).load(ReflectionHelper.getId((Object)bean));
                    } else {
                        ((EditorViewComponent)v).setModel(bean);
                    }
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
        return v;
    }

    public static Component createComponent(Class viewClass) {
        RpcListViewComponent v = null;
        try {
            v = RpcCrudView.class.isAssignableFrom(viewClass) ? new RpcListViewComponent(viewClass) : new RpcListViewComponent(viewClass);
        }
        catch (Exception e) {
            Notifier.alert((Throwable)e);
        }
        return v;
    }

    public static ListViewComponent createSearcherComponent(MDDBinder parentBinder, FieldInterfaced field) {
        ListViewComponent v = null;
        Class modelType = null;
        try {
            modelType = field.getType();
            v = MDDViewComponentCreator.createListViewComponent(modelType, null, null, null, null, null, null, o -> {
                try {
                    Object bean = parentBinder.getBean();
                    ReflectionHelper.setValue((FieldInterfaced)field, (Object)bean, (Object)o);
                    parentBinder.update(bean);
                }
                catch (Exception e) {
                    Notifier.alert((Throwable)e);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return v;
    }

    public static Component createComponent(MDDOpenCRUDAction action) {
        ListViewComponent v = null;
        Class modelType = null;
        try {
            modelType = action.getEntityClass();
            v = MDDViewComponentCreator.createListViewComponent(modelType, action.getQueryFilters(), action.getExtraFilters(), action.getDefaultValues(), action.getColumns(), action.getFilters(), action.getFields());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return v;
    }

    public static EditorViewComponent createEditorViewComponent(Class modelType) throws Exception {
        return MDDViewComponentCreator.createEditorViewComponent(modelType, true);
    }

    public static EditorViewComponent createEditorViewComponent(Class modelType, boolean createSaveBUtton) throws Exception {
        EditorViewComponent v = new EditorViewComponent(modelType, createSaveBUtton);
        return v;
    }

    public static EditorViewComponent createEditorViewComponent(Object owner, FieldInterfaced field, Class modelType, boolean createSaveBUtton) throws Exception {
        EditorViewComponent v = new EditorViewComponent(owner, field, modelType, createSaveBUtton);
        return v;
    }

    private static ListViewComponent createListViewComponent(Class modelType, String queryFilters, ExtraFilters extraFilters, Map<String, Object> defaultValues) throws Exception {
        return MDDViewComponentCreator.createListViewComponent(modelType, queryFilters, extraFilters, defaultValues, null, null, null);
    }

    private static ListViewComponent createListViewComponent(Class modelType, String queryFilters, ExtraFilters extraFilters, Map<String, Object> defaultValues, String columns, String filters, String fields) throws Exception {
        return MDDViewComponentCreator.createListViewComponent(modelType, queryFilters, extraFilters, defaultValues, columns, filters, fields, null);
    }

    private static ListViewComponent createListViewComponent(Class modelType, String queryFilters, ExtraFilters extraFilters, Map<String, Object> defaultValues, String columns, String filters, String fields, Consumer<Object> callback) throws Exception {
        JPAListViewComponent v = null;
        if (modelType.isAnnotationPresent(Entity.class)) {
            v = new JPAListViewComponent(modelType, queryFilters, extraFilters, defaultValues, columns, filters, fields, callback);
        }
        return v;
    }

    public static Component createComponent(WizardPage page) {
        return new WizardComponent(page);
    }
}

