/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.vaadin.components.app.main;

import com.google.common.base.Strings;
import com.vaadin.event.FocusShortcut;
import com.vaadin.event.LayoutEvents;
import com.vaadin.event.MouseEvents;
import com.vaadin.event.ShortcutListener;
import com.vaadin.icons.VaadinIcons;
import com.vaadin.server.ClassResource;
import com.vaadin.server.ExternalResource;
import com.vaadin.server.Page;
import com.vaadin.server.Resource;
import com.vaadin.server.ThemeResource;
import com.vaadin.shared.ui.ContentMode;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Image;
import com.vaadin.ui.Label;
import com.vaadin.ui.MenuBar;
import com.vaadin.ui.UI;
import com.vaadin.ui.Window;
import io.mateu.mdd.core.app.AbstractAction;
import io.mateu.mdd.core.app.AbstractApplication;
import io.mateu.mdd.core.app.AbstractArea;
import io.mateu.mdd.core.app.AbstractMenu;
import io.mateu.mdd.core.ui.MDDUIAccessor;
import io.mateu.mdd.shared.interfaces.App;
import io.mateu.mdd.shared.interfaces.IArea;
import io.mateu.mdd.shared.interfaces.IModule;
import io.mateu.mdd.shared.interfaces.MenuEntry;
import io.mateu.mdd.vaadin.components.app.main.MainComponent;
import io.mateu.mdd.vaadin.components.app.main.MenuSearcher;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class HeaderComponent
extends HorizontalLayout {
    private final MainComponent home;
    private AbstractArea area;
    private Label labelPosition;
    private HorizontalLayout positionLayout;
    private boolean isPrivate;
    private CssLayout barContainer;
    private MenuSearcher menuSearcher;

    public HeaderComponent(MainComponent home) {
        this.home = home;
        this.setWidthFull();
        this.addStyleName("mateu-header");
        this.refresh(false);
    }

    public void refresh(boolean isPrivate) {
        Button b;
        this.removeAllComponents();
        this.isPrivate = isPrivate;
        App app = MDDUIAccessor.getApp();
        String logo = app.getLogo();
        ThemeResource resource = new ThemeResource("img/logomateu2.png");
        if (!Strings.isNullOrEmpty((String)logo)) {
            if (logo.contains(":")) {
                resource = new ExternalResource(logo);
            } else {
                if (!logo.startsWith("/")) {
                    logo = "/" + logo;
                }
                if (!logo.startsWith("/VAADIN")) {
                    logo = "/VAADIN" + logo;
                }
                resource = new ClassResource(logo);
            }
        }
        Image i = new Image(null, (Resource)resource);
        this.addComponent((Component)i);
        i.setHeight("37px");
        i.addClickListener((MouseEvents.ClickListener & Serializable)e -> MDDUIAccessor.goTo((String)""));
        i.addStyleName("clickable");
        Component[] componentArray = new Component[1];
        this.labelPosition = new Label(app.getName());
        componentArray[0] = this.labelPosition;
        this.positionLayout = new HorizontalLayout(componentArray);
        this.addComponent((Component)this.positionLayout);
        this.labelPosition.addStyleName("appname");
        this.labelPosition.addStyleName("clickable");
        this.positionLayout.addStyleName("nopadding");
        this.positionLayout.setSpacing(false);
        if (app.getAreas().length <= 1) {
            this.positionLayout.addLayoutClickListener((LayoutEvents.LayoutClickListener & Serializable)e -> MDDUIAccessor.goTo((String)""));
        } else {
            this.positionLayout.addLayoutClickListener((LayoutEvents.LayoutClickListener & Serializable)e -> this.chooseArea());
        }
        this.barContainer = new CssLayout();
        this.addComponent((Component)this.barContainer);
        this.barContainer.addStyleName("nopadding");
        String basePath = UI.getCurrent().getUiRootPath();
        if (!basePath.endsWith("/")) {
            basePath = basePath + "/";
        }
        this.menuSearcher = new MenuSearcher((AbstractApplication)app);
        this.addComponent((Component)this.menuSearcher);
        String finalBasePath = basePath;
        if (isPrivate) {
            b = new Button("Logout", (Button.ClickListener & Serializable)e -> Page.getCurrent().setLocation(finalBasePath + "private/logout"));
            this.addComponent((Component)b);
            b.addStyleName("quiet");
        } else if (app.hasPrivateContent()) {
            if (app.hasRegistrationForm()) {
                b = new Button("Registrarse", (Button.ClickListener & Serializable)e -> Page.getCurrent().setLocation(finalBasePath + "private/register"));
                this.addComponent((Component)b);
                b.addStyleName("quiet");
            }
            b = new Button("Login", (Button.ClickListener & Serializable)e -> Page.getCurrent().setLocation(finalBasePath + "private"));
            this.addComponent((Component)b);
            b.addStyleName("quiet");
        } else {
            this.addComponent((Component)new Label(" "));
        }
        this.setExpandRatio((Component)this.barContainer, 1.0f);
        List areas = Arrays.asList(app.getAreas()).stream().filter(a -> !isPrivate && a.isPublicAccess() || isPrivate && !a.isPublicAccess()).collect(Collectors.toList());
        if (areas.size() > 0) {
            this.setArea((AbstractArea)areas.get(0));
        }
    }

    private void chooseArea() {
        Window w = new Window("Please select a work area");
        w.addStyleName("mateu");
        w.setWidth("80%");
        w.setHeight("80%");
        CssLayout lx = new CssLayout();
        lx.addStyleName("maincomponent");
        lx.addStyleName("selectarea");
        App app = MDDUIAccessor.getApp();
        List areas = Arrays.asList(app.getAreas()).stream().filter(a -> !this.isPrivate && a.isPublicAccess() || this.isPrivate && !a.isPublicAccess()).collect(Collectors.toList());
        for (IArea a2 : areas) {
            Button b = new Button(a2.getName());
            lx.addComponent((Component)b);
            if (!VaadinIcons.ADOBE_FLASH.equals((Object)a2.getIcon())) {
                b.setIcon((Resource)a2.getIcon());
            }
            b.addClickListener((Button.ClickListener & Serializable)e -> {
                w.close();
                this.home.irA(app.getState((Object)a2));
            });
            b.setPrimaryStyleName("huge");
            b.addStyleName("submenuoption");
        }
        w.setContent((Component)lx);
        w.center();
        w.setModal(true);
        UI.getCurrent().addWindow(w);
    }

    public void refreshMenuBar() {
        App app = MDDUIAccessor.getApp();
        this.barContainer.removeAllComponents();
        MenuBar menubar = new MenuBar();
        menubar.addStyleName("borderless");
        List<IArea> areas = Arrays.asList(app.getAreas()).stream().filter(a -> !this.isPrivate && a.isPublicAccess() || this.isPrivate && !a.isPublicAccess()).collect(Collectors.toList());
        if (this.area == null && areas.size() > 0) {
            this.area = (AbstractArea)areas.get(0);
        }
        if (this.area != null) {
            for (IModule module : this.area.getModules()) {
                this.addMenu(app, menubar, module);
            }
        } else {
            areas.forEach(area -> this.addMenu(app, menubar, (IArea)area));
        }
        menubar.addShortcutListener((ShortcutListener)new FocusShortcut((Component.Focusable)menubar, 112));
        this.barContainer.addComponent((Component)menubar);
    }

    private void addMenu(App app, MenuBar menubar, IModule module) {
        for (MenuEntry entry : module.getMenu()) {
            if (entry instanceof AbstractMenu) {
                MenuBar.MenuItem submenu = menubar.addItem(entry.getCaption(), null);
                this.addSubmenu(app, submenu, (AbstractMenu)entry);
                continue;
            }
            if (!(entry instanceof AbstractAction)) continue;
            menubar.addItem(entry.getCaption(), (MenuBar.Command & Serializable)item -> this.home.irA(app.getState((Object)entry)));
        }
    }

    private void addMenu(App app, MenuBar menubar, IArea area) {
        MenuBar.MenuItem menu = menubar.addItem(area.getName(), null);
        for (IModule module : area.getModules()) {
            this.addMenu(app, menu, module);
        }
    }

    private void addMenu(App app, MenuBar.MenuItem menu, IModule module) {
        for (MenuEntry entry : module.getMenu()) {
            if (entry instanceof AbstractMenu) {
                MenuBar.MenuItem submenu = menu.addItem(entry.getCaption(), null);
                this.addSubmenu(app, submenu, (AbstractMenu)entry);
                continue;
            }
            if (!(entry instanceof AbstractAction)) continue;
            menu.addItem(entry.getCaption(), (MenuBar.Command & Serializable)item -> this.home.irA(app.getState((Object)entry)));
        }
    }

    private void addSubmenu(App app, MenuBar.MenuItem menu, AbstractMenu entries) {
        for (MenuEntry entry : entries.getEntries()) {
            if (entry instanceof AbstractMenu) {
                MenuBar.MenuItem submenu = menu.addItem(entry.getCaption(), null);
                this.addSubmenu(app, submenu, (AbstractMenu)entry);
                continue;
            }
            if (!(entry instanceof AbstractAction)) continue;
            menu.addItem(entry.getCaption(), (MenuBar.Command & Serializable)item -> this.home.irA(app.getState((Object)entry)));
        }
    }

    public void setArea(AbstractArea area) {
        this.area = area;
        if (!Strings.isNullOrEmpty((String)area.getName())) {
            this.labelPosition.setValue(area.getName());
            this.positionLayout.removeAllComponents();
            Label l = new Label(VaadinIcons.GRID_SMALL.getHtml(), ContentMode.HTML);
            this.positionLayout.addComponent((Component)l);
            l.addStyleName("iconoarea");
            l.addStyleName("clickable");
            this.positionLayout.addComponent((Component)this.labelPosition);
        }
        this.refreshMenuBar();
    }

    public void updateSession() {
        this.menuSearcher.updateDataProvider((AbstractApplication)MDDUIAccessor.getApp());
    }
}

