/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.vaadin.components.app.main;

import com.google.common.base.Strings;
import com.vaadin.event.LayoutEvents;
import com.vaadin.icons.VaadinIcons;
import com.vaadin.server.Page;
import com.vaadin.server.Resource;
import com.vaadin.shared.ui.ContentMode;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import io.mateu.mdd.core.app.AbstractAction;
import io.mateu.mdd.core.app.AbstractArea;
import io.mateu.mdd.core.app.AbstractMenu;
import io.mateu.mdd.core.ui.MDDUIAccessor;
import io.mateu.mdd.shared.annotations.FullWidth;
import io.mateu.mdd.shared.interfaces.App;
import io.mateu.mdd.shared.interfaces.IArea;
import io.mateu.mdd.shared.interfaces.IModule;
import io.mateu.mdd.shared.interfaces.MenuEntry;
import io.mateu.mdd.vaadin.MateuUI;
import io.mateu.mdd.vaadin.components.app.main.MainComponent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class HeaderForMobileComponent
extends HorizontalLayout {
    private final MainComponent home;
    private AbstractArea area;
    private Label labelPosition;
    private HorizontalLayout positionLayout;
    private boolean isPrivate;
    private VerticalLayout barContainer;
    private Window ventanaMenu;

    public HeaderForMobileComponent(MainComponent home) {
        this.home = home;
        this.setWidthFull();
        this.addStyleName("mateu-header-mobile");
        App app = MDDUIAccessor.getApp();
        if (!app.getClass().isAnnotationPresent(FullWidth.class)) {
            this.addStyleName("container");
        }
        this.refresh(false);
    }

    public void refresh(boolean isPrivate) {
        Button b;
        this.removeAllComponents();
        this.isPrivate = isPrivate;
        App app = MDDUIAccessor.getApp();
        HorizontalLayout i = new HorizontalLayout();
        Label l = new Label(VaadinIcons.MENU.getHtml(), ContentMode.HTML);
        i.addComponent((Component)l);
        l.addStyleName("iconomenu");
        l.addStyleName("clickable");
        this.addComponent((Component)i);
        i.setHeight("37px");
        i.addLayoutClickListener((LayoutEvents.LayoutClickListener & Serializable)e -> this.openMenu());
        i.addStyleName("clickable");
        Component[] componentArray = new Component[1];
        this.labelPosition = new Label(app.getName());
        componentArray[0] = this.labelPosition;
        this.positionLayout = new HorizontalLayout(componentArray);
        this.addComponent((Component)this.positionLayout);
        this.labelPosition.addStyleName("appname");
        this.labelPosition.addStyleName("clickable");
        this.positionLayout.addStyleName("nopadding");
        this.positionLayout.addStyleName("centro");
        this.positionLayout.setSpacing(false);
        if (app.getAreas().length <= 1) {
            this.positionLayout.addLayoutClickListener((LayoutEvents.LayoutClickListener & Serializable)e -> MDDUIAccessor.goTo((String)""));
        } else {
            this.positionLayout.addLayoutClickListener((LayoutEvents.LayoutClickListener & Serializable)e -> this.chooseArea());
        }
        this.barContainer = new VerticalLayout();
        String basePath = UI.getCurrent().getUiRootPath();
        if (!basePath.endsWith("/")) {
            basePath = basePath + "/";
        }
        String finalBasePath = basePath;
        if (isPrivate) {
            b = new Button("Logout", (Button.ClickListener & Serializable)e -> Page.getCurrent().setLocation(finalBasePath + "private/logout"));
            this.addComponent((Component)b);
            b.addStyleName("quiet");
        } else if (app.hasPrivateContent()) {
            if (app.hasRegistrationForm()) {
                b = new Button("Registrarse", (Button.ClickListener & Serializable)e -> Page.getCurrent().setLocation(finalBasePath + "private/register"));
                this.addComponent((Component)b);
                b.addStyleName("quiet");
            }
            b = new Button("Login", (Button.ClickListener & Serializable)e -> Page.getCurrent().setLocation(finalBasePath + "private"));
            this.addComponent((Component)b);
            b.addStyleName("quiet");
        }
        this.setExpandRatio((Component)this.positionLayout, 1.0f);
        List areas = Arrays.asList(app.getAreas()).stream().filter(a -> !isPrivate && a.isPublicAccess() || isPrivate && !a.isPublicAccess()).collect(Collectors.toList());
        if (areas.size() > 0) {
            this.setArea((AbstractArea)areas.get(0));
        }
    }

    private void openMenu() {
        Window w = new Window("Please select a work area");
        w.addStyleName("mateu");
        w.addStyleName("menulateral");
        w.setWidth("300px");
        w.setHeight("100%");
        CssLayout lx = new CssLayout();
        lx.addStyleName("maincomponent");
        lx.addStyleName("selectarea");
        lx.addComponent((Component)this.barContainer);
        w.setContent((Component)lx);
        w.center();
        UI.getCurrent().addWindow(w);
        VerticalLayout fondo = new VerticalLayout();
        fondo.addStyleName("fondomenu");
        MateuUI.get().getMain().addComponent((Component)fondo);
        fondo.addLayoutClickListener((LayoutEvents.LayoutClickListener & Serializable)e -> w.close());
        w.addCloseListener((Window.CloseListener & Serializable)e -> {
            MateuUI.get().getMain().removeComponent((Component)fondo);
            this.ventanaMenu = null;
        });
        this.ventanaMenu = w;
    }

    private void chooseArea() {
        Window w = new Window("Please select a work area");
        w.addStyleName("mateu");
        w.setWidth("80%");
        w.setHeight("80%");
        CssLayout lx = new CssLayout();
        lx.addStyleName("maincomponent");
        lx.addStyleName("selectarea");
        App app = MDDUIAccessor.getApp();
        List areas = Arrays.asList(app.getAreas()).stream().filter(a -> !this.isPrivate && a.isPublicAccess() || this.isPrivate && !a.isPublicAccess()).collect(Collectors.toList());
        for (IArea a2 : areas) {
            Button b = new Button(a2.getName());
            lx.addComponent((Component)b);
            if (!VaadinIcons.ADOBE_FLASH.equals((Object)a2.getIcon())) {
                b.setIcon((Resource)a2.getIcon());
            }
            b.addClickListener((Button.ClickListener & Serializable)e -> {
                w.close();
                this.home.irA(app.getState((Object)a2));
            });
            b.setPrimaryStyleName("huge");
            b.addStyleName("submenuoption");
        }
        w.setContent((Component)lx);
        w.center();
        w.setModal(true);
        UI.getCurrent().addWindow(w);
    }

    public void refreshMenuBar() {
        App app = MDDUIAccessor.getApp();
        this.barContainer.removeAllComponents();
        List areas = Arrays.asList(app.getAreas()).stream().filter(a -> !this.isPrivate && a.isPublicAccess() || this.isPrivate && !a.isPublicAccess()).collect(Collectors.toList());
        if (this.area == null && areas.size() > 0) {
            this.area = (AbstractArea)areas.get(0);
        }
        if (this.area != null) {
            for (IModule module : this.area.getModules()) {
                this.addMenu(app, this.barContainer, module);
            }
        }
    }

    private void addMenu(App app, VerticalLayout menubar, IModule module) {
        for (MenuEntry entry : module.getMenu()) {
            Button b;
            if (entry instanceof AbstractMenu) {
                b = new Button(entry.getCaption(), (Button.ClickListener & Serializable)e -> this.addSubmenu(app, menubar, (AbstractMenu)entry));
                menubar.addComponent((Component)b);
                b.addStyleName("botonmenu");
                b.addStyleName("quiet");
                if (VaadinIcons.ADOBE_FLASH.equals((Object)entry.getIcon())) continue;
                b.setIcon((Resource)entry.getIcon());
                continue;
            }
            if (!(entry instanceof AbstractAction)) continue;
            b = new Button(entry.getCaption(), (Button.ClickListener & Serializable)e -> {
                this.cerrarMenu();
                this.home.irA(app.getState((Object)entry));
            });
            menubar.addComponent((Component)b);
            b.addStyleName("botonmenu");
            b.addStyleName("quiet");
            if (VaadinIcons.ADOBE_FLASH.equals((Object)entry.getIcon())) continue;
            b.setIcon((Resource)entry.getIcon());
        }
    }

    private void cerrarMenu() {
        if (this.ventanaMenu != null) {
            this.ventanaMenu.close();
        }
    }

    private void addSubmenu(App app, VerticalLayout menubar, AbstractMenu entries) {
        ArrayList<Component> old = new ArrayList<Component>();
        for (int i = 0; i < menubar.getComponentCount(); ++i) {
            old.add(menubar.getComponent(i));
        }
        menubar.removeAllComponents();
        Button b = new Button("Back", (Button.ClickListener & Serializable)e -> {
            menubar.removeAllComponents();
            old.forEach(c -> menubar.addComponentsAndExpand(new Component[]{c}));
        });
        menubar.addComponent((Component)b);
        b.addStyleName("botonmenu");
        b.addStyleName("quiet");
        b.setIcon((Resource)VaadinIcons.CHEVRON_LEFT);
        for (MenuEntry entry : entries.getEntries()) {
            Button b2;
            if (entry instanceof AbstractMenu) {
                b2 = new Button(entry.getCaption(), (Button.ClickListener & Serializable)e -> this.addSubmenu(app, menubar, (AbstractMenu)entry));
                menubar.addComponent((Component)b2);
                b2.addStyleName("botonmenu");
                b2.addStyleName("quiet");
                if (VaadinIcons.ADOBE_FLASH.equals((Object)entry.getIcon())) continue;
                b2.setIcon((Resource)entry.getIcon());
                continue;
            }
            if (!(entry instanceof AbstractAction)) continue;
            b2 = new Button(entry.getCaption(), (Button.ClickListener & Serializable)e -> {
                this.cerrarMenu();
                this.home.irA(app.getState((Object)entry));
            });
            menubar.addComponent((Component)b2);
            b2.addStyleName("botonmenu");
            b2.addStyleName("quiet");
            if (VaadinIcons.ADOBE_FLASH.equals((Object)entry.getIcon())) continue;
            b2.setIcon((Resource)entry.getIcon());
        }
    }

    public void setArea(AbstractArea area) {
        this.area = area;
        if (!Strings.isNullOrEmpty((String)area.getName())) {
            this.labelPosition.setValue(area.getName());
            this.positionLayout.removeAllComponents();
            Label l = new Label(VaadinIcons.GRID_SMALL.getHtml(), ContentMode.HTML);
            this.positionLayout.addComponent((Component)l);
            l.addStyleName("iconoarea");
            l.addStyleName("clickable");
            this.positionLayout.addComponent((Component)this.labelPosition);
        }
        this.refreshMenuBar();
    }
}

