/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.vaadin.components.app.views.firstLevel;

import com.google.common.base.Strings;
import com.vaadin.icons.VaadinIcons;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import com.vaadin.ui.VerticalLayout;
import io.mateu.mdd.core.app.AbstractAction;
import io.mateu.mdd.core.app.AbstractMenu;
import io.mateu.mdd.core.ui.MDDUIAccessor;
import io.mateu.mdd.shared.interfaces.App;
import io.mateu.mdd.shared.interfaces.MenuEntry;
import io.mateu.mdd.vaadin.components.views.AbstractViewComponent;
import java.io.Serializable;

public class MenuComponent
extends AbstractViewComponent {
    private final AbstractMenu menu;

    @Override
    public VaadinIcons getIcon() {
        return VaadinIcons.MENU;
    }

    public String toString() {
        return this.menu.getCaption();
    }

    public MenuComponent(AbstractMenu menu) {
        this.menu = menu;
    }

    public Component createMenuComponent(MenuEntry e) {
        VerticalLayout l = new VerticalLayout();
        l.setSizeUndefined();
        l.addStyleName("submenupanel");
        this.fill(l, e, 0);
        return l;
    }

    private void fill(VerticalLayout l, MenuEntry e, int nivel) {
        if (e instanceof AbstractMenu) {
            AbstractMenu m = (AbstractMenu)e;
            VerticalLayout q = new VerticalLayout();
            q.setSizeUndefined();
            q.addStyleName("submenulayout");
            if (!Strings.isNullOrEmpty((String)m.getCaption())) {
                Label t = new Label(m.getCaption());
                q.addComponent((Component)t);
                if (nivel == 0) {
                    t.addStyleName("h2");
                } else if (nivel == 1) {
                    t.addStyleName("h3");
                } else {
                    t.addStyleName("h4");
                }
            }
            m.getEntries().forEach(s -> this.fill(q, (MenuEntry)s, nivel + 1));
            l.addComponent((Component)q);
        } else if (e instanceof AbstractAction) {
            App app = MDDUIAccessor.getApp();
            Button b = new Button(e.getCaption(), (Button.ClickListener & Serializable)ev -> MDDUIAccessor.goTo((String)app.getMenuId(e)));
            l.addComponent((Component)b);
            b.setPrimaryStyleName("link");
            b.addStyleName("submenuoption");
        }
    }
}

