/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.vaadin.components.fieldBuilders;

import com.vaadin.data.HasValue;
import com.vaadin.data.Validator;
import com.vaadin.server.Resource;
import com.vaadin.shared.Registration;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Layout;
import io.mateu.mdd.core.app.AbstractAction;
import io.mateu.mdd.core.interfaces.AbstractStylist;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.mdd.vaadin.components.fieldBuilders.AbstractFieldBuilder;
import io.mateu.mdd.vaadin.components.views.EditorViewComponent;
import io.mateu.mdd.vaadin.data.MDDBinder;
import io.mateu.util.notification.Notifier;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class ButtonFieldBuilder
extends AbstractFieldBuilder {
    @Override
    public boolean isSupported(FieldInterfaced field) {
        return io.mateu.mdd.core.interfaces.Button.class.isAssignableFrom(field.getType());
    }

    @Override
    public Component build(FieldInterfaced field, Object object, Layout container, MDDBinder binder, Map<HasValue, List<Validator>> validators, AbstractStylist stylist, Map<FieldInterfaced, Component> allFieldContainers, boolean forSearchFilter, Map<String, List<AbstractAction>> attachedActions) {
        HorizontalLayout hl = new HorizontalLayout();
        container.addComponent((Component)hl);
        hl.addStyleName("nopadding");
        hl.setCaption("");
        this.bind(binder, hl, field);
        return hl;
    }

    private void bind(final MDDBinder binder, final HorizontalLayout hl, FieldInterfaced field) {
        binder.forField(new HasValue(){
            io.mateu.mdd.core.interfaces.Button v = null;

            public void setValue(Object o) {
                hl.removeAllComponents();
                this.v = (io.mateu.mdd.core.interfaces.Button)o;
                if (this.v != null) {
                    Button b = new Button();
                    hl.addComponent((Component)b);
                    b.setCaption(this.v.getCaption());
                    b.setIcon((Resource)this.v.getIcon());
                    b.setPrimaryStyleName("");
                    b.setStyleName("");
                    b.addStyleName("quiet");
                    b.addStyleName("mddbutton");
                    this.v.getStyles().forEach(s -> b.addStyleName(s));
                    b.addClickListener((Button.ClickListener & Serializable)e -> {
                        try {
                            this.v.getRunnable().run();
                        }
                        catch (Throwable throwable) {
                            Notifier.alert((Throwable)throwable);
                        }
                        if (binder.getViewComponent() instanceof EditorViewComponent) {
                            binder.update(binder.getBean());
                        }
                    });
                }
            }

            public Object getValue() {
                return this.v;
            }

            public Registration addValueChangeListener(HasValue.ValueChangeListener valueChangeListener) {
                return null;
            }

            public void setRequiredIndicatorVisible(boolean b) {
            }

            public boolean isRequiredIndicatorVisible() {
                return false;
            }

            public void setReadOnly(boolean b) {
            }

            public boolean isReadOnly() {
                return false;
            }
        }).bind(field.getName());
    }
}

