/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.vaadin.components.fieldBuilders;

import com.vaadin.data.HasValue;
import com.vaadin.data.ValidationResult;
import com.vaadin.data.Validator;
import com.vaadin.data.ValueContext;
import com.vaadin.server.ErrorMessage;
import com.vaadin.server.UserError;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.Layout;
import com.vaadin.ui.RadioButtonGroup;
import io.mateu.mdd.core.app.AbstractAction;
import io.mateu.mdd.core.interfaces.AbstractStylist;
import io.mateu.mdd.shared.annotations.UseRadioButtons;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.mdd.vaadin.components.fieldBuilders.AbstractFieldBuilder;
import io.mateu.mdd.vaadin.data.MDDBinder;
import io.mateu.reflection.ReflectionHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;

public class FromDataProviderFieldBuilder
extends AbstractFieldBuilder {
    @Override
    public boolean isSupported(FieldInterfaced field) {
        return field.getDataProvider() != null;
    }

    @Override
    public Component build(FieldInterfaced field, Object object, Layout container, MDDBinder binder, final Map<HasValue, List<Validator>> validators, AbstractStylist stylist, Map<FieldInterfaced, Component> allFieldContainers, boolean forSearchFilter, Map<String, List<AbstractAction>> attachedActions) {
        RadioButtonGroup r = null;
        if (field.isAnnotationPresent(UseRadioButtons.class)) {
            final RadioButtonGroup tf = new RadioButtonGroup();
            container.addComponent((Component)tf);
            if (allFieldContainers != null && allFieldContainers.size() == 0) {
                tf.focus();
            }
            tf.setDataProvider(field.getDataProvider());
            if (allFieldContainers != null) {
                allFieldContainers.put(field, (Component)tf);
            }
            if (container.getComponentCount() > 0) {
                tf.setCaption(ReflectionHelper.getCaption((FieldInterfaced)field));
            }
            validators.put((HasValue)tf, new ArrayList());
            tf.addValueChangeListener((HasValue.ValueChangeListener)new HasValue.ValueChangeListener<String>(){

                public void valueChange(HasValue.ValueChangeEvent<String> valueChangeEvent) {
                    Validator v;
                    ValidationResult result = null;
                    Iterator iterator = ((List)validators.get(tf)).iterator();
                    while (iterator.hasNext() && !(result = (v = (Validator)iterator.next()).apply(valueChangeEvent.getValue(), new ValueContext((Component)tf))).isError()) {
                    }
                    if (result != null && result.isError()) {
                        tf.setComponentError((ErrorMessage)new UserError(result.getErrorMessage()));
                    } else {
                        tf.setComponentError(null);
                    }
                }
            });
            if (!forSearchFilter) {
                tf.setRequiredIndicatorVisible(field.isAnnotationPresent(NotNull.class));
            }
            FromDataProviderFieldBuilder.completeBinding((HasValue)tf, binder, field);
            this.addErrorHandler(field, (AbstractComponent)tf);
            r = tf;
        } else {
            final ComboBox tf = new ComboBox();
            container.addComponent((Component)tf);
            if (allFieldContainers != null && allFieldContainers.size() == 0) {
                tf.focus();
            }
            tf.setDataProvider(field.getDataProvider());
            if (allFieldContainers != null) {
                allFieldContainers.put(field, (Component)tf);
            }
            if (container.getComponentCount() > 0) {
                tf.setCaption(ReflectionHelper.getCaption((FieldInterfaced)field));
            }
            validators.put((HasValue)tf, new ArrayList());
            tf.addValueChangeListener((HasValue.ValueChangeListener)new HasValue.ValueChangeListener<String>(){

                public void valueChange(HasValue.ValueChangeEvent<String> valueChangeEvent) {
                    Validator v;
                    ValidationResult result = null;
                    Iterator iterator = ((List)validators.get(tf)).iterator();
                    while (iterator.hasNext() && !(result = (v = (Validator)iterator.next()).apply(valueChangeEvent.getValue(), new ValueContext((Component)tf))).isError()) {
                    }
                    if (result != null && result.isError()) {
                        tf.setComponentError((ErrorMessage)new UserError(result.getErrorMessage()));
                    } else {
                        tf.setComponentError(null);
                    }
                }
            });
            if (!forSearchFilter) {
                tf.setRequiredIndicatorVisible(field.isAnnotationPresent(NotNull.class));
            }
            FromDataProviderFieldBuilder.completeBinding((HasValue)tf, binder, field);
            this.addErrorHandler(field, (AbstractComponent)tf);
            r = tf;
        }
        return r;
    }
}

