/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.vaadin.components.fieldBuilders;

import com.google.common.base.Strings;
import com.vaadin.data.Binder;
import com.vaadin.data.Converter;
import com.vaadin.data.HasValue;
import com.vaadin.data.Result;
import com.vaadin.data.Validator;
import com.vaadin.data.ValueContext;
import com.vaadin.data.converter.StringToLongConverter;
import com.vaadin.data.validator.BeanValidator;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.Component;
import com.vaadin.ui.Layout;
import com.vaadin.ui.Slider;
import com.vaadin.ui.TextField;
import io.mateu.mdd.core.app.AbstractAction;
import io.mateu.mdd.core.interfaces.AbstractStylist;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.mdd.vaadin.components.fieldBuilders.JPAStringFieldBuilder;
import io.mateu.mdd.vaadin.data.MDDBinder;
import io.mateu.reflection.ReflectionHelper;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

public class JPALongFieldBuilder
extends JPAStringFieldBuilder {
    @Override
    public boolean isSupported(FieldInterfaced field) {
        return Long.class.equals((Object)field.getType()) || Long.TYPE.equals(field.getType());
    }

    @Override
    public Component build(FieldInterfaced field, Object object, Layout container, MDDBinder binder, Map<HasValue, List<Validator>> validators, AbstractStylist stylist, Map<FieldInterfaced, Component> allFieldContainers, boolean forSearchFilter, Map<String, List<AbstractAction>> attachedActions) {
        Component r = null;
        if (field.isAnnotationPresent(Min.class) && field.isAnnotationPresent(Max.class)) {
            Slider tf = new Slider(new Long(((Min)field.getAnnotation(Min.class)).value()).intValue(), new Long(((Max)field.getAnnotation(Max.class)).value()).intValue());
            container.addComponent((Component)tf);
            if (allFieldContainers != null && allFieldContainers.size() == 0) {
                tf.focus();
            }
            if (allFieldContainers != null) {
                allFieldContainers.put(field, (Component)tf);
            }
            if (container.getComponentCount() > 0) {
                tf.setCaption(ReflectionHelper.getCaption((FieldInterfaced)field));
            }
            if (!forSearchFilter) {
                tf.setRequiredIndicatorVisible(field.isAnnotationPresent(NotNull.class) || field.isAnnotationPresent(NotEmpty.class));
            }
            this.bind(binder, tf, field, forSearchFilter);
            this.addErrorHandler(field, (AbstractComponent)tf);
            r = tf;
        } else {
            r = super.build(field, object, container, binder, validators, stylist, allFieldContainers, forSearchFilter, attachedActions);
        }
        return r;
    }

    protected void bind(MDDBinder binder, Slider tf, FieldInterfaced field, boolean forSearchFilter) {
        Binder.BindingBuilder aux = binder.forField((HasValue)tf).withConverter(new Converter(){

            public Result convertToModel(Object o, ValueContext valueContext) {
                return Result.ok(o != null ? Long.valueOf(new Double(o.toString()).longValue()) : null);
            }

            public Object convertToPresentation(Object o, ValueContext valueContext) {
                return o != null ? new Double("" + o) : null;
            }
        });
        if (!forSearchFilter && field.getDeclaringClass() != null) {
            aux.withValidator((Validator)new BeanValidator(field.getDeclaringClass(), field.getName()));
        }
        JPALongFieldBuilder.completeBinding(aux, binder, field);
    }

    @Override
    protected void bind(MDDBinder binder, TextField tf, final FieldInterfaced field, boolean forSearchFilter) {
        Binder.BindingBuilder aux = binder.forField((HasValue)tf).withConverter((Converter)new StringToLongConverter(Long.TYPE.equals(field.getType()) ? Long.valueOf(0L) : null, "Must be a long"){

            public Result<Long> convertToModel(String value, ValueContext context) {
                if (Long.TYPE.equals(field.getType())) {
                    return super.convertToModel(value, context);
                }
                return Result.ok(!Strings.isNullOrEmpty((String)value) ? Long.valueOf(new Double(value.toString()).longValue()) : null);
            }

            public String convertToPresentation(Long value, ValueContext context) {
                if (value == null) {
                    return "";
                }
                return "" + value;
            }
        });
        if (!forSearchFilter && field.getDeclaringClass() != null) {
            aux.withValidator((Validator)new BeanValidator(field.getDeclaringClass(), field.getName()));
        }
        JPALongFieldBuilder.completeBinding(aux, binder, field);
    }
}

