/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.vaadin.components.fieldBuilders;

import com.google.common.base.Strings;
import com.vaadin.data.Binder;
import com.vaadin.data.Converter;
import com.vaadin.data.HasDataProvider;
import com.vaadin.data.HasValue;
import com.vaadin.data.Result;
import com.vaadin.data.Validator;
import com.vaadin.data.ValueContext;
import com.vaadin.data.provider.ListDataProvider;
import com.vaadin.data.provider.Query;
import com.vaadin.data.validator.BeanValidator;
import com.vaadin.server.SerializableFunction;
import com.vaadin.server.SerializablePredicate;
import com.vaadin.server.Sizeable;
import com.vaadin.shared.ui.ValueChangeMode;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.ItemCaptionGenerator;
import com.vaadin.ui.Layout;
import com.vaadin.ui.PasswordField;
import com.vaadin.ui.RadioButtonGroup;
import com.vaadin.ui.TextField;
import io.mateu.mdd.core.app.AbstractAction;
import io.mateu.mdd.core.dataProviders.JPQLListDataProvider;
import io.mateu.mdd.core.interfaces.AbstractStylist;
import io.mateu.mdd.core.ui.MDDUIAccessor;
import io.mateu.mdd.shared.annotations.DataProvider;
import io.mateu.mdd.shared.annotations.FullWidth;
import io.mateu.mdd.shared.annotations.Password;
import io.mateu.mdd.shared.annotations.UseRadioButtons;
import io.mateu.mdd.shared.annotations.ValueClass;
import io.mateu.mdd.shared.annotations.Width;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.mdd.vaadin.components.fieldBuilders.AbstractFieldBuilder;
import io.mateu.mdd.vaadin.data.MDDBinder;
import io.mateu.reflection.ReflectionHelper;
import io.mateu.util.notification.Notifier;
import io.mateu.util.persistence.JPAHelper;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

public class JPAStringFieldBuilder
extends AbstractFieldBuilder {
    @Override
    public boolean isSupported(FieldInterfaced field) {
        return String.class.equals((Object)field.getType());
    }

    @Override
    public Component build(FieldInterfaced field, Object object, Layout container, MDDBinder binder, Map<HasValue, List<Validator>> validators, AbstractStylist stylist, Map<FieldInterfaced, Component> allFieldContainers, boolean forSearchFilter, Map<String, List<AbstractAction>> attachedActions) {
        Method mdp = ReflectionHelper.getMethod((Class)field.getDeclaringClass(), (String)(ReflectionHelper.getGetter((String)field.getName()) + "DataProvider"));
        RadioButtonGroup r = null;
        if (field.isAnnotationPresent(ValueClass.class) || field.isAnnotationPresent(DataProvider.class) || mdp != null) {
            RadioButtonGroup tf = null;
            RadioButtonGroup hv = null;
            if (field.isAnnotationPresent(UseRadioButtons.class)) {
                RadioButtonGroup rbg;
                tf = rbg = new RadioButtonGroup();
                container.addComponent((Component)rbg);
                hv = rbg;
                if (mdp != null) {
                    try {
                        ((HasDataProvider)tf).setDataProvider((com.vaadin.data.provider.DataProvider)mdp.invoke(object, new Object[0]));
                    }
                    catch (Exception e) {
                        Notifier.alert((Throwable)e);
                    }
                } else if (field.isAnnotationPresent(ValueClass.class)) {
                    ValueClass a = (ValueClass)field.getAnnotation(ValueClass.class);
                    ((HasDataProvider)tf).setDataProvider((com.vaadin.data.provider.DataProvider)new JPQLListDataProvider(a.value()));
                } else if (field.isAnnotationPresent(DataProvider.class)) {
                    try {
                        DataProvider a = (DataProvider)field.getAnnotation(DataProvider.class);
                        ((HasDataProvider)tf).setDataProvider((com.vaadin.data.provider.DataProvider)a.dataProvider().newInstance());
                        rbg.setItemCaptionGenerator((ItemCaptionGenerator)a.itemCaptionGenerator().newInstance());
                    }
                    catch (InstantiationException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                } else {
                    try {
                        JPAHelper.notransact(em -> rbg.setDataProvider((com.vaadin.data.provider.DataProvider)new JPQLListDataProvider(em, field)));
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                    FieldInterfaced fName = ReflectionHelper.getNameField((Class)field.getType());
                    if (fName != null) {
                        rbg.setItemCaptionGenerator((ItemCaptionGenerator & Serializable)i -> {
                            try {
                                return "" + ReflectionHelper.getValue((FieldInterfaced)fName, (Object)i);
                            }
                            catch (NoSuchMethodException e) {
                                e.printStackTrace();
                            }
                            catch (IllegalAccessException e) {
                                e.printStackTrace();
                            }
                            catch (InvocationTargetException e) {
                                e.printStackTrace();
                            }
                            return "Error";
                        });
                    }
                }
                if (!forSearchFilter) {
                    rbg.setRequiredIndicatorVisible(field.isAnnotationPresent(NotNull.class) || field.isAnnotationPresent(NotEmpty.class));
                }
                this.addErrorHandler(field, (AbstractComponent)rbg);
            } else {
                final ComboBox cb = new ComboBox();
                tf = cb;
                container.addComponent((Component)cb);
                cb.addStyleName("combo");
                if (allFieldContainers.size() == 0) {
                    cb.focus();
                }
                hv = cb;
                if (mdp != null) {
                    try {
                        cb.setDataProvider((com.vaadin.data.provider.DataProvider)mdp.invoke(object, new Object[0]), (SerializableFunction & Serializable)f -> new SerializablePredicate(){

                            public boolean test(Object o) {
                                String s = (String)f;
                                return o != null && (Strings.isNullOrEmpty((String)s) || cb.getItemCaptionGenerator().apply(o).toLowerCase().contains(s.toLowerCase()));
                            }
                        });
                    }
                    catch (Exception e) {
                        Notifier.alert((Throwable)e);
                    }
                } else if (field.isAnnotationPresent(ValueClass.class)) {
                    ValueClass a = (ValueClass)field.getAnnotation(ValueClass.class);
                    cb.setDataProvider((ListDataProvider)new JPQLListDataProvider(a.value()));
                } else if (field.isAnnotationPresent(DataProvider.class)) {
                    try {
                        DataProvider a = (DataProvider)field.getAnnotation(DataProvider.class);
                        cb.setDataProvider((com.vaadin.data.provider.DataProvider)a.dataProvider().newInstance(), (SerializableFunction & Serializable)f -> new SerializablePredicate(){

                            public boolean test(Object o) {
                                String s = (String)f;
                                return o != null && (Strings.isNullOrEmpty((String)s) || cb.getItemCaptionGenerator().apply(o).toLowerCase().contains(s.toLowerCase()));
                            }
                        });
                        cb.setItemCaptionGenerator((ItemCaptionGenerator)a.itemCaptionGenerator().newInstance());
                    }
                    catch (InstantiationException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                } else {
                    try {
                        JPAHelper.notransact(em -> cb.setDataProvider((com.vaadin.data.provider.DataProvider)new JPQLListDataProvider(em, field), (SerializableFunction & Serializable)f -> new SerializablePredicate(){

                            public boolean test(Object o) {
                                String s = (String)f;
                                return o != null && (Strings.isNullOrEmpty((String)s) || cb.getItemCaptionGenerator().apply(o).toLowerCase().contains(s.toLowerCase()));
                            }
                        }));
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                    FieldInterfaced fName = ReflectionHelper.getNameField((Class)field.getType());
                    if (fName != null) {
                        cb.setItemCaptionGenerator((ItemCaptionGenerator & Serializable)i -> {
                            try {
                                return "" + ReflectionHelper.getValue((FieldInterfaced)fName, (Object)i);
                            }
                            catch (NoSuchMethodException e) {
                                e.printStackTrace();
                            }
                            catch (IllegalAccessException e) {
                                e.printStackTrace();
                            }
                            catch (InvocationTargetException e) {
                                e.printStackTrace();
                            }
                            return "Error";
                        });
                    }
                }
                if (!forSearchFilter) {
                    cb.setRequiredIndicatorVisible(field.isAnnotationPresent(NotNull.class) || field.isAnnotationPresent(NotEmpty.class));
                }
                this.addErrorHandler(field, (AbstractComponent)cb);
            }
            if (allFieldContainers != null) {
                allFieldContainers.put(field, (Component)tf);
            }
            if (container.getComponentCount() > 0) {
                tf.setCaption(ReflectionHelper.getCaption((FieldInterfaced)field));
            }
            this.bind(binder, (HasValue)hv, field, forSearchFilter);
            r = tf;
        } else {
            PasswordField tf = field.isAnnotationPresent(Password.class) ? new PasswordField() : new TextField();
            container.addComponent((Component)tf);
            tf.setValueChangeMode(ValueChangeMode.BLUR);
            if (String.class.equals((Object)field.getType())) {
                if (!forSearchFilter) {
                    if (MDDUIAccessor.isMobile() || field.isAnnotationPresent(FullWidth.class)) {
                        tf.setWidth("100%");
                    } else if (field.isAnnotationPresent(Width.class) && !Strings.isNullOrEmpty((String)((Width)field.getAnnotation(Width.class)).value())) {
                        tf.setWidth(((Width)field.getAnnotation(Width.class)).value());
                    } else {
                        tf.setWidth(370.0f, Sizeable.Unit.PIXELS);
                    }
                } else if (MDDUIAccessor.isMobile() || field.isAnnotationPresent(FullWidth.class)) {
                    tf.setWidth("100%");
                }
            } else {
                tf.setWidth(100.0f, Sizeable.Unit.PIXELS);
                tf.addStyleName("align-right");
            }
            if (allFieldContainers != null && allFieldContainers.size() == 0) {
                tf.focus();
            }
            if (allFieldContainers != null) {
                allFieldContainers.put(field, (Component)tf);
            }
            if (container.getComponentCount() > 0) {
                tf.setCaption(ReflectionHelper.getCaption((FieldInterfaced)field));
            }
            if (!forSearchFilter) {
                tf.setRequiredIndicatorVisible(field.isAnnotationPresent(NotNull.class) || field.isAnnotationPresent(NotEmpty.class));
            }
            this.bind(binder, (TextField)tf, field, forSearchFilter);
            this.addErrorHandler(field, (AbstractComponent)tf);
            r = tf;
        }
        return r;
    }

    protected void bind(MDDBinder binder, TextField tf, FieldInterfaced field, boolean forSearchFilter) {
        Binder.BindingBuilder aux = binder.forField((HasValue)tf);
        if (field.isAnnotationPresent(ValueClass.class)) {
            aux.withConverter(new Converter(){

                public Result convertToModel(Object o, ValueContext valueContext) {
                    return Result.ok((Object)o);
                }

                public Object convertToPresentation(Object o, ValueContext valueContext) {
                    return o != null ? o : "";
                }
            });
        } else {
            aux.withConverter(new Converter(){

                public Result convertToModel(Object o, ValueContext valueContext) {
                    return Result.ok((Object)o);
                }

                public Object convertToPresentation(Object o, ValueContext valueContext) {
                    return o != null ? o : "";
                }
            });
        }
        if (!forSearchFilter && field.getDeclaringClass() != null) {
            aux.withValidator((Validator)new BeanValidator(field.getDeclaringClass(), field.getName()));
        }
        JPAStringFieldBuilder.completeBinding(aux, binder, field);
    }

    protected void bind(MDDBinder binder, final HasValue tf, final FieldInterfaced field, boolean forSearchFilter) {
        Binder.BindingBuilder aux = binder.forField(tf);
        aux.withConverter(new Converter(){

            public Result convertToModel(Object o, ValueContext valueContext) {
                if (o != null && !"".equals(o)) {
                    return Result.ok((Object)(o.getClass().equals(field.getType()) ? o : ReflectionHelper.getId((Object)o)));
                }
                return Result.ok(null);
            }

            public Object convertToPresentation(Object o, ValueContext valueContext) {
                if (o == null) {
                    return "";
                }
                com.vaadin.data.provider.DataProvider dp = null;
                if (tf instanceof HasDataProvider) {
                    dp = ((HasDataProvider)tf).getDataProvider();
                } else if (tf instanceof ComboBox) {
                    dp = ((ComboBox)tf).getDataProvider();
                }
                if (dp != null) {
                    Optional<Object> optional = dp.fetch(new Query()).filter(x -> x.getClass().equals(o.getClass()) ? x.equals(o) : ReflectionHelper.getId((Object)x).equals(o)).findFirst();
                    if (optional.isPresent()) {
                        return optional.get();
                    }
                    return "";
                }
                return o;
            }
        });
        if (!forSearchFilter && field.getDeclaringClass() != null) {
            aux.withValidator((Validator)new BeanValidator(field.getDeclaringClass(), field.getName()));
        }
        JPAStringFieldBuilder.completeBinding(aux, binder, field);
    }
}

