/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.vaadin.components.fieldBuilders;

import com.vaadin.data.HasValue;
import com.vaadin.data.Validator;
import com.vaadin.icons.VaadinIcons;
import com.vaadin.shared.Registration;
import com.vaadin.shared.ui.ContentMode;
import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import com.vaadin.ui.Layout;
import com.vaadin.ui.VerticalLayout;
import io.mateu.mdd.core.app.AbstractAction;
import io.mateu.mdd.core.interfaces.AbstractStylist;
import io.mateu.mdd.shared.annotations.KPI;
import io.mateu.mdd.shared.annotations.KPIInline;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.mdd.vaadin.components.fieldBuilders.AbstractFieldBuilder;
import io.mateu.mdd.vaadin.data.MDDBinder;
import io.mateu.reflection.ReflectionHelper;
import java.util.List;
import java.util.Map;

public class KPIInlineFieldBuilder
extends AbstractFieldBuilder {
    @Override
    public boolean isSupported(FieldInterfaced field) {
        return field.isAnnotationPresent(KPIInline.class);
    }

    @Override
    public Component build(FieldInterfaced field, Object object, Layout container, MDDBinder binder, Map<HasValue, List<Validator>> validators, AbstractStylist stylist, Map<FieldInterfaced, Component> allFieldContainers, boolean forSearchFilter, Map<String, List<AbstractAction>> attachedActions) {
        VerticalLayout vl = new VerticalLayout();
        container.addComponent((Component)vl);
        vl.addStyleName(((KPIInline)field.getAnnotation(KPIInline.class)).style());
        vl.setWidth("100%");
        Label t = new Label(ReflectionHelper.getCaption((FieldInterfaced)field));
        Label l = new Label();
        l.addStyleName("valor");
        l.setContentMode(ContentMode.HTML);
        if ("superkpi".equals(((KPIInline)field.getAnnotation(KPIInline.class)).style())) {
            vl.addComponents(new Component[]{l, t});
        } else {
            vl.addComponents(new Component[]{t, l});
        }
        allFieldContainers.put(field, (Component)vl);
        this.bind(binder, vl, l, field);
        return null;
    }

    protected void bind(MDDBinder binder, VerticalLayout tf, final Label l, final FieldInterfaced field) {
        binder.forField(new HasValue(){
            Object v = null;

            public void setValue(Object o) {
                this.v = o;
                String s = "";
                if (this.v == null) {
                    s = "";
                } else if (this.v instanceof Boolean) {
                    if (((Boolean)this.v).booleanValue() && !((KPI)field.getAnnotation(KPI.class)).reversed()) {
                        s = VaadinIcons.CHECK.getHtml();
                        l.addStyleName("friendly");
                    } else {
                        s = VaadinIcons.CLOSE.getHtml();
                        l.addStyleName("danger");
                    }
                    l.addStyleName("centered");
                } else {
                    s = "" + this.v;
                }
                l.setValue(s);
            }

            public Object getValue() {
                return this.v;
            }

            public Registration addValueChangeListener(HasValue.ValueChangeListener valueChangeListener) {
                return null;
            }

            public void setRequiredIndicatorVisible(boolean b) {
            }

            public boolean isRequiredIndicatorVisible() {
                return false;
            }

            public void setReadOnly(boolean b) {
            }

            public boolean isReadOnly() {
                return false;
            }
        }).bind(field.getName());
    }
}

