/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.vaadin.components.views;

import com.google.common.collect.Lists;
import com.vaadin.data.provider.QuerySortOrder;
import com.vaadin.icons.VaadinIcons;
import com.vaadin.shared.data.sort.SortDirection;
import com.vaadin.ui.Grid;
import io.mateu.mdd.core.MDD;
import io.mateu.mdd.core.app.AbstractAction;
import io.mateu.mdd.core.ui.MDDUIAccessor;
import io.mateu.mdd.shared.annotations.Action;
import io.mateu.mdd.shared.data.ChartData;
import io.mateu.mdd.shared.data.SumData;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.mdd.vaadin.MateuUI;
import io.mateu.mdd.vaadin.components.views.ListViewComponent;
import io.mateu.mdd.vaadin.components.views.ListViewComponentListener;
import io.mateu.mdd.vaadin.components.views.ViewComponentHelper;
import io.mateu.mdd.vaadin.data.MDDBinder;
import io.mateu.reflection.ReflectionHelper;
import io.mateu.util.Helper;
import io.mateu.util.notification.Notifier;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javassist.ClassPool;

public class CollectionListViewComponent
extends ListViewComponent {
    private List collection;
    private final Class columnType;

    @Override
    public VaadinIcons getIcon() {
        return VaadinIcons.LIST_SELECT;
    }

    public CollectionListViewComponent(Collection collection, Class columnType) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        this.collection = Lists.newArrayList((Iterable)collection);
        this.columnType = columnType;
        this.addListener(new ListViewComponentListener(){

            @Override
            public void onEdit(Object id) {
                try {
                    MateuUI.get().setPendingResult(id);
                    MDDUIAccessor.go((String)("" + id));
                }
                catch (Throwable throwable) {
                    Notifier.alert((Throwable)throwable);
                }
            }

            @Override
            public void onSelect(Object id) {
            }
        });
    }

    public String toString() {
        return Helper.pluralize((String)Helper.capitalize((String)this.columnType.getSimpleName()));
    }

    @Override
    public Object getModelForSearchFilters() throws InstantiationException, IllegalAccessException {
        return this.getFiltersType().newInstance();
    }

    @Override
    public void setModelForSearchFilters(Object filters) {
        this.filtersComponent.getBinder().setBean(filters);
    }

    @Override
    public Class getColumnType() {
        return this.columnType;
    }

    @Override
    public Class getFiltersType() {
        try {
            return ReflectionHelper.createClass((ClassPool)MDD.getClassPool(), MDDBinder.class, (ClassLoader)MDD.getClassPool().getClassLoader(), (String)(this.columnType.getName() + "000CollectionFilters"), this.getFilterFields(this.columnType), (boolean)true);
        }
        catch (Exception e) {
            Notifier.alert((Throwable)e);
            return null;
        }
    }

    @Override
    public List<AbstractAction> getActions() {
        ArrayList<AbstractAction> l = new ArrayList<AbstractAction>();
        ArrayList<Method> ms = new ArrayList<Method>();
        for (Method m2 : ReflectionHelper.getAllMethods((Class)this.columnType)) {
            if (!Modifier.isStatic(m2.getModifiers()) || !m2.isAnnotationPresent(Action.class)) continue;
            ms.add(m2);
        }
        ms.sort((a, b) -> a.getAnnotation(Action.class).order() - b.getAnnotation(Action.class).order());
        ms.forEach(m -> l.add(ViewComponentHelper.createAction(m, this)));
        return l;
    }

    @Override
    public List findAll(Object filters, List<QuerySortOrder> sortOrders, int offset, int limit) {
        try {
            return this.collection.stream().filter(o -> this.filtrar(o, filters)).sorted(this.getComparator(sortOrders)).skip(offset).limit(limit).collect(Collectors.toList());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    private boolean filtrar(Object o, Object filters) {
        boolean ok = true;
        if (filters != null) {
            for (FieldInterfaced f : ReflectionHelper.getAllEditableFields(filters.getClass())) {
                FieldInterfaced fo = ReflectionHelper.getFieldByName(o.getClass(), (String)f.getName());
                try {
                    Object o1 = ReflectionHelper.getValue((FieldInterfaced)f, (Object)filters);
                    if (o1 != null) {
                        if (o != null) {
                            Object o2 = ReflectionHelper.getValue((FieldInterfaced)fo, (Object)o);
                            if (o1 instanceof String) {
                                o2.toString().toLowerCase().contains(((String)o1).toLowerCase());
                            } else {
                                ok = o1.equals(o2);
                            }
                        } else {
                            ok = false;
                        }
                    }
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                if (ok) continue;
                break;
            }
        }
        return ok;
    }

    private Comparator getComparator(final List<QuerySortOrder> sortOrders) {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                int r = 0;
                for (QuerySortOrder sortOrder : sortOrders) {
                    FieldInterfaced f = ReflectionHelper.getFieldByName((Class)CollectionListViewComponent.this.getColumnType(), (String)sortOrder.getSorted());
                    if (f != null) {
                        try {
                            Object x1 = ReflectionHelper.getValue((FieldInterfaced)f, (Object)o1);
                            Object x2 = ReflectionHelper.getValue((FieldInterfaced)f, (Object)o2);
                            r = x1 != null && x1 instanceof Comparable ? (x2 != null ? ((Comparable)x1).compareTo(x2) : 1) : -1;
                            if (SortDirection.DESCENDING.equals((Object)sortOrder.getDirection())) {
                                r *= -1;
                            }
                        }
                        catch (NoSuchMethodException e) {
                            e.printStackTrace();
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                        catch (InvocationTargetException e) {
                            e.printStackTrace();
                        }
                    }
                    if (r == 0) continue;
                    break;
                }
                return r;
            }
        };
    }

    @Override
    protected int gatherCount(Object filters) throws Throwable {
        return (int)this.collection.stream().filter(o -> this.filtrar(o, filters)).count();
    }

    @Override
    protected List<SumData> getSums(Object filters) {
        return new ArrayList<SumData>();
    }

    @Override
    protected List<ChartData> getCharts(Object filters) {
        return null;
    }

    @Override
    public Object deserializeId(String sid) {
        Optional<Object> o = this.collection.stream().filter(x -> sid.equals(ReflectionHelper.getId((Object)x).toString())).findFirst();
        return o.isPresent() ? o.get() : null;
    }

    @Override
    public boolean isAddEnabled() {
        return false;
    }

    @Override
    public void decorateGrid(Grid grid) {
    }

    @Override
    public Class getModelType() {
        return this.columnType;
    }
}

