/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.vaadin.components.views;

import com.google.common.base.Strings;
import com.vaadin.data.Binder;
import com.vaadin.data.BinderValidationStatus;
import com.vaadin.data.HasValue;
import com.vaadin.data.Validator;
import com.vaadin.icons.VaadinIcons;
import com.vaadin.server.Resource;
import com.vaadin.shared.Registration;
import com.vaadin.shared.ui.ContentMode;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.AbstractField;
import com.vaadin.ui.Button;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.HasComponents;
import com.vaadin.ui.Label;
import com.vaadin.ui.Layout;
import com.vaadin.ui.MenuBar;
import com.vaadin.ui.Panel;
import com.vaadin.ui.TabSheet;
import com.vaadin.ui.TextField;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import io.mateu.mdd.core.MDD;
import io.mateu.mdd.core.app.AbstractAction;
import io.mateu.mdd.core.app.MDDRunnableAction;
import io.mateu.mdd.core.interfaces.AbstractStylist;
import io.mateu.mdd.core.interfaces.HasHeader;
import io.mateu.mdd.core.interfaces.Header;
import io.mateu.mdd.core.interfaces.PersistentPojo;
import io.mateu.mdd.core.interfaces.ReadOnly;
import io.mateu.mdd.shared.FormLayoutBuilderParameters;
import io.mateu.mdd.shared.annotations.Action;
import io.mateu.mdd.shared.annotations.Balance;
import io.mateu.mdd.shared.annotations.DependsOn;
import io.mateu.mdd.shared.annotations.Indelible;
import io.mateu.mdd.shared.annotations.KPI;
import io.mateu.mdd.shared.annotations.Keep;
import io.mateu.mdd.shared.annotations.ModifyValuesOnly;
import io.mateu.mdd.shared.annotations.Money;
import io.mateu.mdd.shared.annotations.NewNotAllowed;
import io.mateu.mdd.shared.annotations.NonDuplicable;
import io.mateu.mdd.shared.annotations.NotWhenCreating;
import io.mateu.mdd.shared.annotations.NotWhenEditing;
import io.mateu.mdd.shared.annotations.Unmodifiable;
import io.mateu.mdd.shared.interfaces.IResource;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.mdd.shared.ui.MDDUIAccessor;
import io.mateu.mdd.vaadin.MateuUI;
import io.mateu.mdd.vaadin.components.ClassOption;
import io.mateu.mdd.vaadin.components.app.views.secondLevel.FiltersViewFlowComponent;
import io.mateu.mdd.vaadin.components.views.AbstractViewComponent;
import io.mateu.mdd.vaadin.components.views.EditorListener;
import io.mateu.mdd.vaadin.components.views.FormLayoutBuilder;
import io.mateu.mdd.vaadin.components.views.IEditorViewComponent;
import io.mateu.mdd.vaadin.components.views.ListViewComponent;
import io.mateu.mdd.vaadin.components.views.OwnedCollectionComponent;
import io.mateu.mdd.vaadin.components.views.ResourceModel;
import io.mateu.mdd.vaadin.components.views.ViewComponentHelper;
import io.mateu.mdd.vaadin.data.MDDBinder;
import io.mateu.mdd.vaadin.util.BindedWindow;
import io.mateu.mdd.vaadin.util.VaadinHelper;
import io.mateu.reflection.ReflectionHelper;
import io.mateu.reflection.Transferrer;
import io.mateu.util.common.HasChangesSignature;
import io.mateu.util.data.Pair;
import io.mateu.util.interfaces.EditorViewStyler;
import io.mateu.util.notification.Notifier;
import io.mateu.util.persistence.JPAHelper;
import io.mateu.util.persistence.JPATransaction;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.OptimisticLockException;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditorViewComponent
extends AbstractViewComponent
implements IEditorViewComponent {
    private static final Logger log = LoggerFactory.getLogger(EditorViewComponent.class);
    private boolean createSaveButton;
    private final List<FieldInterfaced> visibleFields;
    private final List<FieldInterfaced> hiddenFields;
    private ListViewComponent listViewComponent;
    private Object owner = null;
    private FieldInterfaced field = null;
    private Map<HasValue, List<Validator>> validators = new HashMap<HasValue, List<Validator>>();
    List<Component> componentsToLookForErrors = new ArrayList<Component>();
    protected boolean newRecord;
    private Class modelType;
    private MDDBinder binder;
    private AbstractStylist stylist;
    private Panel panel;
    private Layout kpisContainer;
    private Layout kpis;
    private Panel panelContenido;
    private List<EditorListener> listeners = new ArrayList<EditorListener>();
    private List<String> shortcutsCreated = new ArrayList<String>();
    private Object modelId;
    private Map<Method, Optional<Method>> mvs = new HashMap<Method, Optional<Method>>();
    private Object parent;
    private Map<String, Object> initialValues;
    private CssLayout links;
    private Map<String, List<AbstractAction>> actionsPerSection = new HashMap<String, List<AbstractAction>>();
    private VerticalLayout actionsContainer;
    private String focusedSectionId;
    private Map<String, List<AbstractAction>> actionsPerField = new HashMap<String, List<AbstractAction>>();
    private BindedWindow creatorWindow;
    private Runnable beforeOpen;
    private TabSheet sectionTabSheet;
    private Component selectedTab;
    public String _defaultAction;

    public Runnable getBeforeOpen() {
        return this.beforeOpen;
    }

    public void setBeforeOpen(Runnable beforeOpen) {
        this.beforeOpen = beforeOpen;
    }

    @Override
    public BindedWindow getCreatorWindow() {
        return this.creatorWindow;
    }

    public String getFocusedSectionId() {
        return this.focusedSectionId;
    }

    public void setFocusedSectionId(String focusedSectionId) {
        this.focusedSectionId = focusedSectionId;
    }

    public void setFocusedSection(TabSheet sectionTabSheet, Component selectedTab) {
        this.sectionTabSheet = sectionTabSheet;
        this.selectedTab = selectedTab;
        this.setFocusedSectionId("" + selectedTab.getId());
    }

    public void setCreateSaveButton(boolean createSaveButton) {
        this.createSaveButton = createSaveButton;
    }

    public boolean isCreateSaveButton() {
        return this.createSaveButton;
    }

    @Override
    public VaadinIcons getIcon() {
        return super.getIcon() != null ? super.getIcon() : VaadinIcons.EDIT;
    }

    public void setKpisContainer(Layout kpisContainer) {
        this.kpisContainer = kpisContainer;
        if (this.kpis != null) {
            kpisContainer.addComponent((Component)this.kpis);
        }
    }

    @Override
    public void setParentView(AbstractViewComponent parentView) {
        super.setParentView(parentView);
        if (parentView instanceof ListViewComponent) {
            this.setListViewComponent((ListViewComponent)parentView);
        }
    }

    public ListViewComponent getListViewComponent() {
        return this.listViewComponent;
    }

    public void setListViewComponent(ListViewComponent listViewComponent) {
        this.listViewComponent = listViewComponent;
    }

    public boolean isModificado() {
        return EditorViewComponent.isModificado(this.initialValues, this.buildSignature());
    }

    public static boolean isModificado(Map<String, Object> initialValues, Map<String, Object> currentValues) {
        boolean modificado = false;
        if (initialValues != null) {
            for (String k : initialValues.keySet()) {
                Object v0 = initialValues.get(k);
                Object v = currentValues.get(k);
                if (v0 != null && v0 instanceof String && "".equals(v0) && v == null || v != null && v instanceof String && "".equals(v) && v0 == null || (v0 != null || v == null) && (v0 == null || v0.equals(v))) continue;
                System.out.println("modificado. k=" + k + ",v0=" + v0 + ",v=" + v);
                modificado = true;
                break;
            }
        }
        return modificado;
    }

    public boolean isNewRecord() {
        return this.newRecord;
    }

    public void setModelType(Class modelType) {
        this.modelType = modelType;
    }

    public void addEditorListener(EditorListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public MDDBinder getBinder() {
        return this.binder;
    }

    public EditorViewComponent(Class modelType) {
        this(modelType, true);
    }

    public EditorViewComponent(ListViewComponent listViewComponent, Class modelType) {
        this(listViewComponent, modelType, true);
    }

    public EditorViewComponent(ListViewComponent listViewComponent, Object owner, FieldInterfaced field, Class modelType, List<FieldInterfaced> visibleFields, List<FieldInterfaced> hiddenFields, boolean createSaveButton) {
        this.listViewComponent = listViewComponent;
        this.owner = owner;
        this.field = field;
        this.modelType = modelType;
        this.visibleFields = visibleFields;
        this.hiddenFields = hiddenFields;
        this.createSaveButton = createSaveButton;
    }

    private Class getPojoTypeForEntity(Class modelType) throws ClassNotFoundException {
        return Class.forName(modelType.getName() + "Pojo");
    }

    public EditorViewComponent(Object owner, FieldInterfaced field, Class modelType, boolean createSaveButton) {
        this(null, owner, field, modelType, new ArrayList<FieldInterfaced>(), new ArrayList<FieldInterfaced>(), createSaveButton);
    }

    public EditorViewComponent(Class modelType, boolean createSaveButton) {
        this(null, null, modelType, createSaveButton);
    }

    public EditorViewComponent(ListViewComponent listViewComponent, Class modelType, boolean createSaveButton) {
        this(listViewComponent, null, null, modelType, new ArrayList<FieldInterfaced>(), new ArrayList<FieldInterfaced>(), createSaveButton);
    }

    public EditorViewComponent(Object model) {
        this(model, true);
    }

    public EditorViewComponent(Object model, Component lastViewComponent) {
        this(lastViewComponent instanceof ListViewComponent ? (ListViewComponent)lastViewComponent : null, model, null, null, true);
    }

    public EditorViewComponent(Object model, List<FieldInterfaced> visibleFields, List<FieldInterfaced> hiddenFields) {
        this(model, visibleFields, hiddenFields, true);
    }

    public EditorViewComponent(ListViewComponent listViewComponent, Object model, List<FieldInterfaced> visibleFields, List<FieldInterfaced> hiddenFields) {
        this(listViewComponent, model, visibleFields, hiddenFields, true);
    }

    public EditorViewComponent(Object model, boolean createSaveButton) {
        this(model, new ArrayList<FieldInterfaced>(), new ArrayList<FieldInterfaced>(), createSaveButton);
    }

    public EditorViewComponent(Object model, List<FieldInterfaced> visibleFields, List<FieldInterfaced> hiddenFields, boolean createSaveButton) {
        this(null, model, visibleFields, hiddenFields, createSaveButton);
    }

    public EditorViewComponent(ListViewComponent listViewComponent, Object model, List<FieldInterfaced> visibleFields, List<FieldInterfaced> hiddenFields, boolean createSaveButton) {
        this.listViewComponent = listViewComponent;
        this.modelType = model.getClass();
        this.visibleFields = visibleFields;
        this.hiddenFields = hiddenFields;
        this.createSaveButton = !(this instanceof OwnedCollectionComponent) && createSaveButton;
        this.setModel(model);
    }

    @Override
    public Object getModel() {
        return this.binder != null ? this.binder.getBean() : null;
    }

    public void setModel(Object model) {
        this.setModel(model, true);
    }

    public void setModel(Object model, boolean updateChangesSignature) {
        if (model != null) {
            this.modelType = model.getClass();
        } else {
            try {
                model = this.modelType.newInstance();
            }
            catch (Exception e) {
                Notifier.alert((Throwable)e);
            }
        }
        Object old = this.getModel();
        if (old != null) {
            this.listeners.remove(old);
        }
        if (model instanceof EditorListener) {
            this.addEditorListener((EditorListener)model);
        }
        this.binder = new MDDBinder(model.getClass(), this);
        if (model != null) {
            if (model.getClass().isAnnotationPresent(Entity.class)) {
                this.modelId = ReflectionHelper.getId((Object)model);
            }
            if (PersistentPojo.class.isAssignableFrom(model.getClass())) {
                this.modelId = ((PersistentPojo)model).getId();
            }
        }
        this.binder.setBean(model);
        String oldFocusedSectionId = this.focusedSectionId;
        this.build(model);
        if (!Strings.isNullOrEmpty((String)oldFocusedSectionId) && this.sectionTabSheet != null) {
            this.sectionTabSheet.setSelectedTab(Integer.parseInt(oldFocusedSectionId));
            this.focusedSectionId = oldFocusedSectionId;
        }
        this.rebuildActions();
        if (updateChangesSignature) {
            this.initialValues = this.buildSignature();
        }
    }

    public Map<String, Object> buildSignature() {
        return EditorViewComponent.buildSignature(this.getModel());
    }

    public static Map<String, Object> buildSignature(Object m) {
        HashMap<String, Object> s = new HashMap<String, Object>();
        if (m != null && m instanceof HasChangesSignature) {
            s.put("signature", ((HasChangesSignature)m).getChangesSignature());
        } else if (m != null) {
            ArrayList<Object> seen = new ArrayList<Object>();
            seen.add(m);
            for (FieldInterfaced f : ReflectionHelper.getAllEditableFields(m.getClass())) {
                if (Modifier.isTransient(f.getModifiers())) continue;
                try {
                    Object v = ReflectionHelper.getValue((FieldInterfaced)f, (Object)m);
                    if (v != null) {
                        if (v instanceof Collection) {
                            Collection col = (Collection)v;
                            String cols = "";
                            for (Object o : col) {
                                if (!"".equals(cols)) {
                                    cols = cols + ",";
                                }
                                cols = cols + "" + EditorViewComponent.serialize(seen, o);
                            }
                            s.put(f.getName(), cols);
                            continue;
                        }
                    } else {
                        v = "";
                    }
                    s.put(f.getName(), "" + v);
                }
                catch (Exception e) {
                    s.put(f.getName(), null);
                }
            }
        }
        return s;
    }

    public static String serialize(List<Object> seen, Object o) {
        String s = "";
        if (o != null) {
            if (seen.contains(o)) {
                return "" + o;
            }
            seen.add(o);
            for (FieldInterfaced f : ReflectionHelper.getAllEditableFields(o.getClass())) {
                if (!"".equals(s)) {
                    s = s + "&";
                }
                try {
                    s = s + f.getName() + "=";
                    Object v = ReflectionHelper.getValue((FieldInterfaced)f, (Object)o);
                    if (v != null) {
                        String z;
                        if (v instanceof Collection) {
                            z = "";
                            for (Object i : (Collection)v) {
                                if (!"".equals(z)) {
                                    z = z + "|";
                                }
                                z = z + EditorViewComponent.serialize(seen, i);
                            }
                            v = z;
                        } else if (v instanceof Map) {
                            z = "";
                            for (Object i : ((Map)v).keySet()) {
                                if (!"".equals(z)) {
                                    z = z + "|";
                                }
                                z = z + EditorViewComponent.serialize(seen, i) + "->" + EditorViewComponent.serialize(seen, ((Map)v).get(i));
                            }
                            v = z;
                        }
                    } else {
                        v = "";
                    }
                    s = s + v;
                }
                catch (Exception e) {
                    s = s + f.getName() + "=exception";
                }
            }
        } else {
            s = "null";
        }
        return s;
    }

    private void build(Object model) {
        if (this.isResource(model)) {
            model = new ResourceModel((IResource)model);
        }
        long t0 = System.currentTimeMillis();
        if (model != null && model.getClass().isAnnotationPresent(Entity.class)) {
            Object id = ReflectionHelper.getId((Object)model);
            boolean esNuevo = false;
            esNuevo = id instanceof Long ? (Long)id == 0L : (id instanceof Integer ? (Integer)id == 0 : id == null);
            this.newRecord = esNuevo;
        }
        this.clear();
        this.componentsToLookForErrors = new ArrayList<Component>();
        try {
            List kpiFields;
            if (this.panel == null) {
                this.build();
            }
            if (this.links != null) {
                this.links.removeAllComponents();
            }
            this.getActions();
            this.updateSubheader(model);
            this.panelContenido = new Panel();
            this.panelContenido.addStyleName("borderless");
            this.panelContenido.addStyleName("nopadding");
            this.panelContenido.addStyleName("panelContenido");
            this.panelContenido.setSizeFull();
            if (this.kpis == null) {
                this.kpis = new CssLayout();
                this.kpis.addStyleName("nopadding");
            }
            if (this.kpisContainer != null) {
                this.kpisContainer.removeAllComponents();
                this.kpisContainer.addComponent((Component)this.kpis);
            }
            if (!(this instanceof FiltersViewFlowComponent) && (kpiFields = ReflectionHelper.getKpiFields(model.getClass())).size() > 0 && this.kpis != null) {
                this.kpis.removeAllComponents();
                for (FieldInterfaced kpi : kpiFields) {
                    this.kpis.addComponent(this.createKpi(this.binder, kpi));
                }
            }
            this.panel.setContent((Component)this.panelContenido);
            List fields = ReflectionHelper.getAllEditableFields(model.getClass(), this.owner != null ? this.owner.getClass() : null, (boolean)false, (FieldInterfaced)this.field);
            this.removeUneditableFields(fields);
            if (this.visibleFields != null && this.visibleFields.size() > 0) {
                fields.removeIf(f -> !this.visibleFields.contains(f));
            }
            if (this.hiddenFields != null && this.hiddenFields.size() > 0) {
                fields.removeIf(f -> this.hiddenFields.contains(f));
            }
            FormLayoutBuilderParameters.FormLayoutBuilderParametersBuilder params = FormLayoutBuilderParameters.builder().validators(this.validators).allFields(fields).links(this.links).actionsPerSection(this.actionsPerSection);
            if (this instanceof FiltersViewFlowComponent) {
                params = params.forSearchFilters(true).forSearchFiltersExtended(true).createSections(false).createTabs(false);
            }
            Pair<Component, AbstractStylist> r = FormLayoutBuilder.get().build(this, this.binder, model.getClass(), model, this.componentsToLookForErrors, params.build(), this.actionsPerField);
            this.stylist = (AbstractStylist)r.getValue();
            this.panelContenido.setContent((Component)r.getKey());
            AbstractStylist finalStylist = this.stylist;
            if (this.getView() != null) {
                this.getView().updateViewTitle(this.toString());
            }
            if (this.links != null) {
                if (this.links.getComponentCount() == 0) {
                    this.links.setVisible(false);
                } else {
                    this.links.setVisible(true);
                }
            }
            this.focusFirstField(this.panelContenido.getContent());
        }
        catch (Exception e) {
            Notifier.alert((Throwable)e);
        }
        this.rebuildActions();
        this.actionsByMethod.keySet().forEach(x -> {
            Method mv;
            ArrayList<DependsOn> as = new ArrayList<DependsOn>();
            Method m = (Method)x;
            if (m.isAnnotationPresent(DependsOn.class)) {
                as.add(m.getAnnotation(DependsOn.class));
            }
            if ((mv = ReflectionHelper.getMethod((Class)this.modelType, (String)(ReflectionHelper.getGetter((String)m.getName()).replaceFirst("get", "is") + "Visible"))) != null && mv.isAnnotationPresent(DependsOn.class)) {
                as.add(mv.getAnnotation(DependsOn.class));
            }
            for (DependsOn a : as) {
                for (String fn : a.value().split(",")) {
                    String finalFn = fn = fn.trim();
                    Optional b = this.binder.getBinding(fn);
                    if (b.isPresent()) {
                        ((Binder.Binding)b.get()).getField().addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.rebuildActions());
                        continue;
                    }
                    this.binder.forField((HasValue)new AbstractField(){
                        Object v = null;

                        protected void doSetValue(Object o) {
                            this.v = o;
                        }

                        public Object getValue() {
                            return this.v;
                        }
                    }).bind(finalFn);
                }
            }
        });
        if (this.esForm()) {
            this.addStyleName("contenido");
            this.addStyleName("container");
        }
        log.debug("editor component built in " + (System.currentTimeMillis() - t0) + " ms.");
    }

    private void updateSubheader(Object model) {
        if (this.subheader != null) {
            this.subheader.removeAllComponents();
            if (model != null && model instanceof HasHeader) {
                Component h = this.createSubheader(((HasHeader)model).getHeader());
                if (h != null) {
                    this.subheader.addComponent(h);
                    this.subheader.setVisible(true);
                } else {
                    this.subheader.setVisible(false);
                }
            }
        }
    }

    private Component createSubheader(Header header) {
        if (header == null) {
            return null;
        }
        Label l = new Label(header.getMessage());
        l.addStyleName("subheader");
        String s = null;
        switch (header.getType()) {
            case Info: {
                s = "v-label-info";
                break;
            }
            case Success: {
                s = "success";
                break;
            }
            case Warning: {
                s = "v-label-warning";
                break;
            }
            case Error: {
                s = "failure";
            }
        }
        l.addStyleName(s);
        return l;
    }

    private boolean isResource(Object model) {
        boolean r = false;
        if (model instanceof IResource) {
            r = true;
        } else if (model instanceof List && IResource.class.equals((Object)ReflectionHelper.getGenericClass(model.getClass()))) {
            r = true;
        }
        return r;
    }

    protected void removeUneditableFields(List<FieldInterfaced> fields) {
        fields.stream().filter(f -> ReflectionHelper.hasGetter((FieldInterfaced)f)).collect(Collectors.toList());
    }

    private boolean focusFirstField(Component c) {
        if (c instanceof AbstractField) {
            if (c instanceof TextField) {
                ((TextField)c).selectAll();
            }
            ((AbstractField)c).focus();
            return true;
        }
        if (c instanceof ComboBox) {
            ((ComboBox)c).focus();
            return true;
        }
        if (c instanceof HasComponents) {
            HasComponents l = (HasComponents)c;
            for (Component ch : l) {
                if (!this.focusFirstField(ch)) continue;
                return true;
            }
        }
        return false;
    }

    private Component createKpi(MDDBinder binder, final FieldInterfaced kpi) {
        VerticalLayout vl = new VerticalLayout();
        vl.addStyleName("kpi");
        vl.setWidthUndefined();
        vl.addComponent((Component)new Label(ReflectionHelper.getCaption((FieldInterfaced)kpi)));
        final Label l = new Label();
        vl.addComponent((Component)l);
        l.addStyleName("valor");
        l.setContentMode(ContentMode.HTML);
        Binder.Binding binding = binder.forField(new HasValue(){
            Object v = null;

            public void setValue(Object o) {
                this.v = o;
                String s = "";
                if (Double.TYPE.equals(kpi.getType()) && (kpi.isAnnotationPresent(Money.class) || kpi.isAnnotationPresent(Balance.class))) {
                    DecimalFormat df = new DecimalFormat("##,###,###,###,##0.00");
                    s = df.format(this.v != null ? this.v : Integer.valueOf(0));
                    if (kpi.isAnnotationPresent(Balance.class)) {
                        if (this.v != null && (Double)this.v < 0.0) {
                            l.addStyleName("negativo");
                            l.removeStyleName("positivo");
                        } else {
                            l.addStyleName("positivo");
                            l.removeStyleName("negativo");
                        }
                    }
                } else if (this.v == null) {
                    s = "";
                } else if (this.v instanceof Boolean) {
                    if (((Boolean)this.v).booleanValue() && !((KPI)kpi.getAnnotation(KPI.class)).reversed()) {
                        s = VaadinIcons.CHECK.getHtml();
                        l.addStyleName("friendly");
                    } else {
                        s = VaadinIcons.CLOSE.getHtml();
                        l.addStyleName("danger");
                    }
                    l.addStyleName("centered");
                } else {
                    s = "" + this.v;
                }
                l.setValue(s);
            }

            public Object getValue() {
                return this.v;
            }

            public Registration addValueChangeListener(HasValue.ValueChangeListener valueChangeListener) {
                return null;
            }

            public void setRequiredIndicatorVisible(boolean b) {
            }

            public boolean isRequiredIndicatorVisible() {
                return false;
            }

            public void setReadOnly(boolean b) {
            }

            public boolean isReadOnly() {
                return false;
            }
        }).bind(kpi.getName());
        return vl;
    }

    @Override
    public void updateModel(Object model) {
        if (this.binder != null) {
            this.binder.update(model);
            this.updateSubheader(model);
        }
    }

    @Override
    public void updatePageTitle() {
        super.updatePageTitle();
        if (this.getModel() != null && this.getModel() instanceof EditorViewStyler) {
            ((EditorViewStyler)this.getModel()).apply((Component)this);
        }
    }

    public String toString() {
        String t = this.stylist != null ? this.stylist.getViewTitle(this.newRecord, this.getModel()) : "Not yet";
        return t;
    }

    public Class getModelType() {
        return this.modelType;
    }

    public EditorViewComponent build() throws Exception {
        this.actionsContainer = new VerticalLayout();
        this.actionsContainer.addStyleName("actionscontainer");
        this.actionsContainer.addStyleName("nopadding");
        this.actionsContainer.setSizeUndefined();
        super.build();
        log.debug("*******BUILD***************");
        this.addStyleName("editorviewcomponent");
        this.panel = new Panel();
        this.panel.addStyleName("borderless");
        this.panel.addStyleName("nopadding");
        this.panel.addStyleName("panelContenedor");
        if (this.esForm()) {
            this.addComponent((Component)this.panel);
            this.addActionsBar(false);
        } else {
            this.addComponentsAndExpand(new Component[]{this.panel});
        }
        return this;
    }

    @Override
    public boolean esForm() {
        return this.listViewComponent == null && (this.modelType.isAnnotationPresent(io.mateu.mdd.core.annotations.MateuUI.class) || !this.modelType.isAnnotationPresent(Entity.class) && !PersistentPojo.class.isAssignableFrom(this.modelType));
    }

    private void updateActions() {
        if (this.stylist != null) {
            Object model = this.binder.getBean();
            for (String k : this.menuItemsById.keySet()) {
                Object c = this.menuItemsById.get(k);
                if (c instanceof MenuBar.MenuItem) {
                    ((MenuBar.MenuItem)c).setEnabled(this.stylist.isActionEnabled(k, model));
                    continue;
                }
                if (!(c instanceof Button)) continue;
                ((Button)c).setEnabled(this.stylist.isActionEnabled(k, model));
            }
        }
        if (this.bar.getComponentCount() == 0) {
            this.bar.setVisible(false);
        } else {
            this.bar.setVisible(true);
        }
    }

    @Override
    public void addViewActionsMenuItems(CssLayout bar) {
        boolean readOnly;
        boolean isEditingNewRecord = this.newRecord;
        boolean bl = readOnly = this.getModel() != null && this.getModel() instanceof ReadOnly && ((ReadOnly)this.getModel()).isReadOnly();
        if (!this.esForm()) {
            Button i;
            if (this.modelType.isAnnotationPresent(Entity.class) || PersistentPojo.class.isAssignableFrom(this.modelType)) {
                if (this.field == null && !(this instanceof OwnedCollectionComponent) && !this.isActionPresent("refresh")) {
                    i = new Button("", (Resource)VaadinIcons.REFRESH);
                    bar.addComponent((Component)i);
                    i.addStyleName("quiet");
                    i.addClickListener((Button.ClickListener & Serializable)e -> {
                        try {
                            this.load(this.modelId);
                        }
                        catch (Throwable throwable) {
                            Notifier.alert((Throwable)throwable);
                        }
                    });
                    this.addMenuItem("refresh", (Component)i);
                    i.setClickShortcut(82, new int[]{17});
                    this.shortcutsCreated.add("refresh");
                }
                if (!this.isActionPresent("prev")) {
                    i = new Button("", (Resource)VaadinIcons.ARROW_UP);
                    bar.addComponent((Component)i);
                    i.addStyleName("quiet");
                    i.addClickListener((Button.ClickListener & Serializable)e -> {
                        try {
                            Object xid = this.listViewComponent.getPrevious(this.modelId);
                            if (xid != null) {
                                io.mateu.mdd.core.ui.MDDUIAccessor.goSibling((Object)xid);
                            }
                        }
                        catch (Throwable throwable) {
                            Notifier.alert((Throwable)throwable);
                        }
                    });
                    this.addMenuItem("prev", (Component)i);
                    i.setClickShortcut(38, new int[]{17, 18});
                    this.shortcutsCreated.add("prev");
                }
                if (!this.isActionPresent("next")) {
                    i = new Button("", (Resource)VaadinIcons.ARROW_DOWN);
                    bar.addComponent((Component)i);
                    i.addStyleName("quiet");
                    i.addClickListener((Button.ClickListener & Serializable)e -> {
                        try {
                            Object xid = this.listViewComponent.getNext(this.modelId);
                            if (xid != null) {
                                io.mateu.mdd.core.ui.MDDUIAccessor.goSibling((Object)xid);
                            }
                        }
                        catch (Throwable throwable) {
                            Notifier.alert((Throwable)throwable);
                        }
                    });
                    this.addMenuItem("next", (Component)i);
                    i.setClickShortcut(40, new int[]{17, 18});
                    this.shortcutsCreated.add("next");
                }
            }
            if (!readOnly && this.createSaveButton && (this.modelType.isAnnotationPresent(Entity.class) || PersistentPojo.class.isAssignableFrom(this.modelType)) && (this.isNewRecord() || !this.modelType.isAnnotationPresent(Unmodifiable.class))) {
                if (!this.isActionPresent("save")) {
                    Button b;
                    i = new Button("", (Resource)VaadinIcons.CHECK);
                    bar.addComponent((Component)i);
                    i.addStyleName("quiet");
                    i.addClickListener((Button.ClickListener & Serializable)e -> {
                        try {
                            BinderValidationStatus v = this.binder.validate();
                            if (v.isOk()) {
                                this.preSave();
                                this.save();
                            } else {
                                for (Component c : this.componentsToLookForErrors) {
                                    if (!(c instanceof AbstractComponent) || ((AbstractComponent)c).getComponentError() == null) continue;
                                    if (!(c instanceof Component.Focusable)) break;
                                    ((Component.Focusable)c).focus();
                                    break;
                                }
                                MDD.alert((BinderValidationStatus)v);
                            }
                        }
                        catch (Throwable throwable) {
                            Notifier.alert((Throwable)throwable);
                        }
                    });
                    this.addMenuItem("save", (Component)i);
                    i.setClickShortcut(83, new int[]{17});
                    if (!this.shortcutsCreated.contains("saveandstay")) {
                        b = new Button();
                        this.getHiddens().addComponent((Component)b);
                        b.addClickListener((Button.ClickListener & Serializable)e -> {
                            BinderValidationStatus v = this.binder.validate();
                            if (v.isOk()) {
                                try {
                                    this.preSave();
                                    this.save(false);
                                }
                                catch (Throwable throwable) {
                                    throwable.printStackTrace();
                                }
                            } else {
                                MDD.alert((BinderValidationStatus)v);
                            }
                        });
                        b.setClickShortcut(83, new int[]{17, 18});
                        this.shortcutsCreated.add("saveandstay");
                    }
                    if (!this.shortcutsCreated.contains("new")) {
                        b = new Button();
                        this.getHiddens().addComponent((Component)b);
                        b.addClickListener((Button.ClickListener & Serializable)e -> {
                            BinderValidationStatus v = this.binder.validate();
                            if (v.isOk()) {
                                try {
                                    this.preSave();
                                    this.save(false);
                                    Object old = this.getBinder().getBean();
                                    Object current = ReflectionHelper.newInstance((Class)this.modelType, (Object)this.parent);
                                    this.newRecord = true;
                                    for (FieldInterfaced f : ReflectionHelper.getAllEditableFields(old.getClass())) {
                                        if (!f.isAnnotationPresent(Keep.class)) continue;
                                        ReflectionHelper.setValue((FieldInterfaced)f, (Object)current, (Object)ReflectionHelper.getValue((FieldInterfaced)f, (Object)old));
                                    }
                                    this.getBinder().setBean(current, false);
                                    io.mateu.mdd.core.ui.MDDUIAccessor.updateTitle((String)this.getTitle());
                                }
                                catch (Throwable throwable) {
                                    throwable.printStackTrace();
                                }
                            } else {
                                MDD.alert((BinderValidationStatus)v);
                            }
                        });
                        b.setClickShortcut(78, new int[]{17, 18});
                        this.shortcutsCreated.add("new");
                    }
                    if (!(!this.modelType.isAnnotationPresent(Entity.class) && !PersistentPojo.class.isAssignableFrom(this.modelType) || this.modelType.isAnnotationPresent(NonDuplicable.class) || this.isActionPresent("duplicate") || this.isNewRecord() || this.shortcutsCreated.contains("duplicate"))) {
                        b = new Button();
                        this.getHiddens().addComponent((Component)b);
                        b.addClickListener((Button.ClickListener & Serializable)e -> {
                            try {
                                BinderValidationStatus v = this.binder.validate();
                                if (v.isOk()) {
                                    try {
                                        this.preSave();
                                        this.save(false);
                                        Object old = this.getBinder().getBean();
                                        Object current = ReflectionHelper.newInstance((Class)this.modelType, (Object)this.parent);
                                        this.newRecord = true;
                                        for (FieldInterfaced f : ReflectionHelper.getAllEditableFields(old.getClass())) {
                                            if (Collection.class.isAssignableFrom(f.getType())) continue;
                                            ReflectionHelper.setValue((FieldInterfaced)f, (Object)current, (Object)ReflectionHelper.getValue((FieldInterfaced)f, (Object)old));
                                        }
                                        this.getBinder().setBean(current, false);
                                        this.setModel(current);
                                        this.modelId = null;
                                        io.mateu.mdd.core.ui.MDDUIAccessor.updateTitle((String)this.getTitle());
                                    }
                                    catch (Throwable throwable) {
                                        throwable.printStackTrace();
                                    }
                                } else {
                                    MDD.alert((BinderValidationStatus)v);
                                }
                            }
                            catch (Throwable throwable) {
                                Notifier.alert((Throwable)throwable);
                            }
                        });
                        b.setClickShortcut(68, new int[]{17});
                        this.shortcutsCreated.add("duplicate");
                    }
                }
                if (!(this.modelType != null && (this.modelType.isAnnotationPresent(ModifyValuesOnly.class) || this.modelType.isAnnotationPresent(NewNotAllowed.class)) || this.field != null && !ReflectionHelper.puedeAnadir((FieldInterfaced)this.field) || this.isActionPresent("add"))) {
                    i = new Button("", (Resource)VaadinIcons.PLUS);
                    bar.addComponent((Component)i);
                    i.addStyleName("quiet");
                    i.addClickListener((Button.ClickListener & Serializable)e -> {
                        try {
                            BinderValidationStatus v = this.binder.validate();
                            if (v.isOk()) {
                                try {
                                    this.preSave();
                                    this.save(false);
                                    Object old = this.getBinder().getBean();
                                    this.load(null);
                                    Object current = this.getModel();
                                    for (FieldInterfaced f : ReflectionHelper.getAllEditableFields(old.getClass())) {
                                        if (!f.isAnnotationPresent(Keep.class)) continue;
                                        ReflectionHelper.setValue((FieldInterfaced)f, (Object)current, (Object)ReflectionHelper.getValue((FieldInterfaced)f, (Object)old));
                                    }
                                    this.getBinder().setBean(current, false);
                                    this.setModel(current);
                                    this.modelId = null;
                                    io.mateu.mdd.core.ui.MDDUIAccessor.updateTitle((String)this.getTitle());
                                }
                                catch (Throwable throwable) {
                                    throwable.printStackTrace();
                                }
                            } else {
                                MDD.alert((BinderValidationStatus)v);
                            }
                        }
                        catch (Throwable throwable) {
                            Notifier.alert((Throwable)throwable);
                        }
                    });
                    this.addMenuItem("add", (Component)i);
                }
                if (!(this.modelType != null && (this.modelType.isAnnotationPresent(ModifyValuesOnly.class) || this.modelType.isAnnotationPresent(Indelible.class)) || this.field != null && !ReflectionHelper.puedeBorrar((FieldInterfaced)this.field) || this.isActionPresent("remove"))) {
                    i = new Button("", (Resource)VaadinIcons.MINUS);
                    bar.addComponent((Component)i);
                    i.addStyleName("quiet");
                    i.addClickListener((Button.ClickListener & Serializable)e -> VaadinHelper.confirm("Are you sure you want to delete this item?", () -> {
                        try {
                            Object xid = null;
                            try {
                                xid = this.listViewComponent.getNext(this.modelId);
                            }
                            catch (Throwable throwable) {
                                try {
                                    xid = this.listViewComponent.getPrevious(this.modelId);
                                }
                                catch (Throwable throwable2) {
                                    // empty catch block
                                }
                            }
                            if (!isEditingNewRecord) {
                                JPAHelper.transact(em -> ReflectionHelper.delete((EntityManager)em, (Object)em.find(this.getModelType(), ReflectionHelper.getId((Object)this.getModel()))));
                            }
                            if (xid != null) {
                                io.mateu.mdd.core.ui.MDDUIAccessor.goSibling((Object)xid);
                            } else {
                                this.goBack();
                            }
                        }
                        catch (Throwable ex) {
                            Notifier.alert((Throwable)ex);
                        }
                    }));
                    this.addMenuItem("remove", (Component)i);
                }
            }
            if (this.getMenuItemById("prev") != null) {
                this.getMenuItemById("prev").setVisible(!this.isNewRecord() && this.listViewComponent != null);
            }
            if (this.getMenuItemById("next") != null) {
                this.getMenuItemById("next").setVisible(!this.isNewRecord() && this.listViewComponent != null);
            }
            if (this.getMenuItemById("duplicate") != null) {
                this.getMenuItemById("duplicate").setVisible(!this.isNewRecord());
            }
            if (this.getMenuItemById("add") != null && (this.getView() == null || this.getView().getWindowContainer() != null || this instanceof OwnedCollectionComponent)) {
                this.getMenuItemById("add").setVisible(false);
            }
            if (this.getMenuItemById("remove") != null && (this.getView() == null || this.getView().getWindowContainer() != null || this instanceof OwnedCollectionComponent)) {
                this.getMenuItemById("remove").setVisible(false);
            }
            if (this.getMenuItemById("save") != null && this instanceof OwnedCollectionComponent) {
                this.getMenuItemById("save").setVisible(false);
            }
        }
        super.addViewActionsMenuItems(bar);
    }

    public AbstractStylist getStylist() {
        return this.stylist;
    }

    public void setStylist(AbstractStylist stylist) {
        this.stylist = stylist;
    }

    @Override
    public List<AbstractAction> getActions() {
        MDDRunnableAction a2;
        ArrayList<3> l;
        final Object bean = this.binder != null ? this.binder.getBean() : null;
        boolean isEditingNewRecord = io.mateu.mdd.core.ui.MDDUIAccessor.isEditingNewRecord();
        this.actionsPerSection = new HashMap<String, List<AbstractAction>>();
        ArrayList<Method> ms = new ArrayList<Method>();
        ArrayList<Method> mvf = new ArrayList<Method>();
        if (this.esForm() && Runnable.class.isAssignableFrom(this.modelType)) {
            l = new ArrayList();
            this.actionsPerSection.put("", l);
            a2 = new MDDRunnableAction("Submit"){

                public void run() throws Throwable {
                    if (EditorViewComponent.this.validate()) {
                        ((Runnable)bean).run();
                        Label h = new Label("Thanks for submitting!");
                        h.addStyleName("h1");
                        MDDUIAccessor.setPendingResult((Object)h);
                        io.mateu.mdd.core.ui.MDDUIAccessor.go((String)"submitted");
                    }
                }
            };
            l.add(a2);
            a2.setId("submitted");
            a2.setOrder(-100);
        } else if (this.esForm() && Callable.class.isAssignableFrom(this.modelType)) {
            l = new ArrayList<3>();
            this.actionsPerSection.put("", l);
            a2 = new MDDRunnableAction("Submit"){

                public void run() throws Throwable {
                    if (EditorViewComponent.this.validate()) {
                        Object r = ((Callable)bean).call();
                        MDDUIAccessor.setPendingResult(r);
                        io.mateu.mdd.core.ui.MDDUIAccessor.go((String)"submitted");
                    }
                }
            };
            l.add(a2);
            a2.setId("submitted");
            a2.setOrder(-100);
        } else if (this.esForm() && (this.modelType.isAnnotationPresent(Entity.class) || this.modelType.isAnnotationPresent(PersistentPojo.class))) {
            l = new ArrayList();
            this.actionsPerSection.put("", l);
            a2 = new MDDRunnableAction("Submit"){

                public void run() throws Throwable {
                    if (EditorViewComponent.this.validate()) {
                        EditorViewComponent.this.save(false);
                        Label h = new Label("Thanks for submitting!");
                        h.addStyleName("h1");
                        MDDUIAccessor.setPendingResult((Object)h);
                        io.mateu.mdd.core.ui.MDDUIAccessor.go((String)"submitted");
                    }
                }
            };
            l.add(a2);
            a2.setOrder(-100);
            a2.setId("submitted");
        }
        for (Method m2 : ReflectionHelper.getAllMethods((Class)this.modelType)) {
            if (Modifier.isStatic(m2.getModifiers()) || m2.isAnnotationPresent(NotWhenCreating.class) && isEditingNewRecord || m2.isAnnotationPresent(NotWhenEditing.class) && !isEditingNewRecord || !m2.isAnnotationPresent(Action.class) || !this.isCreateSaveButton() && (m2.getAnnotation(Action.class).saveAfter() || m2.getAnnotation(Action.class).saveBefore())) continue;
            this.addMethod(m2, bean, ms, mvf);
        }
        ms.sort((a, b) -> (a.getAnnotation(Action.class) != null ? a.getAnnotation(Action.class).order() : -100) - (b.getAnnotation(Action.class) != null ? b.getAnnotation(Action.class).order() : -100));
        mvf.sort((a, b) -> (a.getAnnotation(Action.class) != null ? a.getAnnotation(Action.class).order() : -100) - (b.getAnnotation(Action.class) != null ? b.getAnnotation(Action.class).order() : -100));
        ms.forEach(m -> {
            Action aa = m.getAnnotation(Action.class);
            String k = aa != null ? aa.section() : "";
            this.actionsPerSection.putIfAbsent(k, new ArrayList());
            List<AbstractAction> l = this.actionsPerSection.get(k);
            AbstractAction a = ViewComponentHelper.createAction(m, this);
            l.add(a);
        });
        this.actionsPerField = new HashMap<String, List<AbstractAction>>();
        mvf.forEach(m -> {
            Action aa = m.getAnnotation(Action.class);
            String k = aa != null ? aa.attachToField() : "";
            this.actionsPerField.putIfAbsent(k, new ArrayList());
            List<AbstractAction> l = this.actionsPerField.get(k);
            AbstractAction a = ViewComponentHelper.createAction(m, this);
            l.add(a);
        });
        List r = this.actionsPerSection.getOrDefault("", new ArrayList());
        if (this.esForm() && r.size() > 0) {
            this._defaultAction = ((AbstractAction)r.get(0)).getId();
        }
        return r;
    }

    private void addMethod(Method m, Object bean, List<Method> ms, List<Method> mvf) {
        Method mv;
        Optional<Method> omv = this.mvs.get(m);
        if (omv == null) {
            mv = ReflectionHelper.getMethod((Class)this.modelType, (String)(ReflectionHelper.getGetter((String)m.getName()).replaceFirst("get", "is") + "Visible"));
            omv = mv != null ? Optional.of(mv) : Optional.empty();
            this.mvs.put(m, omv);
        }
        mv = null;
        if (omv.isPresent()) {
            mv = omv.get();
        }
        try {
            if (mv == null || bean == null || ((Boolean)mv.invoke(bean, new Object[0])).booleanValue()) {
                (m.getAnnotation(Action.class) == null || Strings.isNullOrEmpty((String)m.getAnnotation(Action.class).attachToField()) ? ms : mvf).add(m);
            }
        }
        catch (Exception e) {
            Notifier.alert((Throwable)e);
        }
    }

    @Override
    public Method getMethod(String methodName) {
        Method a = null;
        for (Method m : ReflectionHelper.getAllMethods((Class)this.getModelType())) {
            if (Modifier.isStatic(m.getModifiers()) || !m.getName().equals(methodName)) continue;
            a = m;
            break;
        }
        return a;
    }

    @Override
    public FieldInterfaced getField(String fieldName) {
        FieldInterfaced a = null;
        for (FieldInterfaced m : ReflectionHelper.getAllFields((Class)this.getModelType())) {
            if (!m.getName().equals(fieldName) && !(m.getName() + "_search").equals(fieldName)) continue;
            a = m;
            break;
        }
        return a;
    }

    public void save() throws Throwable {
        this.save(true);
    }

    @Override
    public void save(boolean goBack) throws Throwable {
        this.save(goBack, true);
    }

    @Override
    public void preSave() throws Throwable {
        for (EditorListener l : this.listeners) {
            l.preSave(this.getModel());
        }
    }

    @Override
    public void save(boolean goBack, boolean notify) throws Throwable {
        this.save(goBack, notify, false);
    }

    public void save(boolean goBack, boolean notify, boolean copyEditableValues) throws Throwable {
        if (this.validate()) {
            try {
                if (this.modelType.isAnnotationPresent(Entity.class)) {
                    final Object m = this.getModel();
                    JPAHelper.transact((JPATransaction)new JPATransaction(){

                        public void run(EntityManager em) throws Throwable {
                            ReflectionHelper.auditar((Object)m);
                            Object d = EditorViewComponent.this.transferirValores(em, m);
                            EditorViewComponent.this.setModel(d);
                        }
                    }, () -> {
                        System.out.println("entramos en el callback");
                        if (!goBack) {
                            System.out.println("actualizamos el ui");
                            UI.getCurrent().access(() -> {
                                try {
                                    JPAHelper.notransact(em -> {
                                        if (this.modelId != null) {
                                            this.binder.update(em.find(m.getClass(), this.modelId));
                                        }
                                        this.initialValues = this.buildSignature();
                                    });
                                    io.mateu.mdd.core.ui.MDDUIAccessor.updateTitle((String)this.getTitle());
                                }
                                catch (Throwable throwable) {
                                    Notifier.alert((Throwable)throwable);
                                }
                            });
                        }
                    });
                    this.modelId = ReflectionHelper.getId((Object)this.getModel());
                    JPAHelper.notransact(em -> {
                        this.binder.update(em.find(m.getClass(), this.modelId));
                        this.initialValues = this.buildSignature();
                    });
                    if (goBack) {
                        this.goBack();
                    }
                } else if (PersistentPojo.class.isAssignableFrom(this.modelType)) {
                    PersistentPojo ppojo = (PersistentPojo)this.getModel();
                    ppojo.save();
                    this.setModel(ppojo);
                    if (goBack) {
                        this.goBack();
                    }
                }
                if (notify) {
                    this.listeners.forEach(l -> l.onSave(this.getModel()));
                }
                if (!goBack && (this.modelType.isAnnotationPresent(Entity.class) || PersistentPojo.class.isAssignableFrom(this.modelType))) {
                    this.load(this.modelId);
                }
                if (this.getView() != null) {
                    this.getView().updateViewTitle(this.toString());
                }
            }
            catch (OptimisticLockException ole) {
                VaadinHelper.confirm("Some objects have been modified by someone else. You should refresh and recover any modification you have done. Do you want to go ahead and overwrite instead?", () -> {
                    try {
                        this.save(goBack, notify, true);
                    }
                    catch (Throwable throwable) {
                        Notifier.alert((Throwable)throwable);
                    }
                });
            }
        }
    }

    public boolean validate() {
        return this.validate(false);
    }

    public boolean validate(boolean silent) {
        boolean noerror = true;
        BinderValidationStatus status = this.binder.validate();
        for (Component c : this.componentsToLookForErrors) {
            if (!c.isVisible() || !c.getParent().isVisible() || !(c instanceof AbstractComponent) || ((AbstractComponent)c).getComponentError() == null) continue;
            noerror = false;
            if (!(c instanceof Component.Focusable)) break;
            ((Component.Focusable)c).focus();
            break;
        }
        if (!noerror && !silent) {
            Notifier.alert((String)"Please solve errors for all fields");
        }
        return noerror;
    }

    private Object transferirValores(EntityManager em, Object m) throws Throwable {
        return new Transferrer().transfer(em, m);
    }

    public void load(final Object id, Object parent, FieldInterfaced field) throws Throwable {
        this.modelId = id;
        this.parent = parent;
        if (id == null) {
            this.newRecord = true;
            Set subClasses = ReflectionHelper.getSubclasses((Class)this.modelType);
            if (subClasses.size() > 1) {
                LinkedHashSet subClassesOptions = new LinkedHashSet();
                subClasses.forEach(c -> subClassesOptions.add(new ClassOption((Class)c)));
                VaadinHelper.choose("Please choose type", subClassesOptions, c -> {
                    if (c == null) {
                        io.mateu.mdd.core.ui.MDDUIAccessor.goBack();
                    } else {
                        try {
                            this.create(((ClassOption)c).get_class(), parent);
                        }
                        catch (Throwable e) {
                            Notifier.alert((Throwable)e);
                        }
                    }
                }, () -> io.mateu.mdd.core.ui.MDDUIAccessor.goBack());
            } else if (subClasses.size() == 1) {
                this.create((Class)subClasses.iterator().next(), parent);
            } else {
                this.create(this.modelType, parent);
            }
        } else {
            this.newRecord = false;
            if (this.modelType.isAnnotationPresent(Entity.class)) {
                JPAHelper.notransact((JPATransaction)new JPATransaction(){

                    public void run(EntityManager em) throws Throwable {
                        EditorViewComponent.this.setModel(em.find(EditorViewComponent.this.modelType, id));
                    }
                });
            } else if (PersistentPojo.class.isAssignableFrom(this.modelType)) {
                PersistentPojo ppojo = null;
                ppojo = id != null && this.modelType.equals(id.getClass()) ? (PersistentPojo)id : (PersistentPojo)this.modelType.newInstance();
                ppojo.load(id);
                if (parent != null) {
                    for (FieldInterfaced f : ReflectionHelper.getAllFields(ppojo.getClass())) {
                        if (!f.getType().equals(parent.getClass()) || !f.isAnnotationPresent(NotNull.class)) continue;
                        ReflectionHelper.setValue((FieldInterfaced)f, (Object)ppojo, (Object)parent);
                        break;
                    }
                }
                this.setModel(ppojo);
            } else {
                if (parent != null) {
                    for (FieldInterfaced f : ReflectionHelper.getAllFields(id.getClass())) {
                        if (!f.getType().equals(parent.getClass()) || !f.isAnnotationPresent(NotNull.class)) continue;
                        ReflectionHelper.setValue((FieldInterfaced)f, (Object)id, (Object)parent);
                        break;
                    }
                }
                this.setModel(id);
            }
        }
    }

    private void create(Class type, Object parent) throws Throwable {
        Constructor con;
        Constructor constructor = con = parent != null ? ReflectionHelper.getConstructor((Class)type, parent.getClass()) : ReflectionHelper.getConstructor((Class)type);
        if (con != null && con.getParameterCount() > 0) {
            VaadinHelper.fill(this, "I need some data", con, i -> {
                try {
                    this.setModel(i);
                }
                catch (Throwable e) {
                    Notifier.alert((Throwable)e);
                }
                MateuUI.closeWindow(false);
            }, () -> io.mateu.mdd.core.ui.MDDUIAccessor.goBack());
        } else {
            this.setModel(ReflectionHelper.newInstance((Class)type, (Object)parent));
        }
    }

    public void load(Object id) throws Throwable {
        this.load(id, null, null);
    }

    public void rebuildActions() {
        this.markAllAsUnseen();
        this.addViewActionsMenuItems(this.bar);
        this.removeUnseen();
        this.updateActions();
    }

    public void clear() {
        log.debug("*********CLEAR PANEL***********");
        if (this.panel != null) {
            this.panel.setContent(null);
        }
    }

    public void onGoBack() {
        if (this.binder != null) {
            for (EditorListener l : this.listeners) {
                l.onGoBack(this.binder.getBean());
            }
        }
    }

    public void goBack() {
        io.mateu.mdd.core.ui.MDDUIAccessor.goBack();
    }

    public void setCreatorWindow(BindedWindow creatorWindow) {
        this.creatorWindow = creatorWindow;
    }
}

