/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.vaadin.components.views;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.vaadin.icons.VaadinIcons;
import io.mateu.mdd.core.MDD;
import io.mateu.mdd.core.app.AbstractAction;
import io.mateu.mdd.core.app.MDDRunnableAction;
import io.mateu.mdd.core.ui.MDDUIAccessor;
import io.mateu.mdd.shared.annotations.Action;
import io.mateu.mdd.shared.reflection.CoreReflectionHelper;
import io.mateu.mdd.vaadin.MateuUI;
import io.mateu.mdd.vaadin.components.views.EditorViewComponent;
import io.mateu.mdd.vaadin.data.MDDBinder;
import io.mateu.mdd.vaadin.navigation.View;
import io.mateu.mdd.vaadin.navigation.ViewStack;
import io.mateu.reflection.ReflectionHelper;
import io.mateu.util.Helper;
import io.mateu.util.notification.Notifier;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import javassist.ClassPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodParametersViewComponent
extends EditorViewComponent {
    private static final Logger log = LoggerFactory.getLogger(MethodParametersViewComponent.class);
    private final Method method;
    private final Object bean;
    private final Set pendingSelection;
    private Class parametersType;
    private Object paremetersModel;

    @Override
    public VaadinIcons getIcon() {
        return VaadinIcons.FORM;
    }

    public MethodParametersViewComponent(Object bean, Method method, Set pendingSelection) throws Exception {
        super(ReflectionHelper.createClass((ClassPool)MDD.getClassPool(), MDDBinder.class, (ClassLoader)MDD.getClassPool().getClassLoader(), (String)("" + method.getDeclaringClass().getSimpleName() + "_" + method.getName() + "_Parameters000"), (List)ReflectionHelper.getAllFields((Method)method), (boolean)false));
        this.bean = bean;
        this.method = method;
        this.pendingSelection = pendingSelection;
        this.setModel(this.getModelType().newInstance());
    }

    @Override
    public String toString() {
        String t = Helper.capitalize((String)this.method.getName());
        if (this.method.isAnnotationPresent(Action.class) && !Strings.isNullOrEmpty((String)this.method.getAnnotation(Action.class).value())) {
            t = this.method.getAnnotation(Action.class).value();
        }
        return t;
    }

    @Override
    public List<AbstractAction> getActions() {
        return Lists.newArrayList((Object[])new AbstractAction[]{new MDDRunnableAction(this.toString()){

            public void run() {
                if (MethodParametersViewComponent.this.validate()) {
                    try {
                        Object r = CoreReflectionHelper.execute((Method)MethodParametersViewComponent.this.method, (Object)MethodParametersViewComponent.this.getBinder().getBean(), (Object)MethodParametersViewComponent.this.bean, (Set)MethodParametersViewComponent.this.pendingSelection);
                        if (MethodParametersViewComponent.this.bean != null && Void.TYPE.equals(MethodParametersViewComponent.this.method.getReturnType())) {
                            if (MethodParametersViewComponent.this.method.isAnnotationPresent(Action.class) && MethodParametersViewComponent.this.method.getAnnotation(Action.class).saveAfter()) {
                                View v;
                                ViewStack stack = MateuUI.get().getStack();
                                View view = v = stack.size() >= 2 ? stack.get(stack.size() - 2) : null;
                                if (v != null && v.getViewComponent() instanceof EditorViewComponent) {
                                    ((EditorViewComponent)v.getViewComponent()).save(false);
                                }
                            }
                        } else {
                            MDDUIAccessor.setPendingResult((Object)r);
                        }
                        if (r == null || Void.TYPE.equals(MethodParametersViewComponent.this.method.getReturnType())) {
                            Notifier.info((String)"Done");
                            MDDUIAccessor.goBack();
                        } else {
                            MDDUIAccessor.go((String)"result");
                        }
                    }
                    catch (Throwable e) {
                        Notifier.alert((Throwable)e);
                    }
                }
            }
        }.setIcon(VaadinIcons.BOLT)});
    }
}

