/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.vaadin.data;

import com.vaadin.data.Binder;
import com.vaadin.data.HasValue;
import com.vaadin.data.PropertyDefinition;
import com.vaadin.data.PropertySet;
import com.vaadin.data.ValueProvider;
import com.vaadin.server.Setter;
import io.mateu.mdd.shared.interfaces.IBinder;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.mdd.vaadin.components.views.AbstractViewComponent;
import io.mateu.mdd.vaadin.components.views.EditorViewComponent;
import io.mateu.reflection.FieldInterfacedFromField;
import io.mateu.reflection.ReflectionHelper;
import io.mateu.util.notification.Notifier;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

public class MDDBinder
extends Binder
implements IBinder {
    private AbstractViewComponent viewComponent;
    private final Class beanType;
    private boolean updating;

    public MDDBinder(final List<FieldInterfaced> fields) {
        super(new PropertySet(){
            private Map<String, PropertyDefinition> definitions;
            {
                this.definitions = MDDBinder.createDefinitions(this, fields);
            }

            public Stream<PropertyDefinition> getProperties() {
                return this.definitions.values().stream();
            }

            public Optional<PropertyDefinition> getProperty(String s) {
                return Optional.of(this.definitions.get(s));
            }
        });
        this.beanType = new HashMap().getClass();
    }

    public static Map<String, PropertyDefinition> createDefinitions(PropertySet propertySet, List<FieldInterfaced> fields) {
        HashMap<String, PropertyDefinition> defs = new HashMap<String, PropertyDefinition>();
        fields.forEach(f -> defs.put(f.getName(), new PropertyDefinition((FieldInterfaced)f, propertySet){
            private ValueProvider valueProvider = new ValueProvider(){

                public Object apply(Object o) {
                    try {
                        return ReflectionHelper.getValue((FieldInterfaced)val$f, (Object)o);
                    }
                    catch (Exception e) {
                        Notifier.alert((Throwable)e);
                        return null;
                    }
                }
            };
            final /* synthetic */ FieldInterfaced val$f;
            final /* synthetic */ PropertySet val$propertySet;
            {
                this.val$f = fieldInterfaced;
                this.val$propertySet = propertySet;
            }

            public ValueProvider getGetter() {
                return this.valueProvider;
            }

            public Optional<Setter> getSetter() {
                return Optional.of(new Setter(){

                    public void accept(Object o, Object v) {
                        try {
                            ReflectionHelper.setValue((FieldInterfaced)val$f, (Object)o, (Object)v);
                        }
                        catch (Exception e) {
                            Notifier.alert((Throwable)e);
                        }
                    }
                });
            }

            public Class getType() {
                if (Integer.TYPE.equals(this.val$f.getType())) {
                    return Integer.class;
                }
                if (Long.TYPE.equals(this.val$f.getType())) {
                    return Long.class;
                }
                if (Float.TYPE.equals(this.val$f.getType())) {
                    return Float.class;
                }
                if (Double.TYPE.equals(this.val$f.getType())) {
                    return Double.class;
                }
                if (Boolean.TYPE.equals(this.val$f.getType())) {
                    return Boolean.class;
                }
                return this.val$f.getType();
            }

            public Class<?> getPropertyHolderType() {
                return this.val$f.getDeclaringClass();
            }

            public String getName() {
                return this.val$f.getName();
            }

            public String getCaption() {
                return ReflectionHelper.getCaption((FieldInterfaced)this.val$f);
            }

            public PropertySet getPropertySet() {
                return this.val$propertySet;
            }
        }));
        return defs;
    }

    public MDDBinder(Class beanType) {
        super(beanType);
        this.beanType = beanType;
    }

    public MDDBinder(Class beanType, EditorViewComponent component) {
        super(beanType);
        this.beanType = beanType;
        this.viewComponent = component;
    }

    public AbstractViewComponent getViewComponent() {
        return this.viewComponent;
    }

    public void setViewComponent(AbstractViewComponent viewComponent) {
        this.viewComponent = viewComponent;
    }

    public void setBean(Object bean) {
        this.setBean(bean, true);
    }

    public void setBean(Object bean, boolean reset) {
        super.setBean(bean);
    }

    public Class getBeanType() {
        return this.beanType;
    }

    public void refresh() {
        this.setBean(this.getBean(), false);
    }

    public void update(Object model) {
        if (!this.updating) {
            this.updating = true;
            if (model != null) {
                this.getBindings().forEach(b -> ((Binder.Binding)b).read(model));
                Field v = ReflectionHelper.getVersionField(model.getClass());
                if (v != null) {
                    try {
                        v.setAccessible(true);
                        v.set(this.getBean(), v.get(model));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                for (FieldInterfaced f2 : ReflectionHelper.getAllFields(model.getClass())) {
                    if (!(f2 instanceof FieldInterfacedFromField)) continue;
                    try {
                        f2.getField().setAccessible(true);
                        f2.getField().set(this.getBean(), f2.getField().get(model));
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                this.getFields().forEach(f -> {
                    HasValue hv = (HasValue)f;
                    hv.setValue(null);
                });
            }
            this.updating = false;
        }
    }

    public Optional<Binder.Binding> getFieldBinding(HasValue hv) {
        return this.getBindings().stream().filter(b -> ((Binder.Binding)b).getField() == hv).findFirst();
    }
}

