/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.vaadin.navigation;

import com.vaadin.ui.Component;
import com.vaadin.ui.UI;
import com.vaadin.ui.Window;
import io.mateu.mdd.core.ui.MDDUIAccessor;
import io.mateu.mdd.vaadin.components.views.AbstractViewComponent;
import io.mateu.mdd.vaadin.components.views.EditorViewComponent;
import io.mateu.mdd.vaadin.components.views.ListViewComponent;
import io.mateu.mdd.vaadin.components.views.RpcListViewComponent;
import io.mateu.mdd.vaadin.controllers.Controller;
import io.mateu.mdd.vaadin.navigation.View;
import io.mateu.reflection.ReflectionHelper;
import io.mateu.util.notification.Notifier;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ViewStack {
    private List<View> stack = new ArrayList<View>();
    private Map<String, View> viewByState = new HashMap<String, View>();
    private Map<View, String> stateByView = new HashMap<View, String>();

    public int size() {
        return this.stack.size();
    }

    public Map<View, String> getStateByView() {
        return this.stateByView;
    }

    public Map<String, View> getViewByState() {
        return this.viewByState;
    }

    public View push(String state, Component component, Controller c) throws Exception {
        if (component != null && component instanceof AbstractViewComponent) {
            Class<?> cl;
            Method m;
            RpcListViewComponent rlvc;
            String t = null;
            if (component instanceof ListViewComponent) {
                ((ListViewComponent)component).setBaseUrl(state);
            }
            if (component instanceof RpcListViewComponent && (rlvc = (RpcListViewComponent)component).getRpcListView() != null && (m = ReflectionHelper.getMethod(cl = rlvc.getRpcListView().getClass(), (String)"toString")) != null && !Object.class.equals(m.getDeclaringClass())) {
                t = "" + rlvc.getRpcListView();
            }
            if (MDDUIAccessor.getApp().getMenu(state) != null) {
                t = MDDUIAccessor.getApp().getMenu(state).getCaption();
            }
            if (t != null) {
                ((AbstractViewComponent)component).setTitle(t);
            }
            if (this.stack.size() > 0 && this.stack.get(this.stack.size() - 1).getViewComponent() instanceof AbstractViewComponent) {
                ((AbstractViewComponent)component).setParentView(this.stack.get(this.stack.size() - 1).getViewComponent());
            }
        }
        View v = new View(this, component);
        this.push(state, v, c);
        return v;
    }

    public View push(String state, View v, Controller c) throws Exception {
        String cleanState = ViewStack.cleanState(state);
        boolean yaAbierto = false;
        if (v.getViewComponent() instanceof EditorViewComponent) {
            if (((EditorViewComponent)v.getViewComponent()).getModel() != null) {
                yaAbierto = this.stack.stream().anyMatch(w -> w.getViewComponent() instanceof EditorViewComponent && ((EditorViewComponent)w.getViewComponent()).getModel() != null && ((EditorViewComponent)w.getViewComponent()).getModel().equals(((EditorViewComponent)v.getViewComponent()).getModel()));
            }
        } else if (v.getViewComponent() instanceof ListViewComponent) {
            ((ListViewComponent)v.getViewComponent()).setBaseUrl(state);
        }
        if (yaAbierto) {
            throw new Exception("You are already editing " + v.getViewComponent().getPageTitle());
        }
        if (this.viewByState.containsKey(cleanState)) {
            View x = this.viewByState.remove(cleanState);
            this.stateByView.remove(x);
            this.stack.remove(x);
        }
        this.viewByState.put(cleanState, v);
        this.stateByView.put(v, cleanState);
        v.setController(c);
        this.stack.add(v);
        return v;
    }

    public com.vaadin.navigator.View pop() {
        return this.pop(1);
    }

    public com.vaadin.navigator.View pop(int positions) {
        com.vaadin.navigator.View r = null;
        if (positions <= this.stack.size()) {
            int index = this.stack.size() - positions;
            if (index < 0) {
                index = 0;
            }
            while (index < this.stack.size()) {
                com.vaadin.navigator.View v = r = (com.vaadin.navigator.View)this.stack.remove(this.stack.size() - 1);
                String state = this.stateByView.remove(v);
                this.viewByState.remove(state);
                if (this.viewByState.size() != this.stateByView.size()) {
                    List<String> missedStates = this.viewByState.keySet().stream().filter(k -> !this.stateByView.values().contains(k)).collect(Collectors.toList());
                    List<View> missedViews = this.stateByView.keySet().stream().filter(k -> !this.viewByState.values().contains(k)).collect(Collectors.toList());
                    missedStates.forEach(k -> this.viewByState.remove(k));
                    missedViews.forEach(k -> this.stateByView.remove(k));
                }
                if (this.viewByState.size() != this.stateByView.size()) {
                    Notifier.alert((String)("stateByView.size()=" + this.stateByView.size() + ", viewByState.size()=" + this.viewByState.size()));
                }
                if (!(v instanceof View) || ((View)v).getWindowContainer() == null) continue;
                Window w = ((View)v).getWindowContainer();
                if (this.stack.size() <= 0 || w.equals((Object)this.getLast().getWindowContainer())) continue;
                w.setData((Object)"noback");
                w.close();
            }
        }
        return r;
    }

    public View getLast() {
        int pos = this.stack.size() - 1;
        return pos >= 0 ? this.stack.get(pos) : null;
    }

    public View getParent(com.vaadin.navigator.View view) {
        int pos = this.stack.indexOf(view);
        return pos > 0 ? this.stack.get(pos - 1) : null;
    }

    public void popTo(int index) {
        this.pop(this.stack.size() - (index + 1));
    }

    public int getStackSize() {
        return this.stack.size();
    }

    public View getViewInStack(int pos) {
        return this.stack.get(pos);
    }

    public View get(int index) {
        return this.stack.get(index);
    }

    public View get(String state) {
        return this.viewByState.get(ViewStack.cleanState(state));
    }

    public int indexOf(com.vaadin.navigator.View v) {
        return this.stack.indexOf(v);
    }

    public String getState(com.vaadin.navigator.View v) {
        return v != null ? this.stateByView.get(v) : "";
    }

    public void clear() {
        this.stack = new ArrayList<View>();
        this.viewByState = new HashMap<String, View>();
        this.stateByView = new HashMap<View, String>();
        if (UI.getCurrent() != null) {
            UI.getCurrent().getWindows().forEach(w -> {
                w.setData((Object)"noback");
                w.close();
            });
        }
    }

    public List<View> getStack() {
        return this.stack;
    }

    public com.vaadin.navigator.View getLastNavigable() {
        View firstInWindow = this.stack.stream().filter(v -> v.getWindowContainer() != null).findFirst().orElse(null);
        View last = this.getLast();
        if (firstInWindow != null) {
            int pos = this.stack.indexOf(firstInWindow);
            last = this.stack.get(pos - 1);
        }
        return last;
    }

    public com.vaadin.navigator.View popTo(String state) {
        String cleanState = ViewStack.cleanState(state);
        com.vaadin.navigator.View v = null;
        while (v == null && this.stack.size() > 0) {
            com.vaadin.navigator.View r = this.stack.get(this.stack.size() - 1);
            if (cleanState.equals(this.getState(r))) {
                v = r;
                break;
            }
            this.pop();
        }
        return v;
    }

    public static String cleanState(String state) {
        String s = "";
        for (String t : state.split("/")) {
            if (!"".equals(s)) {
                s = s + "/";
            }
            s = s + (t.contains("&") ? t.substring(0, t.indexOf("&")) : t);
        }
        return s;
    }
}

