/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.security.web;

import freemarker.template.TemplateException;
import io.mateu.mdd.shared.interfaces.UserPrincipal;
import io.mateu.security.MateuSecurityManager;
import io.mateu.util.Helper;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

@WebFilter(value={"/zzz/private/*"})
public class MateuSecurityFilter
implements Filter {
    String byeFreemark = "Not initialized. Surely /security/bye.html was not found in the classpath.";
    String errorFreemark = "Not initialized. Surely /security/error.html was not found in the classpath.";
    String loginFormFreemark = "Not initialized. Surely /security/loginForm.html was not found in the classpath.";
    String recoverPasswordFormFreemark = "Not initialized. Surely /security/recoverPasswordForm.html was not found in the classpath.";
    String initializationErrorMsg;
    private ServletContext context;
    private MateuSecurityManager securityManager;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.context = filterConfig.getServletContext();
        try {
            this.securityManager = (MateuSecurityManager)Helper.getImpl(MateuSecurityManager.class);
            this.loginFormFreemark = Helper.leerFichero((InputStream)this.getClass().getResourceAsStream("/security/loginForm.html"));
            this.byeFreemark = Helper.leerFichero((InputStream)this.getClass().getResourceAsStream("/security/bye.html"));
            this.errorFreemark = Helper.leerFichero((InputStream)this.getClass().getResourceAsStream("/security/error.html"));
            this.recoverPasswordFormFreemark = Helper.leerFichero((InputStream)this.getClass().getResourceAsStream("/security/recoverPasswordForm.html"));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.initializationErrorMsg = Helper.toString((Throwable)e);
            this.context.log("MateuSecurityFilter initialization error", (Throwable)e);
        }
        this.context.log("MateuSecurityFilter initialized");
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)servletRequest;
        HttpServletResponse res = (HttpServletResponse)servletResponse;
        try {
            if (this.securityManager == null) {
                filterChain.doFilter((ServletRequest)req, (ServletResponse)res);
            } else {
                if (this.initializationErrorMsg != null) {
                    this.print(res, this.initializationErrorMsg);
                }
                String uri = req.getRequestURI();
                this.context.log("Requested Resource::" + uri);
                HttpSession session = req.getSession(false);
                if (uri.endsWith("private/logout")) {
                    session.invalidate();
                    res.sendRedirect("bye");
                } else if (uri.endsWith("private/bye")) {
                    this.showBye(req, res);
                } else if (uri.contains("/oauth/github/callback") || uri.contains("/oauth/google/callback") || uri.contains("/oauth/microsoft/callback")) {
                    UserPrincipal p = null;
                    if (uri.contains("/oauth/github/callback")) {
                        p = this.securityManager.getUserDataFromGitHubCode(req);
                    }
                    if (uri.contains("/oauth/google/callback")) {
                        p = this.securityManager.getUserDataFromGoogleCode(req);
                    }
                    if (uri.contains("/oauth/microsoft/callback")) {
                        p = this.securityManager.getUserDataFromMicrosoftCode(req);
                    }
                    if (p != null) {
                        req.getSession().setAttribute("__user", (Object)p);
                    }
                    res.sendRedirect(session.getAttribute("__originalUrl") != null ? "" + session.getAttribute("__originalUrl") : "/");
                } else if (session == null || this.securityManager.getPrincipal(session) == null) {
                    if (uri.endsWith("private/authenticate")) {
                        this.authenticate(req, res);
                    } else if (uri.endsWith("private/recoverPassword")) {
                        this.recoverPassword(req, res);
                    } else if (uri.endsWith("private/passwordForgotten")) {
                        this.showRecoverPasswordForm(req, res);
                    } else {
                        this.context.log("Unauthorized access request");
                        req.getSession().setAttribute("__originalUrl", (Object)req.getRequestURL().toString());
                        this.showLoginForm(req, res);
                    }
                } else if (uri.endsWith("private/logout")) {
                    session.invalidate();
                    res.sendRedirect("bye");
                } else {
                    filterChain.doFilter((ServletRequest)req, (ServletResponse)res);
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.showError(req, res, e.getMessage());
        }
    }

    private void showError(HttpServletRequest req, HttpServletResponse res, String msg) throws IOException {
        String html = null;
        try {
            Map<String, Object> props = this.getLoginFormProperties(req);
            props.put("msg", msg);
            html = Helper.freemark((String)this.errorFreemark, props);
        }
        catch (TemplateException | IOException e) {
            e.printStackTrace();
            html = Helper.toString((Throwable)e);
        }
        this.print(res, html);
    }

    private void showBye(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String html = null;
        try {
            html = Helper.freemark((String)this.byeFreemark, this.getLoginFormProperties(req));
        }
        catch (TemplateException e) {
            e.printStackTrace();
            html = Helper.toString((Throwable)e);
        }
        this.print(res, html);
    }

    private Map<String, Object> getByeProperties() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("hasFavicon", this.securityManager.hasFavicon());
        if (this.securityManager.hasFavicon()) {
            m.put("favIcon", this.securityManager.getFavicon());
            m.put("favIcon", this.getFaviconType(this.securityManager.getFavicon()));
        }
        m.put("byeMessage", this.securityManager.getByeMessage());
        m.put("byeInfo", this.securityManager.getByeInfo());
        return m;
    }

    private void showRecoverPasswordForm(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String html = null;
        try {
            html = Helper.freemark((String)this.recoverPasswordFormFreemark, this.getLoginFormProperties(req));
        }
        catch (TemplateException e) {
            e.printStackTrace();
            html = Helper.toString((Throwable)e);
        }
        this.print(res, html);
    }

    private void showLoginForm(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String html = null;
        try {
            html = Helper.freemark((String)this.loginFormFreemark, this.getLoginFormProperties(req));
        }
        catch (TemplateException e) {
            e.printStackTrace();
            html = Helper.toString((Throwable)e);
        }
        this.print(res, html);
    }

    private Map<String, Object> getLoginFormProperties(HttpServletRequest req) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        String callbackUrl = req.getRequestURL().toString();
        if (!(callbackUrl = callbackUrl.substring(0, callbackUrl.indexOf("private") + "private".length())).endsWith("/")) {
            callbackUrl = callbackUrl + "/";
        }
        m.put("baseUrl", callbackUrl);
        m.put("welcomeMessage", this.securityManager.getWelcomeMessage() != null ? this.securityManager.getWelcomeMessage() : "Welcome!");
        m.put("welcomeInfo", this.securityManager.getWelcomeInfo() != null ? this.securityManager.getWelcomeInfo() : "Please login");
        m.put("hasFavicon", this.securityManager.hasFavicon());
        if (this.securityManager.hasFavicon()) {
            m.put("favIcon", this.securityManager.getFavicon());
            m.put("favIcon", this.getFaviconType(this.securityManager.getFavicon()));
        }
        m.put("hasLogo", this.securityManager.hasLogo());
        m.put("logo", this.securityManager.getLogo());
        m.put("login", this.securityManager.isLoginSupported());
        m.put("hasRegistration", this.securityManager.getRegistrationUrl() != null);
        m.put("registrationUrl", this.securityManager.getRegistrationUrl());
        m.put("passwordForgottenUrl", this.securityManager.getForgotternPasswordUrl() != null ? this.securityManager.getForgotternPasswordUrl() : callbackUrl + "passwordForgotten");
        m.put("github", this.securityManager.getGithubClientId() != null && this.securityManager.getGithubClientSecret() != null);
        if (this.securityManager.getGithubClientId() != null && this.securityManager.getGithubClientSecret() != null) {
            m.put("githubUrl", "https://github.com/login/oauth/authorize?client_id=" + this.securityManager.getGithubClientId());
        }
        m.put("google", this.securityManager.getGoogleClientId() != null && this.securityManager.getGoogleClientSecret() != null);
        if (this.securityManager.getGoogleClientId() != null && this.securityManager.getGoogleClientSecret() != null) {
            try {
                m.put("googleUrl", "https://accounts.google.com/o/oauth2/v2/auth?response_type=code&client_id=" + this.securityManager.getGoogleClientId() + "&redirect_uri=" + URLEncoder.encode(callbackUrl + "oauth/google/callback", "iso-8859-1") + "&scope=" + URLEncoder.encode("https://www.googleapis.com/auth/userinfo.email https://www.googleapis.com/auth/userinfo.profile", "iso-8859-1"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        m.put("microsoft", this.securityManager.getMicrosoftClientId() != null && this.securityManager.getMicrosoftClientSecret() != null);
        if (this.securityManager.getMicrosoftClientId() != null && this.securityManager.getMicrosoftClientSecret() != null) {
            try {
                m.put("microsoftUrl", "https://login.microsoftonline.com/common/oauth2/authorize?response_type=code&client_id=" + this.securityManager.getMicrosoftClientId() + "&redirect_uri=" + URLEncoder.encode(callbackUrl + "oauth/microsoft/callback", "iso-8859-1") + "&scope=" + URLEncoder.encode("email profile openid", "iso-8859-1"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return m;
    }

    private String getFaviconType(String favIcon) {
        if (favIcon.toLowerCase().endsWith("png")) {
            return "image/png";
        }
        if (favIcon.toLowerCase().endsWith("ico")) {
            return "image/vnd.microsoft.icon";
        }
        if (favIcon.toLowerCase().endsWith("gif")) {
            return "image/gif";
        }
        if (favIcon.toLowerCase().endsWith("svg")) {
            return "image/svg+xml";
        }
        return "";
    }

    private void recoverPassword(HttpServletRequest req, HttpServletResponse res) throws IOException {
        String login = req.getParameter("login");
        String password = req.getParameter("password");
        String msg = "";
        boolean valid = false;
        if (this.securityManager == null) {
            msg = "No MateuSecurityManager implementation found.";
        } else {
            try {
                msg = this.securityManager.recoverPassword(req.getSession(), login);
                valid = true;
            }
            catch (Throwable throwable) {
                msg = throwable.getMessage();
            }
        }
        String json = "{\"msg\": \"" + msg.replaceAll("\"", "\\\"") + "\", \"valid\": " + valid + "}";
        this.print(res, "application/json", json);
    }

    private void authenticate(HttpServletRequest req, HttpServletResponse res) throws IOException {
        String login = req.getParameter("login");
        String password = req.getParameter("password");
        String msg = "";
        boolean valid = false;
        if (this.securityManager == null) {
            msg = "No MateuSecurityManager implementation found.";
        } else {
            try {
                UserPrincipal p = this.securityManager.validate(req.getSession(), login, password);
                boolean bl = valid = p != null;
                if (valid) {
                    req.getSession().setAttribute("__user", (Object)p);
                }
                msg = valid ? "Credentials are valid" : "Invalid credentials";
            }
            catch (Throwable throwable) {
                msg = throwable.getMessage();
            }
        }
        String json = "{\"msg\": \"" + msg.replaceAll("\"", "\\\"") + "\", \"valid\": " + valid + "}";
        this.print(res, "application/json", json);
    }

    private void print(HttpServletResponse res, String body) throws IOException {
        this.print(res, "text/html", body);
    }

    private void print(HttpServletResponse res, String contentType, String body) throws IOException {
        res.setContentType("text/html");
        if (body == null) {
            body = "";
        }
        res.setContentLength(body.length());
        res.getWriter().print(body);
    }

    public void destroy() {
    }
}

