/*
 * Decompiled with CFR 0.152.
 */
package io.mats3;

import io.mats3.MatsConfig;
import io.mats3.MatsEndpoint;
import io.mats3.MatsInitiator;
import io.mats3.MatsStage;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

public interface MatsFactory
extends MatsConfig.StartStoppable {
    public static final Consumer<MatsConfig> NO_CONFIG = config -> {};

    public FactoryConfig getFactoryConfig();

    public <R, S> MatsEndpoint<R, S> staged(String var1, Class<R> var2, Class<S> var3);

    public <R, S> MatsEndpoint<R, S> staged(String var1, Class<R> var2, Class<S> var3, Consumer<? super MatsEndpoint.EndpointConfig<R, S>> var4);

    public <R, I> MatsEndpoint<R, Void> single(String var1, Class<R> var2, Class<I> var3, MatsEndpoint.ProcessSingleLambda<R, I> var4);

    public <R, I> MatsEndpoint<R, Void> single(String var1, Class<R> var2, Class<I> var3, Consumer<? super MatsEndpoint.EndpointConfig<R, Void>> var4, Consumer<? super MatsStage.StageConfig<R, Void, I>> var5, MatsEndpoint.ProcessSingleLambda<R, I> var6);

    public <S, I> MatsEndpoint<Void, S> terminator(String var1, Class<S> var2, Class<I> var3, MatsEndpoint.ProcessTerminatorLambda<S, I> var4);

    public <S, I> MatsEndpoint<Void, S> terminator(String var1, Class<S> var2, Class<I> var3, Consumer<? super MatsEndpoint.EndpointConfig<Void, S>> var4, Consumer<? super MatsStage.StageConfig<Void, S, I>> var5, MatsEndpoint.ProcessTerminatorLambda<S, I> var6);

    public <S, I> MatsEndpoint<Void, S> subscriptionTerminator(String var1, Class<S> var2, Class<I> var3, MatsEndpoint.ProcessTerminatorLambda<S, I> var4);

    public <S, I> MatsEndpoint<Void, S> subscriptionTerminator(String var1, Class<S> var2, Class<I> var3, Consumer<? super MatsEndpoint.EndpointConfig<Void, S>> var4, Consumer<? super MatsStage.StageConfig<Void, S, I>> var5, MatsEndpoint.ProcessTerminatorLambda<S, I> var6);

    public List<MatsEndpoint<?, ?>> getEndpoints();

    public Optional<MatsEndpoint<?, ?>> getEndpoint(String var1);

    public MatsInitiator getDefaultInitiator();

    public MatsInitiator getOrCreateInitiator(String var1);

    public List<MatsInitiator> getInitiators();

    @Override
    public void start();

    public void holdEndpointsUntilFactoryIsStarted();

    @Override
    public boolean waitForReceiving(int var1);

    @Override
    public boolean stop(int var1);

    default public void close() {
        this.stop(30000);
    }

    default public <I> I unwrapTo(Class<I> iface) {
        if (iface == null) {
            throw new NullPointerException("iface");
        }
        if (iface.isAssignableFrom(this.getClass())) {
            return (I)this;
        }
        throw new IllegalArgumentException("This [" + this + "] doesn't implement [" + iface + "].");
    }

    default public MatsFactory unwrapFully() {
        return this;
    }

    public static class MatsFactoryWrapper
    implements MatsWrapper<MatsFactory>,
    MatsFactory {
        private MatsFactory _targetMatsFactory;

        public MatsFactoryWrapper(MatsFactory targetMatsFactory) {
            this.setWrappee(targetMatsFactory);
        }

        public MatsFactoryWrapper() {
        }

        @Override
        public void setWrappee(MatsFactory targetMatsFactory) {
            this._targetMatsFactory = targetMatsFactory;
        }

        @Override
        public MatsFactory unwrap() {
            if (this._targetMatsFactory == null) {
                throw new IllegalStateException("MatsFactory.MatsFactoryWrapper.unwrap(): The '_targetMatsFactory' is not set!");
            }
            return this._targetMatsFactory;
        }

        @Override
        public <I> I unwrapTo(Class<I> iface) {
            return MatsWrapper.super.unwrapTo(iface);
        }

        @Override
        public MatsFactory unwrapFully() {
            return this.unwrap().unwrapFully();
        }

        @Override
        public FactoryConfig getFactoryConfig() {
            return this.unwrap().getFactoryConfig();
        }

        @Override
        public <R, S> MatsEndpoint<R, S> staged(String endpointId, Class<R> replyClass, Class<S> stateClass) {
            return this.unwrap().staged(endpointId, replyClass, stateClass);
        }

        @Override
        public <R, S> MatsEndpoint<R, S> staged(String endpointId, Class<R> replyClass, Class<S> stateClass, Consumer<? super MatsEndpoint.EndpointConfig<R, S>> endpointConfigLambda) {
            return this.unwrap().staged(endpointId, replyClass, stateClass, endpointConfigLambda);
        }

        @Override
        public <R, I> MatsEndpoint<R, Void> single(String endpointId, Class<R> replyClass, Class<I> incomingClass, MatsEndpoint.ProcessSingleLambda<R, I> processor) {
            return this.unwrap().single(endpointId, replyClass, incomingClass, processor);
        }

        @Override
        public <R, I> MatsEndpoint<R, Void> single(String endpointId, Class<R> replyClass, Class<I> incomingClass, Consumer<? super MatsEndpoint.EndpointConfig<R, Void>> endpointConfigLambda, Consumer<? super MatsStage.StageConfig<R, Void, I>> stageConfigLambda, MatsEndpoint.ProcessSingleLambda<R, I> processor) {
            return this.unwrap().single(endpointId, replyClass, incomingClass, endpointConfigLambda, stageConfigLambda, processor);
        }

        @Override
        public <S, I> MatsEndpoint<Void, S> terminator(String endpointId, Class<S> stateClass, Class<I> incomingClass, MatsEndpoint.ProcessTerminatorLambda<S, I> processor) {
            return this.unwrap().terminator(endpointId, stateClass, incomingClass, processor);
        }

        @Override
        public <S, I> MatsEndpoint<Void, S> terminator(String endpointId, Class<S> stateClass, Class<I> incomingClass, Consumer<? super MatsEndpoint.EndpointConfig<Void, S>> endpointConfigLambda, Consumer<? super MatsStage.StageConfig<Void, S, I>> stageConfigLambda, MatsEndpoint.ProcessTerminatorLambda<S, I> processor) {
            return this.unwrap().terminator(endpointId, stateClass, incomingClass, endpointConfigLambda, stageConfigLambda, processor);
        }

        @Override
        public <S, I> MatsEndpoint<Void, S> subscriptionTerminator(String endpointId, Class<S> stateClass, Class<I> incomingClass, MatsEndpoint.ProcessTerminatorLambda<S, I> processor) {
            return this.unwrap().subscriptionTerminator(endpointId, stateClass, incomingClass, processor);
        }

        @Override
        public <S, I> MatsEndpoint<Void, S> subscriptionTerminator(String endpointId, Class<S> stateClass, Class<I> incomingClass, Consumer<? super MatsEndpoint.EndpointConfig<Void, S>> endpointConfigLambda, Consumer<? super MatsStage.StageConfig<Void, S, I>> stageConfigLambda, MatsEndpoint.ProcessTerminatorLambda<S, I> processor) {
            return this.unwrap().subscriptionTerminator(endpointId, stateClass, incomingClass, endpointConfigLambda, stageConfigLambda, processor);
        }

        @Override
        public List<MatsEndpoint<?, ?>> getEndpoints() {
            return this.unwrap().getEndpoints();
        }

        @Override
        public Optional<MatsEndpoint<?, ?>> getEndpoint(String endpointId) {
            return this.unwrap().getEndpoint(endpointId);
        }

        @Override
        public MatsInitiator getDefaultInitiator() {
            return this.unwrap().getDefaultInitiator();
        }

        @Override
        public MatsInitiator getOrCreateInitiator(String name) {
            return this.unwrap().getOrCreateInitiator(name);
        }

        @Override
        public List<MatsInitiator> getInitiators() {
            return this.unwrap().getInitiators();
        }

        @Override
        public void holdEndpointsUntilFactoryIsStarted() {
            this.unwrap().holdEndpointsUntilFactoryIsStarted();
        }

        @Override
        public void start() {
            this.unwrap().start();
        }

        @Override
        public boolean waitForReceiving(int timeoutMillis) {
            return this.unwrap().waitForReceiving(timeoutMillis);
        }

        @Override
        public boolean stop(int gracefulShutdownMillis) {
            return this.unwrap().stop(gracefulShutdownMillis);
        }

        public int hashCode() {
            return this.unwrap().hashCode();
        }

        public boolean equals(Object obj) {
            return this.unwrap().equals(obj);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this.unwrap().toString() + "]";
        }
    }

    public static interface MatsWrapper<T> {
        public void setWrappee(T var1);

        public T unwrap();

        default public <I> I unwrapTo(Class<I> iface) {
            if (iface == null) {
                throw new NullPointerException("iface");
            }
            if (iface.isAssignableFrom(this.getClass())) {
                return (I)this;
            }
            T unwrapped = this.unwrap();
            if (iface.isAssignableFrom(unwrapped.getClass())) {
                return (I)unwrapped;
            }
            if (unwrapped instanceof MatsWrapper) {
                return ((MatsWrapper)unwrapped).unwrapTo(iface);
            }
            throw new IllegalArgumentException("This [" + this + "] doesn't implement [" + iface + "], and neither do the wrappee [" + unwrapped + "].");
        }

        default public T unwrapFully() {
            T target = this.unwrap();
            if (target instanceof MatsWrapper) {
                MatsWrapper wrapped = (MatsWrapper)target;
                return wrapped.unwrapFully();
            }
            return target;
        }
    }

    public static interface MatsPlugin {
        default public void start(MatsFactory matsFactory) {
        }

        default public void addingInitiator(MatsInitiator initiator) {
        }

        default public void addingEndpoint(MatsEndpoint<?, ?> endpoint) {
        }

        default public void removedEndpoint(MatsEndpoint<?, ?> endpoint) {
        }

        default public void preStop() {
        }

        default public void stop() {
        }
    }

    public static interface FactoryConfig
    extends MatsConfig {
        public FactoryConfig setName(String var1);

        public String getName();

        public int getNumberOfCpus();

        public FactoryConfig setInitiateTraceIdModifier(Function<String, String> var1);

        public FactoryConfig setMatsDestinationPrefix(String var1);

        public String getMatsDestinationPrefix();

        public FactoryConfig setMatsTraceKey(String var1);

        public String getMatsTraceKey();

        public String getAppName();

        public String getAppVersion();

        public String getSystemInformation();

        public FactoryConfig setNodename(String var1);

        public String getCommonEndpointGroupId();

        public FactoryConfig setCommonEndpointGroupId(String var1);

        public String getNodename();

        public String getMatsImplementationName();

        public String getMatsImplementationVersion();

        public <T> T instantiateNewObject(Class<T> var1);

        public FactoryConfig installPlugin(MatsPlugin var1) throws IllegalStateException;

        public <T extends MatsPlugin> List<T> getPlugins(Class<T> var1);

        public boolean removePlugin(MatsPlugin var1);

        @Override
        public FactoryConfig setAttribute(String var1, Object var2);

        @Override
        public FactoryConfig setConcurrency(int var1);

        @Override
        public FactoryConfig setInteractiveConcurrency(int var1);
    }

    public static class ContextLocal {
        private static volatile BiFunction<Class<?>, String[], Optional<?>> callback;

        public static <T> Optional<T> getAttribute(Class<T> type, String ... name) {
            return callback.apply(type, name);
        }
    }
}

