/*
 * Decompiled with CFR 0.152.
 */
package io.mats3.intercept.logging;

import io.mats3.MatsEndpoint;
import io.mats3.MatsFactory;
import io.mats3.api.intercept.CommonCompletedContext;
import io.mats3.api.intercept.MatsInitiateInterceptor;
import io.mats3.api.intercept.MatsLoggingInterceptor;
import io.mats3.api.intercept.MatsOutgoingMessage;
import io.mats3.api.intercept.MatsStageInterceptor;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class MatsMetricsLoggingInterceptor
implements MatsLoggingInterceptor,
MatsInitiateInterceptor,
MatsStageInterceptor {
    public static final String LOG_INIT_NAME = "io.mats3.log.init";
    public static final String LOG_STAGE_NAME = "io.mats3.log.stage";
    public static final int NUMBER_OF_MILLIS_BETWEEN_SUPPRESSION_LOG = 1800000;
    protected static final Logger log_init = LoggerFactory.getLogger((String)"io.mats3.log.init");
    protected static final Logger log_stage = LoggerFactory.getLogger((String)"io.mats3.log.stage");
    protected static final String SUPPRESS_LOGGING_INTERCEPT_CONTEXT_ATTRIBUTE = "suppressStageLogging";
    public static final String LOG_PREFIX = "#MATSLOG# ";
    public static final String SUPPRESSION_MDC_KEY_PARTS_SEPARATOR = ",";
    public static final String MDC_TRACE_ID = "traceId";
    public static final MatsMetricsLoggingInterceptor INSTANCE = new MatsMetricsLoggingInterceptor();
    public static final String MDC_MATS_VERSION = "mats.Version";
    public static final String MDC_INIT_OR_STAGE_ID = "mats.InitOrStageId";
    public static final String MDC_MATS_EXEC_TIME_TOTAL = "mats.exec.Total.ms";
    public static final String MDC_MATS_EXEC_TIME_USER_LAMBDA = "mats.exec.UserLambda.ms";
    public static final String MDC_MATS_EXEC_TIME_OUT = "mats.exec.Out.ms";
    public static final String MDC_MATS_EXEC_QUANTITY_OUT = "mats.exec.Out.quantity";
    public static final String MDC_MATS_EXEC_SIZE_OUT_TOTAL_WIRE = "mats.exec.Out.TotalWire.bytes";
    public static final String MDC_MATS_EXEC_TIME_DB_COMMIT = "mats.exec.DbCommit.ms";
    public static final String MDC_MATS_EXEC_TIME_MSGSYS_COMMIT = "mats.exec.MsgSysCommit.ms";
    public static final String MDC_MATS_EXEC_OPS_TIMING_PREFIX = "mats.exec.ops.time.";
    public static final String MDC_MATS_EXEC_OPS_MEASURE_PREFIX = "mats.exec.ops.measure.";
    public static final String MDC_MATS_EXEC_OPS_KEYNAME = "mats.exec.ops.key";
    public static final String MDC_MATS_EXEC_OPS_DESCRIPTION = "mats.exec.ops.description";
    public static final String MDC_MATS_INITIATE_COMPLETED = "mats.InitiateCompleted";
    public static final String MDC_MATS_MESSAGE_RECEIVED = "mats.MessageReceived";
    public static final String MDC_MATS_IN_DELIVERY_COUNT = "mats.in.DeliveryCount";
    public static final String MDC_MATS_IN_MATS_MESSAGE_ID = "mats.in.MatsMsgId";
    public static final String MDC_MATS_IN_MESSAGE_TYPE = "mats.in.MessageType";
    public static final String MDC_MATS_IN_FROM_APP_NAME = "mats.in.from.App";
    public static final String MDC_MATS_IN_FROM_ID = "mats.in.from.Id";
    public static final String MDC_MATS_IN_TIME_SINCE_SENT = "mats.in.SinceSent.ms";
    public static final String MDC_MATS_IN_TIME_SINCE_PRECEDING_ENDPOINT_STAGE = "mats.in.PrecedEpStage.ms";
    public static final String MDC_MATS_IN_SIZE_TOTAL_WIRE = "mats.in.TotalWire.bytes";
    public static final String MDC_MATS_IN_TIME_TOTAL_PREPROC_AND_DESERIAL = "mats.in.TotalPreprocDeserial.ms";
    public static final String MDC_MATS_IN_TIME_MSGSYS_DECONSTRUCT = "mats.in.MsgSysDeconstruct.ms";
    public static final String MDC_MATS_IN_SIZE_ENVELOPE_WIRE = "mats.in.EnvelopeWire.bytes";
    public static final String MDC_MATS_IN_TIME_ENVELOPE_DECOMPRESS = "mats.in.EnvelopeDecompress.ms";
    public static final String MDC_MATS_IN_SIZE_ENVELOPE_SERIAL = "mats.in.EnvelopeSerial.bytes";
    public static final String MDC_MATS_IN_TIME_ENVELOPE_DESERIAL = "mats.in.EnvelopeDeserial.ms";
    public static final String MDC_MATS_IN_TIME_DATA_AND_STATE_DESERIAL = "mats.in.DataAndStateDeserial.ms";
    public static final String MDC_MATS_IN_SIZE_STATE_SERIAL = "mats.in.StateSerial.bytes";
    public static final String MDC_MATS_IN_SIZE_DATA_SERIAL = "mats.in.DataSerial.bytes";
    public static final String MDC_MATS_STAGE_COMPLETED = "mats.StageCompleted";
    public static final String MDC_MATS_PROCESS_RESULT = "mats.ProcessResult";
    public static final String MDC_MATS_EXEC_TIME_TOTAL_PREPROC_AND_DESERIAL = "mats.exec.TotalPreprocDeserial.ms";
    public static final String MDC_MATS_EXEC_SIZE_IN_TOTAL_WIRE = "mats.exec.In.TotalWire.bytes";
    public static final String MDC_MATS_ENDPOINT_COMPLETED = "mats.EndpointCompleted";
    public static final String MDC_MATS_ENDPOINT_COMPLETE_TIME_TOTAL = "mats.endpoint.Total.ms";
    public static final String MDC_MATS_FLOW_COMPLETED = "mats.FlowCompleted";
    public static final String MDC_MATS_FLOW_COMPLETE_TIME_TOTAL = "mats.flow.Total.ms";
    public static final String MDC_MATS_MESSAGE_SENT = "mats.MessageSent";
    public static final String MDC_MATS_DISPATCH_TYPE = "mats.DispatchType";
    public static final String MDC_MATS_OUT_MATS_MESSAGE_ID = "mats.out.MatsMsgId";
    public static final String MDC_MATS_OUT_MESSAGE_SYSTEM_ID = "mats.out.MsgSysId";
    public static final String MDC_MATS_OUT_FROM_ID = "mats.out.from.Id";
    public static final String MDC_MATS_OUT_TO_ID = "mats.out.to.Id";
    public static final String MDC_MATS_OUT_TIME_TOTAL = "mats.out.Total.ms";
    public static final String MDC_MATS_OUT_SIZE_DATA_SERIAL = "mats.out.DataSerial.bytes";
    public static final String MDC_MATS_OUT_TIME_ENVELOPE_PRODUCE = "mats.out.EnvelopeProduce.ms";
    public static final String MDC_MATS_OUT_TIME_ENVELOPE_SERIAL = "mats.out.EnvelopeSerial.ms";
    public static final String MDC_MATS_OUT_SIZE_ENVELOPE_SERIAL = "mats.out.EnvelopeSerial.bytes";
    public static final String MDC_MATS_OUT_TIME_ENVELOPE_COMPRESS = "mats.out.EnvelopeCompress.ms";
    public static final String MDC_MATS_OUT_SIZE_ENVELOPE_WIRE = "mats.out.EnvelopeWire.bytes";
    public static final String MDC_MATS_OUT_SIZE_TOTAL_WIRE = "mats.out.TotalWire.bytes";
    public static final String MDC_MATS_OUT_TIME_MSGSYS = "mats.out.MsgSys.ms";
    public static final String MDC_MATS_INIT_APP = "mats.init.App";
    public static final String MDC_MATS_INIT_ID = "mats.init.Id";
    public static final String MDC_MATS_AUDIT = "mats.Audit";
    public static final String MDC_MATS_INTERACTIVE = "mats.Interactive";
    public static final String MDC_MATS_PERSISTENT = "mats.Persistent";
    protected final ConcurrentHashMap<String, AtomicInteger> _suppressions = new ConcurrentHashMap();

    public static void install(MatsFactory matsFactory) {
        matsFactory.getFactoryConfig().installPlugin((MatsFactory.MatsPlugin)INSTANCE);
    }

    public static void remove(MatsFactory matsFactory) {
        matsFactory.getFactoryConfig().removePlugin((MatsFactory.MatsPlugin)INSTANCE);
    }

    protected MatsMetricsLoggingInterceptor() {
        Thread suppressionSummarizerThread = new Thread(this::suppressionSummarizerThreadRunnable, "#MATSLOG#  Periodic Log Suppression summarizer");
        suppressionSummarizerThread.setDaemon(true);
        suppressionSummarizerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void suppressionSummarizerThreadRunnable() {
        while (true) {
            try {
                Thread.sleep(1800000L);
            }
            catch (InterruptedException e) {
                log_stage.info("#MATSLOG# Surprisingly, we were interrupted. Exiting.");
                return;
            }
            int suppressionSize = this._suppressions.size();
            if (suppressionSize > 500) {
                log_stage.error("#MATSLOG# NOTE!! THERE ARE WAY TOO MANY [" + suppressionSize + "] SUPPRESSION ENTRIES! This indicates that fromId (initiatorId) on initiations is set dynamically. You must fix this, or risk out of memory situations.");
            }
            if (suppressionSize == 0) continue;
            HashMap<String, Integer> suppressionsCopy = new HashMap<String, Integer>();
            Iterator<Map.Entry<String, AtomicInteger>> it = this._suppressions.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, AtomicInteger> entry = it.next();
                it.remove();
                suppressionsCopy.put(entry.getKey(), entry.getValue().get());
            }
            try {
                int totalSuppressed = 0;
                for (Map.Entry entry : suppressionsCopy.entrySet()) {
                    int count = (Integer)entry.getValue();
                    totalSuppressed += count;
                    MDC.put((String)((String)entry.getKey()), (String)Integer.toString((Integer)entry.getValue()));
                }
                log_stage.info("#MATSLOG#  Suppressed log entries! Total: [" + totalSuppressed + "], over [" + suppressionsCopy.size() + "] groups. Group counts are in MDC.");
                continue;
            }
            finally {
                MDC.clear();
                continue;
            }
            break;
        }
    }

    private boolean shouldSuppressInitLogging(List<MatsOutgoingMessage.MatsSentOutgoingMessage> outgoingMessages) {
        if (outgoingMessages.isEmpty()) {
            return false;
        }
        for (MatsOutgoingMessage.MatsSentOutgoingMessage outgoingMessage : outgoingMessages) {
            Object suppressed = outgoingMessage.getTraceProperty("mats.SuppressLogging", Object.class);
            if (suppressed == Boolean.TRUE) continue;
            return false;
        }
        return true;
    }

    public void initiateCompleted(MatsInitiateInterceptor.InitiateCompletedContext ctx) {
        boolean interactive;
        String firstMsgInitiatorId;
        List outgoingMessages = ctx.getOutgoingMessages();
        MatsFactory.FactoryConfig factoryConfig = ctx.getInitiator().getParentFactory().getFactoryConfig();
        if (this.shouldSuppressInitLogging(outgoingMessages)) {
            MatsOutgoingMessage.MatsSentOutgoingMessage outgoingMessage = (MatsOutgoingMessage.MatsSentOutgoingMessage)outgoingMessages.get(0);
            String suppressedId = "logsuppress:" + factoryConfig.getName() + SUPPRESSION_MDC_KEY_PARTS_SEPARATOR + outgoingMessage.getInitiatingAppName() + SUPPRESSION_MDC_KEY_PARTS_SEPARATOR + outgoingMessage.getInitiatorId() + ",INIT";
            int numberOfSuppressions = this._suppressions.computeIfAbsent(suppressedId, s -> new AtomicInteger(-1)).incrementAndGet();
            if (numberOfSuppressions > 0) {
                return;
            }
        }
        this.outputMeasurementsLoglines(log_init, (CommonCompletedContext)ctx);
        Map<String, String> completedMDC = Collections.singletonMap(MDC_MATS_INITIATE_COMPLETED, MatsMetricsLoggingInterceptor.msS(ctx.getTotalExecutionNanos()));
        String messageSenderName = factoryConfig.getName() + "|" + ctx.getInitiator().getName();
        String matsVersion = factoryConfig.getMatsImplementationVersion();
        if (outgoingMessages.isEmpty()) {
            firstMsgInitiatorId = "_no_outgoing_messages_";
            interactive = false;
        } else {
            MatsOutgoingMessage.MatsSentOutgoingMessage firstMessage = (MatsOutgoingMessage.MatsSentOutgoingMessage)outgoingMessages.get(0);
            firstMsgInitiatorId = firstMessage.getInitiatorId();
            interactive = firstMessage.isInteractive();
        }
        String initiatingAppName = factoryConfig.getAppName();
        this.commonStageAndInitiateCompleted((CommonCompletedContext)ctx, matsVersion, firstMsgInitiatorId, initiatingAppName, firstMsgInitiatorId, interactive, ctx.getInitiateProcessResult(), log_init, outgoingMessages, messageSenderName, "", 0L, completedMDC);
    }

    protected boolean shouldSuppressStageLogging(MatsStageInterceptor.StageCommonContext ctx) {
        Object suppressionAllowed = ctx.getStage().getParentEndpoint().getEndpointConfig().getAttribute("mats.SuppressLoggingAllowed");
        if (suppressionAllowed == Boolean.TRUE) {
            Object suppressed = ctx.getProcessContext().getTraceProperty("mats.SuppressLogging", Object.class);
            return suppressed == Boolean.TRUE;
        }
        return false;
    }

    public void stagePreprocessAndDeserializeError(MatsStageInterceptor.StagePreprocessAndDeserializeErrorContext context) {
        try {
            MDC.put((String)MDC_TRACE_ID, (String)context.getTraceId().orElse(":unknown:"));
            MDC.put((String)MDC_INIT_OR_STAGE_ID, (String)context.getStage().getStageConfig().getStageId());
            if (context.getThrowable().isPresent()) {
                log_stage.error("#MATSLOG# !!ERROR!! Preprocess or deserialize failed with '" + context.getStagePreprocessAndDeserializeError() + "'.", (Throwable)context.getThrowable().get());
            } else {
                log_stage.error("#MATSLOG# !!ERROR!! Preprocess or deserialize failed with '" + context.getStagePreprocessAndDeserializeError() + "'.");
            }
        }
        finally {
            MDC.remove((String)MDC_TRACE_ID);
            MDC.remove((String)MDC_INIT_OR_STAGE_ID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stageReceived(MatsStageInterceptor.StageReceivedContext ctx) {
        String suppressedId;
        int numberOfSuppressions;
        MatsEndpoint.ProcessContext processContext = ctx.getProcessContext();
        if (this.shouldSuppressStageLogging((MatsStageInterceptor.StageCommonContext)ctx) && (numberOfSuppressions = this._suppressions.computeIfAbsent(suppressedId = "logsuppress:" + ctx.getStage().getParentEndpoint().getParentFactory().getFactoryConfig().getName() + SUPPRESSION_MDC_KEY_PARTS_SEPARATOR + processContext.getInitiatingAppName() + SUPPRESSION_MDC_KEY_PARTS_SEPARATOR + processContext.getInitiatorId() + SUPPRESSION_MDC_KEY_PARTS_SEPARATOR + ctx.getStage().getStageConfig().getStageId(), s -> new AtomicInteger(-1)).incrementAndGet()) > 0) {
            ctx.putInterceptContextAttribute(SUPPRESS_LOGGING_INTERCEPT_CONTEXT_ATTRIBUTE, (Object)Boolean.TRUE);
            return;
        }
        try {
            String totalPreprocessAndDeserializeMillisString = MatsMetricsLoggingInterceptor.msS(ctx.getTotalPreprocessAndDeserializeNanos());
            MDC.put((String)MDC_MATS_MESSAGE_RECEIVED, (String)totalPreprocessAndDeserializeMillisString);
            long sumNanosPieces = ctx.getMessageSystemDeconstructNanos() + ctx.getEnvelopeDecompressionNanos() + ctx.getEnvelopeDeserializationNanos() + ctx.getDataAndStateDeserializationNanos();
            MDC.put((String)MDC_MATS_INIT_APP, (String)processContext.getInitiatingAppName());
            MDC.put((String)MDC_MATS_INIT_ID, (String)processContext.getInitiatorId());
            MDC.put((String)MDC_MATS_AUDIT, (String)Boolean.toString(!processContext.isNoAudit()));
            MDC.put((String)MDC_MATS_PERSISTENT, (String)Boolean.toString(!processContext.isNonPersistent()));
            MDC.put((String)MDC_MATS_INTERACTIVE, (String)Boolean.toString(processContext.isInteractive()));
            if (ctx.getDeliveryCount() != -1) {
                MDC.put((String)MDC_MATS_IN_DELIVERY_COUNT, (String)Integer.toString(ctx.getDeliveryCount()));
            }
            MDC.put((String)MDC_MATS_IN_MATS_MESSAGE_ID, (String)processContext.getMatsMessageId());
            MatsOutgoingMessage.MessageType incomingMessageType = ctx.getIncomingMessageType();
            MDC.put((String)MDC_MATS_IN_MESSAGE_TYPE, (String)incomingMessageType.toString());
            MDC.put((String)MDC_MATS_IN_FROM_APP_NAME, (String)processContext.getFromAppName());
            MDC.put((String)MDC_MATS_IN_FROM_ID, (String)processContext.getFromStageId());
            long now = System.currentTimeMillis();
            MDC.put((String)MDC_MATS_IN_TIME_SINCE_SENT, (String)Long.toString(now - processContext.getFromTimestamp().toEpochMilli()));
            if (incomingMessageType == MatsOutgoingMessage.MessageType.REPLY || incomingMessageType == MatsOutgoingMessage.MessageType.REPLY_SUBSCRIPTION || incomingMessageType == MatsOutgoingMessage.MessageType.NEXT || incomingMessageType == MatsOutgoingMessage.MessageType.GOTO) {
                MDC.put((String)MDC_MATS_IN_TIME_SINCE_PRECEDING_ENDPOINT_STAGE, (String)Long.toString(now - ctx.getPrecedingSameStackHeightOutgoingTimestamp().toEpochMilli()));
            }
            MDC.put((String)MDC_MATS_IN_TIME_TOTAL_PREPROC_AND_DESERIAL, (String)totalPreprocessAndDeserializeMillisString);
            MDC.put((String)MDC_MATS_IN_TIME_MSGSYS_DECONSTRUCT, (String)MatsMetricsLoggingInterceptor.msS(ctx.getMessageSystemDeconstructNanos()));
            MDC.put((String)MDC_MATS_IN_SIZE_ENVELOPE_WIRE, (String)Integer.toString(ctx.getEnvelopeWireSize()));
            MDC.put((String)MDC_MATS_IN_TIME_ENVELOPE_DECOMPRESS, (String)MatsMetricsLoggingInterceptor.msS(ctx.getEnvelopeDecompressionNanos()));
            MDC.put((String)MDC_MATS_IN_SIZE_ENVELOPE_SERIAL, (String)Integer.toString(ctx.getEnvelopeSerializedSize()));
            MDC.put((String)MDC_MATS_IN_TIME_ENVELOPE_DESERIAL, (String)MatsMetricsLoggingInterceptor.msS(ctx.getEnvelopeDeserializationNanos()));
            MDC.put((String)MDC_MATS_IN_TIME_DATA_AND_STATE_DESERIAL, (String)MatsMetricsLoggingInterceptor.msS(ctx.getDataAndStateDeserializationNanos()));
            MDC.put((String)MDC_MATS_IN_SIZE_STATE_SERIAL, (String)Integer.toString(ctx.getStateSerializedSize()));
            MDC.put((String)MDC_MATS_IN_SIZE_DATA_SERIAL, (String)Integer.toString(ctx.getDataSerializedSize()));
            MDC.put((String)MDC_MATS_IN_SIZE_TOTAL_WIRE, (String)Integer.toString(ctx.getMessageSystemTotalWireSize()));
            log_stage.info("#MATSLOG# RECEIVED [" + incomingMessageType + "] message from [" + processContext.getFromStageId() + "@" + processContext.getFromAppName() + ",v." + processContext.getFromAppVersion() + "], totPreprocAndDeserial:[" + MatsMetricsLoggingInterceptor.ms(ctx.getTotalPreprocessAndDeserializeNanos()) + "] || breakdown: msgSysDeconstruct:[" + MatsMetricsLoggingInterceptor.ms(ctx.getMessageSystemDeconstructNanos()) + " ms]->envelopeWireSize:[" + ctx.getEnvelopeWireSize() + " B]->decomp:[" + MatsMetricsLoggingInterceptor.ms(ctx.getEnvelopeDecompressionNanos()) + " ms]->serialSize:[" + ctx.getEnvelopeSerializedSize() + " B]->deserial:[" + MatsMetricsLoggingInterceptor.ms(ctx.getEnvelopeDeserializationNanos()) + " ms]->(envelope)->dto&stoDeserial:[" + MatsMetricsLoggingInterceptor.ms(ctx.getDataAndStateDeserializationNanos()) + " ms] - sum pieces:[" + MatsMetricsLoggingInterceptor.ms(sumNanosPieces) + " ms], diff:[" + MatsMetricsLoggingInterceptor.ms(ctx.getTotalPreprocessAndDeserializeNanos() - sumNanosPieces) + " ms]");
        }
        finally {
            MDC.remove((String)MDC_MATS_MESSAGE_RECEIVED);
            MDC.remove((String)MDC_MATS_INIT_APP);
            MDC.remove((String)MDC_MATS_INIT_ID);
            MDC.remove((String)MDC_MATS_AUDIT);
            MDC.remove((String)MDC_MATS_PERSISTENT);
            MDC.remove((String)MDC_MATS_INTERACTIVE);
            MDC.remove((String)MDC_MATS_IN_DELIVERY_COUNT);
            MDC.remove((String)MDC_MATS_IN_MATS_MESSAGE_ID);
            MDC.remove((String)MDC_MATS_IN_MESSAGE_TYPE);
            MDC.remove((String)MDC_MATS_IN_FROM_APP_NAME);
            MDC.remove((String)MDC_MATS_IN_FROM_ID);
            MDC.remove((String)MDC_MATS_IN_TIME_SINCE_SENT);
            MDC.remove((String)MDC_MATS_IN_TIME_SINCE_PRECEDING_ENDPOINT_STAGE);
            MDC.remove((String)MDC_MATS_IN_TIME_TOTAL_PREPROC_AND_DESERIAL);
            MDC.remove((String)MDC_MATS_IN_TIME_MSGSYS_DECONSTRUCT);
            MDC.remove((String)MDC_MATS_IN_SIZE_ENVELOPE_WIRE);
            MDC.remove((String)MDC_MATS_IN_TIME_ENVELOPE_DECOMPRESS);
            MDC.remove((String)MDC_MATS_IN_SIZE_ENVELOPE_SERIAL);
            MDC.remove((String)MDC_MATS_IN_TIME_ENVELOPE_DESERIAL);
            MDC.remove((String)MDC_MATS_IN_TIME_DATA_AND_STATE_DESERIAL);
            MDC.remove((String)MDC_MATS_IN_SIZE_STATE_SERIAL);
            MDC.remove((String)MDC_MATS_IN_SIZE_DATA_SERIAL);
            MDC.remove((String)MDC_MATS_IN_SIZE_TOTAL_WIRE);
        }
    }

    public void stageCompleted(MatsStageInterceptor.StageCompletedContext ctx) {
        if (ctx.getInterceptContextAttribute(SUPPRESS_LOGGING_INTERCEPT_CONTEXT_ATTRIBUTE) == Boolean.TRUE) {
            boolean badResult;
            boolean bl = badResult = ctx.getStageProcessResult() == MatsStageInterceptor.StageCompletedContext.StageProcessResult.USER_EXCEPTION || ctx.getStageProcessResult() == MatsStageInterceptor.StageCompletedContext.StageProcessResult.SYSTEM_EXCEPTION;
            if (!badResult) {
                return;
            }
        }
        this.outputMeasurementsLoglines(log_stage, (CommonCompletedContext)ctx);
        HashMap<String, String> completedMDC = new HashMap<String, String>();
        completedMDC.put(MDC_MATS_STAGE_COMPLETED, MatsMetricsLoggingInterceptor.msS(ctx.getTotalExecutionNanos()));
        List outgoingMessages = ctx.getOutgoingMessages();
        String totalPreprocessAndDeserializeNanosString = MatsMetricsLoggingInterceptor.msS(ctx.getTotalPreprocessAndDeserializeNanos());
        String extraBreakdown = " totPreprocAndDeserial:[" + totalPreprocessAndDeserializeNanosString + " ms],";
        long extraNanosBreakdown = ctx.getTotalPreprocessAndDeserializeNanos();
        completedMDC.put(MDC_MATS_EXEC_TIME_TOTAL_PREPROC_AND_DESERIAL, totalPreprocessAndDeserializeNanosString);
        completedMDC.put(MDC_MATS_EXEC_SIZE_IN_TOTAL_WIRE, Integer.toString(ctx.getMessageSystemTotalWireSize()));
        completedMDC.put(MDC_MATS_PROCESS_RESULT, ctx.getStageProcessResult().toString());
        if (ctx.getStageProcessResult() == MatsStageInterceptor.StageCompletedContext.StageProcessResult.REPLY || ctx.getStageProcessResult() == MatsStageInterceptor.StageCompletedContext.StageProcessResult.REPLY_SUBSCRIPTION || ctx.getStageProcessResult() == MatsStageInterceptor.StageCompletedContext.StageProcessResult.NONE) {
            String totalEndpointTimeString = "0";
            long endpointEnteredTimestamp = ctx.getEndpointEnteredTimestamp().toEpochMilli();
            if (endpointEnteredTimestamp > 0L) {
                long totalEndpointTime = System.currentTimeMillis() - endpointEnteredTimestamp;
                totalEndpointTimeString = Long.toString(totalEndpointTime);
            }
            completedMDC.put(MDC_MATS_ENDPOINT_COMPLETED, totalEndpointTimeString);
            completedMDC.put(MDC_MATS_ENDPOINT_COMPLETE_TIME_TOTAL, totalEndpointTimeString);
        }
        MatsEndpoint.DetachedProcessContext processContext = ctx.getProcessContext();
        if (ctx.getStageProcessResult() == MatsStageInterceptor.StageCompletedContext.StageProcessResult.NONE) {
            long initiationTimestamp = processContext.getInitiatingTimestamp().toEpochMilli();
            long totalFlowTime = System.currentTimeMillis() - initiationTimestamp;
            String totalFlowTimeString = Long.toString(totalFlowTime);
            completedMDC.put(MDC_MATS_FLOW_COMPLETED, totalFlowTimeString);
            completedMDC.put(MDC_MATS_FLOW_COMPLETE_TIME_TOTAL, totalFlowTimeString);
        }
        MatsFactory.FactoryConfig factoryConfig = ctx.getStage().getParentEndpoint().getParentFactory().getFactoryConfig();
        String messageSenderName = factoryConfig.getName();
        String matsVersion = factoryConfig.getMatsImplementationVersion();
        String stageId = ctx.getStage().getStageConfig().getStageId();
        String initiatingAppName = processContext.getInitiatingAppName();
        String initiatorId = processContext.getInitiatorId();
        boolean interactive = processContext.isInteractive();
        this.commonStageAndInitiateCompleted((CommonCompletedContext)ctx, matsVersion, stageId, initiatingAppName, initiatorId, interactive, ctx.getStageProcessResult(), log_stage, outgoingMessages, messageSenderName, extraBreakdown, extraNanosBreakdown, completedMDC);
    }

    protected void outputMeasurementsLoglines(Logger logger, CommonCompletedContext ctx) {
        String baseUnit;
        String measure;
        String[] labelKeyValue;
        String metricDescription;
        String metricId;
        for (CommonCompletedContext.MatsTimingMeasurement measurement : ctx.getTimingMeasurements()) {
            metricId = measurement.getMetricId();
            metricDescription = measurement.getMetricDescription();
            labelKeyValue = measurement.getLabelKeyValue();
            measure = MatsMetricsLoggingInterceptor.msS(measurement.getNanos());
            baseUnit = "ms";
            this.outputMeasurementLogline(logger, "TIMING ", MDC_MATS_EXEC_OPS_TIMING_PREFIX, metricId, baseUnit, measure, metricDescription, labelKeyValue);
        }
        for (CommonCompletedContext.MatsTimingMeasurement measurement : ctx.getMeasurements()) {
            metricId = measurement.getMetricId();
            metricDescription = measurement.getMetricDescription();
            labelKeyValue = measurement.getLabelKeyValue();
            measure = Double.toString(measurement.getMeasure());
            baseUnit = measurement.getBaseUnit();
            this.outputMeasurementLogline(logger, "MEASURE ", MDC_MATS_EXEC_OPS_MEASURE_PREFIX, metricId, baseUnit, measure, metricDescription, labelKeyValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void outputMeasurementLogline(Logger logger, String what, String mdcPrefix, String metricId, String baseUnit, String measure, String metricDescription, String[] labelKeyValue) {
        ArrayList<CallSite> mdcTagKeysToClear = labelKeyValue.length > 0 ? new ArrayList<CallSite>() : null;
        String mdcKey = mdcPrefix + metricId + "." + baseUnit;
        try {
            void var12_13;
            MDC.put((String)mdcKey, (String)measure);
            MDC.put((String)MDC_MATS_EXEC_OPS_KEYNAME, (String)mdcKey);
            MDC.put((String)MDC_MATS_EXEC_OPS_DESCRIPTION, (String)metricDescription);
            StringBuilder buf = new StringBuilder(128);
            buf.append(LOG_PREFIX).append(what).append(metricId).append(":[").append(measure).append(' ').append(baseUnit).append(']');
            boolean bl = false;
            while (var12_13 < labelKeyValue.length) {
                String labelKey = labelKeyValue[var12_13];
                String labelValue = labelKeyValue[var12_13 + true];
                String mdcLabelKey = mdcKey + ".tag." + labelKey;
                MDC.put((String)mdcLabelKey, (String)labelValue);
                mdcTagKeysToClear.add((CallSite)((Object)mdcLabelKey));
                buf.append(' ').append(labelKey).append(':').append(labelValue);
                var12_13 += 2;
            }
            logger.info(buf.toString());
        }
        finally {
            MDC.remove((String)mdcKey);
            MDC.remove((String)MDC_MATS_EXEC_OPS_KEYNAME);
            MDC.remove((String)MDC_MATS_EXEC_OPS_DESCRIPTION);
            if (mdcTagKeysToClear != null) {
                for (String string : mdcTagKeysToClear) {
                    MDC.remove((String)string);
                }
            }
        }
    }

    protected void commonStageAndInitiateCompleted(CommonCompletedContext ctx, String matsVersion, String initOrStageId, String initiatingAppName, String initatorId, boolean interactive, Object processResult, Logger logger, List<MatsOutgoingMessage.MatsSentOutgoingMessage> outgoingMessages, String messageSenderName, String extraBreakdown, long extraNanosBreakdown, Map<String, String> completedMDC) {
        String what = ctx instanceof MatsInitiateInterceptor.InitiateCompletedContext ? "INIT" : (completedMDC.containsKey(MDC_MATS_FLOW_COMPLETED) ? "STAGE/ENDPOINT/FLOW" : (completedMDC.containsKey(MDC_MATS_ENDPOINT_COMPLETED) ? "STAGE/ENDPOINT" : "STAGE"));
        if (ctx.getThrowable().isPresent()) {
            Throwable t = (Throwable)ctx.getThrowable().get();
            this.commonStageAndInitiateCompleted_inner(ctx, matsVersion, initOrStageId, initiatingAppName, initatorId, interactive, LOG_PREFIX + what + " !!FAILED!! with result " + processResult, extraBreakdown, extraNanosBreakdown, Collections.emptyList(), Level.ERROR, logger, t, "", completedMDC);
        } else if (outgoingMessages.size() != 1) {
            this.commonStageAndInitiateCompleted_inner(ctx, matsVersion, initOrStageId, initiatingAppName, initatorId, interactive, LOG_PREFIX + what + " completed with result " + processResult, extraBreakdown, extraNanosBreakdown, outgoingMessages, Level.INFO, logger, null, "", completedMDC);
            for (MatsOutgoingMessage.MatsSentOutgoingMessage outgoingMessage : ctx.getOutgoingMessages()) {
                this.msgLog_AddMsgMdcs(outgoingMessage, () -> log_init.info(LOG_PREFIX + this.msgLog_CreateMsgLogLine(messageSenderName, outgoingMessage)));
            }
        } else {
            this.msgLog_AddMsgMdcs(outgoingMessages.get(0), () -> {
                String msgLine = this.msgLog_CreateMsgLogLine(messageSenderName, (MatsOutgoingMessage.MatsSentOutgoingMessage)outgoingMessages.get(0));
                this.commonStageAndInitiateCompleted_inner(ctx, matsVersion, initOrStageId, initiatingAppName, initatorId, interactive, LOG_PREFIX + what + " completed with result " + processResult, extraBreakdown, extraNanosBreakdown, outgoingMessages, Level.INFO, logger, null, "\n    #MATSLOG# " + msgLine, completedMDC);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void commonStageAndInitiateCompleted_inner(CommonCompletedContext ctx, String matsVersion, String initOrStageId, String initiatingAppName, String initiatorId, boolean interactive, String logPrefix, String extraBreakdown, long extraNanosBreakdown, List<MatsOutgoingMessage.MatsSentOutgoingMessage> outgoingMessages, Level level, Logger log, Throwable t, String logPostfix, Map<String, String> completedMDC) {
        Object numMessagesText;
        long nanosTaken_SumDtoAndStoSerialNanos = 0L;
        for (MatsOutgoingMessage.MatsSentOutgoingMessage msg : outgoingMessages) {
            nanosTaken_SumDtoAndStoSerialNanos += msg.getEnvelopeProduceNanos();
        }
        long nanosTaken_UserLambdaAlone = ctx.getUserLambdaNanos() - nanosTaken_SumDtoAndStoSerialNanos;
        long nanosTaken_SumMessageOutHandling = nanosTaken_SumDtoAndStoSerialNanos + ctx.getSumEnvelopeSerializationAndCompressionNanos() + ctx.getSumMessageSystemProductionAndSendNanos();
        long nanosTaken_SumPieces = extraNanosBreakdown + nanosTaken_UserLambdaAlone + nanosTaken_SumMessageOutHandling + ctx.getDbCommitNanos() + ctx.getMessageSystemCommitNanos();
        switch (outgoingMessages.size()) {
            case 0: {
                numMessagesText = "no outgoing messages";
                break;
            }
            case 1: {
                numMessagesText = "single outgoing " + outgoingMessages.get(0).getMessageType() + " message";
                break;
            }
            default: {
                numMessagesText = "[" + outgoingMessages.size() + "] outgoing messages";
            }
        }
        try {
            completedMDC.forEach(MDC::put);
            int totalWireSize = 0;
            for (MatsOutgoingMessage.MatsSentOutgoingMessage outgoingMessage : outgoingMessages) {
                totalWireSize += outgoingMessage.getMessageSystemTotalWireSize();
            }
            MDC.put((String)MDC_MATS_VERSION, (String)matsVersion);
            MDC.put((String)MDC_INIT_OR_STAGE_ID, (String)initOrStageId);
            MDC.put((String)MDC_MATS_INIT_APP, (String)initiatingAppName);
            MDC.put((String)MDC_MATS_INIT_ID, (String)initiatorId);
            MDC.put((String)MDC_MATS_INTERACTIVE, (String)Boolean.valueOf(interactive).toString());
            MDC.put((String)MDC_MATS_EXEC_TIME_TOTAL, (String)MatsMetricsLoggingInterceptor.msS(ctx.getTotalExecutionNanos()));
            MDC.put((String)MDC_MATS_EXEC_TIME_USER_LAMBDA, (String)MatsMetricsLoggingInterceptor.msS(nanosTaken_UserLambdaAlone));
            MDC.put((String)MDC_MATS_EXEC_TIME_OUT, (String)MatsMetricsLoggingInterceptor.msS(nanosTaken_SumMessageOutHandling));
            MDC.put((String)MDC_MATS_EXEC_QUANTITY_OUT, (String)String.valueOf(outgoingMessages.size()));
            MDC.put((String)MDC_MATS_EXEC_SIZE_OUT_TOTAL_WIRE, (String)String.valueOf(totalWireSize));
            MDC.put((String)MDC_MATS_EXEC_TIME_DB_COMMIT, (String)MatsMetricsLoggingInterceptor.msS(ctx.getDbCommitNanos()));
            MDC.put((String)MDC_MATS_EXEC_TIME_MSGSYS_COMMIT, (String)MatsMetricsLoggingInterceptor.msS(ctx.getMessageSystemCommitNanos()));
            String msg = logPrefix + ", " + (String)numMessagesText + ", total:[" + MatsMetricsLoggingInterceptor.ms(ctx.getTotalExecutionNanos()) + " ms] || breakdown:" + extraBreakdown + " userLambda (excl. produceEnvelopes):[" + MatsMetricsLoggingInterceptor.ms(nanosTaken_UserLambdaAlone) + " ms], msgsOut:[" + MatsMetricsLoggingInterceptor.ms(nanosTaken_SumMessageOutHandling) + " ms], dbCommit:[" + MatsMetricsLoggingInterceptor.ms(ctx.getDbCommitNanos()) + " ms], msgSysCommit:[" + MatsMetricsLoggingInterceptor.ms(ctx.getMessageSystemCommitNanos()) + " ms] - sum pieces:[" + MatsMetricsLoggingInterceptor.ms(nanosTaken_SumPieces) + " ms], diff:[" + MatsMetricsLoggingInterceptor.ms(ctx.getTotalExecutionNanos() - nanosTaken_SumPieces) + " ms]" + logPostfix;
            if (level == Level.INFO) {
                log.info(msg);
            } else {
                log.error(msg, t);
            }
        }
        finally {
            completedMDC.keySet().forEach(MDC::remove);
            MDC.remove((String)MDC_MATS_VERSION);
            MDC.remove((String)MDC_INIT_OR_STAGE_ID);
            MDC.remove((String)MDC_MATS_INIT_APP);
            MDC.remove((String)MDC_MATS_INIT_ID);
            MDC.remove((String)MDC_MATS_INTERACTIVE);
            MDC.remove((String)MDC_MATS_EXEC_TIME_TOTAL);
            MDC.remove((String)MDC_MATS_EXEC_TIME_USER_LAMBDA);
            MDC.remove((String)MDC_MATS_EXEC_TIME_OUT);
            MDC.remove((String)MDC_MATS_EXEC_QUANTITY_OUT);
            MDC.remove((String)MDC_MATS_EXEC_SIZE_OUT_TOTAL_WIRE);
            MDC.remove((String)MDC_MATS_EXEC_TIME_DB_COMMIT);
            MDC.remove((String)MDC_MATS_EXEC_TIME_MSGSYS_COMMIT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void msgLog_AddMsgMdcs(MatsOutgoingMessage.MatsSentOutgoingMessage msg, Runnable runnable) {
        String existingTraceId = MDC.get((String)MDC_TRACE_ID);
        try {
            MDC.put((String)MDC_TRACE_ID, (String)msg.getTraceId());
            long nanosTaken_Total = msg.getEnvelopeProduceNanos() + msg.getEnvelopeSerializationNanos() + msg.getEnvelopeCompressionNanos() + msg.getMessageSystemProduceAndSendNanos();
            String millisTaken_Total_String = MatsMetricsLoggingInterceptor.msS(nanosTaken_Total);
            MDC.put((String)MDC_MATS_MESSAGE_SENT, (String)millisTaken_Total_String);
            MDC.put((String)MDC_MATS_DISPATCH_TYPE, (String)msg.getDispatchType().toString());
            MDC.put((String)MDC_MATS_OUT_MATS_MESSAGE_ID, (String)msg.getMatsMessageId());
            MDC.put((String)MDC_MATS_OUT_MESSAGE_SYSTEM_ID, (String)msg.getSystemMessageId());
            MDC.put((String)MDC_MATS_INIT_APP, (String)msg.getInitiatingAppName());
            MDC.put((String)MDC_MATS_INIT_ID, (String)msg.getInitiatorId());
            MDC.put((String)MDC_MATS_OUT_FROM_ID, (String)msg.getFrom());
            MDC.put((String)MDC_INIT_OR_STAGE_ID, (String)msg.getFrom());
            MDC.put((String)MDC_MATS_OUT_TO_ID, (String)msg.getTo());
            MDC.put((String)MDC_MATS_AUDIT, (String)Boolean.toString(!msg.isNoAudit()));
            MDC.put((String)MDC_MATS_PERSISTENT, (String)Boolean.toString(!msg.isNonPersistent()));
            MDC.put((String)MDC_MATS_INTERACTIVE, (String)Boolean.toString(msg.isInteractive()));
            MDC.put((String)MDC_MATS_OUT_TIME_ENVELOPE_PRODUCE, (String)MatsMetricsLoggingInterceptor.msS(msg.getEnvelopeProduceNanos()));
            MDC.put((String)MDC_MATS_OUT_TIME_ENVELOPE_SERIAL, (String)MatsMetricsLoggingInterceptor.msS(msg.getEnvelopeSerializationNanos()));
            MDC.put((String)MDC_MATS_OUT_SIZE_ENVELOPE_SERIAL, (String)Integer.toString(msg.getEnvelopeSerializedSize()));
            MDC.put((String)MDC_MATS_OUT_TIME_ENVELOPE_COMPRESS, (String)MatsMetricsLoggingInterceptor.msS(msg.getEnvelopeCompressionNanos()));
            MDC.put((String)MDC_MATS_OUT_SIZE_ENVELOPE_WIRE, (String)Integer.toString(msg.getEnvelopeWireSize()));
            MDC.put((String)MDC_MATS_OUT_TIME_MSGSYS, (String)MatsMetricsLoggingInterceptor.msS(msg.getMessageSystemProduceAndSendNanos()));
            MDC.put((String)MDC_MATS_OUT_TIME_TOTAL, (String)millisTaken_Total_String);
            MDC.put((String)MDC_MATS_OUT_SIZE_TOTAL_WIRE, (String)Integer.toString(msg.getMessageSystemTotalWireSize()));
            MDC.put((String)MDC_MATS_OUT_SIZE_DATA_SERIAL, (String)Integer.toString(msg.getDataSerializedSize()));
            runnable.run();
        }
        finally {
            if (existingTraceId == null) {
                MDC.remove((String)MDC_TRACE_ID);
            } else {
                MDC.put((String)MDC_TRACE_ID, (String)existingTraceId);
            }
            MDC.remove((String)MDC_MATS_MESSAGE_SENT);
            MDC.remove((String)MDC_MATS_DISPATCH_TYPE);
            MDC.remove((String)MDC_MATS_OUT_MATS_MESSAGE_ID);
            MDC.remove((String)MDC_MATS_OUT_MESSAGE_SYSTEM_ID);
            MDC.remove((String)MDC_MATS_INIT_APP);
            MDC.remove((String)MDC_MATS_INIT_ID);
            MDC.remove((String)MDC_MATS_OUT_FROM_ID);
            MDC.remove((String)MDC_INIT_OR_STAGE_ID);
            MDC.remove((String)MDC_MATS_OUT_TO_ID);
            MDC.remove((String)MDC_MATS_AUDIT);
            MDC.remove((String)MDC_MATS_PERSISTENT);
            MDC.remove((String)MDC_MATS_INTERACTIVE);
            MDC.remove((String)MDC_MATS_OUT_TIME_ENVELOPE_PRODUCE);
            MDC.remove((String)MDC_MATS_OUT_TIME_ENVELOPE_SERIAL);
            MDC.remove((String)MDC_MATS_OUT_SIZE_ENVELOPE_SERIAL);
            MDC.remove((String)MDC_MATS_OUT_TIME_ENVELOPE_COMPRESS);
            MDC.remove((String)MDC_MATS_OUT_SIZE_ENVELOPE_WIRE);
            MDC.remove((String)MDC_MATS_OUT_TIME_MSGSYS);
            MDC.remove((String)MDC_MATS_OUT_TIME_TOTAL);
            MDC.remove((String)MDC_MATS_OUT_SIZE_TOTAL_WIRE);
            MDC.remove((String)MDC_MATS_OUT_SIZE_DATA_SERIAL);
        }
    }

    protected String msgLog_CreateMsgLogLine(String messageSenderName, MatsOutgoingMessage.MatsSentOutgoingMessage msg) {
        long nanosTaken_Total = msg.getEnvelopeProduceNanos() + msg.getEnvelopeSerializationNanos() + msg.getEnvelopeCompressionNanos() + msg.getMessageSystemProduceAndSendNanos();
        return msg.getDispatchType() + " outgoing " + msg.getMessageType() + " message from [" + messageSenderName + "|" + msg.getFrom() + "] -> [" + msg.getTo() + "], total:[" + MatsMetricsLoggingInterceptor.ms(nanosTaken_Total) + " ms] || breakdown: produce:[" + MatsMetricsLoggingInterceptor.ms(msg.getEnvelopeProduceNanos()) + " ms]->(envelope)->serial:[" + MatsMetricsLoggingInterceptor.ms(msg.getEnvelopeSerializationNanos()) + " ms]->serialSize:[" + msg.getEnvelopeSerializedSize() + " B]->comp:[" + MatsMetricsLoggingInterceptor.ms(msg.getEnvelopeCompressionNanos()) + " ms]->envelopeWireSize:[" + msg.getEnvelopeWireSize() + " B]->msgSysConstruct&Send:[" + MatsMetricsLoggingInterceptor.ms(msg.getMessageSystemProduceAndSendNanos()) + " ms]";
    }

    protected static String msS(long nanosTake) {
        return Double.toString(MatsMetricsLoggingInterceptor.ms(nanosTake));
    }

    protected static double ms(long nanosTaken) {
        if (nanosTaken == 0L) {
            return 0.0;
        }
        if (nanosTaken >= 500000000000L) {
            return (double)Math.round((double)nanosTaken / 1.0E9) * 1000.0;
        }
        if (nanosTaken >= 50000000000L) {
            return (double)Math.round((double)nanosTaken / 1.0E8) * 100.0;
        }
        if (nanosTaken >= 5000000000L) {
            return (double)Math.round((double)nanosTaken / 1.0E7) * 10.0;
        }
        if (nanosTaken >= 500000000L) {
            return Math.round((double)nanosTaken / 1000000.0);
        }
        if (nanosTaken >= 50000000L) {
            return (double)Math.round((double)nanosTaken / 100000.0) / 10.0;
        }
        if (nanosTaken >= 5000000L) {
            return (double)Math.round((double)nanosTaken / 10000.0) / 100.0;
        }
        return Math.max((double)Math.round((double)nanosTaken / 1000.0) / 1000.0, 1.0E-4);
    }

    protected static enum Level {
        INFO,
        ERROR;

    }
}

