/*
 * Decompiled with CFR 0.152.
 */
package io.mats3.localinspect;

import io.mats3.MatsConfig;
import io.mats3.MatsEndpoint;
import io.mats3.MatsFactory;
import io.mats3.MatsInitiator;
import io.mats3.MatsStage;
import io.mats3.api.intercept.MatsInitiateInterceptor;
import io.mats3.api.intercept.MatsOutgoingMessage;
import io.mats3.api.intercept.MatsStageInterceptor;
import io.mats3.localinspect.LocalHtmlInspectForMatsFactory;
import io.mats3.localinspect.LocalStatsMatsInterceptor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;

public class LocalHtmlInspectForMatsFactoryImpl
implements LocalHtmlInspectForMatsFactory {
    private final MatsFactory _matsFactory;
    RgbaColor ms0 = new RgbaColor(128, 255, 128, 1.0);
    RgbaColor ms100 = new RgbaColor(0, 192, 0, 1.0);
    RgbaColor ms250 = new RgbaColor(0, 128, 192, 1.0);
    RgbaColor ms500 = new RgbaColor(0, 64, 255, 1.0);
    RgbaColor ms1000 = new RgbaColor(255, 0, 192, 1.0);
    RgbaColor ms2000 = new RgbaColor(255, 0, 0, 1.0);
    static final DecimalFormatSymbols NF_SYMBOLS = new DecimalFormatSymbols(Locale.US);
    static final DecimalFormat NF_INTEGER;
    static final DecimalFormat NF_0_DECIMALS;
    static final DecimalFormat NF_1_DECIMALS;
    static final DecimalFormat NF_2_DECIMALS;
    static final DecimalFormat NF_3_DECIMALS;

    LocalHtmlInspectForMatsFactoryImpl(MatsFactory matsFactory) {
        this._matsFactory = matsFactory;
    }

    @Override
    public void getStyleSheet(Appendable out) throws IOException {
        LocalHtmlInspectForMatsFactoryImpl.includeFile(out, "localhtmlinspect.css");
    }

    @Override
    public void getJavaScript(Appendable out) throws IOException {
        LocalHtmlInspectForMatsFactoryImpl.includeFile(out, "localhtmlinspect.js");
    }

    private static void includeFile(Appendable out, String file) throws IOException {
        String line;
        String filename = LocalHtmlInspectForMatsFactory.class.getPackage().getName().replace('.', '/') + "/" + file;
        InputStream is = LocalHtmlInspectForMatsFactory.class.getClassLoader().getResourceAsStream(filename);
        if (is == null) {
            throw new IllegalStateException("Missing '" + file + "' from ClassLoader.");
        }
        InputStreamReader isr = new InputStreamReader(is, StandardCharsets.UTF_8);
        BufferedReader br = new BufferedReader(isr);
        while ((line = br.readLine()) != null) {
            out.append(line).append('\n');
        }
    }

    @Override
    public void createFactoryReport(Appendable out, boolean includeInitiators, boolean includeEndpoints, boolean includeStages) throws IOException {
        LocalStatsMatsInterceptor localStats = this._matsFactory.getFactoryConfig().getPlugins(LocalStatsMatsInterceptor.class).stream().findFirst().orElse(null);
        MatsFactory.FactoryConfig config = this._matsFactory.getFactoryConfig();
        out.append("<div class='matsli_report matsli_factory'>\n");
        out.append("<div class='matsli_heading'>MatsFactory <h2>" + config.getName() + "</h2>\n");
        out.append(" - <b>Known number of CPUs:</b> " + config.getNumberOfCpus());
        out.append(" - <b>Concurrency:</b> " + this.formatConcurrency((MatsConfig)config));
        out.append(" - <b>Running:</b> " + config.isRunning());
        out.append("</div>\n");
        out.append("<div class='matsli_info'>");
        out.append("<span style='font-size: 90%; vertical-align: 0.5em'>");
        out.append("<b>Name:</b> " + config.getName());
        out.append(" - <b>App:</b> " + config.getAppName() + " v." + config.getAppVersion());
        out.append(" - <b>Nodename:</b> " + config.getNodename());
        out.append(" - <b>Mats<sup>3</sup>:</b> " + config.getMatsImplementationName() + ", v." + config.getMatsImplementationVersion());
        out.append(" - <b>Destination prefix:</b> '" + config.getMatsDestinationPrefix() + "'");
        out.append(" - <b>Trace key:</b> '" + config.getMatsTraceKey() + "'<br/>\n");
        out.append("</span>\n");
        out.append("<h4>Factory Summary</h4>");
        this.createFactorySummary(out, includeInitiators, includeEndpoints);
        out.append("<br>\n");
        out.append((localStats != null ? "<b>Local Statistics collector present in MatsFactory!</b> (<code>" + LocalStatsMatsInterceptor.class.getSimpleName() + "</code> installed)" : "<b style='color:red;>Missing Local Statistics collector in MatsFactory - <code>" + LocalStatsMatsInterceptor.class.getSimpleName() + "</code> is not installed!</b>") + "</b><br/>");
        List matsPlugins = this._matsFactory.getFactoryConfig().getPlugins(MatsFactory.MatsPlugin.class);
        if (!matsPlugins.isEmpty()) {
            out.append("<b>Installed Plugins:</b><br/>\n");
            for (MatsFactory.MatsPlugin matsPlugin : matsPlugins) {
                out.append("&nbsp;&nbsp;<code>" + matsPlugin.getClass().getName() + "</code>: " + matsPlugin);
                if (matsPlugin instanceof MatsStageInterceptor) {
                    out.append(" - <i>MatsStageInterceptor</i>");
                }
                if (matsPlugin instanceof MatsInitiateInterceptor) {
                    out.append(" - <i>MatsInitiateInterceptor</i>");
                }
                out.append("<br/>\n");
            }
            out.append("<br/>\n");
        }
        out.append("</div>");
        out.append("<div class='matsli_report matsli_system_information'>\n");
        out.append("  <div class='matsli_heading'><h3>MatsFactory SystemInformation</h3> ");
        out.append("<button id='matsli_systeminformation_heighttoggle' onclick='matsli_systeminformation_toggle_height(event)'>Expand to full</button></div>");
        out.append("  <div class='matsli_system_information_content'>");
        out.append(this._matsFactory.getFactoryConfig().getSystemInformation());
        out.append("  </div>\n</div>\n");
        out.append("<hr/>");
        boolean first = true;
        if (includeInitiators) {
            for (MatsInitiator initiator : this._matsFactory.getInitiators()) {
                out.append(first ? "" : "<hr/>");
                first = false;
                this.createInitiatorReport(out, initiator);
            }
        }
        if (includeEndpoints) {
            for (MatsEndpoint endpoint : this._matsFactory.getEndpoints()) {
                out.append(first ? "" : "<hr/>");
                first = false;
                this.createEndpointReport(out, endpoint, includeStages);
            }
        }
        out.append("</div>\n");
    }

    @Override
    public void createFactorySummary(Appendable out, boolean includeInitiators, boolean includeEndpoints) throws IOException {
        if (includeInitiators || includeEndpoints) {
            LocalStatsMatsInterceptor localStats = this._matsFactory.getFactoryConfig().getPlugins(LocalStatsMatsInterceptor.class).stream().findFirst().orElse(null);
            out.append("<table class='matsli_table_summary matsli_report'>");
            out.append("<thead><tr>");
            out.append("<th>Initiator Name / Endpoint Id</th>");
            out.append("<th>type</th>");
            out.append("<th>msgs</th>");
            out.append("<th>samples</th>");
            out.append("<th>avg</th>");
            out.append("<th>median</th>");
            out.append("<th>75%</th>");
            out.append("<th>95%</th>");
            out.append("<th>99.9%</th>");
            out.append("<th>Stages</th>");
            out.append("</tr></thead>");
            if (includeInitiators) {
                for (MatsInitiator matsInitiator : this._matsFactory.getInitiators()) {
                    out.append("<tr class='matsli_summary_initiator_row'>");
                    out.append("<td>").append("&nbsp;&nbsp;<a href='#matsInitiator_").append(this._matsFactory.getFactoryConfig().getName()).append("_").append(matsInitiator.getName()).append("'>").append(matsInitiator.getName()).append("</a><br/>\n").append("</td>");
                    out.append("<td class='matsli_right'>Initiator</td>");
                    if (localStats != null && localStats.getInitiatorStats(matsInitiator).isPresent()) {
                        LocalStatsMatsInterceptor.InitiatorStats stats = localStats.getInitiatorStats(matsInitiator).get();
                        long sumOutMsgs = stats.getOutgoingMessageCounts().values().stream().mapToLong(Long::longValue).sum();
                        out.append("<td class='matsli_right'>").append(this.formatInt(sumOutMsgs)).append("</td>");
                        LocalStatsMatsInterceptor.StatsSnapshot execSnapshot = stats.getTotalExecutionTimeNanos();
                        out.append("<td class='matsli_right'>").append(this.formatInt(execSnapshot.getSamples().length)).append("</td>");
                        this.timingCellForAverage(out, execSnapshot);
                        this.timingCell(out, execSnapshot.getMedian());
                        this.timingCell(out, execSnapshot.get75thPercentile());
                        this.timingCell(out, execSnapshot.get95thPercentile());
                        this.timingCell(out, execSnapshot.get999thPercentile());
                    } else {
                        out.append("<td colspan=7></td>");
                    }
                    out.append("<td></td>");
                    out.append("</tr>");
                }
            }
            if (includeEndpoints) {
                List endpoints = this._matsFactory.getEndpoints();
                for (int i = 0; i < endpoints.size(); ++i) {
                    LocalStatsMatsInterceptor.StatsSnapshot execSnapshot;
                    MatsEndpoint matsEndpoint = (MatsEndpoint)endpoints.get(i);
                    if (i == endpoints.size() - 1) {
                        out.append("<tr class='matsli_summary_lastline'>");
                    } else {
                        out.append("<tr>");
                    }
                    boolean subscription = matsEndpoint.getEndpointConfig().isSubscription();
                    out.append("<td>").append("&nbsp;&nbsp;").append(subscription ? "<i>" : "").append("<a href='#matsEndpoint_").append(this._matsFactory.getFactoryConfig().getName()).append("_").append(matsEndpoint.getEndpointConfig().getEndpointId()).append("'>").append(matsEndpoint.getEndpointConfig().getEndpointId()).append("</a><br/>\n").append(subscription ? "</i>" : "").append("</td>");
                    out.append("<td class='matsli_right'>").append(subscription ? "<i>" : "").append(this.deduceEndpointType(matsEndpoint)).append(subscription ? "</i>" : "").append("</td>");
                    if (localStats != null && localStats.getEndpointStats(matsEndpoint).isPresent()) {
                        LocalStatsMatsInterceptor.EndpointStats endpointStats = localStats.getEndpointStats(matsEndpoint).get();
                        long sumOutMsgs = endpointStats.getStagesStats().get(0).getIncomingMessageCounts().values().stream().mapToLong(Long::longValue).sum();
                        out.append("<td class='matsli_right'>").append(this.formatInt(sumOutMsgs)).append("</td>");
                        execSnapshot = endpointStats.getTotalEndpointProcessingTimeNanos();
                        out.append("<td class='matsli_right'>").append(this.formatInt(execSnapshot.getSamples().length)).append("</td>");
                        this.timingCellForAverage(out, execSnapshot);
                        this.timingCell(out, execSnapshot.getMedian());
                        this.timingCell(out, execSnapshot.get75thPercentile());
                        this.timingCell(out, execSnapshot.get95thPercentile());
                        this.timingCell(out, execSnapshot.get999thPercentile());
                    } else {
                        out.append("<td colspan=7></td>");
                    }
                    out.append("<td>");
                    for (MatsStage matsStage : matsEndpoint.getStages()) {
                        LocalStatsMatsInterceptor.StageStats stageStats;
                        Optional<LocalStatsMatsInterceptor.StatsSnapshot> betweenSnapshot;
                        if (localStats != null && localStats.getStageStats(matsStage).isPresent() && (betweenSnapshot = (stageStats = localStats.getStageStats(matsStage).get()).getBetweenStagesTimeNanos()).isPresent()) {
                            this.summaryStageTime(out, betweenSnapshot.get());
                        }
                        out.append("<div class='matsli_stage_summary_box'>");
                        if (localStats != null && localStats.getStageStats(matsStage).isPresent()) {
                            stageStats = localStats.getStageStats(matsStage).get();
                            LocalStatsMatsInterceptor.StatsSnapshot queueSnapshot = stageStats.getSpentQueueTimeNanos();
                            this.summaryStageTime(out, queueSnapshot);
                        }
                        out.append("<a href='#");
                        if (matsStage.getStageConfig().getStageIndex() == 0) {
                            out.append("matsEndpoint_").append(this._matsFactory.getFactoryConfig().getName()).append("_").append(matsEndpoint.getEndpointConfig().getEndpointId()).append("'>");
                        } else {
                            out.append("matsStage_").append(this._matsFactory.getFactoryConfig().getName()).append("_").append(matsStage.getStageConfig().getStageId()).append("'>");
                        }
                        out.append("S:").append(Integer.toString(matsStage.getStageConfig().getStageIndex())).append("</a>");
                        if (localStats != null && localStats.getStageStats(matsStage).isPresent()) {
                            stageStats = localStats.getStageStats(matsStage).get();
                            execSnapshot = stageStats.getStageTotalExecutionTimeNanos();
                            this.summaryStageTime(out, execSnapshot);
                        }
                        out.append("</div>");
                    }
                    out.append("</td>");
                    out.append("</tr>");
                }
                out.append("<tr><td colspan=100 class='matsli_right'>");
                out.append("Legend: <div class='matsli_stage_summary_box'>");
                out.append("<div class='matsli_summary_time' style='background: " + this.colorForMs(150.0).toCss() + "'>{queue time}</div>");
                out.append("S:1");
                out.append("<div class='matsli_summary_time' style='background: " + this.colorForMs(150.0).toCss() + "'>{process time}</div>");
                out.append("</div>");
                out.append("<div class='matsli_summary_time' style='background: " + this.colorForMs(150.0).toCss() + "'>{time between}</div>");
                out.append("<div class='matsli_stage_summary_box'>");
                out.append("<div class='matsli_summary_time' style='background: " + this.colorForMs(150.0).toCss() + "'>...</div>");
                out.append("S:2");
                out.append("<div class='matsli_summary_time' style='background: " + this.colorForMs(150.0).toCss() + "'>...</div>");
                out.append("</div>... (95th pctl)");
                out.append("<div style='width: 3em; display:inline-block'></div>");
                out.append("Timings: ");
                this.legendTimingPatch(out, 0.0);
                this.legendTimingPatch(out, 25.0);
                this.legendTimingPatch(out, 50.0);
                this.legendTimingPatch(out, 75.0);
                this.legendTimingPatch(out, 100.0);
                this.legendTimingPatch(out, 150.0);
                this.legendTimingPatch(out, 200.0);
                this.legendTimingPatch(out, 250.0);
                this.legendTimingPatch(out, 300.0);
                this.legendTimingPatch(out, 400.0);
                this.legendTimingPatch(out, 500.0);
                this.legendTimingPatch(out, 750.0);
                this.legendTimingPatch(out, 1000.0);
                this.legendTimingPatch(out, 1250.0);
                this.legendTimingPatch(out, 1500.0);
                this.legendTimingPatch(out, 1750.0);
                this.legendTimingPatch(out, 2000.0);
                out.append("<br>\n");
                out.append("<span style='vertical-align: -0.5em; font-size: 95%'>Notice: <b>#1</b> Pay attention to the {queue time} of the initial stage: It is <i>not</i> included in the Endpoint total times. <b>#2</b> The {time between} will in practice include the {queue time} of the following stage. <b>#3</b> The {queue time} is susceptible to time skews between nodes.</span>\n");
                out.append("</td></tr>");
            }
            out.append("</table>");
        }
    }

    void summaryStageTime(Appendable out, LocalStatsMatsInterceptor.StatsSnapshot stats) throws IOException {
        out.append("<div class='matsli_tooltip'><div class='matsli_summary_time' style='background: " + this.colorForNanos(stats.get95thPercentile()).toCss() + "'>" + this.formatNanos0(stats.get95thPercentile()) + "</div><div class='matsli_tooltiptext'>" + this.formatStats(stats, true) + "</div></div>");
    }

    void timingCell(Appendable out, double nanos) throws IOException {
        out.append("<td class='matsli_right' style='background:").append(this.colorForNanos(nanos).toCss()).append("'>").append(this.formatNanos1(nanos)).append("</td>");
    }

    void timingCellForAverage(Appendable out, LocalStatsMatsInterceptor.StatsSnapshot snapshot) throws IOException {
        out.append("<td class='matsli_right' style='background:").append(this.colorForNanos(snapshot.getAverage()).toCss()).append("'>").append("<div class='matsli_tooltip'>").append(this.formatNanos1(snapshot.getAverage())).append("<div class='matsli_tooltiptext'>").append(this.formatStats(snapshot, true)).append("</div></div>").append("</td>");
    }

    void legendTimingPatch(Appendable out, double ms) throws IOException {
        out.append("<span style='background: " + this.colorForMs(ms).toCss() + "'>&nbsp;" + Math.round(ms) + "&nbsp;</span> ");
    }

    @Override
    public void createInitiatorReport(Appendable out, MatsInitiator matsInitiator) throws IOException {
        LocalStatsMatsInterceptor localStats = this._matsFactory.getFactoryConfig().getPlugins(LocalStatsMatsInterceptor.class).stream().findFirst().orElse(null);
        out.append("<div class='matsli_report matsli_initiator' id='matsInitiator_").append(matsInitiator.getParentFactory().getFactoryConfig().getName()).append("_").append(matsInitiator.getName()).append("'>\n");
        out.append("<div class='matsli_heading'>Initiator <h3>" + matsInitiator.getName() + "</h3>\n");
        out.append("</div>\n");
        out.append("<div class='matsli_info'>\n");
        if (localStats != null) {
            Optional<LocalStatsMatsInterceptor.InitiatorStats> initiatorStats_ = localStats.getInitiatorStats(matsInitiator);
            if (initiatorStats_.isPresent()) {
                LocalStatsMatsInterceptor.InitiatorStats initiatorStats = initiatorStats_.get();
                LocalStatsMatsInterceptor.StatsSnapshot stats = initiatorStats.getTotalExecutionTimeNanos();
                out.append("<b>Total initiation time:</b> " + this.formatStats(stats, false) + "<br/>\n");
                NavigableMap<LocalStatsMatsInterceptor.OutgoingMessageRepresentation, Long> outgoingMessageCounts = initiatorStats.getOutgoingMessageCounts();
                long sumOutMsgs = outgoingMessageCounts.values().stream().mapToLong(Long::longValue).sum();
                if (outgoingMessageCounts.isEmpty()) {
                    out.append("<b>NO outgoing messages!</b><br/>\n");
                } else if (outgoingMessageCounts.size() == 1) {
                    out.append("<b>Outgoing messages:</b> \n");
                } else {
                    out.append("<b>Outgoing messages (" + this.formatInt(sumOutMsgs) + "):</b><br/>\n");
                }
                for (Map.Entry entry : outgoingMessageCounts.entrySet()) {
                    LocalStatsMatsInterceptor.OutgoingMessageRepresentation msg = (LocalStatsMatsInterceptor.OutgoingMessageRepresentation)entry.getKey();
                    out.append("&nbsp;&nbsp;" + this.formatInt((Long)entry.getValue()) + " x " + this.formatClass(msg.getMessageClass()) + " " + msg.getMessageType() + " from initiatorId " + this.formatIid(msg.getInitiatorId()) + " to " + this.formatEpid(msg.getTo()) + "<br/>");
                }
            } else {
                out.append("<i>&mdash; No statistics gathered &mdash;</i>\n");
            }
        }
        out.append("</div>\n");
        out.append("</div>\n");
    }

    @Override
    public void createEndpointReport(Appendable out, MatsEndpoint<?, ?> matsEndpoint, boolean includeStages) throws IOException {
        NavigableMap<LocalStatsMatsInterceptor.IncomingMessageRepresentation, LocalStatsMatsInterceptor.StatsSnapshot> initiatorToTerminatorTimeNanos;
        Optional<LocalStatsMatsInterceptor.EndpointStats> endpointStats_;
        LocalStatsMatsInterceptor localStats = this._matsFactory.getFactoryConfig().getPlugins(LocalStatsMatsInterceptor.class).stream().findFirst().orElse(null);
        MatsEndpoint.EndpointConfig config = matsEndpoint.getEndpointConfig();
        LocalStatsMatsInterceptor.StatsSnapshot totExecSnapshot = null;
        LocalStatsMatsInterceptor.EndpointStats endpointStats = null;
        if (localStats != null && (endpointStats_ = localStats.getEndpointStats(matsEndpoint)).isPresent()) {
            endpointStats = endpointStats_.get();
            totExecSnapshot = endpointStats.getTotalEndpointProcessingTimeNanos();
        }
        String hot = totExecSnapshot != null && totExecSnapshot.get999thPercentile() > 1.0E9 ? " matsli_hot" : "";
        String type = this.deduceEndpointType(matsEndpoint);
        out.append("<div class='matsli_report matsli_endpoint" + hot + "' id='matsEndpoint_").append(matsEndpoint.getParentFactory().getFactoryConfig().getName()).append("_").append(config.getEndpointId()).append("'>\n");
        out.append("<div class='matsli_heading'>" + type + " <h3>" + config.getEndpointId() + "</h3>");
        out.append(" - " + this.formatIoClass("Incoming", config.getIncomingClass()));
        out.append(" - " + this.formatIoClass("Reply", config.getReplyClass()));
        out.append(" - " + this.formatIoClass("State", config.getStateClass()));
        out.append(" - <b>Running:</b> " + config.isRunning());
        out.append(" - <b>Concurrency:</b> " + this.formatConcurrency((MatsConfig)config) + "\n");
        out.append("<br/>");
        out.append("<div class='matsli_creation_info'>").append(matsEndpoint.getEndpointConfig().getOrigin().replace(";", " - \n")).append("</div>");
        out.append("</div>\n");
        out.append("<div class='matsli_info'>\n");
        if (endpointStats != null && !(initiatorToTerminatorTimeNanos = endpointStats.getInitiatorToTerminatorTimeNanos()).isEmpty()) {
            out.append("<b>From Initiator to Terminator times:</b> <i>(From start of MatsInitiator.initiate(..), to reception on initial stage of terminator. Susceptible to time skews if initiated on different app.)</i><br/>\n");
            out.append("<table class='matsli_table_init_to_term'>");
            out.append("<thead><tr>");
            out.append("<th>Initiated from</th>");
            out.append("<th>from</th>");
            out.append("<th>observ</th>");
            out.append("<th>samples</th>");
            out.append("<th>avg</th>");
            out.append("<th>median</th>");
            out.append("<th>75%</th>");
            out.append("<th>95%</th>");
            out.append("<th>99.9%</th>");
            out.append("</tr></thead>");
            out.append("<tbody>");
            for (Map.Entry entry : initiatorToTerminatorTimeNanos.entrySet()) {
                LocalStatsMatsInterceptor.IncomingMessageRepresentation msg = (LocalStatsMatsInterceptor.IncomingMessageRepresentation)entry.getKey();
                LocalStatsMatsInterceptor.StatsSnapshot snapshot = (LocalStatsMatsInterceptor.StatsSnapshot)entry.getValue();
                out.append("<tr>");
                out.append("<td>" + this.formatIid(msg.getInitiatorId()) + " @ " + this.formatAppName(msg.getInitiatingAppName()) + "</td>");
                out.append("<td>" + this.formatMsgType(msg.getMessageType()) + " from " + this.formatEpid(msg.getFromStageId()) + " @ " + this.formatAppName(msg.getFromAppName()) + "</td>");
                out.append("<td class='matsli_right'>").append(this.formatInt(snapshot.getNumObservations())).append("</td>");
                out.append("<td class='matsli_right'>").append(this.formatInt(snapshot.getSamples().length)).append("</td>");
                this.timingCellForAverage(out, snapshot);
                this.timingCell(out, snapshot.getMedian());
                this.timingCell(out, snapshot.get75thPercentile());
                this.timingCell(out, snapshot.get95thPercentile());
                this.timingCell(out, snapshot.get999thPercentile());
                out.append("</tr>");
            }
            out.append("</tbody></table>");
            out.append("<br/>\n");
        }
        if (totExecSnapshot != null) {
            out.append("<b>Total endpoint time:</b> " + this.formatStats(totExecSnapshot, false) + "<br/><span style='font-size: 75%; vertical-align: 0.5em'><i>(Note: From entry on Initial Stage to REPLY or NONE. <b>Does not include queue time for Initial Stage!</b>)</i><br/></span>\n");
        }
        out.append("</div>\n");
        if (includeStages) {
            for (MatsStage stage : matsEndpoint.getStages()) {
                this.createStageReport(out, stage);
            }
        }
        out.append("</div>\n");
    }

    @Override
    public void createStageReport(Appendable out, MatsStage<?, ?, ?> matsStage) throws IOException {
        Optional<LocalStatsMatsInterceptor.StageStats> stageStats_;
        LocalStatsMatsInterceptor.StageStats stageStats;
        Optional<LocalStatsMatsInterceptor.StatsSnapshot> stats;
        Optional<LocalStatsMatsInterceptor.StageStats> stageStats_2;
        LocalStatsMatsInterceptor localStats = this._matsFactory.getFactoryConfig().getPlugins(LocalStatsMatsInterceptor.class).stream().findFirst().orElse(null);
        MatsStage.StageConfig config = matsStage.getStageConfig();
        String anchorId = "matsStage_" + matsStage.getParentEndpoint().getParentFactory().getFactoryConfig().getName() + "_" + config.getStageId();
        boolean anchroIdPrinted = false;
        if (localStats != null && (stageStats_2 = localStats.getStageStats(matsStage)).isPresent() && (stats = (stageStats = stageStats_2.get()).getBetweenStagesTimeNanos()).isPresent()) {
            out.append("<div class='matsli_info' id='").append(anchorId).append("'><b>Time between:</b> ").append(this.formatStats(stats.get(), false)).append("</div>\n");
            anchroIdPrinted = true;
        }
        LocalStatsMatsInterceptor.StatsSnapshot totExecSnapshot = null;
        stageStats = null;
        if (localStats != null && (stageStats_ = localStats.getStageStats(matsStage)).isPresent()) {
            stageStats = stageStats_.get();
            totExecSnapshot = stageStats.getStageTotalExecutionTimeNanos();
        }
        String hot = totExecSnapshot != null && totExecSnapshot.get999thPercentile() > 5.0E8 ? " matsli_hot" : "";
        out.append("<div class='matsli_report matsli_stage" + hot + "'" + (String)(anchroIdPrinted ? "" : " id='" + anchorId + "'") + ">\n");
        out.append("<div class='matsli_heading'>Stage <h4>" + config.getStageId() + "</h4>\n");
        out.append(" - <b>Incoming:</b> <code>" + config.getIncomingClass().getSimpleName() + "</code>\n");
        out.append(" - <b>Running:</b> " + config.isRunning());
        out.append(" - <b>Concurrency:</b> " + this.formatConcurrency((MatsConfig)config) + "\n");
        out.append(" - <b>Running stage processors:</b> " + config.getRunningStageProcessors() + "\n");
        out.append("<br/>");
        out.append("<div class='matsli_creation_info'>").append(matsStage.getStageConfig().getOrigin().replace(";", " - \n")).append("</div>");
        out.append("</div>");
        out.append("<div class='matsli_info'>\n");
        if (stageStats != null && totExecSnapshot != null) {
            boolean initialStage = config.getStageIndex() == 0;
            out.append("<b>Queue time</b>: " + this.formatStats(stageStats.getSpentQueueTimeNanos(), false) + " (susceptible to time skews between nodes)<br/>\n");
            NavigableMap<LocalStatsMatsInterceptor.IncomingMessageRepresentation, Long> incomingMessageCounts = stageStats.getIncomingMessageCounts();
            if (incomingMessageCounts.isEmpty()) {
                out.append("<b>NO incoming messages!</b>\n");
            } else if (incomingMessageCounts.size() == 1) {
                out.append("<b>Incoming messages:</b> ");
                Map.Entry entry = incomingMessageCounts.entrySet().iterator().next();
                Iterator msg = (LocalStatsMatsInterceptor.IncomingMessageRepresentation)entry.getKey();
                out.append(this.formatInt((Long)entry.getValue()) + " x " + this.formatMsgType(msg.getMessageType()) + " from " + this.formatEpid(msg.getFromStageId()) + " <b>@</b> " + this.formatAppName(msg.getFromAppName()) + this.formatInit((LocalStatsMatsInterceptor.MessageRepresentation)((Object)msg)) + "<br/>");
            } else {
                out.append("<span>");
                out.append("<b>Incoming messages (" + this.formatInt(totExecSnapshot.getNumObservations()) + "):</b> <div class='matsli_msgs_summary_btn matsli_msgs_summary_or_details_btn_active' onclick='matsli_messages_summary(event)'>Details - <i>click for summary</i></div> <div class='matsli_msgs_details_btn' onclick='matsli_messages_details(event)'>Summary - <i>click for details (" + incomingMessageCounts.size() + ")</i></div><br/>\n");
                out.append("<div class='matsli_msgs_summary'>");
                TreeMap<String, AtomicLong> summer = new TreeMap<String, AtomicLong>();
                for (Map.Entry entry : incomingMessageCounts.entrySet()) {
                    LocalStatsMatsInterceptor.IncomingMessageRepresentation msg = (LocalStatsMatsInterceptor.IncomingMessageRepresentation)entry.getKey();
                    String key = msg.getMessageType() + "#" + (initialStage ? msg.getInitiatingAppName() : msg.getFromStageId());
                    AtomicLong count = summer.computeIfAbsent(key, s -> new AtomicLong());
                    count.addAndGet((Long)entry.getValue());
                }
                for (Map.Entry entry : summer.entrySet()) {
                    int hash = ((String)entry.getKey()).indexOf(35);
                    String messageType = ((String)entry.getKey()).substring(0, hash);
                    String fromOrInitiatingApp = ((String)entry.getKey()).substring(hash + 1);
                    out.append(this.formatInt(((AtomicLong)entry.getValue()).get())).append(" x ").append(this.formatMsgType(messageType));
                    if (initialStage) {
                        out.append(", flows initiated by ").append(this.formatAppName(fromOrInitiatingApp));
                    } else {
                        out.append(" from stageId ").append(this.formatEpid(fromOrInitiatingApp));
                    }
                    out.append("<br/>\n");
                }
                out.append("</div>\n");
                out.append("<div class='matsli_msgs_details matsli_noshow'>");
                for (Map.Entry entry : incomingMessageCounts.entrySet()) {
                    LocalStatsMatsInterceptor.IncomingMessageRepresentation msg = (LocalStatsMatsInterceptor.IncomingMessageRepresentation)entry.getKey();
                    out.append(this.formatInt((Long)entry.getValue()) + " x " + this.formatMsgType(msg.getMessageType()) + " from " + this.formatEpid(msg.getFromStageId()) + " <b>@</b> " + this.formatAppName(msg.getFromAppName()) + this.formatInit(msg) + "<br/>");
                }
                out.append("</div></span>\n");
            }
            out.append("<b>Total stage time:</b> " + this.formatStats(totExecSnapshot, false) + "<br/>\n");
            NavigableMap<MatsStageInterceptor.StageCompletedContext.StageProcessResult, Long> processResultCounts = stageStats.getProcessResultCounts();
            if (processResultCounts.isEmpty()) {
                out.append("<b>NO processing results!</b><br/>\n");
            } else {
                out.append("<b>Processing results:</b> \n");
                boolean first = true;
                for (Map.Entry entry : processResultCounts.entrySet()) {
                    out.append(first ? "" : ", ");
                    first = false;
                    MatsStageInterceptor.StageCompletedContext.StageProcessResult stageProcessResult = (MatsStageInterceptor.StageCompletedContext.StageProcessResult)entry.getKey();
                    out.append(this.formatInt((Long)entry.getValue()) + " x " + this.formatMsgType(stageProcessResult));
                }
                out.append("<br/>\n");
            }
            NavigableMap<LocalStatsMatsInterceptor.OutgoingMessageRepresentation, Long> outgoingMessageCounts = stageStats.getOutgoingMessageCounts();
            long sumOutMsgs = outgoingMessageCounts.values().stream().mapToLong(Long::longValue).sum();
            if (outgoingMessageCounts.isEmpty()) {
                out.append("<b>NO outgoing messages!</b><br/>\n");
            } else if (outgoingMessageCounts.size() == 1) {
                out.append("<b>Outgoing messages:</b> ");
                Map.Entry entry = outgoingMessageCounts.entrySet().iterator().next();
                LocalStatsMatsInterceptor.OutgoingMessageRepresentation msg = (LocalStatsMatsInterceptor.OutgoingMessageRepresentation)entry.getKey();
                out.append(this.formatInt((Long)entry.getValue()) + " x " + this.formatClass(msg.getMessageClass()) + " " + this.formatMsgType(msg.getMessageType()) + " to " + this.formatEpid(msg.getTo()) + this.formatInit(msg) + "<br/>");
            } else {
                out.append("<span>");
                out.append("<b>Outgoing messages (" + this.formatInt(sumOutMsgs) + "):</b> <div class='matsli_msgs_summary_btn matsli_msgs_summary_or_details_btn_active' onclick='matsli_messages_summary(event)'>Details - <i>click for summary</i></div> <div class='matsli_msgs_details_btn' onclick='matsli_messages_details(event)'>Summary - <i>click for details (" + outgoingMessageCounts.size() + ")</i></div><br/>\n");
                out.append("<div class='matsli_msgs_summary'>");
                TreeMap<String, AtomicLong> summer = new TreeMap<String, AtomicLong>();
                for (Map.Entry entry : outgoingMessageCounts.entrySet()) {
                    LocalStatsMatsInterceptor.OutgoingMessageRepresentation msg = (LocalStatsMatsInterceptor.OutgoingMessageRepresentation)entry.getKey();
                    boolean replyMsg = msg.getMessageType() == MatsOutgoingMessage.MessageType.REPLY || msg.getMessageType() == MatsOutgoingMessage.MessageType.REPLY_SUBSCRIPTION;
                    String messageClassName = msg.getMessageClass() == null ? "null" : msg.getMessageClass().getSimpleName();
                    String key = msg.getMessageType() + "#" + messageClassName + "#" + (replyMsg ? msg.getInitiatingAppName() : msg.getTo());
                    AtomicLong count = summer.computeIfAbsent(key, s -> new AtomicLong());
                    count.addAndGet((Long)entry.getValue());
                }
                for (Map.Entry entry : summer.entrySet()) {
                    int hashIdx1 = ((String)entry.getKey()).indexOf(35);
                    int hashIdx2 = ((String)entry.getKey()).indexOf(35, hashIdx1 + 1);
                    String messageType = ((String)entry.getKey()).substring(0, hashIdx1);
                    boolean isReplyMsg = "REPLY".equals(messageType);
                    String messageClass = ((String)entry.getKey()).substring(hashIdx1 + 1, hashIdx2);
                    String toOrInitiatingApp = ((String)entry.getKey()).substring(hashIdx2 + 1);
                    out.append(this.formatInt(((AtomicLong)entry.getValue()).get())).append(" x ").append(this.formatClass(messageClass)).append(' ').append(this.formatMsgType(messageType));
                    if (isReplyMsg) {
                        out.append(", flows initiated by ").append(this.formatAppName(toOrInitiatingApp));
                    } else {
                        out.append(" to ").append(this.formatEpid(toOrInitiatingApp));
                    }
                    out.append("<br/>\n");
                }
                out.append("</div>");
                out.append("<div class='matsli_msgs_details matsli_noshow'>");
                for (Map.Entry entry : outgoingMessageCounts.entrySet()) {
                    LocalStatsMatsInterceptor.OutgoingMessageRepresentation msg = (LocalStatsMatsInterceptor.OutgoingMessageRepresentation)entry.getKey();
                    out.append(this.formatInt((Long)entry.getValue()) + " x " + this.formatClass(msg.getMessageClass()) + " " + this.formatMsgType(msg.getMessageType()) + " to " + this.formatEpid(msg.getTo()) + this.formatInit(msg) + "<br/>");
                }
                out.append("</div></span>\n");
            }
        } else {
            out.append("<i>&mdash; No statistics gathered &mdash;</i>\n");
        }
        out.append("</div>\n");
        out.append("</div>\n");
    }

    RgbaColor colorForMs(double ms) {
        RgbaColor color = ms < 0.0 ? this.ms0 : (ms < 100.0 ? this.ms0.interpolate(this.ms100, 0.0, 100.0, ms) : (ms < 250.0 ? this.ms100.interpolate(this.ms250, 100.0, 250.0, ms) : (ms < 500.0 ? this.ms250.interpolate(this.ms500, 250.0, 500.0, ms) : (ms < 1000.0 ? this.ms500.interpolate(this.ms1000, 500.0, 1000.0, ms) : (ms < 2000.0 ? this.ms1000.interpolate(this.ms2000, 1000.0, 2000.0, ms) : this.ms2000)))));
        return color.interpolate(new RgbaColor(255, 255, 255, 1.0), 0.5);
    }

    RgbaColor colorForNanos(double nanos) {
        return this.colorForMs(nanos / 1000000.0);
    }

    String deduceEndpointType(MatsEndpoint<?, ?> matsEndpoint) {
        Object type;
        MatsEndpoint.EndpointConfig config = matsEndpoint.getEndpointConfig();
        Object object = type = config.getReplyClass() == Void.TYPE ? "Terminator" : "Endpoint";
        if (matsEndpoint.getStages().size() == 1 && config.getReplyClass() != Void.TYPE) {
            type = "Single " + (String)type;
        }
        if (matsEndpoint.getStages().size() > 1) {
            type = matsEndpoint.getStages().size() + "-Stage " + (String)type;
        }
        if (config.isSubscription()) {
            type = "Subscription " + (String)type;
        }
        return type;
    }

    String formatIid(String iid) {
        return "<span class='matsli_iid'>" + iid + "</span>";
    }

    String formatEpid(String epid) {
        return "<span class='matsli_epid'>" + epid + "</span>";
    }

    String formatAppName(String appName) {
        return "<span class='matsli_appname'>" + appName + "</span>";
    }

    String formatMsgType(Object messageType) {
        return "<span class='matsli_msgtype'>" + messageType.toString() + "</span>";
    }

    String formatInit(LocalStatsMatsInterceptor.MessageRepresentation msg) {
        return " &mdash; <i>init:" + this.formatIid(msg.getInitiatorId()) + " <b>@</b> " + this.formatAppName(msg.getInitiatingAppName()) + "</i>";
    }

    String formatIoClass(String what, Class<?> type) throws IOException {
        boolean isVoid = type == Void.TYPE;
        return (isVoid ? "<s>" : "") + "<b>" + what + ":</b> " + this.formatClass(type) + (isVoid ? "</s>" : "") + "\n";
    }

    String formatClass(Class<?> type) {
        if (type == null) {
            return "<code><i>null</i></code>";
        }
        return "<code>" + type.getSimpleName() + "</code>";
    }

    String formatClass(String type) {
        if (type == null || "null".equals(type)) {
            return "<code><i>null</i></code>";
        }
        return "<code>" + type + "</code>";
    }

    String formatConcurrency(MatsConfig config) {
        return config.getConcurrency() + (config.isConcurrencyDefault() ? " <i>(inherited)</i>" : " <i><b>(explicitly set)</b></i>");
    }

    String formatStats(LocalStatsMatsInterceptor.StatsSnapshot snapshot, boolean tooltipStyle) {
        double sd = snapshot.getStdDev();
        double avg = snapshot.getAverage();
        return "<b>avg:</b>" + this.colorAndFormatNanos(avg) + " <b><i>sd</i>:</b>" + this.formatNanos(sd) + " &mdash; <b>50%:</b>" + this.colorAndFormatNanos(snapshot.getMedian()) + ", <b>75%:</b>" + this.colorAndFormatNanos(snapshot.get75thPercentile()) + ", <b>95%:</b>" + this.colorAndFormatNanos(snapshot.get95thPercentile()) + ", <b>98%:</b>" + this.colorAndFormatNanos(snapshot.get98thPercentile()) + ", <b>99%:</b>" + this.colorAndFormatNanos(snapshot.get99thPercentile()) + ", <b>99.9%:</b>" + this.colorAndFormatNanos(snapshot.get999thPercentile()) + ", <b><span class='matsli_max'>max:</sup></b>" + this.colorAndFormatNanos(snapshot.getMax()) + " - <b><span class='matsli_min'>min:</span></b>" + this.formatNanos(snapshot.getMin()) + (tooltipStyle ? "<br/>\n" : " &mdash; ") + "<i>number of samples: " + this.formatInt(snapshot.getSamples().length) + ", out of observations:" + this.formatInt(snapshot.getNumObservations()) + "</i>";
    }

    String colorAndFormatNanos(double nanos) {
        return "<span style='background: " + this.colorForNanos(nanos).toCss() + "'>" + this.formatNanos(nanos) + "</span>";
    }

    String formatInt(long number) {
        return NF_INTEGER.format(number);
    }

    String formatNanos0(double nanos) {
        if (Double.isNaN(nanos)) {
            return "NaN";
        }
        return NF_0_DECIMALS.format(Math.round(nanos / 1000000.0));
    }

    String formatNanos1(double nanos) {
        if (Double.isNaN(nanos)) {
            return "NaN";
        }
        if (nanos == 0.0) {
            return "0";
        }
        return NF_1_DECIMALS.format((double)Math.round(nanos / 100000.0) / 10.0);
    }

    String formatNanos(double nanos) {
        if (Double.isNaN(nanos)) {
            return "NaN";
        }
        if (nanos == 0.0) {
            return "0";
        }
        if (nanos >= 5.0E8) {
            return NF_0_DECIMALS.format(Math.round(nanos / 1000000.0));
        }
        if (nanos >= 5.0E7) {
            return NF_1_DECIMALS.format((double)Math.round(nanos / 100000.0) / 10.0);
        }
        if (nanos >= 5000000.0) {
            return NF_2_DECIMALS.format((double)Math.round(nanos / 10000.0) / 100.0);
        }
        if (nanos < 0.0) {
            return NF_3_DECIMALS.format((double)Math.round(nanos / 1000.0) / 1000.0);
        }
        double round = (double)Math.round(nanos / 1000.0) / 1000.0;
        if (round == 0.0) {
            return "~>0";
        }
        return NF_3_DECIMALS.format(round);
    }

    static {
        NF_SYMBOLS.setDecimalSeparator('.');
        NF_SYMBOLS.setGroupingSeparator('\u202f');
        NF_INTEGER = new DecimalFormat("#,##0");
        NF_INTEGER.setMaximumFractionDigits(0);
        NF_INTEGER.setDecimalFormatSymbols(NF_SYMBOLS);
        NF_0_DECIMALS = new DecimalFormat("#,##0");
        NF_0_DECIMALS.setMaximumFractionDigits(0);
        NF_0_DECIMALS.setDecimalFormatSymbols(NF_SYMBOLS);
        NF_1_DECIMALS = new DecimalFormat("#,##0.0");
        NF_1_DECIMALS.setMaximumFractionDigits(1);
        NF_1_DECIMALS.setDecimalFormatSymbols(NF_SYMBOLS);
        NF_2_DECIMALS = new DecimalFormat("#,##0.00");
        NF_2_DECIMALS.setMaximumFractionDigits(2);
        NF_2_DECIMALS.setDecimalFormatSymbols(NF_SYMBOLS);
        NF_3_DECIMALS = new DecimalFormat("#,##0.000");
        NF_3_DECIMALS.setMaximumFractionDigits(3);
        NF_3_DECIMALS.setDecimalFormatSymbols(NF_SYMBOLS);
    }

    static class RgbaColor {
        private final int r;
        private final int g;
        private final int b;
        private final double a;

        public RgbaColor(int r, int g, int b, double a) {
            this.r = r;
            this.g = g;
            this.b = b;
            this.a = a;
        }

        RgbaColor interpolate(RgbaColor to, double blendTo) {
            if (blendTo > 1.0 || blendTo < 0.0) {
                throw new IllegalArgumentException("Blend must be [0, 1], not '" + blendTo + "'.");
            }
            double inverseBlend = 1.0 - blendTo;
            int newR = (int)Math.round((double)this.r * inverseBlend + (double)to.r * blendTo);
            int newG = (int)Math.round((double)this.g * inverseBlend + (double)to.g * blendTo);
            int newB = (int)Math.round((double)this.b * inverseBlend + (double)to.b * blendTo);
            double newA = this.a * inverseBlend + to.a * blendTo;
            return new RgbaColor(newR, newG, newB, newA);
        }

        RgbaColor interpolate(RgbaColor to, double rangeFrom, double rangeTo, double value) {
            if (value > rangeTo || value < rangeFrom) {
                throw new IllegalArgumentException("value must be in range [" + rangeFrom + "," + rangeTo + "], not '" + value + "'");
            }
            double rangeSpan = rangeTo - rangeFrom;
            double valueInRange = value - rangeFrom;
            double blend = valueInRange / rangeSpan;
            return this.interpolate(to, blend);
        }

        String toCss() {
            return "rgba(" + this.r + "," + this.g + "," + this.b + "," + (double)Math.round(this.a * 1000.0) / 1000.0;
        }
    }
}

