/*
 * Decompiled with CFR 0.152.
 */
package io.mats3.localinspect;

import io.mats3.MatsEndpoint;
import io.mats3.MatsFactory;
import io.mats3.MatsInitiator;
import io.mats3.MatsStage;
import io.mats3.api.intercept.MatsInitiateInterceptor;
import io.mats3.api.intercept.MatsOutgoingMessage;
import io.mats3.api.intercept.MatsStageInterceptor;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalStatsMatsInterceptor
implements MatsInitiateInterceptor.MatsInitiateInterceptOutgoingMessages,
MatsStageInterceptor.MatsStageInterceptOutgoingMessages {
    private static final Logger log = LoggerFactory.getLogger(LocalStatsMatsInterceptor.class);
    public static final int DEFAULT_NUM_SAMPLES = 1100;
    public static final int MAX_NUMBER_OF_DYNAMIC_ENTRIES = 500;
    private final int _numSamples;
    private final ConcurrentHashMap<MatsInitiator, InitiatorStatsImpl> _initiators = new ConcurrentHashMap();
    private final ConcurrentHashMap<MatsEndpoint<?, ?>, EndpointStatsImpl> _endpoints = new ConcurrentHashMap();
    private final ConcurrentHashMap<MatsStage<?, ?, ?>, StageStatsImpl> _stages = new ConcurrentHashMap();
    public static final String EXTRA_STATE_REQUEST_NANOS = "mats.rts";
    public static final String EXTRA_STATE_REQUEST_NODENAME = "mats.rnn";
    public static final String EXTRA_STATE_ENDPOINT_ENTER_NANOS = "mats.eets";
    public static final String EXTRA_STATE_ENDPOINT_ENTER_NODENAME = "mats.eenn";
    public static final String EXTRA_STATE_OR_SIDELOAD_INITIATOR_NANOS = "mats.its";
    public static final String EXTRA_STATE_OR_SIDELOAD_INITIATOR_NODENAME = "mats.inn";

    public static LocalStatsMatsInterceptor install(MatsFactory matsFactory) {
        LocalStatsMatsInterceptor interceptor = new LocalStatsMatsInterceptor(1100);
        matsFactory.getFactoryConfig().installPlugin((MatsFactory.MatsPlugin)interceptor);
        return interceptor;
    }

    private LocalStatsMatsInterceptor(int numSamples) {
        this._numSamples = numSamples;
    }

    public Optional<InitiatorStats> getInitiatorStats(MatsInitiator matsInitiator) {
        return Optional.ofNullable((InitiatorStats)this._initiators.get(matsInitiator));
    }

    public Optional<EndpointStats> getEndpointStats(MatsEndpoint<?, ?> matsEndpoint) {
        return Optional.ofNullable((EndpointStats)this._endpoints.get(matsEndpoint));
    }

    public Optional<StageStats> getStageStats(MatsStage<?, ?, ?> matsStage) {
        return Optional.ofNullable((StageStats)this._stages.get(matsStage));
    }

    public void initiateInterceptOutgoingMessages(MatsInitiateInterceptor.InitiateInterceptOutgoingMessagesContext context) {
        List outgoingMessages = context.getOutgoingMessages();
        for (MatsOutgoingMessage.MatsEditableOutgoingMessage msg : outgoingMessages) {
            if (msg.getMessageType() == MatsOutgoingMessage.MessageType.REQUEST) {
                msg.setSameStackHeightExtraState(EXTRA_STATE_OR_SIDELOAD_INITIATOR_NANOS, (Object)context.getStartedNanoTime());
                msg.setSameStackHeightExtraState(EXTRA_STATE_OR_SIDELOAD_INITIATOR_NODENAME, (Object)context.getInitiator().getParentFactory().getFactoryConfig().getNodename());
                continue;
            }
            msg.addString(EXTRA_STATE_OR_SIDELOAD_INITIATOR_NANOS, Long.toString(context.getStartedNanoTime()));
            msg.addString(EXTRA_STATE_OR_SIDELOAD_INITIATOR_NODENAME, context.getInitiator().getParentFactory().getFactoryConfig().getNodename());
        }
    }

    public void initiateCompleted(MatsInitiateInterceptor.InitiateCompletedContext context) {
        MatsInitiator initiator = context.getInitiator();
        InitiatorStatsImpl initiatorStats = this._initiators.computeIfAbsent(initiator, v -> new InitiatorStatsImpl(this._numSamples));
        long totalExecutionNanos = context.getTotalExecutionNanos();
        initiatorStats.recordTotalExecutionTimeNanos(totalExecutionNanos);
        List outgoingMessages = context.getOutgoingMessages();
        for (MatsOutgoingMessage.MatsSentOutgoingMessage msg : outgoingMessages) {
            initiatorStats.recordOutgoingMessage(msg.getMessageType(), msg.getTo(), msg.getData() == null ? null : msg.getData().getClass(), msg.getInitiatingAppName(), msg.getInitiatorId());
        }
    }

    public void stageReceived(MatsStageInterceptor.StageReceivedContext i_context) {
        MatsStage stage = i_context.getStage();
        EndpointStatsImpl endpointStats = this.getOrCreateEndpointStatsImpl(stage.getParentEndpoint());
        StageStatsImpl stageStats = this._stages.get(stage);
        MatsEndpoint.ProcessContext p_context = i_context.getProcessContext();
        MatsOutgoingMessage.MessageType incomingMessageType = i_context.getIncomingMessageType();
        IncomingMessageRepresentationImpl incomingMessageRepresentation = new IncomingMessageRepresentationImpl(incomingMessageType, p_context.getFromAppName(), p_context.getFromStageId(), p_context.getInitiatingAppName(), p_context.getInitiatorId());
        stageStats.recordIncomingMessage(incomingMessageRepresentation);
        Instant instantSent = p_context.getFromTimestamp();
        Instant instantReceived = Instant.now();
        Duration durationBetweenSentReceived = Duration.between(instantSent, instantReceived);
        stageStats.recordSpentQueueTimeNanos(durationBetweenSentReceived.toNanos());
        if (!(stageStats.isInitial() || incomingMessageType != MatsOutgoingMessage.MessageType.REPLY && incomingMessageType != MatsOutgoingMessage.MessageType.REPLY_SUBSCRIPTION && incomingMessageType != MatsOutgoingMessage.MessageType.NEXT)) {
            String requestNodename = i_context.getIncomingSameStackHeightExtraState(EXTRA_STATE_REQUEST_NODENAME, String.class).orElse(null);
            boolean sameNode = stage.getParentEndpoint().getParentFactory().getFactoryConfig().getNodename().equals(requestNodename);
            if (sameNode) {
                long requestNanoTime = i_context.getIncomingSameStackHeightExtraState(EXTRA_STATE_REQUEST_NANOS, Long.class).orElse(0L);
                stageStats.recordBetweenStagesTimeNanos(System.nanoTime() - requestNanoTime);
            }
        }
        if (stageStats.isInitial() && endpointStats.isTerminatorEndpoint()) {
            boolean initiatedOnSameApp = stage.getParentEndpoint().getParentFactory().getFactoryConfig().getAppName().equals(p_context.getInitiatingAppName());
            if (i_context.getIncomingMessageType() == MatsOutgoingMessage.MessageType.REPLY || i_context.getIncomingMessageType() == MatsOutgoingMessage.MessageType.REPLY_SUBSCRIPTION) {
                if (initiatedOnSameApp) {
                    String initiatorNodename = i_context.getIncomingSameStackHeightExtraState(EXTRA_STATE_OR_SIDELOAD_INITIATOR_NODENAME, String.class).orElse(null);
                    boolean sameNode = stage.getParentEndpoint().getParentFactory().getFactoryConfig().getNodename().equals(initiatorNodename);
                    if (sameNode) {
                        Long initiatedNanoTime = i_context.getIncomingSameStackHeightExtraState(EXTRA_STATE_OR_SIDELOAD_INITIATOR_NANOS, Long.class).orElse(0L);
                        long nanosSinceInit = System.nanoTime() - initiatedNanoTime;
                        endpointStats.recordInitiatorToTerminatorTimeNanos(incomingMessageRepresentation, nanosSinceInit, true);
                    }
                } else {
                    long millisSinceInit = System.currentTimeMillis() - p_context.getInitiatingTimestamp().toEpochMilli();
                    endpointStats.recordInitiatorToTerminatorTimeNanos(incomingMessageRepresentation, millisSinceInit * 1000000L, false);
                }
            } else if (initiatedOnSameApp) {
                String initiatorNodename = p_context.getString(EXTRA_STATE_OR_SIDELOAD_INITIATOR_NODENAME);
                boolean sameNode = stage.getParentEndpoint().getParentFactory().getFactoryConfig().getNodename().equals(initiatorNodename);
                if (sameNode) {
                    long initiatedNanoTime = Long.parseLong(p_context.getString(EXTRA_STATE_OR_SIDELOAD_INITIATOR_NANOS));
                    long nanosSinceInit = System.nanoTime() - initiatedNanoTime;
                    endpointStats.recordInitiatorToTerminatorTimeNanos(incomingMessageRepresentation, nanosSinceInit, true);
                }
            } else {
                long millisSinceInit = System.currentTimeMillis() - p_context.getInitiatingTimestamp().toEpochMilli();
                endpointStats.recordInitiatorToTerminatorTimeNanos(incomingMessageRepresentation, millisSinceInit * 1000000L, false);
            }
        }
    }

    public void stageInterceptOutgoingMessages(MatsStageInterceptor.StageInterceptOutgoingMessageContext context) {
        MatsStage stage = context.getStage();
        this.getOrCreateEndpointStatsImpl(stage.getParentEndpoint());
        StageStatsImpl stageStats = this._stages.get(stage);
        List outgoingMessages = context.getOutgoingMessages();
        for (MatsOutgoingMessage.MatsEditableOutgoingMessage msg : outgoingMessages) {
            MatsOutgoingMessage.MessageType messageType = msg.getMessageType();
            if (messageType != MatsOutgoingMessage.MessageType.REQUEST && messageType != MatsOutgoingMessage.MessageType.NEXT) continue;
            msg.setSameStackHeightExtraState(EXTRA_STATE_REQUEST_NANOS, (Object)System.nanoTime());
            msg.setSameStackHeightExtraState(EXTRA_STATE_REQUEST_NODENAME, (Object)stage.getParentEndpoint().getParentFactory().getFactoryConfig().getNodename());
            if (!stageStats.isInitial()) continue;
            msg.setSameStackHeightExtraState(EXTRA_STATE_ENDPOINT_ENTER_NANOS, (Object)context.getStartedNanoTime());
            msg.setSameStackHeightExtraState(EXTRA_STATE_ENDPOINT_ENTER_NODENAME, (Object)stage.getParentEndpoint().getParentFactory().getFactoryConfig().getNodename());
        }
    }

    public void stageCompleted(MatsStageInterceptor.StageCompletedContext context) {
        MatsStage stage = context.getStage();
        EndpointStatsImpl endpointStats = this.getOrCreateEndpointStatsImpl(stage.getParentEndpoint());
        StageStatsImpl stageStats = this._stages.get(stage);
        stageStats.recordStageTotalExecutionTimeNanos(context.getTotalExecutionNanos());
        MatsStageInterceptor.StageCompletedContext.StageProcessResult stageProcessResult = context.getStageProcessResult();
        stageStats.recordProcessResult(stageProcessResult);
        if (stageProcessResult == MatsStageInterceptor.StageCompletedContext.StageProcessResult.REPLY || stageProcessResult == MatsStageInterceptor.StageCompletedContext.StageProcessResult.REPLY_SUBSCRIPTION || stageProcessResult == MatsStageInterceptor.StageCompletedContext.StageProcessResult.NONE) {
            if (stageStats.isInitial()) {
                endpointStats.recordTotalEndpointProcessingTimeNanos(System.nanoTime() - context.getStartedNanoTime());
            } else {
                String enterNodename = context.getIncomingSameStackHeightExtraState(EXTRA_STATE_ENDPOINT_ENTER_NODENAME, String.class).orElse(null);
                if (stage.getParentEndpoint().getParentFactory().getFactoryConfig().getNodename().equals(enterNodename)) {
                    Long enterNanoTime = context.getIncomingSameStackHeightExtraState(EXTRA_STATE_ENDPOINT_ENTER_NANOS, Long.class).orElse(0L);
                    endpointStats.recordTotalEndpointProcessingTimeNanos(System.nanoTime() - enterNanoTime);
                }
            }
        }
        List outgoingMessages = context.getOutgoingMessages();
        for (MatsOutgoingMessage.MatsSentOutgoingMessage msg : outgoingMessages) {
            stageStats.recordOutgoingMessage(msg.getMessageType(), msg.getTo(), msg.getData() == null ? null : msg.getData().getClass(), msg.getInitiatingAppName(), msg.getInitiatorId());
        }
    }

    private EndpointStatsImpl getOrCreateEndpointStatsImpl(MatsEndpoint<?, ?> endpoint) {
        return this._endpoints.computeIfAbsent(endpoint, v -> {
            EndpointStatsImpl epStats = new EndpointStatsImpl(endpoint, this._numSamples);
            this._stages.putAll(epStats.getStagesMap());
            return epStats;
        });
    }

    private static String createWarnMessageString(String what, String countDescription, int count, String initiatorId) {
        return "Too many measures: We try to do " + what + ". However, this requires us to keep a " + countDescription + ". Currently, we've added [" + count + "], and this is above the threshold of [500], so we've stopped adding more. InitiatorId of this dropped one: [" + initiatorId + "] - notice that the processing goes through just fine, we'll just not gather statistics for it. NOTE: This typically means that you are wrongly creating a dynamic initiatorId, e.g. adding some Id to the String on the init.from(<initiatorId>) call. Don't do that, such an id should go into the traceId";
    }

    private static class RingBuffer_Long {
        private final long[] _values;
        private final int _sampleReservoirSize;
        private final LongAdder _numAdded;
        private int _bufferPos;

        private RingBuffer_Long(int sampleReservoirSize) {
            this._values = new long[sampleReservoirSize];
            this._sampleReservoirSize = sampleReservoirSize;
            this._numAdded = new LongAdder();
            this._bufferPos = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addEntry(long entry) {
            RingBuffer_Long ringBuffer_Long = this;
            synchronized (ringBuffer_Long) {
                this._values[this._bufferPos] = entry;
                ++this._bufferPos;
                this._bufferPos %= this._sampleReservoirSize;
            }
            this._numAdded.increment();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        long[] getValuesCopy() {
            int numAdded = this._numAdded.intValue();
            RingBuffer_Long ringBuffer_Long = this;
            synchronized (ringBuffer_Long) {
                if (numAdded >= this._sampleReservoirSize) {
                    return (long[])this._values.clone();
                }
                long[] copy = new long[numAdded];
                System.arraycopy(this._values, 0, copy, 0, numAdded);
                return copy;
            }
        }

        public int getSampleReservoirSize() {
            return this._sampleReservoirSize;
        }

        public int getSamplesInReservoir() {
            return Math.min(this._numAdded.intValue(), this._sampleReservoirSize);
        }

        public long getNumObservations() {
            return this._numAdded.longValue();
        }
    }

    static class StatsSnapshotImpl
    implements StatsSnapshot {
        private final long[] _values;
        private final long _numObservations;

        public StatsSnapshotImpl(long[] values, long numObservations) {
            this._values = values;
            Arrays.sort(this._values);
            this._numObservations = numObservations;
        }

        @Override
        public long[] getSamples() {
            return this._values;
        }

        @Override
        public long getValueAtPercentile(double percentile) {
            if (this._values.length == 0) {
                return 0L;
            }
            if (percentile == 0.0) {
                return this._values[0];
            }
            if (percentile == 1.0) {
                return this._values[this._values.length - 1];
            }
            double index = percentile * (double)(this._values.length - 1);
            if (index == Math.rint(index)) {
                return this._values[(int)index];
            }
            double firstIndex = Math.floor(index);
            double remainder = index - firstIndex;
            long first = this._values[(int)firstIndex];
            long second = this._values[(int)firstIndex + 1];
            return (long)((double)first * (1.0 - remainder) + (double)second * remainder);
        }

        @Override
        public long getNumObservations() {
            return this._numObservations;
        }

        @Override
        public double getAverage() {
            if (this._values.length == 0) {
                return 0.0;
            }
            long sum = 0L;
            for (long value : this._values) {
                sum += value;
            }
            return (double)sum / (double)this._values.length;
        }

        @Override
        public double getStdDev() {
            if (this._values.length <= 1) {
                return 0.0;
            }
            double avg = this.getAverage();
            double sd = 0.0;
            for (long value : this._values) {
                sd += Math.pow((double)value - avg, 2.0);
            }
            return Math.sqrt(sd / (double)(this._values.length - 1));
        }
    }

    public static class OutgoingMessageRepresentationImpl
    implements OutgoingMessageRepresentation {
        private final MatsOutgoingMessage.MessageType _messageType;
        private final String _to;
        private final Class<?> _messageClass;
        private final String _initiatingAppName;
        private final String _initiatorId;
        private static final Comparator<OutgoingMessageRepresentation> COMPARATOR = Comparator.comparing(MessageRepresentation::getInitiatingAppName).thenComparing(MessageRepresentation::getInitiatorId).thenComparing(MessageRepresentation::getMessageType).thenComparing(OutgoingMessageRepresentation::getTo).thenComparing(o -> o.getMessageClass() == null ? "null" : o.getMessageClass().getName());

        public OutgoingMessageRepresentationImpl(MatsOutgoingMessage.MessageType messageType, String to, Class<?> messageClass, String initiatingAppName, String initiatorId) {
            this._messageType = messageType;
            this._to = to;
            this._messageClass = messageClass;
            this._initiatingAppName = initiatingAppName;
            this._initiatorId = initiatorId;
        }

        @Override
        public MatsOutgoingMessage.MessageType getMessageType() {
            return this._messageType;
        }

        @Override
        public String getTo() {
            return this._to;
        }

        @Override
        public Class<?> getMessageClass() {
            return this._messageClass;
        }

        @Override
        public String getInitiatingAppName() {
            return this._initiatingAppName;
        }

        @Override
        public String getInitiatorId() {
            return this._initiatorId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OutgoingMessageRepresentationImpl that = (OutgoingMessageRepresentationImpl)o;
            return this._messageType == that._messageType && Objects.equals(this._to, that._to) && Objects.equals(this._messageClass, that._messageClass) && Objects.equals(this._initiatingAppName, that._initiatingAppName) && Objects.equals(this._initiatorId, that._initiatorId);
        }

        public int hashCode() {
            return Objects.hash(this._messageType, this._to, this._messageClass, this._initiatingAppName, this._initiatorId);
        }

        @Override
        public int compareTo(OutgoingMessageRepresentation o) {
            return COMPARATOR.compare(this, o);
        }
    }

    public static class IncomingMessageRepresentationImpl
    implements IncomingMessageRepresentation {
        private final MatsOutgoingMessage.MessageType _messageType;
        private final String _fromAppName;
        private final String _fromStageId;
        private final String _initiatingAppName;
        private final String _initiatorId;
        private static final Comparator<IncomingMessageRepresentation> COMPARATOR = Comparator.comparing(MessageRepresentation::getInitiatingAppName).thenComparing(MessageRepresentation::getInitiatorId).thenComparing(MessageRepresentation::getMessageType).thenComparing(IncomingMessageRepresentation::getFromAppName).thenComparing(IncomingMessageRepresentation::getFromStageId);

        public IncomingMessageRepresentationImpl(MatsOutgoingMessage.MessageType messageType, String fromAppName, String fromStageId, String initiatingAppName, String initiatorId) {
            this._messageType = messageType;
            this._fromAppName = fromAppName;
            this._fromStageId = fromStageId;
            this._initiatingAppName = initiatingAppName;
            this._initiatorId = initiatorId;
        }

        @Override
        public MatsOutgoingMessage.MessageType getMessageType() {
            return this._messageType;
        }

        @Override
        public String getFromAppName() {
            return this._fromAppName;
        }

        @Override
        public String getFromStageId() {
            return this._fromStageId;
        }

        @Override
        public String getInitiatingAppName() {
            return this._initiatingAppName;
        }

        @Override
        public String getInitiatorId() {
            return this._initiatorId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IncomingMessageRepresentationImpl that = (IncomingMessageRepresentationImpl)o;
            return this._messageType == that._messageType && Objects.equals(this._fromAppName, that._fromAppName) && Objects.equals(this._fromStageId, that._fromStageId) && Objects.equals(this._initiatingAppName, that._initiatingAppName) && Objects.equals(this._initiatorId, that._initiatorId);
        }

        public int hashCode() {
            return Objects.hash(this._messageType, this._fromAppName, this._fromStageId, this._initiatingAppName, this._initiatorId);
        }

        @Override
        public int compareTo(IncomingMessageRepresentation o) {
            return COMPARATOR.compare(this, o);
        }
    }

    static class StageStatsImpl
    implements StageStats {
        private final RingBuffer_Long _spentQueueTimeNanos;
        private final RingBuffer_Long _betweenStagesTimeNanos;
        private final RingBuffer_Long _totalExecutionTimeNanos;
        private final int _index;
        private final boolean _initial;
        private final AtomicInteger _numberOfIncomingMessageCounts = new AtomicInteger(0);
        private final ConcurrentHashMap<IncomingMessageRepresentation, AtomicLong> _incomingMessageCounts = new ConcurrentHashMap();
        private final AtomicInteger _numberOfOutgoingMessageCounts = new AtomicInteger(0);
        private final ConcurrentHashMap<OutgoingMessageRepresentation, AtomicLong> _outgoingMessageCounts = new ConcurrentHashMap();
        private final ConcurrentHashMap<MatsStageInterceptor.StageCompletedContext.StageProcessResult, AtomicLong> _processResultCounts = new ConcurrentHashMap();

        public StageStatsImpl(int sampleReservoirSize, int index) {
            this._spentQueueTimeNanos = new RingBuffer_Long(sampleReservoirSize);
            this._betweenStagesTimeNanos = index == 0 ? null : new RingBuffer_Long(sampleReservoirSize);
            this._totalExecutionTimeNanos = new RingBuffer_Long(sampleReservoirSize);
            this._index = index;
            this._initial = index == 0;
        }

        private void recordSpentQueueTimeNanos(long betweenStagesTimeNanos) {
            this._spentQueueTimeNanos.addEntry(betweenStagesTimeNanos);
        }

        private void recordBetweenStagesTimeNanos(long betweenStagesTimeNanos) {
            this._betweenStagesTimeNanos.addEntry(betweenStagesTimeNanos);
        }

        private void recordStageTotalExecutionTimeNanos(long totalExecutionTimeNanos) {
            this._totalExecutionTimeNanos.addEntry(totalExecutionTimeNanos);
        }

        private void recordIncomingMessage(IncomingMessageRepresentation incomingMessageRepresentation) {
            if (this._numberOfIncomingMessageCounts.get() >= 500) {
                log.warn(LocalStatsMatsInterceptor.createWarnMessageString("counts on incoming messages", "count per initiatorId/msgType/from per MatsStage", this._numberOfIncomingMessageCounts.get(), incomingMessageRepresentation.getInitiatorId() + "@" + incomingMessageRepresentation.getInitiatingAppName()));
                return;
            }
            AtomicLong count = this._incomingMessageCounts.computeIfAbsent(incomingMessageRepresentation, x -> {
                this._numberOfIncomingMessageCounts.incrementAndGet();
                return new AtomicLong();
            });
            count.incrementAndGet();
        }

        private void recordProcessResult(MatsStageInterceptor.StageCompletedContext.StageProcessResult stageProcessResult) {
            AtomicLong count = this._processResultCounts.computeIfAbsent(stageProcessResult, x -> new AtomicLong());
            count.incrementAndGet();
        }

        private void recordOutgoingMessage(MatsOutgoingMessage.MessageType messageType, String to, Class<?> messageClass, String initiatingAppName, String initiatorId) {
            if (this._numberOfOutgoingMessageCounts.get() >= 500) {
                log.warn(LocalStatsMatsInterceptor.createWarnMessageString("counts on outgoing messages", "count per initiatorId/msgType/to per MatsStage", this._numberOfOutgoingMessageCounts.get(), initiatorId + "@" + initiatingAppName));
                return;
            }
            OutgoingMessageRepresentationImpl msg = new OutgoingMessageRepresentationImpl(messageType, to, messageClass, initiatingAppName, initiatorId);
            AtomicLong count = this._outgoingMessageCounts.computeIfAbsent(msg, x -> {
                this._numberOfOutgoingMessageCounts.incrementAndGet();
                return new AtomicLong();
            });
            count.incrementAndGet();
        }

        @Override
        public int getIndex() {
            return this._index;
        }

        @Override
        public boolean isInitial() {
            return this._initial;
        }

        @Override
        public StatsSnapshot getSpentQueueTimeNanos() {
            return new StatsSnapshotImpl(this._spentQueueTimeNanos.getValuesCopy(), this._spentQueueTimeNanos.getNumObservations());
        }

        @Override
        public Optional<StatsSnapshot> getBetweenStagesTimeNanos() {
            if (this._betweenStagesTimeNanos == null) {
                return Optional.empty();
            }
            return Optional.of(new StatsSnapshotImpl(this._betweenStagesTimeNanos.getValuesCopy(), this._betweenStagesTimeNanos.getNumObservations()));
        }

        @Override
        public StatsSnapshot getStageTotalExecutionTimeNanos() {
            return new StatsSnapshotImpl(this._totalExecutionTimeNanos.getValuesCopy(), this._totalExecutionTimeNanos.getNumObservations());
        }

        @Override
        public NavigableMap<IncomingMessageRepresentation, Long> getIncomingMessageCounts() {
            TreeMap<IncomingMessageRepresentation, Long> ret = new TreeMap<IncomingMessageRepresentation, Long>();
            this._incomingMessageCounts.forEach((k, v) -> ret.put((IncomingMessageRepresentation)k, v.get()));
            return ret;
        }

        @Override
        public NavigableMap<MatsStageInterceptor.StageCompletedContext.StageProcessResult, Long> getProcessResultCounts() {
            TreeMap<MatsStageInterceptor.StageCompletedContext.StageProcessResult, Long> ret = new TreeMap<MatsStageInterceptor.StageCompletedContext.StageProcessResult, Long>();
            this._processResultCounts.forEach((k, v) -> ret.put((MatsStageInterceptor.StageCompletedContext.StageProcessResult)k, v.get()));
            return ret;
        }

        @Override
        public NavigableMap<OutgoingMessageRepresentation, Long> getOutgoingMessageCounts() {
            TreeMap<OutgoingMessageRepresentation, Long> ret = new TreeMap<OutgoingMessageRepresentation, Long>();
            this._outgoingMessageCounts.forEach((k, v) -> ret.put((OutgoingMessageRepresentation)k, v.get()));
            return ret;
        }
    }

    public static class EndpointStatsImpl
    implements EndpointStats {
        private final boolean _isTerminator;
        private final Map<MatsStage<?, ?, ?>, StageStatsImpl> _stagesMap;
        private final List<StageStats> _stageStats_unmodifiable;
        private final RingBuffer_Long _totalEndpointProcessingTimeNanos;
        private final int _sampleReservoirSize;
        private final AtomicInteger _numberOfAddedInitiatorToTerminatorEntries = new AtomicInteger(0);
        private final ConcurrentHashMap<IncomingMessageRepresentation, InitiatorToTerminatorStatsHolder> _initiatorToTerminatorTimeNanos = new ConcurrentHashMap();

        private EndpointStatsImpl(MatsEndpoint<?, ?> endpoint, int sampleReservoirSize) {
            Class replyClass = endpoint.getEndpointConfig().getReplyClass();
            this._isTerminator = replyClass == Void.TYPE || replyClass == Void.class;
            List stages = endpoint.getStages();
            this._stagesMap = new HashMap(stages.size());
            ArrayList<StageStatsImpl> stageStatsList = new ArrayList<StageStatsImpl>(stages.size());
            for (int i = 0; i < stages.size(); ++i) {
                MatsStage stage = (MatsStage)stages.get(i);
                StageStatsImpl stageStats = new StageStatsImpl(sampleReservoirSize, i);
                this._stagesMap.put(stage, stageStats);
                stageStatsList.add(stageStats);
            }
            this._stageStats_unmodifiable = Collections.unmodifiableList(stageStatsList);
            this._sampleReservoirSize = sampleReservoirSize;
            this._totalEndpointProcessingTimeNanos = new RingBuffer_Long(sampleReservoirSize);
        }

        public Map<MatsStage<?, ?, ?>, StageStatsImpl> getStagesMap() {
            return this._stagesMap;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void recordInitiatorToTerminatorTimeNanos(IncomingMessageRepresentation incomingMessageRepresentation, long initiatorToTerminatorTimeNanos, boolean sameNode) {
            if (this._numberOfAddedInitiatorToTerminatorEntries.get() >= 500) {
                log.warn(LocalStatsMatsInterceptor.createWarnMessageString("statistics on timing between initiations and terminators", "statistics-gatherer per initiatorId/terminatorId", this._numberOfAddedInitiatorToTerminatorEntries.get(), incomingMessageRepresentation.getInitiatorId() + "@" + incomingMessageRepresentation.getInitiatingAppName()));
                return;
            }
            InitiatorToTerminatorStatsHolder ringBufferHolder = this._initiatorToTerminatorTimeNanos.computeIfAbsent(incomingMessageRepresentation, s -> {
                this._numberOfAddedInitiatorToTerminatorEntries.incrementAndGet();
                return new InitiatorToTerminatorStatsHolder(new RingBuffer_Long(this._sampleReservoirSize));
            });
            boolean alreadySeenSameNode = ringBufferHolder._sameNode.get();
            if (alreadySeenSameNode) {
                if (!sameNode) return;
                ringBufferHolder._ringBuffer.addEntry(initiatorToTerminatorTimeNanos);
                return;
            } else {
                ringBufferHolder._ringBuffer.addEntry(initiatorToTerminatorTimeNanos);
                if (!sameNode) return;
                ringBufferHolder._sameNode.set(true);
            }
        }

        private void recordTotalEndpointProcessingTimeNanos(long totalEndpointProcessingTimeNanos) {
            this._totalEndpointProcessingTimeNanos.addEntry(totalEndpointProcessingTimeNanos);
        }

        @Override
        public boolean isTerminatorEndpoint() {
            return this._isTerminator;
        }

        @Override
        public List<StageStats> getStagesStats() {
            return this._stageStats_unmodifiable;
        }

        @Override
        public StageStats getStageStats(MatsStage<?, ?, ?> stage) {
            return this._stagesMap.get(stage);
        }

        @Override
        public StatsSnapshot getTotalEndpointProcessingTimeNanos() {
            return new StatsSnapshotImpl(this._totalEndpointProcessingTimeNanos.getValuesCopy(), this._totalEndpointProcessingTimeNanos.getNumObservations());
        }

        @Override
        public NavigableMap<IncomingMessageRepresentation, StatsSnapshot> getInitiatorToTerminatorTimeNanos() {
            TreeMap<IncomingMessageRepresentation, StatsSnapshot> ret = new TreeMap<IncomingMessageRepresentation, StatsSnapshot>();
            this._initiatorToTerminatorTimeNanos.forEach((k, v) -> ret.put((IncomingMessageRepresentation)k, new StatsSnapshotImpl(v._ringBuffer.getValuesCopy(), v._ringBuffer.getNumObservations())));
            return ret;
        }

        private static class InitiatorToTerminatorStatsHolder {
            private final RingBuffer_Long _ringBuffer;
            private final AtomicBoolean _sameNode = new AtomicBoolean(false);

            public InitiatorToTerminatorStatsHolder(RingBuffer_Long ringBuffer) {
                this._ringBuffer = ringBuffer;
            }
        }
    }

    static class InitiatorStatsImpl
    implements InitiatorStats {
        private final RingBuffer_Long _totalExecutionTimeNanos;
        private final AtomicInteger _numberOfAddedOutgoingMessageCounts = new AtomicInteger(0);
        private final ConcurrentHashMap<OutgoingMessageRepresentationImpl, AtomicLong> _outgoingMessageCounts = new ConcurrentHashMap();

        public InitiatorStatsImpl(int numSamples) {
            this._totalExecutionTimeNanos = new RingBuffer_Long(numSamples);
        }

        public void recordTotalExecutionTimeNanos(long totalExecutionTimeNanos) {
            this._totalExecutionTimeNanos.addEntry(totalExecutionTimeNanos);
        }

        private void recordOutgoingMessage(MatsOutgoingMessage.MessageType messageType, String to, Class<?> messageClass, String initiatingAppName, String initiatorId) {
            if (this._numberOfAddedOutgoingMessageCounts.get() >= 500) {
                log.warn(LocalStatsMatsInterceptor.createWarnMessageString("counts on outgoing messages from initiators", "count per initiatorId/msgType/to per MatsInitiator", this._numberOfAddedOutgoingMessageCounts.get(), initiatorId + "@" + initiatingAppName));
                return;
            }
            OutgoingMessageRepresentationImpl msg = new OutgoingMessageRepresentationImpl(messageType, to, messageClass, initiatingAppName, initiatorId);
            AtomicLong count = this._outgoingMessageCounts.computeIfAbsent(msg, x -> {
                this._numberOfAddedOutgoingMessageCounts.incrementAndGet();
                return new AtomicLong();
            });
            count.incrementAndGet();
        }

        @Override
        public StatsSnapshot getTotalExecutionTimeNanos() {
            return new StatsSnapshotImpl(this._totalExecutionTimeNanos.getValuesCopy(), this._totalExecutionTimeNanos.getNumObservations());
        }

        @Override
        public NavigableMap<OutgoingMessageRepresentation, Long> getOutgoingMessageCounts() {
            TreeMap<OutgoingMessageRepresentation, Long> ret = new TreeMap<OutgoingMessageRepresentation, Long>();
            this._outgoingMessageCounts.forEach((k, v) -> ret.put((OutgoingMessageRepresentation)k, v.get()));
            return ret;
        }
    }

    public static interface OutgoingMessageRepresentation
    extends MessageRepresentation,
    Comparable<OutgoingMessageRepresentation> {
        public String getTo();

        public Class<?> getMessageClass();
    }

    public static interface IncomingMessageRepresentation
    extends MessageRepresentation,
    Comparable<IncomingMessageRepresentation> {
        public String getFromAppName();

        public String getFromStageId();
    }

    public static interface MessageRepresentation {
        public MatsOutgoingMessage.MessageType getMessageType();

        public String getInitiatingAppName();

        public String getInitiatorId();
    }

    static interface StatsSnapshot {
        public long[] getSamples();

        public long getValueAtPercentile(double var1);

        public long getNumObservations();

        default public long getMin() {
            return this.getValueAtPercentile(0.0);
        }

        public double getAverage();

        default public long getMax() {
            return this.getValueAtPercentile(1.0);
        }

        public double getStdDev();

        default public double getMedian() {
            return this.getValueAtPercentile(0.5);
        }

        default public double get75thPercentile() {
            return this.getValueAtPercentile(0.75);
        }

        default public double get95thPercentile() {
            return this.getValueAtPercentile(0.95);
        }

        default public double get98thPercentile() {
            return this.getValueAtPercentile(0.98);
        }

        default public double get99thPercentile() {
            return this.getValueAtPercentile(0.99);
        }

        default public double get999thPercentile() {
            return this.getValueAtPercentile(0.999);
        }
    }

    public static interface StageStats {
        public int getIndex();

        public boolean isInitial();

        public StatsSnapshot getSpentQueueTimeNanos();

        public Optional<StatsSnapshot> getBetweenStagesTimeNanos();

        public StatsSnapshot getStageTotalExecutionTimeNanos();

        public NavigableMap<IncomingMessageRepresentation, Long> getIncomingMessageCounts();

        public NavigableMap<MatsStageInterceptor.StageCompletedContext.StageProcessResult, Long> getProcessResultCounts();

        public NavigableMap<OutgoingMessageRepresentation, Long> getOutgoingMessageCounts();
    }

    public static interface EndpointStats {
        public List<StageStats> getStagesStats();

        public StageStats getStageStats(MatsStage<?, ?, ?> var1);

        public StatsSnapshot getTotalEndpointProcessingTimeNanos();

        public boolean isTerminatorEndpoint();

        public NavigableMap<IncomingMessageRepresentation, StatsSnapshot> getInitiatorToTerminatorTimeNanos();
    }

    public static interface InitiatorStats {
        public StatsSnapshot getTotalExecutionTimeNanos();

        public NavigableMap<OutgoingMessageRepresentation, Long> getOutgoingMessageCounts();
    }
}

