/*
 * Decompiled with CFR 0.152.
 */
package io.mats3.serial.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import io.mats3.serial.MatsSerializer;
import io.mats3.serial.MatsTrace;
import io.mats3.serial.impl.MatsTraceFieldImpl;
import io.mats3.util.FieldBasedJacksonMapper;
import io.mats3.util.compression.ByteArrayDeflaterOutputStreamWithStats;
import io.mats3.util.compression.InflaterInputStreamWithStats;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;

public class MatsSerializerJson
implements MatsSerializer {
    public static String IDENTIFICATION = "MatsTrace_JSON_v1";
    public static int DEFAULT_COMPRESSION_LEVEL = 1;
    private final int _compressionLevel;
    private final ObjectMapper _objectMapper;
    private final ObjectReader _matsTraceJson_Reader;
    private final ObjectWriter _matsTraceJson_Writer;
    private static final String COMPRESS_DEFLATE = "deflate";
    private static final String COMPRESS_PLAIN = "plain";
    private static final String DECOMPRESSED_SIZE_ATTRIBUTE = ";decompSize=";

    public static MatsSerializerJson create() {
        return new MatsSerializerJson(DEFAULT_COMPRESSION_LEVEL);
    }

    public static MatsSerializerJson create(int compressionLevel) {
        return new MatsSerializerJson(compressionLevel);
    }

    protected MatsSerializerJson(int compressionLevel) {
        this._compressionLevel = compressionLevel;
        ObjectMapper mapper = FieldBasedJacksonMapper.getMats3DefaultJacksonObjectMapper();
        this.extraConfigureObjectMapper(mapper);
        this._objectMapper = mapper;
        this._matsTraceJson_Reader = mapper.readerFor(MatsTraceFieldImpl.class);
        this._matsTraceJson_Writer = mapper.writerFor(MatsTraceFieldImpl.class);
    }

    protected void extraConfigureObjectMapper(ObjectMapper mapper) {
    }

    public boolean handlesMeta(String meta) {
        if (meta == null) {
            return false;
        }
        return meta.startsWith(IDENTIFICATION);
    }

    public MatsTrace createNewMatsTrace(String traceId, String flowId, MatsTrace.KeepMatsTrace keepMatsTrace, boolean nonPersistent, boolean interactive, long ttlMillis, boolean noAudit) {
        MatsTrace ret = MatsTraceFieldImpl.createNew((String)traceId, (String)flowId, (MatsTrace.KeepMatsTrace)keepMatsTrace, (boolean)nonPersistent, (boolean)interactive, (long)ttlMillis, (boolean)noAudit);
        ret.setMatsSerializerMeta(IDENTIFICATION);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MatsSerializer.SerializedMatsTrace serializeMatsTrace(MatsTrace matsTrace) {
        try {
            long nanosAtStart_SerializationAndCompression = System.nanoTime();
            out.setCompressionLevel(this._compressionLevel);
            try (ByteArrayDeflaterOutputStreamWithStats out = new ByteArrayDeflaterOutputStreamWithStats();){
                this._matsTraceJson_Writer.writeValue((OutputStream)out, (Object)matsTrace);
            }
            long nanosTaken_Compression = out.getDeflateAndWriteTimeNanos();
            long nanosTaken_Serialization = System.nanoTime() - nanosAtStart_SerializationAndCompression - nanosTaken_Compression;
            byte[] resultBytes = out.toByteArray();
            long serializedBytesLength = resultBytes.length;
            String meta = IDENTIFICATION + ":deflate;decompSize=" + serializedBytesLength;
            matsTrace.setMatsSerializerMeta(meta);
            return new SerializedMatsTraceImpl(resultBytes, meta, (int)serializedBytesLength, nanosTaken_Serialization, nanosTaken_Compression);
        }
        catch (IOException e) {
            throw new MatsSerializer.SerializationException("Couldn't serialize MatsTrace, which is crazy!\n" + matsTrace, (Throwable)e);
        }
    }

    public MatsSerializer.DeserializedMatsTrace deserializeMatsTrace(byte[] matsTraceBytes, String meta) {
        return this.deserializeMatsTrace(matsTraceBytes, 0, matsTraceBytes.length, meta);
    }

    public MatsSerializer.DeserializedMatsTrace deserializeMatsTrace(byte[] matsTraceBytes, int offset, int length, String meta) {
        try {
            long nanosTaken_Deserialization;
            long nanosTaken_Decompression;
            int decompressedBytesLength;
            MatsTrace matsTrace;
            if (meta.indexOf(58) != -1) {
                meta = meta.substring(meta.indexOf(58) + 1);
            }
            if (meta.startsWith(COMPRESS_DEFLATE)) {
                long nanosStart_DecompressionAndDeserialization = System.nanoTime();
                InflaterInputStreamWithStats in = new InflaterInputStreamWithStats(matsTraceBytes, offset, length);
                matsTrace = (MatsTrace)this._matsTraceJson_Reader.readValue((InputStream)in);
                decompressedBytesLength = (int)in.getUncompressedBytesOutput();
                nanosTaken_Decompression = in.getReadAndInflateTimeNanos();
                nanosTaken_Deserialization = System.nanoTime() - nanosStart_DecompressionAndDeserialization - nanosTaken_Decompression;
            } else if (meta.startsWith(COMPRESS_PLAIN)) {
                long nanosStart_Deserialization = System.nanoTime();
                nanosTaken_Decompression = 0L;
                decompressedBytesLength = length;
                matsTrace = (MatsTrace)this._matsTraceJson_Reader.readValue(matsTraceBytes, offset, length);
                nanosTaken_Deserialization = System.nanoTime() - nanosStart_Deserialization;
            } else {
                throw new AssertionError((Object)"Can only deserialize 'plain' and 'deflate'.");
            }
            matsTrace.setMatsSerializerMeta(meta);
            return new DeserializedMatsTraceImpl(matsTrace, matsTraceBytes.length, decompressedBytesLength, nanosTaken_Deserialization, nanosTaken_Decompression);
        }
        catch (IOException e) {
            throw new MatsSerializer.SerializationException("Couldn't deserialize MatsTrace from given JSON, which is crazy!\n" + new String(matsTraceBytes, StandardCharsets.UTF_8), (Throwable)e);
        }
    }

    public String serializeObject(Object object) {
        if (object == null) {
            return null;
        }
        try {
            return this._objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new MatsSerializer.SerializationException("Couldn't serialize Object [" + object + "].", (Throwable)e);
        }
    }

    public int sizeOfSerialized(Object s, String meta) {
        if (s == null) {
            return 0;
        }
        return ((String)s).length();
    }

    public <T> T deserializeObject(Object serialized, Class<T> type, String meta) {
        if (serialized == null) {
            return null;
        }
        try {
            return (T)this._objectMapper.readValue((String)serialized, type);
        }
        catch (IOException e) {
            throw new MatsSerializer.SerializationException("Couldn't deserialize JSON into object of type [" + type + "].\n" + serialized, (Throwable)e);
        }
    }

    public <T> T newInstance(Class<T> clazz) {
        if (Boolean.class == clazz || Boolean.TYPE == clazz) {
            return this.deserializeObject("0", clazz, IDENTIFICATION);
        }
        if (clazz.isPrimitive() || Number.class.isAssignableFrom(clazz) || Character.class == clazz) {
            return this.deserializeObject("0", clazz, IDENTIFICATION);
        }
        if (String.class == clazz) {
            String t = "";
            return (T)t;
        }
        try {
            return this.deserializeObject("{}", clazz, IDENTIFICATION);
        }
        catch (MatsSerializer.SerializationException e) {
            throw new CannotCreateEmptyInstanceException("Could not create an empty object of type [" + clazz + "] by attempting to deserialize the empty object JSON string \"{}\".", e);
        }
    }

    private static class CannotCreateEmptyInstanceException
    extends MatsSerializer.SerializationException {
        CannotCreateEmptyInstanceException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    private static final class DeserializedMatsTraceImpl
    implements MatsSerializer.DeserializedMatsTrace {
        private final MatsTrace _matsTrace;
        private final int _sizeIncoming;
        private final int _sizeDecompressed;
        private final long _nanosDeserialization;
        private final long _nanosDecompression;

        public DeserializedMatsTraceImpl(MatsTrace matsTrace, int sizeIncoming, int sizeDecompressed, long nanosDeserialization, long nanosDecompression) {
            this._matsTrace = matsTrace;
            this._sizeIncoming = sizeIncoming;
            this._sizeDecompressed = sizeDecompressed;
            this._nanosDeserialization = nanosDeserialization;
            this._nanosDecompression = nanosDecompression;
        }

        public MatsTrace getMatsTrace() {
            return this._matsTrace;
        }

        public int getSizeIncoming() {
            return this._sizeIncoming;
        }

        public int getSizeDecompressed() {
            return this._sizeDecompressed;
        }

        public long getNanosDeserialization() {
            return this._nanosDeserialization;
        }

        public long getNanosDecompression() {
            return this._nanosDecompression;
        }
    }

    private static class SerializedMatsTraceImpl
    implements MatsSerializer.SerializedMatsTrace {
        private final byte[] _matsTraceBytes;
        private final String _meta;
        private final int _sizeUncompressed;
        private final long _nanosSerialization;
        private final long _nanosCompression;

        public SerializedMatsTraceImpl(byte[] matsTraceBytes, String meta, int sizeUncompressed, long nanosSerialization, long nanosCompression) {
            this._matsTraceBytes = matsTraceBytes;
            this._meta = meta;
            this._sizeUncompressed = sizeUncompressed;
            this._nanosSerialization = nanosSerialization;
            this._nanosCompression = nanosCompression;
        }

        public byte[] getMatsTraceBytes() {
            return this._matsTraceBytes;
        }

        public String getMeta() {
            return this._meta;
        }

        public int getSizeUncompressed() {
            return this._sizeUncompressed;
        }

        public long getNanosSerialization() {
            return this._nanosSerialization;
        }

        public long getNanosCompression() {
            return this._nanosCompression;
        }
    }
}

