/*
 * Decompiled with CFR 0.152.
 */
package io.mats3.serial.impl;

import io.mats3.serial.MatsTrace;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ThreadLocalRandom;

public class MatsTraceFieldImpl<Z>
implements MatsTrace<Z>,
Cloneable {
    private final String id;
    private final String tid;
    private long ts;
    private final MatsTrace.KeepMatsTrace kt;
    private final Boolean np;
    private final Boolean ia;
    private final Long tl;
    private final Boolean na;
    private Long tidh;
    private Long tidl;
    private Long sid;
    private Long pid;
    private Byte f;
    private long[] sids;
    private int d;
    private String an;
    private String av;
    private String h;
    private String iid;
    private String x;
    private String auth;
    private String sig;
    private int cn;
    private int tcn;
    private String pmid;
    private List<CallImpl<Z>> c = new ArrayList<CallImpl<Z>>();
    private List<StackStateImpl<Z>> ss = new ArrayList<StackStateImpl<Z>>();
    private Map<String, Z> tp = new LinkedHashMap<String, Z>();
    private long[] ots;
    private long[] eets;
    private static final long FNV1A_64_OFFSET_BASIS = -3750763034362895579L;
    private static final long FNV1A_64_PRIME = 1099511628211L;

    @Override
    public MatsTrace<Z> withDebugInfo(String initiatingAppName, String initiatingAppVersion, String initiatingHost, String initiatorId, String debugInfo) {
        this.an = initiatingAppName;
        this.av = initiatingAppVersion;
        this.h = initiatingHost;
        this.iid = initiatorId;
        this.x = debugInfo;
        return this;
    }

    @Override
    public MatsTrace<Z> withChildFlow(String parentMatsMessageId, int totalCallNumber) {
        this.pmid = parentMatsMessageId;
        this.tcn = totalCallNumber;
        return this;
    }

    protected MatsTraceFieldImpl() {
        this.tid = null;
        this.id = null;
        this.kt = null;
        this.np = null;
        this.ia = null;
        this.tl = null;
        this.na = null;
    }

    protected MatsTraceFieldImpl(String traceId, String flowId, MatsTrace.KeepMatsTrace keepMatsTrace, boolean nonPersistent, boolean interactive, long ttlMillis, boolean noAudit) {
        this.tid = traceId;
        this.id = flowId;
        this.ts = System.currentTimeMillis();
        this.eets = new long[]{0L};
        this.kt = keepMatsTrace;
        this.np = nonPersistent ? Boolean.TRUE : null;
        this.ia = interactive ? Boolean.TRUE : null;
        this.tl = ttlMillis > 0L ? Long.valueOf(ttlMillis) : null;
        this.na = noAudit ? Boolean.TRUE : null;
        this.cn = 0;
        this.tcn = 0;
    }

    public void overrideInitiatingTimestamp_ForTests(long timestamp) {
        this.ts = timestamp;
        this.eets = new long[]{0L};
    }

    @Override
    public String getTraceId() {
        return this.tid;
    }

    @Override
    public String getFlowId() {
        return this.id;
    }

    @Override
    public long getInitiatingTimestamp() {
        return this.ts;
    }

    @Override
    public MatsTrace.KeepMatsTrace getKeepTrace() {
        return this.kt;
    }

    @Override
    public boolean isNonPersistent() {
        return this.np == null ? Boolean.FALSE : this.np;
    }

    @Override
    public boolean isInteractive() {
        return this.ia == null ? Boolean.FALSE : this.ia;
    }

    @Override
    public long getTimeToLive() {
        return this.tl != null ? this.tl : 0L;
    }

    @Override
    public boolean isNoAudit() {
        return this.na == null ? Boolean.FALSE : this.na;
    }

    @Override
    public String getInitiatingAppName() {
        return this.an == null ? "-nulled-" : this.an;
    }

    @Override
    public String getInitiatingAppVersion() {
        return this.av == null ? "-nulled-" : this.av;
    }

    @Override
    public String getInitiatingHost() {
        return this.h == null ? "-nulled-" : this.h;
    }

    @Override
    public String getInitiatorId() {
        return this.iid == null ? "-nulled-" : this.iid;
    }

    @Override
    public String getDebugInfo() {
        return this.x;
    }

    @Override
    public int getCallNumber() {
        return this.cn;
    }

    @Override
    public int getTotalCallNumber() {
        return this.tcn;
    }

    @Override
    public String getParentMatsMessageId() {
        return this.pmid;
    }

    @Override
    public void setTraceProperty(String propertyName, Z propertyValue) {
        this.tp.put(propertyName, propertyValue);
    }

    @Override
    public Z getTraceProperty(String propertyName) {
        return this.tp.get(propertyName);
    }

    @Override
    public Set<String> getTracePropertyKeys() {
        return this.tp.keySet();
    }

    @Override
    public MatsTraceFieldImpl<Z> addRequestCall(String from, String to, MatsTrace.Call.MessagingModel toMessagingModel, String replyTo, MatsTrace.Call.MessagingModel replyToMessagingModel, Z data, Z replyState, Z initialState) {
        List<ReplyChannel> newCallReplyStack = this.getCopyOfCurrentStackForNewCall();
        MatsTraceFieldImpl<Z> clone = this.cloneForNewCall();
        StackStateImpl<Z> newState = new StackStateImpl<Z>(newCallReplyStack.size(), replyState);
        this.forwardExtraStateIfExist(newState);
        clone.ss.add(newState);
        newCallReplyStack.add(ReplyChannel.newWithRandomSpanId(replyTo, replyToMessagingModel));
        clone.dropValuesOnCurrentCallIfAny();
        clone.c.add(new CallImpl<Z>(MatsTrace.Call.CallType.REQUEST, this.getFlowId(), this.getInitiatingTimestamp(), this.getCallNumber(), from, new ToChannel(to, toMessagingModel), data, newCallReplyStack));
        if (initialState != null) {
            clone.ss.add(new StackStateImpl<Z>(newCallReplyStack.size(), initialState));
        }
        clone.pruneUnnecessaryStackStates();
        return clone;
    }

    @Override
    public MatsTraceFieldImpl<Z> addSendCall(String from, String to, MatsTrace.Call.MessagingModel toMessagingModel, Z data, Z initialState) {
        List<ReplyChannel> newCallReplyStack = this.getCopyOfCurrentStackForNewCall();
        MatsTraceFieldImpl<Z> clone = this.cloneForNewCall();
        clone.dropValuesOnCurrentCallIfAny();
        clone.c.add(new CallImpl<Z>(MatsTrace.Call.CallType.SEND, this.getFlowId(), this.getInitiatingTimestamp(), this.getCallNumber(), from, new ToChannel(to, toMessagingModel), data, newCallReplyStack));
        if (initialState != null) {
            clone.ss.add(new StackStateImpl<Z>(newCallReplyStack.size(), initialState));
        }
        clone.pruneUnnecessaryStackStates();
        return clone;
    }

    @Override
    public MatsTraceFieldImpl<Z> addNextCall(String from, String to, Z data, Z state) {
        if (state == null) {
            throw new IllegalStateException("When adding next-call, state-data string should not be null.");
        }
        List<ReplyChannel> newCallReplyStack = this.getCopyOfCurrentStackForNewCall();
        MatsTraceFieldImpl<Z> clone = this.cloneForNewCall();
        clone.dropValuesOnCurrentCallIfAny();
        clone.c.add(new CallImpl<Z>(MatsTrace.Call.CallType.NEXT, this.getFlowId(), this.getInitiatingTimestamp(), this.getCallNumber(), from, new ToChannel(to, MatsTrace.Call.MessagingModel.QUEUE), data, newCallReplyStack));
        StackStateImpl<Z> newState = new StackStateImpl<Z>(newCallReplyStack.size(), state);
        this.forwardExtraStateIfExist(newState);
        clone.ss.add(newState);
        clone.pruneUnnecessaryStackStates();
        return clone;
    }

    @Override
    public MatsTraceFieldImpl<Z> addReplyCall(String from, Z data) {
        List<ReplyChannel> newCallReplyStack = this.getCopyOfCurrentStackForNewCall();
        if (newCallReplyStack.size() == 0) {
            throw new IllegalStateException("Trying to add Reply Call when there is no stack. (Implementation note: You need to check the getCurrentCall().getStackHeight() before trying to do a reply - if it is zero, then just drop the reply instead.)");
        }
        MatsTraceFieldImpl<Z> clone = this.cloneForNewCall();
        clone.dropValuesOnCurrentCallIfAny();
        ReplyChannel to = newCallReplyStack.remove(newCallReplyStack.size() - 1);
        CallImpl<Z> replyCall = new CallImpl<Z>(MatsTrace.Call.CallType.REPLY, this.getFlowId(), this.getInitiatingTimestamp(), this.getCallNumber(), from, new ToChannel(to.i, to.m), data, newCallReplyStack).setReplyForSpanId(this.getCurrentSpanId());
        clone.c.add(replyCall);
        clone.pruneUnnecessaryStackStates();
        return clone;
    }

    @Override
    public MatsTrace<Z> addGotoCall(String from, String to, Z data, Z initialState) {
        List<ReplyChannel> newCallReplyStack = this.getCopyOfCurrentStackForNewCall();
        MatsTraceFieldImpl<Z> clone = this.cloneForNewCall();
        clone.dropValuesOnCurrentCallIfAny();
        clone.c.add(new CallImpl<Z>(MatsTrace.Call.CallType.GOTO, this.getFlowId(), this.getInitiatingTimestamp(), this.getCallNumber(), from, new ToChannel(to, MatsTrace.Call.MessagingModel.QUEUE), data, newCallReplyStack));
        if (initialState != null) {
            StackStateImpl<Z> initialGototate = new StackStateImpl<Z>(newCallReplyStack.size(), initialState);
            clone.ss.add(initialGototate);
        }
        clone.pruneUnnecessaryStackStates();
        return clone;
    }

    @Override
    public void setOutgoingTimestamp(long timestamp) {
        MatsTrace.Call cc = this.getCurrentCall();
        ((CallImpl)cc).setCalledTimestamp(timestamp);
        int stackHeight = ((CallImpl)cc).getReplyStackHeight();
        if (((CallImpl)cc).t == MatsTrace.Call.CallType.REPLY) {
            this.ots = this.ots == null ? new long[stackHeight + 1] : Arrays.copyOf(this.ots, stackHeight + 1);
            return;
        }
        long diff = timestamp - this.getInitiatingTimestamp();
        if (((CallImpl)cc).t == MatsTrace.Call.CallType.REQUEST) {
            this.ots = this.ots == null ? new long[stackHeight] : Arrays.copyOf(this.ots, stackHeight);
            this.ots[stackHeight - 1] = diff;
            return;
        }
        this.ots = this.ots == null ? new long[stackHeight + 1] : Arrays.copyOf(this.ots, stackHeight + 1);
        this.ots[stackHeight] = diff;
    }

    @Override
    public long getSameHeightOutgoingTimestamp() {
        MatsTrace.Call cc = this.getCurrentCall();
        if (((CallImpl)cc).t == MatsTrace.Call.CallType.REQUEST) {
            return -1L;
        }
        int stackHeight = ((CallImpl)this.getCurrentCall()).getReplyStackHeight();
        return this.ots == null ? 0L : this.ots[stackHeight] + this.getInitiatingTimestamp();
    }

    @Override
    public void setStageEnteredTimestamp(long timestamp) {
        MatsTrace.Call cc = this.getCurrentCall();
        if (((CallImpl)cc).t == MatsTrace.Call.CallType.NEXT) {
            return;
        }
        if (((CallImpl)cc).t == MatsTrace.Call.CallType.GOTO) {
            return;
        }
        if (((CallImpl)cc).t == MatsTrace.Call.CallType.REPLY) {
            return;
        }
        int stackHeight = ((CallImpl)cc).getReplyStackHeight();
        long diff = timestamp - this.getInitiatingTimestamp();
        this.eets = this.eets == null ? new long[stackHeight + 1] : Arrays.copyOf(this.eets, stackHeight + 1);
        this.eets[stackHeight] = diff;
    }

    @Override
    public long getSameHeightEndpointEnteredTimestamp() {
        int stackHeight = ((CallImpl)this.getCurrentCall()).getReplyStackHeight();
        return this.eets == null ? 0L : this.eets[stackHeight] + this.getInitiatingTimestamp();
    }

    private void forwardExtraStateIfExist(StackStateImpl<Z> newState) {
        StackStateImpl<Z> currentState;
        StackStateImpl<Z> stackStateImpl = currentState = this.c.isEmpty() ? null : this.getState(((CallImpl)this.getCurrentCall()).getReplyStackHeight());
        if (currentState != null && currentState.es != null) {
            newState.es = new HashMap(currentState.es);
        }
    }

    private List<ReplyChannel> getCopyOfCurrentStackForNewCall() {
        if (this.c.isEmpty()) {
            return new ArrayList<ReplyChannel>();
        }
        return ((CallImpl)this.getCurrentCall()).getReplyStack_internal();
    }

    private void pruneUnnecessaryStackStates() {
        if (this.kt == MatsTrace.KeepMatsTrace.MINIMAL || this.kt == MatsTrace.KeepMatsTrace.COMPACT) {
            this.ss = this.getStateStack_internal();
        }
    }

    @Override
    public long getCurrentSpanId() {
        MatsTrace.Call currentCall = this.getCurrentCall();
        if (currentCall == null) {
            return this.getRootSpanId();
        }
        List<ReplyChannel> stack = ((CallImpl)currentCall).s;
        if (stack.isEmpty()) {
            return this.getRootSpanId();
        }
        return stack.get(stack.size() - 1).getSpanId();
    }

    private long getRootSpanId() {
        return this.sid != null ? this.sid : MatsTraceFieldImpl.fnv1a_64(this.getFlowId().getBytes(StandardCharsets.UTF_8));
    }

    private List<Long> getSpanIdStack() {
        ArrayList<Long> spanIds = new ArrayList<Long>();
        spanIds.add(this.getRootSpanId());
        MatsTrace.Call currentCall = this.getCurrentCall();
        if (currentCall != null) {
            for (ReplyChannel cws : ((CallImpl)currentCall).s) {
                spanIds.add(cws.sid);
            }
        }
        return spanIds;
    }

    private static long fnv1a_64(byte[] k) {
        long rv = -3750763034362895579L;
        for (byte b : k) {
            rv ^= (long)b;
            rv *= 1099511628211L;
        }
        return rv;
    }

    private void dropValuesOnCurrentCallIfAny() {
        if (this.c.size() > 0) {
            ((CallImpl)this.getCurrentCall()).dropFromAndStack();
            if (this.kt == MatsTrace.KeepMatsTrace.COMPACT) {
                ((CallImpl)this.getCurrentCall()).dropData();
            }
        }
    }

    @Override
    public CallImpl<Z> getCurrentCall() {
        if (this.c.size() == 0) {
            throw new IllegalStateException("No calls added - this is evidently a newly created MatsTrace, which isn't meaningful before an initial call is added");
        }
        return this.c.get(this.c.size() - 1);
    }

    @Override
    public List<MatsTrace.Call<Z>> getCallFlow() {
        return new ArrayList<MatsTrace.Call<Z>>(this.c);
    }

    @Override
    public Optional<MatsTrace.StackState<Z>> getCurrentState() {
        return Optional.ofNullable(this.getState(((CallImpl)this.getCurrentCall()).getReplyStackHeight()));
    }

    @Override
    public List<MatsTrace.StackState<Z>> getStateFlow() {
        return new ArrayList<MatsTrace.StackState<Z>>(this.ss);
    }

    @Override
    public List<MatsTrace.StackState<Z>> getStateStack() {
        List<MatsTrace.StackState<Z>> ret = this.getStateStack_internal();
        return ret;
    }

    public List<StackStateImpl<Z>> getStateStack_internal() {
        if (this.ss.isEmpty()) {
            return new ArrayList<StackStateImpl<Z>>();
        }
        int currentCallStackHeight = ((CallImpl)this.getCurrentCall()).getReplyStackHeight();
        int topOfStateStack = Math.min(currentCallStackHeight, this.ss.get(this.ss.size() - 1).getHeight());
        ArrayList<StackStateImpl<Z>> newStateStack = new ArrayList<StackStateImpl<Z>>(topOfStateStack + 1);
        for (int i = 0; i <= topOfStateStack; ++i) {
            newStateStack.add(null);
        }
        for (StackStateImpl<Z> stackState : this.ss) {
            if (stackState.getHeight() > topOfStateStack) continue;
            newStateStack.set(stackState.getHeight(), stackState);
        }
        return newStateStack;
    }

    private StackStateImpl<Z> getState(int stackDepth) {
        StackStateImpl<Z> stackState;
        for (int i = this.ss.size() - 1; i >= 0 && stackDepth <= (stackState = this.ss.get(i)).getHeight(); --i) {
            if (stackDepth != stackState.getHeight()) continue;
            return stackState;
        }
        return null;
    }

    protected MatsTraceFieldImpl<Z> cloneForNewCall() {
        try {
            MatsTraceFieldImpl cloned = (MatsTraceFieldImpl)super.clone();
            if (this.kt == MatsTrace.KeepMatsTrace.MINIMAL) {
                cloned.c = new ArrayList<CallImpl<Z>>(1);
            } else {
                cloned.c = new ArrayList<CallImpl<Z>>(this.c.size());
                for (CallImpl<Z> callImpl : this.c) {
                    cloned.c.add((CallImpl<Z>)callImpl.clone());
                }
            }
            cloned.ss = new ArrayList<StackStateImpl<Z>>(this.ss.size());
            for (StackStateImpl stackStateImpl : this.ss) {
                cloned.ss.add((StackStateImpl<Z>)stackStateImpl.clone());
            }
            cloned.tp = new LinkedHashMap<String, Z>(this.tp);
            cloned.cn = this.cn + 1;
            cloned.tcn = this.tcn + 1;
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError("Implements Cloneable, so clone() should not throw.", e);
        }
    }

    private static String spaces(int length) {
        return new String(new char[length]).replace("\u0000", " ");
    }

    public String toString() {
        int i;
        StringBuilder buf = new StringBuilder();
        MatsTrace.Call currentCall = this.getCurrentCall();
        if (currentCall == null) {
            return "MatsTrace w/o CurrentCall. TraceId:" + this.tid + ", FlowId:" + this.id + ".";
        }
        Object callType = ((CallImpl)currentCall).getCallType().toString();
        callType = (String)callType + MatsTraceFieldImpl.spaces(8 - ((String)callType).length());
        buf.append("MatsTrace").append('\n').append("  Call Flow / Initiation:").append('\n').append("    Timestamp _________ : ").append(Instant.ofEpochMilli(this.getInitiatingTimestamp()).atZone(ZoneId.systemDefault())).append('\n').append("    TraceId ___________ : ").append(this.getTraceId()).append('\n').append("    FlowId ____________ : ").append(this.getFlowId()).append('\n').append("    Initiating App ____ : ").append(this.getInitiatingAppName()).append(",v.").append(this.getInitiatingAppVersion()).append('\n').append("    Initiator (from)___ : ").append(this.getInitiatorId()).append('\n').append("    Init debug info ___ : ").append(this.getDebugInfo() != null ? this.getDebugInfo() : "-not present-").append('\n').append("    Properties:").append('\n').append("      KeepMatsTrace ___ : ").append((Object)this.getKeepTrace()).append('\n').append("      NonPersistent ___ : ").append(this.isNonPersistent()).append('\n').append("      Interactive _____ : ").append(this.isInteractive()).append('\n').append("      TimeToLive ______ : ").append(this.tl == null || this.tl == 0L ? "forever" : this.tl.toString()).append('\n').append("      NoAudit _________ : ").append(this.isNoAudit()).append('\n').append('\n');
        buf.append(" Current Call: ").append(((CallImpl)currentCall).getCallType().toString()).append('\n').append("    Timestamp _________ : ").append(Instant.ofEpochMilli(((CallImpl)this.getCurrentCall()).getCalledTimestamp()).atZone(ZoneId.systemDefault())).append('\n').append("    MatsMessageId _____ : ").append(((CallImpl)this.getCurrentCall()).getMatsMessageId()).append('\n').append("    From App __________ : ").append(((CallImpl)this.getCurrentCall()).getCallingAppName()).append(",v.").append(((CallImpl)this.getCurrentCall()).getCallingAppVersion()).append('\n').append("    From ______________ : ").append(((CallImpl)this.getCurrentCall()).getFrom()).append('\n').append("    To (this) _________ : ").append(((CallImpl)this.getCurrentCall()).getTo()).append('\n').append("    Call debug info ___ : ").append(((CallImpl)currentCall).getDebugInfo() != null ? ((CallImpl)currentCall).getDebugInfo() : "-not present-").append('\n').append("    Flow call# ________ : ").append(this.getCallNumber()).append('\n').append("    Incoming State ____ : ").append(this.getCurrentState().map(MatsTrace.StackState::getState).map(Object::toString).orElse("-null-")).append('\n').append("    Incoming Msg ______ : ").append(((CallImpl)currentCall).getData()).append('\n').append("    Current SpanId ____ : ").append(Long.toString(this.getCurrentSpanId(), 36)).append('\n').append("    ReplyFrom SpanId __ : ").append(((CallImpl)currentCall).getCallType() == MatsTrace.Call.CallType.REPLY ? Long.toString(((CallImpl)currentCall).getReplyFromSpanId(), 36) : "n/a (not REPLY)").append('\n');
        buf.append('\n');
        if (this.getKeepTrace() == MatsTrace.KeepMatsTrace.MINIMAL) {
            buf.append(" initiator:  (MINIMAL, so only have initiator and current call)\n");
            buf.append("     ");
            if (this.an != null) {
                buf.append(" @").append(this.an);
            }
            if (this.av != null) {
                buf.append('[').append(this.av).append(']');
            }
            if (this.h != null) {
                buf.append(" @").append(this.h);
            }
            if (this.ts != 0L) {
                buf.append(" @");
                DateTimeFormatter.ISO_OFFSET_DATE_TIME.formatTo(ZonedDateTime.ofInstant(Instant.ofEpochMilli(this.ts), TimeZone.getDefault().toZoneId()), buf);
            }
            if (this.iid != null) {
                buf.append(" #initiatorId:").append(this.iid);
            }
            buf.append('\n');
            buf.append(" current call:  (stack height: ").append(((CallImpl)currentCall).getReplyStackHeight()).append(")\n");
            buf.append("    ").append(((CallImpl)this.getCallFlow().get(0)).toStringFromMatsTrace(this.ts, 0, 0, false));
            buf.append('\n');
        } else {
            buf.append(" call#:       call type\n");
            buf.append("    0    --- [Initiator]");
            if (this.an != null) {
                buf.append(" @").append(this.an);
            }
            if (this.av != null) {
                buf.append('[').append(this.av).append(']');
            }
            if (this.h != null) {
                buf.append(" @").append(this.h);
            }
            if (this.ts != 0L) {
                buf.append(" @");
                DateTimeFormatter.ISO_OFFSET_DATE_TIME.formatTo(ZonedDateTime.ofInstant(Instant.ofEpochMilli(this.ts), TimeZone.getDefault().toZoneId()), buf);
            }
            if (this.iid != null) {
                buf.append(" #initiatorId:").append(this.iid);
            }
            buf.append('\n');
            int maxStackSize = this.c.stream().mapToInt(CallImpl::getReplyStackHeight).max().orElse(0);
            int maxToStageIdLength = this.c.stream().mapToInt(c -> c.getTo().toString().length()).max().orElse(0);
            List<MatsTrace.Call<Z>> callFlow = this.getCallFlow();
            for (i = 0; i < callFlow.size(); ++i) {
                boolean printNullData = this.kt == MatsTrace.KeepMatsTrace.FULL || i == callFlow.size() - 1;
                CallImpl call = (CallImpl)callFlow.get(i);
                buf.append(String.format("   %2d %s\n", i + 1, call.toStringFromMatsTrace(this.ts, maxStackSize, maxToStageIdLength, printNullData)));
            }
        }
        buf.append('\n');
        buf.append(" ").append("states: (").append((Object)this.getKeepTrace()).append(", thus ").append(this.getKeepTrace() == MatsTrace.KeepMatsTrace.FULL ? "state flow" : "state stack").append(" - includes state (if any) for this frame, and for all reply frames below us)").append("\n");
        List<MatsTrace.StackState<Z>> stateFlow = this.getStateFlow();
        if (stateFlow.isEmpty()) {
            buf.append("    <empty, no states>\n");
        }
        for (int i2 = 0; i2 < stateFlow.size(); ++i2) {
            buf.append(String.format("   %2d %s", i2, stateFlow.get(i2))).append('\n');
        }
        buf.append('\n');
        buf.append(" current ReplyTo stack (frames below us): \n");
        List<MatsTrace.Call.Channel> stack = ((CallImpl)currentCall).getReplyStack();
        if (stack.isEmpty()) {
            buf.append("    <empty, cannot reply>\n");
        } else {
            List<MatsTrace.StackState<Z>> stateStack = this.getStateStack();
            for (i = 0; i < stack.size(); ++i) {
                buf.append(String.format("   %2d %s", i, stack.get(i).toString())).append("  #state:").append(stateStack.get(i).getState()).append('\n');
            }
        }
        buf.append('\n');
        buf.append(" current SpanId stack: \n");
        List<Long> spanIdStack = this.getSpanIdStack();
        for (i = 0; i < spanIdStack.size(); ++i) {
            buf.append(String.format("   %2d %s", i, Long.toString(spanIdStack.get(i), 36)));
            if (i == spanIdStack.size() - 1) {
                buf.append(" (SpanId which current ").append((Object)((CallImpl)currentCall).getCallType()).append(" call is processing within)");
            }
            if (i == 0) {
                buf.append(" (Root SpanId for initiator/terminator level)");
            }
            buf.append('\n');
        }
        return buf.toString();
    }

    private static class StackStateImpl<Z>
    implements MatsTrace.StackState<Z>,
    Cloneable {
        private final int h;
        private final Z s;
        private Map<String, Z> es;

        private StackStateImpl() {
            this.h = 0;
            this.s = null;
        }

        public StackStateImpl(int height, Z state) {
            this.h = height;
            this.s = state;
        }

        @Override
        public int getHeight() {
            return this.h;
        }

        @Override
        public Z getState() {
            return this.s;
        }

        @Override
        public void setExtraState(String key, Z value) {
            if (this.es == null) {
                this.es = new HashMap<String, Z>();
            }
            this.es.put(key, value);
        }

        @Override
        public Z getExtraState(String key) {
            return this.es != null ? (Z)this.es.get(key) : null;
        }

        public String toString() {
            return "height=" + this.h + ", state=" + this.s + (String)(this.es != null ? ", extraState=" + this.es.toString() : "");
        }

        protected StackStateImpl<Z> clone() {
            try {
                StackStateImpl clone = (StackStateImpl)super.clone();
                if (this.es != null) {
                    clone.es = new HashMap<String, Z>(this.es);
                }
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError("Implements Cloneable, so shouldn't throw", e);
            }
        }
    }

    private static class ReplyChannel
    implements MatsTrace.Call.Channel {
        private final String i;
        private final MatsTrace.Call.MessagingModel m;
        private final long sid;

        public ReplyChannel() {
            this.i = null;
            this.m = null;
            this.sid = 0L;
        }

        public ReplyChannel(String i, MatsTrace.Call.MessagingModel m, long sid) {
            this.i = i;
            this.m = m;
            this.sid = sid;
        }

        public static ReplyChannel newWithRandomSpanId(String i, MatsTrace.Call.MessagingModel m) {
            return new ReplyChannel(i, m, ThreadLocalRandom.current().nextLong());
        }

        public long getSpanId() {
            return this.sid;
        }

        @Override
        public String getId() {
            return this.i;
        }

        @Override
        public MatsTrace.Call.MessagingModel getMessagingModel() {
            return this.m;
        }
    }

    private static class ToChannel
    implements MatsTrace.Call.Channel {
        private final String i;
        private final MatsTrace.Call.MessagingModel m;

        private ToChannel() {
            this.i = null;
            this.m = null;
        }

        public ToChannel(String i, MatsTrace.Call.MessagingModel m) {
            this.i = i;
            this.m = m;
        }

        @Override
        public String getId() {
            return this.i;
        }

        @Override
        public MatsTrace.Call.MessagingModel getMessagingModel() {
            return this.m;
        }

        public String toString() {
            String model;
            switch (this.m) {
                case QUEUE: {
                    model = "Q";
                    break;
                }
                case TOPIC: {
                    model = "T";
                    break;
                }
                default: {
                    model = this.m.toString();
                }
            }
            return "[" + model + "]" + this.i;
        }
    }

    public static class CallImpl<Z>
    implements MatsTrace.Call<Z>,
    Cloneable {
        private String an;
        private String av;
        private String h;
        private String x;
        private long ts;
        private String id;
        private final MatsTrace.Call.CallType t;
        private String f;
        private final ToChannel to;
        private Z d;
        private List<ReplyChannel> s;
        private Integer ss;
        private Long rid;

        private CallImpl() {
            this.t = null;
            this.to = null;
        }

        CallImpl(MatsTrace.Call.CallType type, String flowId, long matsTraceCreationMillis, int callNo, String from, ToChannel to, Z data, List<ReplyChannel> stack) {
            this.t = type;
            this.f = from;
            this.to = to;
            this.d = data;
            this.s = stack;
            this.ts = System.currentTimeMillis();
            long millisSince = this.ts - matsTraceCreationMillis;
            Object millisSinceString = millisSince >= 0L ? Long.toString(millisSince) : "n" + Math.abs(millisSince);
            this.id = flowId + "_t" + (String)millisSinceString + "_n" + callNo;
        }

        @Override
        public CallImpl<Z> setDebugInfo(String callingAppName, String callingAppVersion, String callingHost, String debugInfo) {
            this.an = callingAppName;
            this.av = callingAppVersion;
            this.h = callingHost;
            this.x = debugInfo;
            return this;
        }

        void setCalledTimestamp(long calledTimestamp) {
            this.ts = calledTimestamp;
        }

        CallImpl<Z> setReplyForSpanId(long replyForSpanId) {
            this.rid = replyForSpanId;
            return this;
        }

        void dropFromAndStack() {
            this.f = null;
            this.ss = this.s.size();
            this.s = null;
        }

        void dropData() {
            this.d = null;
        }

        @Override
        public String getCallingAppName() {
            return this.an;
        }

        @Override
        public String getCallingAppVersion() {
            return this.av;
        }

        @Override
        public String getCallingHost() {
            return this.h;
        }

        @Override
        public long getCalledTimestamp() {
            return this.ts;
        }

        @Override
        public String getMatsMessageId() {
            return this.id;
        }

        @Override
        public String getDebugInfo() {
            return this.x;
        }

        @Override
        public MatsTrace.Call.CallType getCallType() {
            return this.t;
        }

        @Override
        public long getReplyFromSpanId() {
            if (this.getCallType() != MatsTrace.Call.CallType.REPLY) {
                throw new IllegalStateException("Type of this call is not REPLY, so you cannot ask for ReplyFromSpanId.");
            }
            return this.rid;
        }

        @Override
        public String getFrom() {
            if (this.f == null) {
                return "-nulled-";
            }
            return this.f;
        }

        @Override
        public MatsTrace.Call.Channel getTo() {
            return this.to;
        }

        @Override
        public Z getData() {
            return this.d;
        }

        @Override
        public List<MatsTrace.Call.Channel> getReplyStack() {
            List<MatsTrace.Call.Channel> ret = this.getReplyStack_internal();
            return ret;
        }

        List<ReplyChannel> getReplyStack_internal() {
            if (this.s == null) {
                return new ArrayList<ReplyChannel>(Collections.nCopies(this.getReplyStackHeight(), new ReplyChannel("-nulled-", null, 0L)));
            }
            return new ArrayList<ReplyChannel>(this.s);
        }

        @Override
        public int getReplyStackHeight() {
            return this.s != null ? this.s.size() : this.ss.intValue();
        }

        private String indent() {
            return new String(new char[this.getReplyStackHeight()]).replace("\u0000", ": ");
        }

        private String fromStackData(boolean printNullData) {
            return "#from:" + (this.an != null ? this.an : "") + (String)(this.av != null ? "[" + this.av + "]" : "") + (String)(this.h != null ? "@" + this.h : "") + (String)(this.id != null ? ":" + this.id : "") + (String)(this.x != null ? ", debug:" + this.x : "") + (String)(this.d != null || printNullData ? ", #data:" + this.d : "");
        }

        public String toString() {
            return this.indent() + this.t + (String)(this.ts != 0L ? " " + DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(ZonedDateTime.ofInstant(Instant.ofEpochMilli(this.ts), TimeZone.getDefault().toZoneId())) + " -" : "") + " #to:" + this.to + ", " + this.fromStackData(false);
        }

        public String toStringFromMatsTrace(long startTimestamp, int maxStackSize, int maxToStageIdLength, boolean printNulLData) {
            String toType = (String)(this.ts != 0L ? String.format("%4d", this.ts - startTimestamp) + "ms " : " - ") + this.indent() + this.t;
            int numMaxIncludingCallType = 14 + maxStackSize * 2;
            int numSpacesTo = Math.max(0, numMaxIncludingCallType - toType.length());
            String toTo = toType + MatsTraceFieldImpl.spaces(numSpacesTo) + " #to:" + this.to;
            int numSpacesStack = Math.max(1, 7 + numMaxIncludingCallType + maxToStageIdLength - toTo.length());
            return toTo + MatsTraceFieldImpl.spaces(numSpacesStack) + this.fromStackData(printNulLData);
        }

        protected CallImpl<Z> clone() {
            try {
                CallImpl cloned = (CallImpl)super.clone();
                cloned.s = this.s == null ? null : new ArrayList<ReplyChannel>(this.s);
                return cloned;
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError("Implements Cloneable, so clone() should not throw.", e);
            }
        }
    }
}

