/*
 * Decompiled with CFR 0.152.
 */
package io.mats3.serial;

import java.util.List;
import java.util.Optional;
import java.util.Set;

public interface MatsTrace {
    public static final String NULLED = "-nulled-";

    public MatsTrace withDebugInfo(String var1, String var2, String var3, String var4, String var5);

    public MatsTrace withChildFlow(String var1, int var2);

    public void setMatsSerializerMeta(String var1);

    public String getMatsSerializerMeta();

    public String getTraceId();

    public String getFlowId();

    public KeepMatsTrace getKeepTrace();

    public boolean isNonPersistent();

    public boolean isInteractive();

    public long getTimeToLive();

    public boolean isNoAudit();

    public long getInitiatingTimestamp();

    public String getInitiatingAppName();

    public String getInitiatingAppVersion();

    public String getInitiatingHost();

    public String getInitiatorId();

    public String getDebugInfo();

    public int getCallNumber();

    public int getTotalCallNumber();

    public String getParentMatsMessageId();

    public void setTraceProperty(String var1, Object var2);

    public Object getTraceProperty(String var1);

    public Set<String> getTracePropertyKeys();

    public MatsTrace addRequestCall(String var1, String var2, Call.MessagingModel var3, String var4, Call.MessagingModel var5, Object var6, Object var7, Object var8);

    public MatsTrace addSendCall(String var1, String var2, Call.MessagingModel var3, Object var4, Object var5);

    public MatsTrace addNextCall(String var1, String var2, Object var3, Object var4);

    public MatsTrace addReplyCall(String var1, Object var2);

    public MatsTrace addGotoCall(String var1, String var2, Object var3, Object var4);

    public void setOutgoingTimestamp(long var1);

    public long getSameHeightOutgoingTimestamp();

    public void setStageEnteredTimestamp(long var1);

    public long getSameHeightEndpointEnteredTimestamp();

    public long getCurrentSpanId();

    public Call getCurrentCall();

    public Optional<StackState> getCurrentState();

    public List<StackState> getStateStack();

    public List<Call> getCallFlow();

    public List<StackState> getStateFlow();

    public static interface StackState {
        public int getHeight();

        public Object getState();

        public void setExtraState(String var1, Object var2);

        public Object getExtraState(String var1);
    }

    public static interface Call {
        public long getCalledTimestamp();

        public String getMatsMessageId();

        public Call setDebugInfo(String var1, String var2, String var3, String var4);

        public String getCallingAppName();

        public String getCallingAppVersion();

        public String getCallingHost();

        public String getDebugInfo();

        public CallType getCallType();

        public long getReplyFromSpanId();

        public String getFrom();

        public Channel getTo();

        public Object getData();

        public int getReplyStackHeight();

        public List<Channel> getReplyStack();

        public static enum MessagingModel {
            QUEUE,
            TOPIC;

        }

        public static interface Channel {
            public String getId();

            public MessagingModel getMessagingModel();
        }

        public static enum CallType {
            REQUEST,
            SEND,
            NEXT,
            REPLY,
            GOTO;

        }
    }

    public static enum KeepMatsTrace {
        FULL,
        COMPACT,
        MINIMAL;

    }
}

