/*
 * Decompiled with CFR 0.152.
 */
package io.mats3.spring.test;

import io.mats3.spring.test.MatsTestInfrastructureConfiguration;
import io.mats3.spring.test.MatsTestProfile;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotatedBeanDefinitionReader;
import org.springframework.context.annotation.Import;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;

@Target(value={ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
@ContextConfiguration(initializers={MatsSimpleTestInfrastructureContextInitializer.class})
@Import(value={MatsTestInfrastructureConfiguration.class})
@DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_CLASS)
@Documented
@MatsTestProfile
public @interface MatsTestContext {

    public static class MatsSimpleTestInfrastructureContextInitializer
    implements ApplicationContextInitializer<ConfigurableApplicationContext> {
        private static final Log log = LogFactory.getLog(MatsSimpleTestInfrastructureContextInitializer.class);
        private static final String LOG_PREFIX = "#SPRINGMATS# ";

        public void initialize(ConfigurableApplicationContext applicationContext) {
            log.debug((Object)("#SPRINGMATS# Registering " + MatsTestInfrastructureConfiguration.class.getSimpleName() + " on: " + applicationContext));
            new AnnotatedBeanDefinitionReader((BeanDefinitionRegistry)applicationContext.getBeanFactory()).register(new Class[]{MatsTestInfrastructureConfiguration.class});
        }
    }
}

