/*
 * Decompiled with CFR 0.152.
 */
package io.mats3.spring.test;

import io.mats3.MatsFactory;
import io.mats3.MatsInitiator;
import io.mats3.serial.MatsSerializer;
import io.mats3.serial.json.MatsSerializerJson;
import io.mats3.spring.EnableMats;
import io.mats3.spring.test.TestSpringMatsFactoryProvider;
import io.mats3.test.MatsTestBrokerInterface;
import io.mats3.test.MatsTestLatch;
import io.mats3.util.MatsFuturizer;
import javax.sql.DataSource;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Role;
import org.springframework.transaction.PlatformTransactionManager;

@EnableMats
@Configuration
@Role(value=2)
public class MatsTestInfrastructureConfiguration {
    @Autowired
    protected ObjectProvider<MatsSerializer<?>> _matsSerializer;
    @Autowired
    protected ObjectProvider<DataSource> _dataSource;
    @Autowired
    protected ObjectProvider<PlatformTransactionManager> _platformTransactionManagerObjectProvider;

    @Bean
    protected MatsFactory testMatsFactory() {
        PlatformTransactionManager platformTransactionManager;
        MatsSerializer matsSerializer = (MatsSerializer)this._matsSerializer.getIfAvailable();
        if (matsSerializer == null) {
            matsSerializer = MatsSerializerJson.create();
        }
        if ((platformTransactionManager = (PlatformTransactionManager)this._platformTransactionManagerObjectProvider.getIfAvailable()) != null) {
            return TestSpringMatsFactoryProvider.createSpringDataSourceTxTestMatsFactory(platformTransactionManager, matsSerializer);
        }
        DataSource dataSource = (DataSource)this._dataSource.getIfAvailable();
        if (dataSource != null) {
            return TestSpringMatsFactoryProvider.createSpringDataSourceTxTestMatsFactory(dataSource, matsSerializer);
        }
        return TestSpringMatsFactoryProvider.createJmsTxOnlyTestMatsFactory(matsSerializer);
    }

    @Bean
    protected MatsTestBrokerInterface testMatsTestMqInterface() {
        return MatsTestBrokerInterface.createForLaterPopulation();
    }

    @Bean
    protected MatsInitiator testMatsInitiator(MatsFactory matsFactory) {
        return matsFactory.getDefaultInitiator();
    }

    @Bean
    protected MatsTestLatch testMatsTestLatch() {
        return new MatsTestLatch();
    }

    @Bean
    @Lazy
    protected MatsFuturizer testMatsFuturizer(MatsFactory matsFactory) {
        return MatsFuturizer.createMatsFuturizer((MatsFactory)matsFactory, (String)"MatsSpringTest");
    }
}

