/*
 * Decompiled with CFR 0.152.
 */
package io.mats3.spring.test;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.support.AbstractTestExecutionListener;

@Target(value={ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
@TestExecutionListeners(listeners={SpringInjectRulesAndExtensionsTestExecutionListener.class}, mergeMode=TestExecutionListeners.MergeMode.MERGE_WITH_DEFAULTS)
@Documented
public @interface SpringInjectRulesAndExtensions {

    public static class SpringInjectRulesAndExtensionsTestExecutionListener
    extends AbstractTestExecutionListener {
        public void prepareTestInstance(TestContext testContext) {
            AutowireCapableBeanFactory beanFactory = testContext.getApplicationContext().getAutowireCapableBeanFactory();
            Set<Field> testRuleFields = SpringInjectRulesAndExtensionsTestExecutionListener.findFields(testContext.getTestClass(), "org.junit.Rule");
            Set<Field> testExtensionFields = SpringInjectRulesAndExtensionsTestExecutionListener.findFields(testContext.getTestClass(), "org.junit.jupiter.api.extension.RegisterExtension");
            HashSet<Field> allFields = new HashSet<Field>();
            allFields.addAll(testRuleFields);
            allFields.addAll(testExtensionFields);
            for (Field testField : allFields) {
                try {
                    testField.setAccessible(true);
                    Object ruleObject = testField.get(testContext.getTestInstance());
                    beanFactory.autowireBean(ruleObject);
                }
                catch (Exception e) {
                    throw new AssertionError("Failed read field [" + testField + "] in [" + testField.getClass() + "], unable to autowire it as a bean in test class [" + testContext.getTestClass() + "]", e);
                }
            }
        }

        protected static Set<Field> findFields(Class<?> clazz, String annotationClassName) {
            try {
                Class<?> annotationClass = Class.forName(annotationClassName);
                HashSet<Field> set = new HashSet<Field>();
                for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
                    for (Field field : c.getDeclaredFields()) {
                        if (!field.isAnnotationPresent(annotationClass)) continue;
                        set.add(field);
                    }
                }
                return set;
            }
            catch (ClassNotFoundException e) {
                return Collections.emptySet();
            }
        }
    }
}

