/*
 * Decompiled with CFR 0.152.
 */
package io.mats3.spring.test;

import io.mats3.MatsFactory;
import io.mats3.impl.jms.JmsMatsFactory;
import io.mats3.impl.jms.JmsMatsJmsSessionHandler;
import io.mats3.impl.jms.JmsMatsJmsSessionHandler_Pooling;
import io.mats3.impl.jms.JmsMatsTransactionManager;
import io.mats3.impl.jms.JmsMatsTransactionManager_Jms;
import io.mats3.serial.MatsSerializer;
import io.mats3.spring.jms.factories.SpringJmsMatsFactoryWrapper;
import io.mats3.spring.jms.tx.JmsMatsTransactionManager_JmsAndSpringManagedSqlTx;
import io.mats3.spring.test.MatsTestInfrastructureConfiguration;
import io.mats3.spring.test.MatsTestInfrastructureDbConfiguration;
import io.mats3.test.broker.MatsTestBroker;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.ConnectionFactory;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;

public class TestSpringMatsFactoryProvider {
    private static final Logger log = LoggerFactory.getLogger(TestSpringMatsFactoryProvider.class);
    private static final String LOG_PREFIX = "#SPRINGJMATS(test)# ";
    private static final AtomicInteger _sequence = new AtomicInteger(0);

    public static MatsFactory createSpringDataSourceTxTestMatsFactory(int concurrency, DataSource sqlDataSource, MatsSerializer<?> matsSerializer) {
        JmsMatsTransactionManager_JmsAndSpringManagedSqlTx springSqlTxMgr = JmsMatsTransactionManager_JmsAndSpringManagedSqlTx.create((DataSource)sqlDataSource);
        return TestSpringMatsFactoryProvider.getMatsFactoryStopLocalVmBrokerWrapper(concurrency, matsSerializer, (JmsMatsTransactionManager)springSqlTxMgr);
    }

    public static MatsFactory createSpringDataSourceTxTestMatsFactory(DataSource sqlDataSource, MatsSerializer<?> matsSerializer) {
        return TestSpringMatsFactoryProvider.createSpringDataSourceTxTestMatsFactory(2, sqlDataSource, matsSerializer);
    }

    public static MatsFactory createSpringDataSourceTxTestMatsFactory(int concurrency, PlatformTransactionManager platformTransactionManager, MatsSerializer<?> matsSerializer) {
        JmsMatsTransactionManager_JmsAndSpringManagedSqlTx springSqlTxMgr = JmsMatsTransactionManager_JmsAndSpringManagedSqlTx.create((PlatformTransactionManager)platformTransactionManager);
        return TestSpringMatsFactoryProvider.getMatsFactoryStopLocalVmBrokerWrapper(concurrency, matsSerializer, (JmsMatsTransactionManager)springSqlTxMgr);
    }

    public static MatsFactory createSpringDataSourceTxTestMatsFactory(PlatformTransactionManager platformTransactionManager, MatsSerializer<?> matsSerializer) {
        return TestSpringMatsFactoryProvider.createSpringDataSourceTxTestMatsFactory(2, platformTransactionManager, matsSerializer);
    }

    public static MatsFactory createJmsTxOnlyTestMatsFactory(int concurrency, MatsSerializer<?> matsSerializer) {
        JmsMatsTransactionManager jmsOnlyTxMgr = JmsMatsTransactionManager_Jms.create();
        return TestSpringMatsFactoryProvider.getMatsFactoryStopLocalVmBrokerWrapper(concurrency, matsSerializer, jmsOnlyTxMgr);
    }

    public static MatsFactory createJmsTxOnlyTestMatsFactory(MatsSerializer<?> matsSerializer) {
        return TestSpringMatsFactoryProvider.createJmsTxOnlyTestMatsFactory(2, matsSerializer);
    }

    private static SpringJmsMatsFactoryWrapper getMatsFactoryStopLocalVmBrokerWrapper(int concurrency, MatsSerializer<?> matsSerializer, JmsMatsTransactionManager springSqlTxMgr) {
        String appName = TestSpringMatsFactoryProvider.getAppNamePrefix().replaceAll("[^a-zA-Z0-9._\\-:]", ".") + "_" + _sequence.getAndIncrement();
        MatsTestBroker inVmActiveMq = MatsTestBroker.create();
        JmsMatsJmsSessionHandler_Pooling sessionPooler = JmsMatsJmsSessionHandler_Pooling.create((ConnectionFactory)inVmActiveMq.getConnectionFactory());
        JmsMatsFactory matsFactory = JmsMatsFactory.createMatsFactory((String)appName, (String)"#testing#", (JmsMatsJmsSessionHandler)sessionPooler, (JmsMatsTransactionManager)springSqlTxMgr, matsSerializer);
        matsFactory.setMatsManagedDlqDivert(2);
        matsFactory.getFactoryConfig().setName(TestSpringMatsFactoryProvider.class.getSimpleName() + "_MF");
        matsFactory.getFactoryConfig().setConcurrency(concurrency);
        MatsFactoryStopLocalVmBrokerWrapper matsFactoryStopLocalVmBrokerWrapper = new MatsFactoryStopLocalVmBrokerWrapper(matsFactory, inVmActiveMq);
        return new SpringJmsMatsFactoryWrapper(inVmActiveMq.getConnectionFactory(), (MatsFactory)matsFactoryStopLocalVmBrokerWrapper);
    }

    private static String getAppNamePrefix() {
        StackTraceElement[] stElements = Thread.currentThread().getStackTrace();
        for (int i = 1; i < stElements.length; ++i) {
            StackTraceElement ste = stElements[i];
            if (ste.getClassName().equals(TestSpringMatsFactoryProvider.class.getName()) || ste.getClassName().startsWith(MatsTestInfrastructureConfiguration.class.getName()) || ste.getClassName().startsWith(MatsTestInfrastructureDbConfiguration.class.getName()) || ste.getClassName().startsWith("org.springframework.") || ste.getClassName().startsWith("sun.") || ste.getClassName().startsWith("java.") || ste.getClassName().startsWith("org.junit.") || ste.getClassName().startsWith("com.intellij.")) continue;
            return ste.getClassName();
        }
        return "Testing_" + TestSpringMatsFactoryProvider.class.getSimpleName();
    }

    private static class MatsFactoryStopLocalVmBrokerWrapper
    extends MatsFactory.MatsFactoryWrapper {
        private final MatsTestBroker _matsTestBroker;

        public MatsFactoryStopLocalVmBrokerWrapper(JmsMatsFactory<?> targetMatsFactory, MatsTestBroker matsTestBroker) {
            super(targetMatsFactory);
            this._matsTestBroker = matsTestBroker;
        }

        public boolean stop(int gracefulShutdownMillis) {
            log.info("#SPRINGJMATS(test)# Stopping test JmsMatsFactory.");
            boolean stopped = super.stop(gracefulShutdownMillis);
            log.info("#SPRINGJMATS(test)# Stopping MatsTestBroker (stopping any in-vm broker).");
            this._matsTestBroker.close();
            return stopped;
        }
    }
}

