/*
 * Decompiled with CFR 0.152.
 */
package io.mats3.test.broker;

import io.mats3.test.broker.messagecursor.Reflection_Hacked_StoreQueueCursor;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.jms.ConnectionFactory;
import org.apache.activemq.RedeliveryPolicy;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.CoreAddressConfiguration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.server.embedded.EmbeddedActiveMQ;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerPlugin;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.region.policy.DeadLetterStrategy;
import org.apache.activemq.broker.region.policy.IndividualDeadLetterStrategy;
import org.apache.activemq.broker.region.policy.PendingQueueMessageStoragePolicy;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.plugin.StatisticsBrokerPlugin;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.kahadb.KahaDBPersistenceAdapter;
import org.apache.activemq.store.kahadb.disk.journal.Journal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface MatsTestBroker {
    public static final String SYSPROP_MATS_TEST_BROKER = "mats.test.broker";
    public static final String SYSPROP_MATS_TEST_BROKER_VALUE_ACTIVEMQ = "activemq";
    public static final String SYSPROP_MATS_TEST_BROKER_VALUE_ARTEMIS = "artemis";
    public static final String SYSPROP_MATS_TEST_BROKER_VALUE_RABBITMQ = "rabbitmq";
    public static final String SYSPROP_MATS_TEST_BROKERURL = "mats.test.brokerurl";
    public static final String SYSPROP_MATS_TEST_BROKERURL_VALUE_IN_VM = "in-vm";
    public static final String SYSPROP_MATS_TEST_BROKERURL_VALUE_LOCALHOST = "localhost";
    public static final int TEST_TOTAL_DELIVERY_ATTEMPTS = 5;
    public static final int TEST_REDELIVERY_DELAY = 250;

    public static MatsTestBroker create() {
        String sysprop_broker = System.getProperty(SYSPROP_MATS_TEST_BROKER);
        if (SYSPROP_MATS_TEST_BROKER_VALUE_ACTIVEMQ.equalsIgnoreCase(sysprop_broker) || sysprop_broker == null) {
            return new MatsTestBroker_ActiveMq();
        }
        if (SYSPROP_MATS_TEST_BROKER_VALUE_ARTEMIS.equalsIgnoreCase(sysprop_broker)) {
            return new MatsTestBroker_Artemis();
        }
        if (SYSPROP_MATS_TEST_BROKER_VALUE_RABBITMQ.equalsIgnoreCase(sysprop_broker)) {
            throw new IllegalArgumentException("RabbitMQ support is not yet done.");
        }
        if (sysprop_broker.contains(".")) {
            Object matsTestBrokerInstance;
            Class<?> matsTestBrokerClass;
            try {
                matsTestBrokerClass = Class.forName(sysprop_broker);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Do not support broker type [" + sysprop_broker + "], even tried instantiating this as a class since it contained a dot, but no such class found.");
            }
            try {
                matsTestBrokerInstance = matsTestBrokerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalStateException("The 'mats.test.broker' system property's value [" + sysprop_broker + "] looked like a class, so we loaded it. However, it was not possible to instantiate it.", e);
            }
            if (!(matsTestBrokerInstance instanceof MatsTestBroker)) {
                throw new IllegalStateException("The 'mats.test.broker' system property's value [" + sysprop_broker + "] looked like a class, so we loaded it. However, when instantiating it, it was not an implementation of MatsTestBroker.");
            }
            Logger log = LoggerFactory.getLogger(MatsTestBroker.class);
            log.info("MatsTestBroker: The 'mats.test.broker' system property's value [" + sysprop_broker + "] looked like a class, so we loaded and instantiated it. Good luck!");
            return (MatsTestBroker)matsTestBrokerInstance;
        }
        throw new IllegalStateException("Do not support broker type [" + sysprop_broker + "].");
    }

    public static MatsTestBroker createUniqueInVmActiveMq() {
        return new MatsTestBroker_InVmActiveMq();
    }

    public ConnectionFactory getConnectionFactory();

    public void close();

    public static BrokerService newActiveMqBroker(ActiveMq ... features) {
        HashSet<ActiveMq> feats = new HashSet<ActiveMq>(Arrays.asList(features));
        Logger log = LoggerFactory.getLogger(MatsTestBroker.class);
        String ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
        StringBuilder brokername = new StringBuilder(6);
        brokername.append("MatsTestActiveMQ_");
        for (int i = 0; i < 6; ++i) {
            brokername.append(ALPHABET.charAt(ThreadLocalRandom.current().nextInt(ALPHABET.length())));
        }
        log.info("Setting up ActiveMQ BrokerService '" + brokername + "'.");
        BrokerService broker = new BrokerService();
        broker.setBrokerName(brokername.toString());
        if (feats.contains((Object)ActiveMq.LOCALHOST)) {
            try {
                TransportConnector connector = new TransportConnector();
                connector.setUri(new URI("nio://0.0.0.0:61616"));
                broker.addConnector(connector);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        broker.setPersistent(false);
        if (feats.contains((Object)ActiveMq.PERSISTENT)) {
            String kahaClassname = "org.apache.activemq.store.kahadb.KahaDBPersistenceAdapter";
            Class<?> kahaClass = null;
            try {
                kahaClass = Class.forName(kahaClassname);
            }
            catch (ClassNotFoundException e) {
                log.error("Missing class '" + kahaClassname + "' (separate ActiveMQ dep), so cannot enable persistence. Ignoring, running without.");
            }
            if (kahaClass != null) {
                log.info("Enabling persistence on BrokerService [" + broker + "].");
                broker.setPersistent(true);
                System.setProperty("org.apache.activemq.kahaDB.files.skipMetadataUpdate", "true");
                try {
                    KahaDBPersistenceAdapter kahaDBPersistenceAdapter = new KahaDBPersistenceAdapter();
                    kahaDBPersistenceAdapter.setJournalDiskSyncStrategy(Journal.JournalDiskSyncStrategy.PERIODIC.name());
                    kahaDBPersistenceAdapter.setJournalDiskSyncInterval(25L);
                    broker.setPersistenceAdapter((PersistenceAdapter)kahaDBPersistenceAdapter);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
        broker.setUseShutdownHook(false);
        if (feats.contains((Object)ActiveMq.SHUTDOWNHOOK)) {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                try {
                    int sleep = 500;
                    log.info("MatsTestBroker: SHUTDOWNHOOK initiated: ActiveMQ BrokerService '" + brokername + "' - chilling a tad to let clients close, thus avoiding needless exceptions in logs.");
                    Thread.sleep(sleep);
                    log.info("MatsTestBroker: SHUTDOWNHOOK commencing after " + sleep + " ms chill: ActiveMQ BrokerService '" + brokername + "' - brokerService.stop().");
                    broker.stop();
                }
                catch (Exception e) {
                    log.error("MatsTestBroker: SHUTDOWNHOOK failed: ActiveMQ BrokerService '" + brokername + "' - got Exception.", (Throwable)e);
                }
            }));
        }
        broker.setUseJmx(feats.contains((Object)ActiveMq.JMX));
        broker.setAdvisorySupport(feats.contains((Object)ActiveMq.ADVISORY));
        broker.setAnonymousProducerAdvisorySupport(feats.contains((Object)ActiveMq.ADVISORY));
        broker.setSchedulePeriodForDestinationPurge(60123);
        StatisticsBrokerPlugin statisticsBrokerPlugin = new StatisticsBrokerPlugin();
        broker.setPlugins(new BrokerPlugin[]{statisticsBrokerPlugin});
        IndividualDeadLetterStrategy individualDeadLetterStrategy = new IndividualDeadLetterStrategy();
        individualDeadLetterStrategy.setQueuePrefix("DLQ.");
        individualDeadLetterStrategy.setTopicPrefix("DLQ.");
        individualDeadLetterStrategy.setProcessExpired(true);
        individualDeadLetterStrategy.setProcessNonPersistent(true);
        individualDeadLetterStrategy.setUseQueueForTopicMessages(true);
        individualDeadLetterStrategy.setUseQueueForQueueMessages(true);
        PolicyEntry allQueuesPolicy = new PolicyEntry();
        allQueuesPolicy.setDestination((ActiveMQDestination)new ActiveMQQueue(">"));
        allQueuesPolicy.setDeadLetterStrategy((DeadLetterStrategy)individualDeadLetterStrategy);
        allQueuesPolicy.setPrioritizedMessages(true);
        allQueuesPolicy.setGcInactiveDestinations(true);
        allQueuesPolicy.setInactiveTimeoutBeforeGC(172800000L);
        allQueuesPolicy.setPendingQueuePolicy((PendingQueueMessageStoragePolicy)new Reflection_Hacked_StoreQueueCursor.Reflection_Hacked_StorePendingQueueMessageStoragePolicy());
        PolicyEntry allTopicsPolicy = new PolicyEntry();
        allTopicsPolicy.setDestination((ActiveMQDestination)new ActiveMQTopic(">"));
        allTopicsPolicy.setDeadLetterStrategy((DeadLetterStrategy)individualDeadLetterStrategy);
        allTopicsPolicy.setPrioritizedMessages(true);
        allTopicsPolicy.setGcInactiveDestinations(true);
        allTopicsPolicy.setInactiveTimeoutBeforeGC(0x6DDD00L);
        allQueuesPolicy.setQueuePrefetch(25);
        allTopicsPolicy.setTopicPrefetch(250);
        PolicyEntry mbmTopicsPolicy = new PolicyEntry();
        mbmTopicsPolicy.setDestination((ActiveMQDestination)new ActiveMQTopic("matsbrokermonitor.>"));
        mbmTopicsPolicy.setTopicPrefetch(25000);
        PolicyMap policyMap = new PolicyMap();
        policyMap.put(allQueuesPolicy.getDestination(), (Object)allQueuesPolicy);
        policyMap.put(allTopicsPolicy.getDestination(), (Object)allTopicsPolicy);
        policyMap.put(mbmTopicsPolicy.getDestination(), (Object)mbmTopicsPolicy);
        broker.setDestinationPolicy(policyMap);
        broker.getSystemUsage().getMemoryUsage().setLimit(0x40000000L);
        broker.setSplitSystemUsageForProducersConsumers(true);
        broker.setProducerSystemUsagePortion(95);
        broker.setConsumerSystemUsagePortion(5);
        try {
            broker.start();
        }
        catch (Exception e) {
            throw new AssertionError("Could not start ActiveMQ BrokerService '" + brokername + "'.", e);
        }
        return broker;
    }

    public static ConnectionFactory newActiveMqConnectionFactory(String brokerUrl) {
        org.apache.activemq.ActiveMQConnectionFactory conFactory = new org.apache.activemq.ActiveMQConnectionFactory(brokerUrl);
        conFactory.setWatchTopicAdvisories(false);
        conFactory.setNonBlockingRedelivery(true);
        conFactory.setMessagePrioritySupported(true);
        RedeliveryPolicy redeliveryPolicy = conFactory.getRedeliveryPolicy();
        redeliveryPolicy.setInitialRedeliveryDelay(250L);
        redeliveryPolicy.setRedeliveryDelay(2000L);
        redeliveryPolicy.setUseExponentialBackOff(true);
        redeliveryPolicy.setBackOffMultiplier(2.0);
        redeliveryPolicy.setUseCollisionAvoidance(true);
        redeliveryPolicy.setCollisionAvoidancePercent((short)15);
        redeliveryPolicy.setMaximumRedeliveries(4);
        return conFactory;
    }

    public static class MatsTestBroker_Artemis
    implements MatsTestBroker {
        private static final Logger log = LoggerFactory.getLogger(MatsTestBroker_Artemis.class);
        protected final ConnectionFactory _connectionFactory;
        protected final EmbeddedActiveMQ _artemisServer;

        MatsTestBroker_Artemis() {
            EmbeddedActiveMQ artemisServer;
            Object brokerUrl;
            String sysprop_brokerUrl = System.getProperty(MatsTestBroker.SYSPROP_MATS_TEST_BROKERURL);
            if (MatsTestBroker.SYSPROP_MATS_TEST_BROKERURL_VALUE_IN_VM.equalsIgnoreCase(sysprop_brokerUrl) || sysprop_brokerUrl == null) {
                brokerUrl = "vm://" + Math.abs(ThreadLocalRandom.current().nextInt());
                artemisServer = MatsTestBroker_Artemis.createArtemisBroker((String)brokerUrl);
            } else if (MatsTestBroker.SYSPROP_MATS_TEST_BROKERURL_VALUE_LOCALHOST.equalsIgnoreCase(sysprop_brokerUrl)) {
                brokerUrl = "tcp://localhost:61616";
                log.info("SKIPPING setup of Artemis broker, since System Property 'mats.test.brokerurl' was set to [" + sysprop_brokerUrl + "] - using [" + (String)brokerUrl + "].");
                artemisServer = null;
            } else {
                log.info("SKIPPING setup of Artemis broker, since System Property 'mats.test.brokerurl' was set to [" + sysprop_brokerUrl + "].");
                brokerUrl = sysprop_brokerUrl;
                artemisServer = null;
            }
            log.info("Setting up Artemis ConnectionFactory to brokerUrl: [" + (String)brokerUrl + "].");
            this._connectionFactory = new ActiveMQConnectionFactory((String)brokerUrl);
            this._artemisServer = artemisServer;
        }

        public static EmbeddedActiveMQ createArtemisBroker(String brokerUrl) {
            log.info("Setting up in-vm Artemis embedded broker on URL '" + brokerUrl + "'.");
            ConfigurationImpl config = new ConfigurationImpl();
            try {
                config.setSecurityEnabled(false);
                config.setPersistenceEnabled(false);
                config.addAcceptorConfiguration(MatsTestBroker.SYSPROP_MATS_TEST_BROKERURL_VALUE_IN_VM, brokerUrl);
                config.addAddressSetting("#", new AddressSettings().setDeadLetterAddress(SimpleString.of((String)"DLQ")).setExpiryAddress(SimpleString.of((String)"ExpiryQueue")).setRedeliveryDelay(250L).setRedeliveryMultiplier(2.0).setMaxDeliveryAttempts(5));
                config.addAddressConfiguration(new CoreAddressConfiguration().setName("DLQ").addRoutingType(RoutingType.ANYCAST).addQueueConfiguration(QueueConfiguration.of((String)"DLQ").setRoutingType(RoutingType.ANYCAST)));
                config.addAddressConfiguration(new CoreAddressConfiguration().setName("ExpiryQueue").addRoutingType(RoutingType.ANYCAST).addQueueConfiguration(QueueConfiguration.of((String)"ExpiryQueue").setRoutingType(RoutingType.ANYCAST)));
            }
            catch (Exception e) {
                throw new AssertionError("Can't config the Artemis Configuration.", e);
            }
            EmbeddedActiveMQ server = new EmbeddedActiveMQ();
            server.setConfiguration((Configuration)config);
            try {
                server.start();
            }
            catch (Exception e) {
                throw new AssertionError("Can't start the Artemis Broker.", e);
            }
            return server;
        }

        public static EmbeddedActiveMQ createArtemisBroker_Should_Be_Individual_DLQs_But_Does_Not_Work(String brokerUrl) {
            log.info("Setting up in-vm Artemis embedded broker on URL '" + brokerUrl + "'.");
            ConfigurationImpl config = new ConfigurationImpl();
            try {
                config.setSecurityEnabled(false);
                config.setPersistenceEnabled(false);
                config.addAcceptorConfiguration(MatsTestBroker.SYSPROP_MATS_TEST_BROKERURL_VALUE_IN_VM, brokerUrl);
                config.addAddressSetting("#", new AddressSettings().setExpiryAddress(SimpleString.of((String)"ExpiryQueue")).setDeadLetterAddress(SimpleString.of((String)"DLQ")).setMaxDeliveryAttempts(3).setAutoCreateQueues(Boolean.valueOf(true)).setAutoCreateAddresses(Boolean.valueOf(true)).setAutoDeleteQueues(Boolean.valueOf(false)).setAutoCreateDeadLetterResources(true).setDeadLetterQueuePrefix(SimpleString.of((String)"DLQ.")).setDeadLetterQueueSuffix(SimpleString.of((String)"")));
                config.addAddressConfiguration(new CoreAddressConfiguration().setName("DLQ").addRoutingType(RoutingType.ANYCAST).addQueueConfiguration(QueueConfiguration.of((String)"DLQ").setRoutingType(RoutingType.ANYCAST)));
                config.addAddressConfiguration(new CoreAddressConfiguration().setName("ExpiryQueue").addRoutingType(RoutingType.ANYCAST).addQueueConfiguration(QueueConfiguration.of((String)"ExpiryQueue").setRoutingType(RoutingType.ANYCAST)));
            }
            catch (Exception e) {
                throw new AssertionError("Can't config the Artemis Configuration.", e);
            }
            EmbeddedActiveMQ server = new EmbeddedActiveMQ();
            server.setConfiguration((Configuration)config);
            try {
                server.start();
            }
            catch (Exception e) {
                throw new AssertionError("Can't start the Artemis Broker.", e);
            }
            return server;
        }

        @Override
        public ConnectionFactory getConnectionFactory() {
            return this._connectionFactory;
        }

        @Override
        public void close() {
            if (this._artemisServer != null) {
                try {
                    this._artemisServer.stop();
                }
                catch (Exception e) {
                    log.error("Got problems shutting down the Artemis broker - ignoring.", (Throwable)e);
                }
            }
        }
    }

    public static class MatsTestBroker_ActiveMq
    implements MatsTestBroker {
        private static final Logger log = LoggerFactory.getLogger(MatsTestBroker_ActiveMq.class);
        protected final BrokerService _brokerService;
        protected final ConnectionFactory _connectionFactory;

        MatsTestBroker_ActiveMq() {
            Object brokerUrl;
            BrokerService brokerService;
            String sysprop_brokerUrl = System.getProperty(MatsTestBroker.SYSPROP_MATS_TEST_BROKERURL);
            if (MatsTestBroker.SYSPROP_MATS_TEST_BROKERURL_VALUE_IN_VM.equalsIgnoreCase(sysprop_brokerUrl) || sysprop_brokerUrl == null) {
                brokerService = MatsTestBroker_InVmActiveMq.createInVmActiveMqBroker();
                brokerUrl = "vm://" + brokerService.getBrokerName() + "?create=false";
            } else if (MatsTestBroker.SYSPROP_MATS_TEST_BROKERURL_VALUE_LOCALHOST.equalsIgnoreCase(sysprop_brokerUrl)) {
                brokerUrl = "tcp://localhost:61616";
                log.info("SKIPPING setup of in-vm ActiveMQ BrokerService (MQ server), since System Property 'mats.test.brokerurl' was set to [" + sysprop_brokerUrl + "] - using [" + (String)brokerUrl + "]");
                brokerService = null;
            } else {
                brokerUrl = sysprop_brokerUrl;
                log.info("SKIPPING setup of in-vm ActiveMQ BrokerService (MQ server), since System Property 'mats.test.brokerurl' was set to [" + sysprop_brokerUrl + "].");
                brokerService = null;
            }
            this._brokerService = brokerService;
            this._connectionFactory = MatsTestBroker_InVmActiveMq.createActiveMQConnectionFactory((String)brokerUrl);
        }

        @Override
        public ConnectionFactory getConnectionFactory() {
            return this._connectionFactory;
        }

        @Override
        public void close() {
            if (this._brokerService != null) {
                MatsTestBroker_InVmActiveMq.closeBroker(this._brokerService);
            }
        }
    }

    public static class MatsTestBroker_InVmActiveMq
    implements MatsTestBroker {
        private static final Logger log = LoggerFactory.getLogger(MatsTestBroker_InVmActiveMq.class);
        protected final BrokerService _brokerService = MatsTestBroker_InVmActiveMq.createInVmActiveMqBroker();
        protected final ConnectionFactory _connectionFactory = MatsTestBroker_InVmActiveMq.createActiveMQConnectionFactory("vm://" + this._brokerService.getBrokerName() + "?create=false");

        MatsTestBroker_InVmActiveMq() {
        }

        @Override
        public ConnectionFactory getConnectionFactory() {
            return this._connectionFactory;
        }

        @Override
        public void close() {
            MatsTestBroker_InVmActiveMq.closeBroker(this._brokerService);
        }

        protected static BrokerService createInVmActiveMqBroker() {
            return MatsTestBroker.newActiveMqBroker(new ActiveMq[0]);
        }

        protected static ConnectionFactory createActiveMQConnectionFactory(String brokerUrl) {
            return MatsTestBroker.newActiveMqConnectionFactory(brokerUrl);
        }

        protected static void closeBroker(BrokerService _brokerService) {
            log.info("ActiveMQ BrokerService '" + _brokerService.getBrokerName() + "'.stop().");
            try {
                _brokerService.stop();
            }
            catch (Exception e) {
                throw new IllegalStateException("Couldn't stop AMQ Broker!", e);
            }
            log.info("ActiveMQ BrokerService '" + _brokerService.getBrokerName() + "'.waitUntilStopped() - waiting.");
            _brokerService.waitUntilStopped();
            log.info("ActiveMQ BrokerService '" + _brokerService.getBrokerName() + "' exited.");
        }
    }

    public static enum ActiveMq {
        LOCALHOST,
        PERSISTENT,
        SHUTDOWNHOOK,
        JMX,
        ADVISORY;

    }
}

