/*
 * Decompiled with CFR 0.152.
 */
package io.matthewnelson.kmp.tor.common.address;

import io.matthewnelson.kmp.tor.common.address.Address;
import io.matthewnelson.kmp.tor.common.address.IPAddressV4;
import io.matthewnelson.kmp.tor.common.address.IPAddressV6;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u0000 \u00022\u00020\u0001:\u0001\u0002\u0082\u0001\u0002\u0003\u0004\u00a8\u0006\u0005"}, d2={"Lio/matthewnelson/kmp/tor/common/address/IPAddress;", "Lio/matthewnelson/kmp/tor/common/address/Address;", "Companion", "Lio/matthewnelson/kmp/tor/common/address/IPAddressV4;", "Lio/matthewnelson/kmp/tor/common/address/IPAddressV6;", "kmp-tor-common"})
public interface IPAddress
extends Address {
    @NotNull
    public static final Companion Companion = io.matthewnelson.kmp.tor.common.address.IPAddress$Companion.$$INSTANCE;

    @JvmStatic
    @NotNull
    public static IPAddress fromString(@NotNull String address) throws IllegalArgumentException {
        return Companion.fromString(address);
    }

    @JvmStatic
    @Nullable
    public static IPAddress fromStringOrNull(@NotNull String address) {
        return Companion.fromStringOrNull(address);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\b"}, d2={"Lio/matthewnelson/kmp/tor/common/address/IPAddress$Companion;", "", "()V", "fromString", "Lio/matthewnelson/kmp/tor/common/address/IPAddress;", "address", "", "fromStringOrNull", "kmp-tor-common"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final IPAddress fromString(@NotNull String address) throws IllegalArgumentException {
            IPAddress iPAddress;
            Intrinsics.checkNotNullParameter((Object)address, (String)"address");
            IPAddressV4 iPAddressV4 = IPAddressV4.Companion.fromStringOrNull(address);
            if (iPAddressV4 != null) {
                iPAddress = iPAddressV4;
            } else {
                IPAddressV6 iPAddressV6 = IPAddressV6.Companion.fromStringOrNull(address);
                if (iPAddressV6 != null) {
                    iPAddress = iPAddressV6;
                } else {
                    throw new IllegalArgumentException("Failed to find an IPv4 or IPv6 address from " + address);
                }
            }
            return iPAddress;
        }

        @JvmStatic
        @Nullable
        public final IPAddress fromStringOrNull(@NotNull String address) {
            IPAddress iPAddress;
            Intrinsics.checkNotNullParameter((Object)address, (String)"address");
            try {
                iPAddress = this.fromString(address);
            }
            catch (IllegalArgumentException _) {
                iPAddress = null;
            }
            return iPAddress;
        }

        static {
            $$INSTANCE = new Companion();
        }
    }
}

